/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.conf.HiveConfUtil;
import org.apache.hadoop.mapred.JobConf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TestHiveCredentialProviders {
    private static final String HADOOP_CREDSTORE_PASSWORD_ENVVAR_VAL = "testhadoopCredStorePassword";
    private static final String HIVE_JOB_CREDSTORE_PASSWORD_ENVVAR_VAL = "testhiveJobCredPassword";
    private static final String JOB_CREDSTORE_LOCATION = "jceks://hdfs/user/hive/creds.jceks";
    private static final String HADOOP_CREDSTORE_LOCATION = "localjceks://file/user/hive/localcreds.jceks";
    private Configuration jobConf;

    private static final void setEnv(Map<String, String> newenv) throws Exception {
        Class<?>[] classes = Collections.class.getDeclaredClasses();
        Map<String, String> env = System.getenv();
        for (Class<?> cl : classes) {
            if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
            Field field = cl.getDeclaredField("m");
            field.setAccessible(true);
            Object obj = field.get(env);
            Map map = (Map)obj;
            map.clear();
            map.putAll(newenv);
        }
    }

    @Before
    public void resetConfig() {
        this.jobConf = new JobConf();
        this.jobConf.set("fs.defaultFS", "file:///");
    }

    @Test
    public void testJobCredentialProvider() throws Exception {
        this.setupConfigs(true, true, true, true);
        HiveConfUtil.updateJobCredentialProviders((Configuration)this.jobConf);
        Assert.assertEquals((Object)JOB_CREDSTORE_LOCATION, (Object)this.jobConf.get("hadoop.security.credential.provider.path"));
        Assert.assertEquals((Object)HIVE_JOB_CREDSTORE_PASSWORD_ENVVAR_VAL, (Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.map.env"), "HADOOP_CREDSTORE_PASSWORD"));
        Assert.assertEquals((Object)HIVE_JOB_CREDSTORE_PASSWORD_ENVVAR_VAL, (Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.reduce.env"), "HADOOP_CREDSTORE_PASSWORD"));
    }

    @Test
    public void testHadoopCredentialProvider() throws Exception {
        this.setupConfigs(true, true, true, false);
        HiveConfUtil.updateJobCredentialProviders((Configuration)this.jobConf);
        Assert.assertEquals((Object)HADOOP_CREDSTORE_LOCATION, (Object)this.jobConf.get("hadoop.security.credential.provider.path"));
        Assert.assertEquals((Object)HADOOP_CREDSTORE_PASSWORD_ENVVAR_VAL, (Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.map.env"), "HADOOP_CREDSTORE_PASSWORD"));
        Assert.assertEquals((Object)HADOOP_CREDSTORE_PASSWORD_ENVVAR_VAL, (Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.reduce.env"), "HADOOP_CREDSTORE_PASSWORD"));
    }

    @Test
    public void testNoCredentialProviderWithPassword() throws Exception {
        this.setupConfigs(false, false, true, false);
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)this.jobConf.get("hadoop.security.credential.provider.path")));
        Assert.assertNull((Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.map.env"), "HADOOP_CREDSTORE_PASSWORD"));
        Assert.assertNull((Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.reduce.env"), "HADOOP_CREDSTORE_PASSWORD"));
    }

    @Test
    public void testJobCredentialProviderWithDefaultPassword() throws Exception {
        this.setupConfigs(false, true, false, true);
        HiveConfUtil.updateJobCredentialProviders((Configuration)this.jobConf);
        Assert.assertEquals((Object)JOB_CREDSTORE_LOCATION, (Object)this.jobConf.get("hadoop.security.credential.provider.path"));
        Assert.assertEquals((Object)HADOOP_CREDSTORE_PASSWORD_ENVVAR_VAL, (Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.map.env"), "HADOOP_CREDSTORE_PASSWORD"));
        Assert.assertEquals((Object)HADOOP_CREDSTORE_PASSWORD_ENVVAR_VAL, (Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.reduce.env"), "HADOOP_CREDSTORE_PASSWORD"));
    }

    @Test
    public void testCredentialProviderWithNoPasswords() throws Exception {
        this.setupConfigs(true, false, false, true);
        HiveConfUtil.updateJobCredentialProviders((Configuration)this.jobConf);
        Assert.assertEquals((Object)JOB_CREDSTORE_LOCATION, (Object)this.jobConf.get("hadoop.security.credential.provider.path"));
        Assert.assertNull((Object)this.jobConf.get("mapreduce.map.env"));
        Assert.assertNull((Object)this.jobConf.get("mapreduce.reduce.env"));
        this.resetConfig();
        this.setupConfigs(true, false, false, false);
        HiveConfUtil.updateJobCredentialProviders((Configuration)this.jobConf);
        Assert.assertEquals((Object)HADOOP_CREDSTORE_LOCATION, (Object)this.jobConf.get("hadoop.security.credential.provider.path"));
        Assert.assertNull((Object)this.jobConf.get("mapreduce.map.env"));
        Assert.assertNull((Object)this.jobConf.get("mapreduce.reduce.env"));
    }

    @Test
    public void testJobCredentialProviderUnset() throws Exception {
        this.setupConfigs(true, true, false, false);
        HiveConfUtil.updateJobCredentialProviders((Configuration)this.jobConf);
        Assert.assertEquals((Object)HADOOP_CREDSTORE_LOCATION, (Object)this.jobConf.get("hadoop.security.credential.provider.path"));
        Assert.assertEquals((Object)HADOOP_CREDSTORE_PASSWORD_ENVVAR_VAL, (Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.map.env"), "HADOOP_CREDSTORE_PASSWORD"));
        Assert.assertEquals((Object)HADOOP_CREDSTORE_PASSWORD_ENVVAR_VAL, (Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.reduce.env"), "HADOOP_CREDSTORE_PASSWORD"));
    }

    @Test
    public void testNoCredentialProvider() throws Exception {
        this.setupConfigs(false, false, false, false);
        Assert.assertTrue((boolean)StringUtils.isBlank((CharSequence)this.jobConf.get("hadoop.security.credential.provider.path")));
        Assert.assertNull((Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.map.env"), "HADOOP_CREDSTORE_PASSWORD"));
        Assert.assertNull((Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.reduce.env"), "HADOOP_CREDSTORE_PASSWORD"));
    }

    @Test
    public void testExistingConfiguration() throws Exception {
        this.jobConf.set("mapreduce.map.env", "k1=v1, k2=v2, HADOOP_CREDSTORE_PASSWORD=test");
        this.setupConfigs(false, true, false, true);
        HiveConfUtil.updateJobCredentialProviders((Configuration)this.jobConf);
        Assert.assertEquals((Object)"v1", (Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.map.env"), "k1"));
        Assert.assertEquals((Object)"v2", (Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.map.env"), "k2"));
        this.resetConfig();
        this.jobConf.set("mapreduce.map.env", "k1=v1, HADOOP_CREDSTORE_PASSWORD=test, k2=v2");
        this.setupConfigs(false, true, false, true);
        HiveConfUtil.updateJobCredentialProviders((Configuration)this.jobConf);
        Assert.assertEquals((Object)"v1", (Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.map.env"), "k1"));
        Assert.assertEquals((Object)"v2", (Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.map.env"), "k2"));
        this.resetConfig();
        this.jobConf.set("mapreduce.map.env", "HADOOP_CREDSTORE_PASSWORD=test, k1=v1, k2=v2");
        this.setupConfigs(false, true, false, true);
        HiveConfUtil.updateJobCredentialProviders((Configuration)this.jobConf);
        Assert.assertEquals((Object)"v1", (Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.map.env"), "k1"));
        Assert.assertEquals((Object)"v2", (Object)this.getValueFromJobConf(this.jobConf.get("mapreduce.map.env"), "k2"));
    }

    private void setupConfigs(boolean setHadoopCredProvider, boolean setHadoopCredstorePassword, boolean setHiveCredPassword, boolean setHiveProviderPath) throws Exception {
        HashMap<String, String> mockEnv = new HashMap<String, String>();
        if (setHadoopCredProvider) {
            this.jobConf.set("hadoop.security.credential.provider.path", HADOOP_CREDSTORE_LOCATION);
        }
        if (setHadoopCredstorePassword) {
            mockEnv.put("HADOOP_CREDSTORE_PASSWORD", HADOOP_CREDSTORE_PASSWORD_ENVVAR_VAL);
        }
        if (setHiveCredPassword) {
            mockEnv.put("HIVE_JOB_CREDSTORE_PASSWORD", HIVE_JOB_CREDSTORE_PASSWORD_ENVVAR_VAL);
        }
        TestHiveCredentialProviders.setEnv(mockEnv);
        if (setHiveProviderPath) {
            this.jobConf.set(HiveConf.ConfVars.HIVE_SERVER2_JOB_CREDENTIAL_PROVIDER_PATH.varname, JOB_CREDSTORE_LOCATION);
        }
        this.jobConf.set(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname, "mr");
    }

    private String getValueFromJobConf(String keyValuePairs, String key) {
        String[] keyValues;
        if (keyValuePairs == null) {
            return null;
        }
        for (String kv : keyValues = keyValuePairs.split(",")) {
            String[] parts = kv.split("=");
            if (!key.equals(parts[0].trim())) continue;
            return parts[1].trim();
        }
        return null;
    }

    @Test
    public void testEnv() throws Exception {
        HashMap<String, String> mockEnv = new HashMap<String, String>();
        mockEnv.put("HADOOP_CREDSTORE_PASSWORD", HADOOP_CREDSTORE_PASSWORD_ENVVAR_VAL);
        mockEnv.put("HIVE_JOB_CREDSTORE_PASSWORD", HIVE_JOB_CREDSTORE_PASSWORD_ENVVAR_VAL);
        TestHiveCredentialProviders.setEnv(mockEnv);
        Assert.assertEquals((Object)HADOOP_CREDSTORE_PASSWORD_ENVVAR_VAL, (Object)System.getenv("HADOOP_CREDSTORE_PASSWORD"));
        Assert.assertEquals((Object)HIVE_JOB_CREDSTORE_PASSWORD_ENVVAR_VAL, (Object)System.getenv("HIVE_JOB_CREDSTORE_PASSWORD"));
    }
}

