/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.authorization;

import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.authorization.PrivilegesTestBase;
import org.apache.hadoop.hive.ql.security.authorization.PrivilegeType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestPrivilegesV2
extends PrivilegesTestBase {
    private QueryState queryState;
    private Hive db;
    private Table table;
    private Partition partition;

    @Before
    public void setup() throws Exception {
        this.queryState = new QueryState.Builder().build();
        HiveConf conf = this.queryState.getConf();
        conf.set("fs.defaultFS", "file:///");
        conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, SQLStdHiveAuthorizerFactory.class.getName());
        this.db = (Hive)Mockito.mock(Hive.class);
        this.table = new Table("default", "table1");
        SessionState.start((HiveConf)conf);
        Mockito.when((Object)this.db.getTable("default", "table1", false)).thenReturn((Object)this.table);
        Mockito.when((Object)this.db.getTable("default.table1", false)).thenReturn((Object)this.table);
        Mockito.when((Object)this.db.getPartition(this.table, new HashMap(), false)).thenReturn((Object)this.partition);
    }

    @Test
    public void testPrivInGrant() throws Exception {
        this.grantUserTable("select", PrivilegeType.SELECT);
        this.grantUserTable("insert", PrivilegeType.INSERT);
        this.grantUserTable("delete", PrivilegeType.DELETE);
        this.grantUserTable("update", PrivilegeType.ALTER_DATA);
        this.grantUserTable("all", PrivilegeType.ALL);
    }

    private void grantUserTable(String privName, PrivilegeType privType) throws Exception {
        TestPrivilegesV2.grantUserTable(privName, privType, this.queryState, this.db);
    }
}

