/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc.encoded;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.common.io.encoded.EncodedColumnBatch;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.Decimal64ColumnVector;
import org.apache.hadoop.hive.ql.io.orc.encoded.OrcBatchKey;
import org.apache.hadoop.hive.ql.io.orc.encoded.Reader;
import org.apache.hadoop.hive.ql.io.orc.encoded.StreamUtils;
import org.apache.orc.CompressionCodec;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.InStream;
import org.apache.orc.impl.PositionProvider;
import org.apache.orc.impl.RunLengthByteReader;
import org.apache.orc.impl.SettableUncompressedStream;
import org.apache.orc.impl.TreeReaderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodedTreeReaderFactory
extends TreeReaderFactory {
    private static final Logger LOG = LoggerFactory.getLogger(EncodedTreeReaderFactory.class);

    private static void skipCompressedIndex(boolean isCompressed, PositionProvider index) {
        if (!isCompressed) {
            return;
        }
        index.getNext();
    }

    public static TreeReaderFactory.StructTreeReader createRootTreeReader(TypeDescription[] batchSchemas, List<OrcProto.ColumnEncoding> encodings, Reader.OrcEncodedColumnBatch batch, CompressionCodec codec, TreeReaderFactory.Context context, boolean useDecimal64ColumnVectors) throws IOException {
        int includedCount = batch.getColumnsWithDataCount();
        if (batchSchemas.length > includedCount) {
            throw new AssertionError((Object)("For " + Arrays.toString(batchSchemas) + ", only received " + includedCount + " columns"));
        }
        TreeReaderFactory.TreeReader[] childReaders = new TreeReaderFactory.TreeReader[batchSchemas.length];
        for (int i = 0; i < batchSchemas.length; ++i) {
            int batchColIx = batchSchemas[i].getId();
            if (!batch.hasData(batchColIx) && !batch.hasVectors(batchColIx)) {
                throw new AssertionError((Object)("No data for column " + batchColIx + ": " + batchSchemas[i]));
            }
            childReaders[i] = EncodedTreeReaderFactory.createEncodedTreeReader(batchSchemas[i], encodings, batch, codec, context, useDecimal64ColumnVectors);
        }
        return StructStreamReader.builder().setColumnIndex(0).setCompressionCodec(codec).setColumnEncoding(encodings.get(0)).setChildReaders(childReaders).setContext(context).build();
    }

    private static void skipSeek(PositionProvider index) {
        index.getNext();
    }

    private static TreeReaderFactory.TreeReader createEncodedTreeReader(TypeDescription schema, List<OrcProto.ColumnEncoding> encodings, Reader.OrcEncodedColumnBatch batch, CompressionCodec codec, TreeReaderFactory.Context context, boolean useDecimal64ColumnVectors) throws IOException {
        int columnIndex = schema.getId();
        EncodedColumnBatch.ColumnStreamData[] streamBuffers = null;
        List<ColumnVector> vectors = null;
        if (batch.hasData(columnIndex)) {
            streamBuffers = batch.getColumnData(columnIndex);
        } else if (batch.hasVectors(columnIndex)) {
            vectors = batch.getColumnVectors(columnIndex);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Batch has no data for " + columnIndex + ": " + batch);
            }
            return null;
        }
        OrcProto.ColumnEncoding columnEncoding = encodings.get(columnIndex);
        EncodedColumnBatch.ColumnStreamData present = null;
        EncodedColumnBatch.ColumnStreamData data = null;
        EncodedColumnBatch.ColumnStreamData dictionary = null;
        EncodedColumnBatch.ColumnStreamData lengths = null;
        EncodedColumnBatch.ColumnStreamData secondary = null;
        if (streamBuffers != null) {
            present = streamBuffers[0];
            data = streamBuffers[1];
            dictionary = streamBuffers[3];
            lengths = streamBuffers[2];
            secondary = streamBuffers[5];
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("columnIndex: {} columnType: {} streamBuffers.length: {} vectors: {} columnEncoding: {} present: {} data: {} dictionary: {} lengths: {} secondary: {} tz: {}", new Object[]{columnIndex, schema, streamBuffers == null ? 0 : streamBuffers.length, vectors == null ? 0 : vectors.size(), columnEncoding, present != null, data, dictionary != null, lengths != null, secondary != null, context.getWriterTimezone()});
        }
        switch (schema.getCategory()) {
            case BINARY: 
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case CHAR: 
            case VARCHAR: 
            case STRING: 
            case DECIMAL: 
            case TIMESTAMP: 
            case DATE: {
                return EncodedTreeReaderFactory.getPrimitiveTreeReader(columnIndex, schema, codec, columnEncoding, present, data, dictionary, lengths, secondary, context, vectors, useDecimal64ColumnVectors);
            }
            case LIST: {
                assert (vectors == null);
                TypeDescription elementType = schema.getChildren().get(0);
                TreeReaderFactory.TreeReader elementReader = EncodedTreeReaderFactory.createEncodedTreeReader(elementType, encodings, batch, codec, context, useDecimal64ColumnVectors);
                return ListStreamReader.builder().setColumnIndex(columnIndex).setColumnEncoding(columnEncoding).setCompressionCodec(codec).setPresentStream(present).setLengthStream(lengths).setElementReader(elementReader).setContext(context).build();
            }
            case MAP: {
                assert (vectors == null);
                TypeDescription keyType = schema.getChildren().get(0);
                TypeDescription valueType = schema.getChildren().get(1);
                TreeReaderFactory.TreeReader keyReader = EncodedTreeReaderFactory.createEncodedTreeReader(keyType, encodings, batch, codec, context, useDecimal64ColumnVectors);
                TreeReaderFactory.TreeReader valueReader = EncodedTreeReaderFactory.createEncodedTreeReader(valueType, encodings, batch, codec, context, useDecimal64ColumnVectors);
                return MapStreamReader.builder().setColumnIndex(columnIndex).setColumnEncoding(columnEncoding).setCompressionCodec(codec).setPresentStream(present).setLengthStream(lengths).setKeyReader(keyReader).setValueReader(valueReader).setContext(context).build();
            }
            case STRUCT: {
                assert (vectors == null);
                int childCount = schema.getChildren().size();
                TreeReaderFactory.TreeReader[] childReaders = new TreeReaderFactory.TreeReader[childCount];
                for (int i = 0; i < childCount; ++i) {
                    TypeDescription childType = schema.getChildren().get(i);
                    childReaders[i] = EncodedTreeReaderFactory.createEncodedTreeReader(childType, encodings, batch, codec, context, useDecimal64ColumnVectors);
                }
                return StructStreamReader.builder().setColumnIndex(columnIndex).setCompressionCodec(codec).setColumnEncoding(columnEncoding).setPresentStream(present).setChildReaders(childReaders).setContext(context).build();
            }
            case UNION: {
                assert (vectors == null);
                int childCount = schema.getChildren().size();
                TreeReaderFactory.TreeReader[] childReaders = new TreeReaderFactory.TreeReader[childCount];
                for (int i = 0; i < childCount; ++i) {
                    TypeDescription childType = schema.getChildren().get(i);
                    childReaders[i] = EncodedTreeReaderFactory.createEncodedTreeReader(childType, encodings, batch, codec, context, useDecimal64ColumnVectors);
                }
                return UnionStreamReader.builder().setColumnIndex(columnIndex).setCompressionCodec(codec).setColumnEncoding(columnEncoding).setPresentStream(present).setDataStream(data).setChildReaders(childReaders).setContext(context).build();
            }
        }
        throw new UnsupportedOperationException("Data type not supported: " + schema);
    }

    private static TreeReaderFactory.TreeReader getPrimitiveTreeReader(int columnIndex, TypeDescription columnType, CompressionCodec codec, OrcProto.ColumnEncoding columnEncoding, EncodedColumnBatch.ColumnStreamData present, EncodedColumnBatch.ColumnStreamData data, EncodedColumnBatch.ColumnStreamData dictionary, EncodedColumnBatch.ColumnStreamData lengths, EncodedColumnBatch.ColumnStreamData secondary, TreeReaderFactory.Context context, List<ColumnVector> vectors, boolean useDecimal64ColumnVectors) throws IOException {
        switch (columnType.getCategory()) {
            case BINARY: {
                return BinaryStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setLengthStream(lengths).setCompressionCodec(codec).setColumnEncoding(columnEncoding).setVectors(vectors).setContext(context).build();
            }
            case BOOLEAN: {
                return BooleanStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).setVectors(vectors).build();
            }
            case BYTE: {
                return ByteStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).setVectors(vectors).build();
            }
            case SHORT: {
                return ShortStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).setColumnEncoding(columnEncoding).setVectors(vectors).setContext(context).build();
            }
            case INT: {
                return IntStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).setColumnEncoding(columnEncoding).setVectors(vectors).setContext(context).build();
            }
            case LONG: {
                return LongStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).setColumnEncoding(columnEncoding).setVectors(vectors).setContext(context).build();
            }
            case FLOAT: {
                return FloatStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).setVectors(vectors).build();
            }
            case DOUBLE: {
                return DoubleStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).setVectors(vectors).build();
            }
            case CHAR: {
                return CharStreamReader.builder().setColumnIndex(columnIndex).setMaxLength(columnType.getMaxLength()).setPresentStream(present).setDataStream(data).setLengthStream(lengths).setDictionaryStream(dictionary).setCompressionCodec(codec).setColumnEncoding(columnEncoding).setVectors(vectors).build();
            }
            case VARCHAR: {
                return VarcharStreamReader.builder().setColumnIndex(columnIndex).setMaxLength(columnType.getMaxLength()).setPresentStream(present).setDataStream(data).setLengthStream(lengths).setDictionaryStream(dictionary).setCompressionCodec(codec).setColumnEncoding(columnEncoding).setVectors(vectors).build();
            }
            case STRING: {
                return StringStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setLengthStream(lengths).setDictionaryStream(dictionary).setCompressionCodec(codec).setColumnEncoding(columnEncoding).setVectors(vectors).build();
            }
            case DECIMAL: {
                boolean useDecimal64Reader;
                boolean bl = useDecimal64Reader = context.getFileFormat() == null && vectors != null && useDecimal64ColumnVectors;
                if (useDecimal64Reader) {
                    boolean containDecimal64CV = false;
                    for (ColumnVector vector : vectors) {
                        if (!(vector instanceof Decimal64ColumnVector)) continue;
                        containDecimal64CV = true;
                        break;
                    }
                    useDecimal64Reader &= containDecimal64CV;
                }
                if ((context.getFileFormat() == OrcFile.Version.UNSTABLE_PRE_2_0 || useDecimal64Reader) && columnType.getPrecision() <= 18) {
                    return Decimal64StreamReader.builder().setColumnIndex(columnIndex).setPrecision(columnType.getPrecision()).setScale(columnType.getScale()).setPresentStream(present).setValueStream(data).setCompressionCodec(codec).setColumnEncoding(columnEncoding).setVectors(vectors).setContext(context).build();
                }
                return DecimalStreamReader.builder().setColumnIndex(columnIndex).setPrecision(columnType.getPrecision()).setScale(columnType.getScale()).setPresentStream(present).setValueStream(data).setScaleStream(secondary).setCompressionCodec(codec).setColumnEncoding(columnEncoding).setVectors(vectors).setContext(context).build();
            }
            case TIMESTAMP: {
                return TimestampStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setSecondsStream(data).setNanosStream(secondary).setCompressionCodec(codec).setColumnEncoding(columnEncoding).setVectors(vectors).setContext(context).build();
            }
            case DATE: {
                return DateStreamReader.builder().setColumnIndex(columnIndex).setPresentStream(present).setDataStream(data).setCompressionCodec(codec).setColumnEncoding(columnEncoding).setVectors(vectors).setContext(context).build();
            }
        }
        throw new AssertionError((Object)("Not a primitive category: " + columnType.getCategory()));
    }

    protected static class UnionStreamReader
    extends TreeReaderFactory.UnionTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;

        public UnionStreamReader(int columnIndex, SettableUncompressedStream present, SettableUncompressedStream dataStream, OrcProto.ColumnEncoding columnEncoding, boolean isFileCompressed, TreeReaderFactory.TreeReader[] childReaders, TreeReaderFactory.Context context) throws IOException {
            super(columnIndex, present, context, columnEncoding, childReaders);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = dataStream;
            this.tags = new RunLengthByteReader(dataStream);
        }

        @Override
        public void seek(PositionProvider[] index) throws IOException {
            PositionProvider ownIndex = index[this.columnId];
            if (this.present != null) {
                if (this._isFileCompressed) {
                    ownIndex.getNext();
                }
                this.present.seek(ownIndex);
            }
            if (this._dataStream.available() > 0) {
                if (this._isFileCompressed) {
                    ownIndex.getNext();
                }
                this.tags.seek(ownIndex);
                if (this.fields != null) {
                    for (TreeReaderFactory.TreeReader child : this.fields) {
                        child.seek(index);
                    }
                }
            }
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            throw new IOException("Should never be called");
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
            if (this.fields != null) {
                for (TreeReaderFactory.TreeReader child : this.fields) {
                    ((SettableTreeReader)((Object)child)).setBuffers(batch, sameStripe);
                }
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private TreeReaderFactory.TreeReader[] childReaders;
            private TreeReaderFactory.Context context;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setChildReaders(TreeReaderFactory.TreeReader[] childReaders) {
                this.childReaders = childReaders;
                return this;
            }

            public StreamReaderBuilder setContext(TreeReaderFactory.Context context) {
                this.context = context;
                return this;
            }

            public UnionStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new UnionStreamReader(this.columnIndex, present, data, this.columnEncoding, isFileCompressed, this.childReaders, this.context);
            }
        }
    }

    protected static class StructStreamReader
    extends TreeReaderFactory.StructTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;

        public StructStreamReader(int columnIndex, SettableUncompressedStream present, OrcProto.ColumnEncoding columnEncoding, boolean isFileCompressed, TreeReaderFactory.TreeReader[] childReaders, TreeReaderFactory.Context context) throws IOException {
            super(columnIndex, present, context, columnEncoding, childReaders);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
        }

        @Override
        public void seek(PositionProvider[] index) throws IOException {
            PositionProvider ownIndex = index[this.columnId];
            if (this.present != null) {
                if (this._isFileCompressed) {
                    ownIndex.getNext();
                }
                this.present.seek(ownIndex);
            }
            if (this.fields != null) {
                for (TreeReaderFactory.TreeReader child : this.fields) {
                    if (child == null) continue;
                    child.seek(index);
                }
            }
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            throw new IOException("Should never be called");
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this.fields != null) {
                for (TreeReaderFactory.TreeReader child : this.fields) {
                    if (child == null) continue;
                    ((SettableTreeReader)((Object)child)).setBuffers(batch, sameStripe);
                }
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private TreeReaderFactory.TreeReader[] childReaders;
            private TreeReaderFactory.Context context;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setChildReaders(TreeReaderFactory.TreeReader[] childReaders) {
                this.childReaders = childReaders;
                return this;
            }

            public StreamReaderBuilder setContext(TreeReaderFactory.Context context) {
                this.context = context;
                return this;
            }

            public StructStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new StructStreamReader(this.columnIndex, present, this.columnEncoding, isFileCompressed, this.childReaders, this.context);
            }
        }
    }

    protected static class MapStreamReader
    extends TreeReaderFactory.MapTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _lengthStream;

        public MapStreamReader(int columnIndex, SettableUncompressedStream present, SettableUncompressedStream lengthStream, OrcProto.ColumnEncoding columnEncoding, boolean isFileCompressed, TreeReaderFactory.TreeReader keyReader, TreeReaderFactory.TreeReader valueReader, TreeReaderFactory.Context context) throws IOException {
            super(columnIndex, present, context, lengthStream, columnEncoding, keyReader, valueReader);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._lengthStream = lengthStream;
        }

        @Override
        public void seek(PositionProvider[] index) throws IOException {
            PositionProvider ownIndex = index[this.columnId];
            if (this.present != null) {
                if (this._isFileCompressed) {
                    ownIndex.getNext();
                }
                this.present.seek(ownIndex);
            }
            if (this._lengthStream.available() > 0) {
                if (this._isFileCompressed) {
                    ownIndex.getNext();
                }
                this.lengths.seek(ownIndex);
                this.keyReader.seek(index);
                this.valueReader.seek(index);
            }
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            throw new IOException("Should never be called");
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._lengthStream != null) {
                this._lengthStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
            }
            if (this.keyReader != null) {
                ((SettableTreeReader)((Object)this.keyReader)).setBuffers(batch, sameStripe);
            }
            if (this.valueReader != null) {
                ((SettableTreeReader)((Object)this.valueReader)).setBuffers(batch, sameStripe);
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData lengthStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private TreeReaderFactory.TreeReader keyReader;
            private TreeReaderFactory.TreeReader valueReader;
            private TreeReaderFactory.Context context;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setLengthStream(EncodedColumnBatch.ColumnStreamData lengthStream) {
                this.lengthStream = lengthStream;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setKeyReader(TreeReaderFactory.TreeReader keyReader) {
                this.keyReader = keyReader;
                return this;
            }

            public StreamReaderBuilder setValueReader(TreeReaderFactory.TreeReader valueReader) {
                this.valueReader = valueReader;
                return this;
            }

            public StreamReaderBuilder setContext(TreeReaderFactory.Context context) {
                this.context = context;
                return this;
            }

            public MapStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream length = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.LENGTH.name(), this.lengthStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new MapStreamReader(this.columnIndex, present, length, this.columnEncoding, isFileCompressed, this.keyReader, this.valueReader, this.context);
            }
        }
    }

    protected static class ListStreamReader
    extends TreeReaderFactory.ListTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _lengthStream;

        public ListStreamReader(int columnIndex, SettableUncompressedStream present, SettableUncompressedStream lengthStream, OrcProto.ColumnEncoding columnEncoding, boolean isFileCompressed, TreeReaderFactory.TreeReader elementReader, TreeReaderFactory.Context context) throws IOException {
            super(columnIndex, present, context, lengthStream, columnEncoding, elementReader);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._lengthStream = lengthStream;
        }

        @Override
        public void seek(PositionProvider[] index) throws IOException {
            PositionProvider ownIndex = index[this.columnId];
            if (this.present != null) {
                if (this._isFileCompressed) {
                    ownIndex.getNext();
                }
                this.present.seek(ownIndex);
            }
            if (this._lengthStream.available() > 0) {
                if (this._isFileCompressed) {
                    ownIndex.getNext();
                }
                this.lengths.seek(ownIndex);
                this.elementReader.seek(index);
            }
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            throw new IOException("Should never be called");
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._lengthStream != null) {
                this._lengthStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
            }
            if (this.elementReader != null) {
                ((SettableTreeReader)((Object)this.elementReader)).setBuffers(batch, sameStripe);
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData lengthStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private TreeReaderFactory.TreeReader elementReader;
            private TreeReaderFactory.Context context;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setLengthStream(EncodedColumnBatch.ColumnStreamData lengthStream) {
                this.lengthStream = lengthStream;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setElementReader(TreeReaderFactory.TreeReader elementReader) {
                this.elementReader = elementReader;
                return this;
            }

            public StreamReaderBuilder setContext(TreeReaderFactory.Context context) {
                this.context = context;
                return this;
            }

            public ListStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream length = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.LENGTH.name(), this.lengthStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new ListStreamReader(this.columnIndex, present, length, this.columnEncoding, isFileCompressed, this.elementReader, this.context);
            }
        }
    }

    protected static class BooleanStreamReader
    extends TreeReaderFactory.BooleanTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private List<ColumnVector> vectors;
        private int vectorIndex = 0;

        private BooleanStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed, List<ColumnVector> vectors) throws IOException {
            super(columnId, (InStream)present, data);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
            this.vectors = vectors;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.vectors != null) {
                return;
            }
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._dataStream.available() > 0) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.reader.seek(index);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.vectors == null) {
                super.nextVector(previousVector, isNull, batchSize);
                return;
            }
            this.vectors.get(this.vectorIndex++).shallowCopyTo(previousVector);
            if (this.vectorIndex == this.vectors.size()) {
                this.vectors = null;
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            assert (this.vectors == null);
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;
            private List<ColumnVector> vectors;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public BooleanStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new BooleanStreamReader(this.columnIndex, present, data, isFileCompressed, this.vectors);
            }

            public StreamReaderBuilder setVectors(List<ColumnVector> vectors) {
                this.vectors = vectors;
                return this;
            }
        }
    }

    protected static class BinaryStreamReader
    extends TreeReaderFactory.BinaryTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private SettableUncompressedStream _lengthsStream;
        private List<ColumnVector> vectors;
        private int vectorIndex = 0;

        private BinaryStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, SettableUncompressedStream length, boolean isFileCompressed, OrcProto.ColumnEncoding encoding, TreeReaderFactory.Context context, List<ColumnVector> vectors) throws IOException {
            super(columnId, present, data, length, encoding, context);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
            this._lengthsStream = length;
            this.vectors = vectors;
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.vectors == null) {
                super.nextVector(previousVector, isNull, batchSize);
                return;
            }
            this.vectors.get(this.vectorIndex++).shallowCopyTo(previousVector);
            if (this.vectorIndex == this.vectors.size()) {
                this.vectors = null;
            }
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.vectors != null) {
                return;
            }
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
            if (this._dataStream.available() > 0) {
                this.stream.seek(index);
            } else {
                assert (this.stream == this._dataStream);
                EncodedTreeReaderFactory.skipSeek(index);
            }
            EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
            if (this.lengths != null && this._lengthsStream.available() > 0) {
                this.lengths.seek(index);
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            assert (this.vectors == null);
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
            if (this._lengthsStream != null) {
                this._lengthsStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private EncodedColumnBatch.ColumnStreamData lengthStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private List<ColumnVector> vectors;
            private TreeReaderFactory.Context context;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setLengthStream(EncodedColumnBatch.ColumnStreamData secondaryStream) {
                this.lengthStream = secondaryStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public StreamReaderBuilder setContext(TreeReaderFactory.Context context) {
                this.context = context;
                return this;
            }

            public BinaryStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                SettableUncompressedStream length = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.LENGTH.name(), this.lengthStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new BinaryStreamReader(this.columnIndex, present, data, length, isFileCompressed, this.columnEncoding, this.context, this.vectors);
            }

            public StreamReaderBuilder setVectors(List<ColumnVector> vectors) {
                this.vectors = vectors;
                return this;
            }
        }
    }

    protected static class ByteStreamReader
    extends TreeReaderFactory.ByteTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private List<ColumnVector> vectors;
        private int vectorIndex = 0;

        private ByteStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed, List<ColumnVector> vectors) throws IOException {
            super(columnId, (InStream)present, data);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
            this.vectors = vectors;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.vectors != null) {
                return;
            }
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._dataStream.available() > 0) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.reader.seek(index);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.vectors == null) {
                super.nextVector(previousVector, isNull, batchSize);
                return;
            }
            this.vectors.get(this.vectorIndex++).shallowCopyTo(previousVector);
            if (this.vectorIndex == this.vectors.size()) {
                this.vectors = null;
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            assert (this.vectors == null);
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;
            private List<ColumnVector> vectors;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public ByteStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new ByteStreamReader(this.columnIndex, present, data, isFileCompressed, this.vectors);
            }

            public StreamReaderBuilder setVectors(List<ColumnVector> vectors) {
                this.vectors = vectors;
                return this;
            }
        }
    }

    protected static class VarcharStreamReader
    extends TreeReaderFactory.VarcharTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private boolean _isDictionaryEncoding;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private SettableUncompressedStream _lengthStream;
        private SettableUncompressedStream _dictionaryStream;
        private List<ColumnVector> vectors;
        private int vectorIndex = 0;

        private VarcharStreamReader(int columnId, int maxLength, SettableUncompressedStream present, SettableUncompressedStream data, SettableUncompressedStream length, SettableUncompressedStream dictionary, boolean isFileCompressed, OrcProto.ColumnEncoding encoding, List<ColumnVector> vectors) throws IOException {
            super(columnId, maxLength, (InStream)present, (InStream)data, (InStream)length, dictionary, encoding);
            this._isDictionaryEncoding = dictionary != null;
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
            this._lengthStream = length;
            this._dictionaryStream = dictionary;
            this.vectors = vectors;
        }

        @Override
        public void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.vectors != null) {
                return;
            }
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.reader.getPresent().seek(index);
            }
            if (this._isDictionaryEncoding) {
                EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
                if (this._dataStream.available() > 0) {
                    ((TreeReaderFactory.StringDictionaryTreeReader)this.reader).getReader().seek(index);
                }
            } else {
                EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
                InStream stream = ((TreeReaderFactory.StringDirectTreeReader)this.reader).getStream();
                if (this._dataStream.available() > 0) {
                    stream.seek(index);
                } else {
                    assert (stream == this._dataStream);
                    EncodedTreeReaderFactory.skipSeek(index);
                }
                EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
                if (this._lengthStream.available() > 0) {
                    ((TreeReaderFactory.StringDirectTreeReader)this.reader).getLengths().seek(index);
                }
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.vectors == null) {
                super.nextVector(previousVector, isNull, batchSize);
                return;
            }
            this.vectors.get(this.vectorIndex++).shallowCopyTo(previousVector);
            if (this.vectorIndex == this.vectors.size()) {
                this.vectors = null;
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            assert (this.vectors == null);
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
            if (!this._isDictionaryEncoding && this._lengthStream != null) {
                this._lengthStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
            }
            if (!sameStripe && this._isDictionaryEncoding) {
                if (this._lengthStream != null) {
                    this._lengthStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
                }
                if (this._dictionaryStream != null) {
                    this._dictionaryStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[3]));
                }
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private int maxLength;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private EncodedColumnBatch.ColumnStreamData dictionaryStream;
            private EncodedColumnBatch.ColumnStreamData lengthStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private List<ColumnVector> vectors;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setMaxLength(int maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setLengthStream(EncodedColumnBatch.ColumnStreamData lengthStream) {
                this.lengthStream = lengthStream;
                return this;
            }

            public StreamReaderBuilder setDictionaryStream(EncodedColumnBatch.ColumnStreamData dictStream) {
                this.dictionaryStream = dictStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public VarcharStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                SettableUncompressedStream length = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.LENGTH.name(), this.lengthStream);
                SettableUncompressedStream dictionary = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DICTIONARY_DATA.name(), this.dictionaryStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new VarcharStreamReader(this.columnIndex, this.maxLength, present, data, length, dictionary, isFileCompressed, this.columnEncoding, this.vectors);
            }

            public StreamReaderBuilder setVectors(List<ColumnVector> vectors) {
                this.vectors = vectors;
                return this;
            }
        }
    }

    protected static class CharStreamReader
    extends TreeReaderFactory.CharTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private boolean _isDictionaryEncoding;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private SettableUncompressedStream _lengthStream;
        private SettableUncompressedStream _dictionaryStream;
        private List<ColumnVector> vectors;
        private int vectorIndex = 0;

        private CharStreamReader(int columnId, int maxLength, SettableUncompressedStream present, SettableUncompressedStream data, SettableUncompressedStream length, SettableUncompressedStream dictionary, boolean isFileCompressed, OrcProto.ColumnEncoding encoding, List<ColumnVector> vectors) throws IOException {
            super(columnId, maxLength, (InStream)present, (InStream)data, (InStream)length, dictionary, encoding);
            this._isDictionaryEncoding = dictionary != null;
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
            this._lengthStream = length;
            this._dictionaryStream = dictionary;
            this.vectors = vectors;
        }

        @Override
        public void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.vectors != null) {
                return;
            }
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.reader.getPresent().seek(index);
            }
            if (this._isDictionaryEncoding) {
                EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
                if (this._dataStream.available() > 0) {
                    ((TreeReaderFactory.StringDictionaryTreeReader)this.reader).getReader().seek(index);
                }
            } else {
                EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
                InStream stream = ((TreeReaderFactory.StringDirectTreeReader)this.reader).getStream();
                if (this._dataStream.available() > 0) {
                    stream.seek(index);
                } else {
                    assert (stream == this._dataStream);
                    EncodedTreeReaderFactory.skipSeek(index);
                }
                EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
                if (this._lengthStream.available() > 0) {
                    ((TreeReaderFactory.StringDirectTreeReader)this.reader).getLengths().seek(index);
                }
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.vectors == null) {
                super.nextVector(previousVector, isNull, batchSize);
                return;
            }
            this.vectors.get(this.vectorIndex++).shallowCopyTo(previousVector);
            if (this.vectorIndex == this.vectors.size()) {
                this.vectors = null;
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            assert (this.vectors == null);
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
            if (!this._isDictionaryEncoding && this._lengthStream != null) {
                this._lengthStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
            }
            if (!sameStripe && this._isDictionaryEncoding) {
                if (this._lengthStream != null) {
                    this._lengthStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
                }
                if (this._dictionaryStream != null) {
                    this._dictionaryStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[3]));
                }
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private int maxLength;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private EncodedColumnBatch.ColumnStreamData dictionaryStream;
            private EncodedColumnBatch.ColumnStreamData lengthStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private List<ColumnVector> vectors;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setMaxLength(int maxLength) {
                this.maxLength = maxLength;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setLengthStream(EncodedColumnBatch.ColumnStreamData lengthStream) {
                this.lengthStream = lengthStream;
                return this;
            }

            public StreamReaderBuilder setDictionaryStream(EncodedColumnBatch.ColumnStreamData dictStream) {
                this.dictionaryStream = dictStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public CharStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                SettableUncompressedStream length = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.LENGTH.name(), this.lengthStream);
                SettableUncompressedStream dictionary = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DICTIONARY_DATA.name(), this.dictionaryStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new CharStreamReader(this.columnIndex, this.maxLength, present, data, length, dictionary, isFileCompressed, this.columnEncoding, this.vectors);
            }

            public StreamReaderBuilder setVectors(List<ColumnVector> vectors) {
                this.vectors = vectors;
                return this;
            }
        }
    }

    protected static class DateStreamReader
    extends TreeReaderFactory.DateTreeReader
    implements SettableTreeReader {
        private boolean isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private List<ColumnVector> vectors;
        private int vectorIndex = 0;

        private DateStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed, OrcProto.ColumnEncoding encoding, TreeReaderFactory.Context context, List<ColumnVector> vectors) throws IOException {
            super(columnId, present, data, encoding, context);
            this.isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
            this.vectors = vectors;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.vectors != null) {
                return;
            }
            if (this.present != null) {
                if (this.isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._dataStream.available() > 0) {
                if (this.isFileCompressed) {
                    index.getNext();
                }
                this.reader.seek(index);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.vectors == null) {
                super.nextVector(previousVector, isNull, batchSize);
                return;
            }
            this.vectors.get(this.vectorIndex++).shallowCopyTo(previousVector);
            if (this.vectorIndex == this.vectors.size()) {
                this.vectors = null;
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            assert (this.vectors == null);
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private List<ColumnVector> vectors;
            private TreeReaderFactory.Context context;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setContext(TreeReaderFactory.Context context) {
                this.context = context;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public StreamReaderBuilder setVectors(List<ColumnVector> vectors) {
                this.vectors = vectors;
                return this;
            }

            public DateStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new DateStreamReader(this.columnIndex, present, data, isFileCompressed, this.columnEncoding, this.context, this.vectors);
            }
        }
    }

    protected static class Decimal64StreamReader
    extends TreeReaderFactory.Decimal64TreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _valueStream;
        private List<ColumnVector> vectors;
        private int vectorIndex = 0;

        private Decimal64StreamReader(int columnId, int precision, int scale, SettableUncompressedStream presentStream, SettableUncompressedStream valueStream, boolean isFileCompressed, OrcProto.ColumnEncoding encoding, TreeReaderFactory.Context context, List<ColumnVector> vectors) throws IOException {
            super(columnId, presentStream, valueStream, encoding, precision, scale, context);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = presentStream;
            this._valueStream = valueStream;
            this.vectors = vectors;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.vectors != null) {
                return;
            }
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
            if (this._valueStream.available() > 0) {
                this.valueReader.seek(index);
            } else {
                EncodedTreeReaderFactory.skipSeek(index);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.vectors == null) {
                super.nextVector(previousVector, isNull, batchSize);
                return;
            }
            this.vectors.get(this.vectorIndex++).shallowCopyTo(previousVector);
            if (this.vectorIndex == this.vectors.size()) {
                this.vectors = null;
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) {
            assert (this.vectors == null);
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._valueStream != null) {
                this._valueStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData valueStream;
            private int scale;
            private int precision;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private List<ColumnVector> vectors;
            private TreeReaderFactory.Context context;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPrecision(int precision) {
                this.precision = precision;
                return this;
            }

            public StreamReaderBuilder setScale(int scale) {
                this.scale = scale;
                return this;
            }

            public StreamReaderBuilder setContext(TreeReaderFactory.Context context) {
                this.context = context;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setValueStream(EncodedColumnBatch.ColumnStreamData valueStream) {
                this.valueStream = valueStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public Decimal64StreamReader build() throws IOException {
                SettableUncompressedStream presentInStream = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream valueInStream = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.valueStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new Decimal64StreamReader(this.columnIndex, this.precision, this.scale, presentInStream, valueInStream, isFileCompressed, this.columnEncoding, this.context, this.vectors);
            }

            public StreamReaderBuilder setVectors(List<ColumnVector> vectors) {
                this.vectors = vectors;
                return this;
            }
        }
    }

    protected static class DecimalStreamReader
    extends TreeReaderFactory.DecimalTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _valueStream;
        private SettableUncompressedStream _scaleStream;
        private List<ColumnVector> vectors;
        private int vectorIndex = 0;

        private DecimalStreamReader(int columnId, int precision, int scale, SettableUncompressedStream presentStream, SettableUncompressedStream valueStream, SettableUncompressedStream scaleStream, boolean isFileCompressed, OrcProto.ColumnEncoding encoding, TreeReaderFactory.Context context, List<ColumnVector> vectors) throws IOException {
            super(columnId, presentStream, valueStream, scaleStream, encoding, precision, scale, context);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = presentStream;
            this._valueStream = valueStream;
            this._scaleStream = scaleStream;
            this.vectors = vectors;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.vectors != null) {
                return;
            }
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
            if (this._valueStream.available() > 0) {
                this.valueStream.seek(index);
            } else {
                assert (this.valueStream == this._valueStream);
                EncodedTreeReaderFactory.skipSeek(index);
            }
            EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
            if (this._scaleStream.available() > 0) {
                this.scaleReader.seek(index);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.vectors == null) {
                super.nextVector(previousVector, isNull, batchSize);
                return;
            }
            this.vectors.get(this.vectorIndex++).shallowCopyTo(previousVector);
            if (this.vectorIndex == this.vectors.size()) {
                this.vectors = null;
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            assert (this.vectors == null);
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._valueStream != null) {
                this._valueStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
            if (this._scaleStream != null) {
                this._scaleStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[5]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData valueStream;
            private EncodedColumnBatch.ColumnStreamData scaleStream;
            private int scale;
            private int precision;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private List<ColumnVector> vectors;
            private TreeReaderFactory.Context context;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPrecision(int precision) {
                this.precision = precision;
                return this;
            }

            public StreamReaderBuilder setScale(int scale) {
                this.scale = scale;
                return this;
            }

            public StreamReaderBuilder setContext(TreeReaderFactory.Context context) {
                this.context = context;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setValueStream(EncodedColumnBatch.ColumnStreamData valueStream) {
                this.valueStream = valueStream;
                return this;
            }

            public StreamReaderBuilder setScaleStream(EncodedColumnBatch.ColumnStreamData scaleStream) {
                this.scaleStream = scaleStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public DecimalStreamReader build() throws IOException {
                SettableUncompressedStream presentInStream = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream valueInStream = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.valueStream);
                SettableUncompressedStream scaleInStream = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.SECONDARY.name(), this.scaleStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new DecimalStreamReader(this.columnIndex, this.precision, this.scale, presentInStream, valueInStream, scaleInStream, isFileCompressed, this.columnEncoding, this.context, this.vectors);
            }

            public StreamReaderBuilder setVectors(List<ColumnVector> vectors) {
                this.vectors = vectors;
                return this;
            }
        }
    }

    protected static class DoubleStreamReader
    extends TreeReaderFactory.DoubleTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private List<ColumnVector> vectors;
        private int vectorIndex = 0;

        private DoubleStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed, List<ColumnVector> vectors) throws IOException {
            super(columnId, (InStream)present, data);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
            this.vectors = vectors;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.vectors != null) {
                return;
            }
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
            if (this._dataStream.available() > 0) {
                this.stream.seek(index);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.vectors == null) {
                super.nextVector(previousVector, isNull, batchSize);
                return;
            }
            this.vectors.get(this.vectorIndex++).shallowCopyTo(previousVector);
            if (this.vectorIndex == this.vectors.size()) {
                this.vectors = null;
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            assert (this.vectors == null);
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;
            private List<ColumnVector> vectors;
            private TreeReaderFactory.Context context;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setContext(TreeReaderFactory.Context context) {
                this.context = context;
                return this;
            }

            public DoubleStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new DoubleStreamReader(this.columnIndex, present, data, isFileCompressed, this.vectors);
            }

            public StreamReaderBuilder setVectors(List<ColumnVector> vectors) {
                this.vectors = vectors;
                return this;
            }
        }
    }

    protected static class FloatStreamReader
    extends TreeReaderFactory.FloatTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private List<ColumnVector> vectors;
        private int vectorIndex = 0;

        private FloatStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed, List<ColumnVector> vectors) throws IOException {
            super(columnId, (InStream)present, data);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
            this.vectors = vectors;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.vectors != null) {
                return;
            }
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
            if (this._dataStream.available() > 0) {
                this.stream.seek(index);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.vectors == null) {
                super.nextVector(previousVector, isNull, batchSize);
                return;
            }
            this.vectors.get(this.vectorIndex++).shallowCopyTo(previousVector);
            if (this.vectorIndex == this.vectors.size()) {
                this.vectors = null;
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            assert (this.vectors == null);
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;
            private List<ColumnVector> vectors;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public FloatStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new FloatStreamReader(this.columnIndex, present, data, isFileCompressed, this.vectors);
            }

            public StreamReaderBuilder setVectors(List<ColumnVector> vectors) {
                this.vectors = vectors;
                return this;
            }
        }
    }

    protected static class IntStreamReader
    extends TreeReaderFactory.IntTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private List<ColumnVector> vectors;
        private int vectorIndex = 0;

        private IntStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed, OrcProto.ColumnEncoding encoding, TreeReaderFactory.Context context, List<ColumnVector> vectors) throws IOException {
            super(columnId, present, data, encoding, context);
            this._isFileCompressed = isFileCompressed;
            this._dataStream = data;
            this._presentStream = present;
            this.vectors = vectors;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.vectors != null) {
                return;
            }
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._dataStream.available() > 0) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.reader.seek(index);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.vectors == null) {
                super.nextVector(previousVector, isNull, batchSize);
                return;
            }
            this.vectors.get(this.vectorIndex++).shallowCopyTo(previousVector);
            if (this.vectorIndex == this.vectors.size()) {
                this.vectors = null;
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            assert (this.vectors == null);
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private List<ColumnVector> vectors;
            private TreeReaderFactory.Context context;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public StreamReaderBuilder setContext(TreeReaderFactory.Context context) {
                this.context = context;
                return this;
            }

            public IntStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new IntStreamReader(this.columnIndex, present, data, isFileCompressed, this.columnEncoding, this.context, this.vectors);
            }

            public StreamReaderBuilder setVectors(List<ColumnVector> vectors) {
                this.vectors = vectors;
                return this;
            }
        }
    }

    protected static class LongStreamReader
    extends TreeReaderFactory.LongTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private List<ColumnVector> vectors;
        private int vectorIndex = 0;

        private LongStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed, OrcProto.ColumnEncoding encoding, TreeReaderFactory.Context context, List<ColumnVector> vectors) throws IOException {
            super(columnId, present, data, encoding, context);
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
            this.vectors = vectors;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.vectors != null) {
                return;
            }
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._dataStream.available() > 0) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.reader.seek(index);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.vectors == null) {
                super.nextVector(previousVector, isNull, batchSize);
                return;
            }
            this.vectors.get(this.vectorIndex++).shallowCopyTo(previousVector);
            if (this.vectorIndex == this.vectors.size()) {
                this.vectors = null;
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            assert (this.vectors == null);
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private TreeReaderFactory.Context context;
            private List<ColumnVector> vectors;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public StreamReaderBuilder setContext(TreeReaderFactory.Context context) {
                this.context = context;
                return this;
            }

            public LongStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new LongStreamReader(this.columnIndex, present, data, isFileCompressed, this.columnEncoding, this.context, this.vectors);
            }

            public StreamReaderBuilder setVectors(List<ColumnVector> vectors) {
                this.vectors = vectors;
                return this;
            }
        }
    }

    protected static class ShortStreamReader
    extends TreeReaderFactory.ShortTreeReader
    implements SettableTreeReader {
        private boolean isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private List<ColumnVector> vectors;
        private int vectorIndex = 0;

        private ShortStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, boolean isFileCompressed, OrcProto.ColumnEncoding encoding, TreeReaderFactory.Context context, List<ColumnVector> vectors) throws IOException {
            super(columnId, present, data, encoding, context);
            this.isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
            this.vectors = vectors;
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.vectors != null) {
                return;
            }
            if (this.present != null) {
                if (this.isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._dataStream.available() > 0) {
                if (this.isFileCompressed) {
                    index.getNext();
                }
                this.reader.seek(index);
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.vectors == null) {
                super.nextVector(previousVector, isNull, batchSize);
                return;
            }
            this.vectors.get(this.vectorIndex++).shallowCopyTo(previousVector);
            if (this.vectorIndex == this.vectors.size()) {
                this.vectors = null;
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            assert (this.vectors == null);
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private List<ColumnVector> vectors;
            private TreeReaderFactory.Context context;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public StreamReaderBuilder setContext(TreeReaderFactory.Context context) {
                this.context = context;
                return this;
            }

            public ShortStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new ShortStreamReader(this.columnIndex, present, data, isFileCompressed, this.columnEncoding, this.context, this.vectors);
            }

            public StreamReaderBuilder setVectors(List<ColumnVector> vectors) {
                this.vectors = vectors;
                return this;
            }
        }
    }

    protected static class StringStreamReader
    extends TreeReaderFactory.StringTreeReader
    implements SettableTreeReader {
        private boolean _isFileCompressed;
        private boolean _isDictionaryEncoding;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _dataStream;
        private SettableUncompressedStream _lengthStream;
        private SettableUncompressedStream _dictionaryStream;
        private List<ColumnVector> vectors;
        private int vectorIndex = 0;

        private StringStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, SettableUncompressedStream length, SettableUncompressedStream dictionary, boolean isFileCompressed, OrcProto.ColumnEncoding encoding, TreeReaderFactory.Context context, List<ColumnVector> vectors) throws IOException {
            super(columnId, present, data, length, dictionary, encoding, context);
            this._isDictionaryEncoding = dictionary != null;
            this._isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._dataStream = data;
            this._lengthStream = length;
            this._dictionaryStream = dictionary;
            this.vectors = vectors;
        }

        @Override
        public void seek(PositionProvider[] index) throws IOException {
            this.seek(index[this.columnId]);
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.vectors != null) {
                return;
            }
            if (this.present != null) {
                if (this._isFileCompressed) {
                    index.getNext();
                }
                this.reader.getPresent().seek(index);
            }
            if (this._isDictionaryEncoding) {
                EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
                if (this._dataStream != null && this._dataStream.available() > 0) {
                    ((TreeReaderFactory.StringDictionaryTreeReader)this.reader).getReader().seek(index);
                }
            } else {
                EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
                InStream stream = ((TreeReaderFactory.StringDirectTreeReader)this.reader).getStream();
                if (this._dataStream != null && this._dataStream.available() > 0) {
                    stream.seek(index);
                } else {
                    assert (stream == this._dataStream);
                    EncodedTreeReaderFactory.skipSeek(index);
                }
                EncodedTreeReaderFactory.skipCompressedIndex(this._isFileCompressed, index);
                if (this._lengthStream != null && this._lengthStream.available() > 0) {
                    ((TreeReaderFactory.StringDirectTreeReader)this.reader).getLengths().seek(index);
                }
            }
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.vectors == null) {
                super.nextVector(previousVector, isNull, batchSize);
                return;
            }
            this.vectors.get(this.vectorIndex++).shallowCopyTo(previousVector);
            if (this.vectorIndex == this.vectors.size()) {
                this.vectors = null;
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            assert (this.vectors == null);
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._dataStream != null) {
                this._dataStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
            if (!this._isDictionaryEncoding && this._lengthStream != null) {
                this._lengthStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
            }
            if (!sameStripe && this._isDictionaryEncoding) {
                if (this._lengthStream != null) {
                    this._lengthStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[2]));
                }
                if (this._dictionaryStream != null) {
                    this._dictionaryStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[3]));
                }
            }
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private EncodedColumnBatch.ColumnStreamData dictionaryStream;
            private EncodedColumnBatch.ColumnStreamData lengthStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private List<ColumnVector> vectors;
            private TreeReaderFactory.Context context;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setDataStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setLengthStream(EncodedColumnBatch.ColumnStreamData lengthStream) {
                this.lengthStream = lengthStream;
                return this;
            }

            public StreamReaderBuilder setDictionaryStream(EncodedColumnBatch.ColumnStreamData dictStream) {
                this.dictionaryStream = dictStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public StreamReaderBuilder setContext(TreeReaderFactory.Context context) {
                this.context = context;
                return this;
            }

            public StringStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                SettableUncompressedStream length = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.LENGTH.name(), this.lengthStream);
                SettableUncompressedStream dictionary = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DICTIONARY_DATA.name(), this.dictionaryStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new StringStreamReader(this.columnIndex, present, data, length, dictionary, isFileCompressed, this.columnEncoding, this.context, this.vectors);
            }

            public StreamReaderBuilder setVectors(List<ColumnVector> vectors) {
                this.vectors = vectors;
                return this;
            }
        }
    }

    public static class TimestampStreamReader
    extends TreeReaderFactory.TimestampTreeReader
    implements SettableTreeReader {
        private boolean isFileCompressed;
        private SettableUncompressedStream _presentStream;
        private SettableUncompressedStream _secondsStream;
        private SettableUncompressedStream _nanosStream;
        private List<ColumnVector> vectors;
        private int vectorIndex = 0;

        private TimestampStreamReader(int columnId, SettableUncompressedStream present, SettableUncompressedStream data, SettableUncompressedStream nanos, boolean isFileCompressed, OrcProto.ColumnEncoding encoding, TreeReaderFactory.Context context, List<ColumnVector> vectors) throws IOException {
            super(columnId, present, data, nanos, encoding, context);
            this.isFileCompressed = isFileCompressed;
            this._presentStream = present;
            this._secondsStream = data;
            this._nanosStream = nanos;
            this.vectors = vectors;
        }

        @Override
        public void nextVector(ColumnVector previousVector, boolean[] isNull, int batchSize) throws IOException {
            if (this.vectors == null) {
                super.nextVector(previousVector, isNull, batchSize);
                return;
            }
            this.vectors.get(this.vectorIndex++).shallowCopyTo(previousVector);
            if (this.vectorIndex == this.vectors.size()) {
                this.vectors = null;
            }
        }

        @Override
        public void seek(PositionProvider index) throws IOException {
            if (this.vectors != null) {
                return;
            }
            if (this.present != null) {
                if (this.isFileCompressed) {
                    index.getNext();
                }
                this.present.seek(index);
            }
            if (this._secondsStream.available() > 0) {
                if (this.isFileCompressed) {
                    index.getNext();
                }
                this.data.seek(index);
            }
            if (this._nanosStream.available() > 0) {
                if (this.isFileCompressed) {
                    index.getNext();
                }
                this.nanos.seek(index);
            }
        }

        @Override
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> batch, boolean sameStripe) throws IOException {
            assert (this.vectors == null);
            EncodedColumnBatch.ColumnStreamData[] streamsData = batch.getColumnData(this.columnId);
            if (this._presentStream != null) {
                this._presentStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[0]));
            }
            if (this._secondsStream != null) {
                this._secondsStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[1]));
            }
            if (this._nanosStream != null) {
                this._nanosStream.setBuffers(StreamUtils.createDiskRangeInfo(streamsData[5]));
            }
        }

        public void updateTimezone(String writerTimezoneId) throws IOException {
            this.base_timestamp = this.getBaseTimestamp(writerTimezoneId);
        }

        public static StreamReaderBuilder builder() {
            return new StreamReaderBuilder();
        }

        public static class StreamReaderBuilder {
            private int columnIndex;
            private EncodedColumnBatch.ColumnStreamData presentStream;
            private EncodedColumnBatch.ColumnStreamData dataStream;
            private EncodedColumnBatch.ColumnStreamData nanosStream;
            private CompressionCodec compressionCodec;
            private OrcProto.ColumnEncoding columnEncoding;
            private TreeReaderFactory.Context context;
            private List<ColumnVector> vectors;

            public StreamReaderBuilder setColumnIndex(int columnIndex) {
                this.columnIndex = columnIndex;
                return this;
            }

            public StreamReaderBuilder setPresentStream(EncodedColumnBatch.ColumnStreamData presentStream) {
                this.presentStream = presentStream;
                return this;
            }

            public StreamReaderBuilder setSecondsStream(EncodedColumnBatch.ColumnStreamData dataStream) {
                this.dataStream = dataStream;
                return this;
            }

            public StreamReaderBuilder setNanosStream(EncodedColumnBatch.ColumnStreamData secondaryStream) {
                this.nanosStream = secondaryStream;
                return this;
            }

            public StreamReaderBuilder setCompressionCodec(CompressionCodec compressionCodec) {
                this.compressionCodec = compressionCodec;
                return this;
            }

            public StreamReaderBuilder setColumnEncoding(OrcProto.ColumnEncoding encoding) {
                this.columnEncoding = encoding;
                return this;
            }

            public StreamReaderBuilder setContext(TreeReaderFactory.Context context) {
                this.context = context;
                return this;
            }

            public TimestampStreamReader build() throws IOException {
                SettableUncompressedStream present = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.PRESENT.name(), this.presentStream);
                SettableUncompressedStream data = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.DATA.name(), this.dataStream);
                SettableUncompressedStream nanos = StreamUtils.createSettableUncompressedStream(OrcProto.Stream.Kind.SECONDARY.name(), this.nanosStream);
                boolean isFileCompressed = this.compressionCodec != null;
                return new TimestampStreamReader(this.columnIndex, present, data, nanos, isFileCompressed, this.columnEncoding, this.context, this.vectors);
            }

            public StreamReaderBuilder setVectors(List<ColumnVector> vectors) {
                this.vectors = vectors;
                return this;
            }
        }
    }

    public static interface SettableTreeReader {
        public void setBuffers(EncodedColumnBatch<OrcBatchKey> var1, boolean var2) throws IOException;
    }
}

