/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import java.util.HashMap;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.processors.ResetProcessor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Test;
import org.mockito.Mockito;

public class TestResetProcessor {
    @Test
    public void testResetClosesSparkSession() throws Exception {
        SessionState mockSessionState = TestResetProcessor.createMockSparkSessionState();
        new ResetProcessor().run(mockSessionState, "");
        ((SessionState)Mockito.verify((Object)mockSessionState)).closeSparkSession();
    }

    @Test
    public void testResetExecutionEngineClosesSparkSession() throws Exception {
        SessionState mockSessionState = TestResetProcessor.createMockSparkSessionState();
        new ResetProcessor().run(mockSessionState, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname);
        ((SessionState)Mockito.verify((Object)mockSessionState)).closeSparkSession();
    }

    private static SessionState createMockSparkSessionState() {
        SessionState mockSessionState = (SessionState)Mockito.mock(SessionState.class);
        HashMap<String, String> overriddenConfigurations = new HashMap<String, String>();
        overriddenConfigurations.put(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname, "spark");
        Mockito.when((Object)mockSessionState.getOverriddenConfigurations()).thenReturn(overriddenConfigurations);
        Mockito.when((Object)mockSessionState.getConf()).thenReturn((Object)new HiveConf());
        return mockSessionState;
    }
}

