/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.metadata.CheckResult;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreChecker;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TestHiveMetaStoreChecker {
    private Hive hive;
    private FileSystem fs;
    private HiveMetaStoreChecker checker = null;
    private final String dbName = "testhivemetastorechecker_db";
    private final String tableName = "testhivemetastorechecker_table";
    private final String partDateName = "partdate";
    private final String partCityName = "partcity";
    private List<FieldSchema> partCols;
    private List<Map<String, String>> parts;

    @Before
    public void setUp() throws Exception {
        this.hive = Hive.get();
        this.hive.getConf().set("fs.defaultFS", "file:///");
        this.hive.getConf().setIntVar(HiveConf.ConfVars.METASTORE_FS_HANDLER_THREADS_COUNT, 15);
        this.hive.getConf().set(HiveConf.ConfVars.HIVE_MSCK_PATH_VALIDATION.varname, "throw");
        this.checker = new HiveMetaStoreChecker(this.hive);
        this.partCols = new ArrayList<FieldSchema>();
        this.partCols.add(new FieldSchema("partdate", "string", ""));
        this.partCols.add(new FieldSchema("partcity", "string", ""));
        this.parts = new ArrayList<Map<String, String>>();
        HashMap<String, String> part1 = new HashMap<String, String>();
        part1.put("partdate", "2008-01-01");
        part1.put("partcity", "london");
        this.parts.add(part1);
        HashMap<String, String> part2 = new HashMap<String, String>();
        part2.put("partdate", "2008-01-02");
        part2.put("partcity", "stockholm");
        this.parts.add(part2);
        this.dropDbTable();
    }

    private void dropDbTable() {
        try {
            this.hive.dropTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", true, true);
            this.hive.dropDatabase("testhivemetastorechecker_db", true, true, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
        }
        catch (HiveException hiveException) {
            // empty catch block
        }
    }

    @After
    public void tearDown() throws Exception {
        this.dropDbTable();
        Hive.closeCurrent();
    }

    @Test
    public void testTableCheck() throws HiveException, MetaException, IOException, TException, AlreadyExistsException {
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", null, null, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        Assert.assertEquals((long)1L, (long)result.getTablesNotInMs().size());
        Assert.assertEquals((Object)"testhivemetastorechecker_table", result.getTablesNotInMs().iterator().next());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        Database db = new Database();
        db.setName("testhivemetastorechecker_db");
        this.hive.createDatabase(db);
        Table table = new Table("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setDbName("testhivemetastorechecker_db");
        table.setInputFormatClass(TextInputFormat.class);
        table.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        this.hive.createTable(table);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", null, null, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        this.fs = table.getPath().getFileSystem((Configuration)this.hive.getConf());
        this.fs.delete(table.getPath(), true);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals((long)1L, (long)result.getTablesNotOnFs().size());
        Assert.assertEquals((Object)"testhivemetastorechecker_table", result.getTablesNotOnFs().iterator().next());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        this.fs.mkdirs(table.getPath());
        Path fakeTable = table.getPath().getParent().suffix("/faketable");
        this.fs.mkdirs(fakeTable);
        this.fs.deleteOnExit(fakeTable);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", null, null, result);
        Assert.assertEquals((long)1L, (long)result.getTablesNotInMs().size());
        Assert.assertEquals((Object)fakeTable.getName(), Lists.newArrayList((Iterable)result.getTablesNotInMs()).get(0));
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        this.hive.dropTable("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setProperty("EXTERNAL", "TRUE");
        this.hive.createTable(table);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", null, null, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
    }

    @Test
    public void testAdditionalPartitionDirs() throws HiveException, AlreadyExistsException, IOException {
        Table table = this.createTestTable();
        List partitions = this.hive.getPartitions(table);
        Assert.assertEquals((long)2L, (long)partitions.size());
        this.fs = ((Partition)partitions.get(0)).getDataLocation().getFileSystem((Configuration)this.hive.getConf());
        Path fakePart = new Path(table.getDataLocation().toString(), "partdate=2017-01-01/partcity=paloalto/fakePartCol=fakepartValue");
        this.fs.mkdirs(fakePart);
        this.fs.deleteOnExit(fakePart);
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)1L, (long)result.getPartitionsNotInMs().size());
    }

    @Test(expected=HiveException.class)
    public void testInvalidPartitionKeyName() throws HiveException, AlreadyExistsException, IOException {
        Table table = this.createTestTable();
        List partitions = this.hive.getPartitions(table);
        Assert.assertEquals((long)2L, (long)partitions.size());
        this.fs = ((Partition)partitions.get(0)).getDataLocation().getFileSystem((Configuration)this.hive.getConf());
        Path fakePart = new Path(table.getDataLocation().toString(), "fakedate=2009-01-01/fakecity=sanjose");
        this.fs.mkdirs(fakePart);
        this.fs.deleteOnExit(fakePart);
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, new CheckResult());
    }

    @Test
    public void testSkipInvalidPartitionKeyName() throws HiveException, AlreadyExistsException, IOException {
        this.hive.getConf().set(HiveConf.ConfVars.HIVE_MSCK_PATH_VALIDATION.varname, "skip");
        this.checker = new HiveMetaStoreChecker(this.hive);
        Table table = this.createTestTable();
        List partitions = this.hive.getPartitions(table);
        Assert.assertEquals((long)2L, (long)partitions.size());
        this.fs = ((Partition)partitions.get(0)).getDataLocation().getFileSystem((Configuration)this.hive.getConf());
        Path fakePart = new Path(table.getDataLocation().toString(), "fakedate=2009-01-01/fakecity=sanjose");
        this.fs.mkdirs(fakePart);
        this.fs.deleteOnExit(fakePart);
        this.createPartitionsDirectoriesOnFS(table, 2);
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)2L, (long)result.getPartitionsNotInMs().size());
    }

    private Table createTestTable() throws AlreadyExistsException, HiveException {
        Database db = new Database();
        db.setName("testhivemetastorechecker_db");
        this.hive.createDatabase(db);
        Table table = new Table("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setDbName("testhivemetastorechecker_db");
        table.setInputFormatClass(TextInputFormat.class);
        table.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        table.setPartCols(this.partCols);
        this.hive.createTable(table);
        table = this.hive.getTable("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        for (Map<String, String> partSpec : this.parts) {
            this.hive.createPartition(table, partSpec);
        }
        return table;
    }

    @Test
    public void testPartitionsCheck() throws HiveException, MetaException, IOException, TException, AlreadyExistsException {
        Table table = this.createTestTable();
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        List partitions = this.hive.getPartitions(table);
        Assert.assertEquals((long)2L, (long)partitions.size());
        Partition partToRemove = (Partition)partitions.get(0);
        Path partToRemovePath = partToRemove.getDataLocation().getParent();
        this.fs = partToRemovePath.getFileSystem((Configuration)this.hive.getConf());
        this.fs.delete(partToRemovePath, true);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals((long)1L, (long)result.getPartitionsNotOnFs().size());
        Assert.assertEquals((Object)partToRemove.getName(), (Object)((CheckResult.PartitionResult)result.getPartitionsNotOnFs().iterator().next()).getPartitionName());
        Assert.assertEquals((Object)partToRemove.getTable().getTableName(), (Object)((CheckResult.PartitionResult)result.getPartitionsNotOnFs().iterator().next()).getTableName());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        ArrayList<LinkedHashMap> partsCopy = new ArrayList<LinkedHashMap>();
        partsCopy.add(((Partition)partitions.get(1)).getSpec());
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", partsCopy, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        this.hive.dropTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", true, true);
        this.hive.createTable(table);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", null, null, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        System.err.println("Test completed - partition check");
    }

    @Test
    public void testDataDeletion() throws HiveException, MetaException, IOException, TException, AlreadyExistsException, NoSuchObjectException {
        Database db = new Database();
        db.setName("testhivemetastorechecker_db");
        this.hive.createDatabase(db);
        Table table = new Table("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setDbName("testhivemetastorechecker_db");
        table.setInputFormatClass(TextInputFormat.class);
        table.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        table.setPartCols(this.partCols);
        this.hive.createTable(table);
        table = this.hive.getTable("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        Path fakeTable = table.getPath().getParent().suffix("/faketable");
        this.fs = fakeTable.getFileSystem((Configuration)this.hive.getConf());
        this.fs.mkdirs(fakeTable);
        this.fs.deleteOnExit(fakeTable);
        Path fakePart = new Path(table.getDataLocation().toString(), "fakepartition=fakevalue");
        this.fs.mkdirs(fakePart);
        this.fs.deleteOnExit(fakePart);
        this.hive.dropTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", true, true);
        Assert.assertFalse((boolean)this.fs.exists(fakePart));
        this.hive.dropDatabase("testhivemetastorechecker_db");
        Assert.assertFalse((boolean)this.fs.exists(fakeTable));
    }

    @Test
    public void testPartitionsNotInMs() throws HiveException, AlreadyExistsException, IOException {
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)10L, (long)result.getPartitionsNotInMs().size());
    }

    @Test
    public void testSingleThreadedCheckMetastore() throws HiveException, AlreadyExistsException, IOException {
        this.hive.getConf().setIntVar(HiveConf.ConfVars.METASTORE_FS_HANDLER_THREADS_COUNT, 0);
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)10L, (long)result.getPartitionsNotInMs().size());
    }

    @Test
    public void testSingleThreadedDeeplyNestedTables() throws HiveException, AlreadyExistsException, IOException {
        this.hive.getConf().setIntVar(HiveConf.ConfVars.METASTORE_FS_HANDLER_THREADS_COUNT, 0);
        int poolSize = 2;
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", poolSize + 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)10L, (long)result.getPartitionsNotInMs().size());
    }

    @Test
    public void testDeeplyNestedPartitionedTables() throws HiveException, AlreadyExistsException, IOException {
        this.hive.getConf().setIntVar(HiveConf.ConfVars.METASTORE_FS_HANDLER_THREADS_COUNT, 2);
        int poolSize = 2;
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", poolSize + 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)10L, (long)result.getPartitionsNotInMs().size());
    }

    @Test
    public void testErrorForMissingPartitionColumn() throws AlreadyExistsException, IOException, HiveException {
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        StringBuilder sb = new StringBuilder(testTable.getDataLocation().toString());
        sb.append("/");
        sb.append("dummyPart=error");
        this.createDirectory(sb.toString());
        CheckResult result = new CheckResult();
        Exception exception = null;
        try {
            this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        }
        catch (Exception e) {
            exception = e;
        }
        Assert.assertTrue((String)"Expected HiveException", (exception != null && exception instanceof HiveException ? 1 : 0) != 0);
        this.createFile(sb.toString(), "dummyFile");
        result = new CheckResult();
        exception = null;
        try {
            this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        }
        catch (Exception e) {
            exception = e;
        }
        Assert.assertTrue((String)"Expected HiveException", (exception != null && exception instanceof HiveException ? 1 : 0) != 0);
    }

    @Test(expected=HiveException.class)
    public void testInvalidOrderForPartitionKeysOnFS() throws AlreadyExistsException, HiveException, IOException {
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createInvalidPartitionDirsOnFS(testTable, 10);
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
    }

    @Test
    public void testSkipInvalidOrderForPartitionKeysOnFS() throws AlreadyExistsException, HiveException, IOException {
        this.hive.getConf().set(HiveConf.ConfVars.HIVE_MSCK_PATH_VALIDATION.varname, "skip");
        this.checker = new HiveMetaStoreChecker(this.hive);
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createInvalidPartitionDirsOnFS(testTable, 2);
        this.createPartitionsDirectoriesOnFS(testTable, 2);
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        Assert.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        Assert.assertEquals((long)2L, (long)result.getPartitionsNotInMs().size());
    }

    @Test
    public void testErrorForMissingPartitionsSingleThreaded() throws AlreadyExistsException, HiveException, IOException {
        this.hive.getConf().setIntVar(HiveConf.ConfVars.METASTORE_FS_HANDLER_THREADS_COUNT, 0);
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        StringBuilder sb = new StringBuilder(testTable.getDataLocation().toString());
        sb.append("/");
        sb.append("dummyPart=error");
        this.createDirectory(sb.toString());
        CheckResult result = new CheckResult();
        Exception exception = null;
        try {
            this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        }
        catch (Exception e) {
            exception = e;
        }
        Assert.assertTrue((String)"Expected HiveException", (exception != null && exception instanceof HiveException ? 1 : 0) != 0);
        this.createFile(sb.toString(), "dummyFile");
        result = new CheckResult();
        exception = null;
        try {
            this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        }
        catch (Exception e) {
            exception = e;
        }
        Assert.assertTrue((String)"Expected HiveException", (exception != null && exception instanceof HiveException ? 1 : 0) != 0);
    }

    private Table createPartitionedTestTable(String dbName, String tableName, int numOfPartKeys, int valuesPerPartition) throws AlreadyExistsException, HiveException {
        Database db = new Database();
        db.setName(dbName);
        this.hive.createDatabase(db);
        Table table = new Table(dbName, tableName);
        table.setDbName(dbName);
        table.setInputFormatClass(TextInputFormat.class);
        table.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        ArrayList<FieldSchema> partKeys = new ArrayList<FieldSchema>();
        for (int i = 1; i <= numOfPartKeys; ++i) {
            String partName = "part" + String.valueOf(i);
            partKeys.add(new FieldSchema(partName, "string", ""));
        }
        table.setPartCols(partKeys);
        this.hive.createTable(table);
        table = this.hive.getTable(dbName, tableName);
        if (valuesPerPartition == 0) {
            return table;
        }
        ArrayList partitionSpecs = new ArrayList();
        for (int partKeyIndex = 0; partKeyIndex < numOfPartKeys; ++partKeyIndex) {
            String string = ((FieldSchema)partKeys.get(partKeyIndex)).getName();
            HashMap<String, String> partMap = new HashMap<String, String>();
            for (int val = 1; val <= valuesPerPartition; ++val) {
                partMap.put(string, String.valueOf(val));
            }
            partitionSpecs.add(partMap);
        }
        for (Map map : partitionSpecs) {
            this.hive.createPartition(table, map);
        }
        List partitions = this.hive.getPartitions(table);
        Assert.assertEquals((long)(numOfPartKeys * valuesPerPartition), (long)partitions.size());
        return table;
    }

    private void createPartitionsDirectoriesOnFS(Table table, int numPartitions, boolean reverseOrder) throws IOException {
        String path = table.getDataLocation().toString();
        this.fs = table.getPath().getFileSystem((Configuration)this.hive.getConf());
        int numPartKeys = table.getPartitionKeys().size();
        for (int i = 0; i < numPartitions; ++i) {
            FieldSchema field;
            int j;
            StringBuilder partPath = new StringBuilder(path);
            partPath.append("/");
            if (!reverseOrder) {
                for (j = 0; j < numPartKeys; ++j) {
                    field = (FieldSchema)table.getPartitionKeys().get(j);
                    partPath.append(field.getName());
                    partPath.append('=');
                    partPath.append("val_");
                    partPath.append(i);
                    if (j >= numPartKeys - 1) continue;
                    partPath.append("/");
                }
            } else {
                for (j = numPartKeys - 1; j >= 0; --j) {
                    field = (FieldSchema)table.getPartitionKeys().get(j);
                    partPath.append(field.getName());
                    partPath.append('=');
                    partPath.append("val_");
                    partPath.append(i);
                    if (j <= 0) continue;
                    partPath.append("/");
                }
            }
            this.createDirectory(partPath.toString());
        }
    }

    private void createPartitionsDirectoriesOnFS(Table table, int numPartitions) throws IOException {
        this.createPartitionsDirectoriesOnFS(table, numPartitions, false);
    }

    private void createInvalidPartitionDirsOnFS(Table table, int numPartitions) throws IOException {
        this.createPartitionsDirectoriesOnFS(table, numPartitions, true);
    }

    private void createFile(String partPath, String filename) throws IOException {
        Path part = new Path(partPath);
        this.fs.mkdirs(part);
        this.fs.createNewFile(new Path(partPath + "/" + filename));
        this.fs.deleteOnExit(part);
    }

    private void createDirectory(String partPath) throws IOException {
        Path part = new Path(partPath);
        this.fs.mkdirs(part);
        this.fs.deleteOnExit(part);
    }
}

