/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.index;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.index.MockHiveInputSplits;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;

public final class MockInputFile {
    private final String path;
    private final ImmutableList<HiveInputFormat.HiveInputSplit> splits;
    private final ImmutableList<HiveInputFormat.HiveInputSplit> selectedSplits;

    private MockInputFile(String path, List<HiveInputFormat.HiveInputSplit> splits, List<HiveInputFormat.HiveInputSplit> selectedSplits) {
        this.path = path;
        this.splits = ImmutableList.copyOf(splits);
        this.selectedSplits = ImmutableList.copyOf(selectedSplits);
    }

    public String getPath() {
        return this.path;
    }

    public List<HiveInputFormat.HiveInputSplit> getSplits() {
        return this.splits;
    }

    public List<HiveInputFormat.HiveInputSplit> getSelectedSplits() {
        return this.selectedSplits;
    }

    public static PathStep builder() {
        return new MockInputFileBuilder();
    }

    private static final class MockInputFileBuilder
    implements PathStep,
    SplitStep,
    LastSplitStep,
    DefaultSplitLengthStep {
        private String path;
        public static final long DEFAULT_SPLIT_SIZE = 0x100000L;
        private long defaultSplitSize = 0x100000L;
        private final List<HiveInputFormat.HiveInputSplit> splits = new ArrayList<HiveInputFormat.HiveInputSplit>();
        private final List<HiveInputFormat.HiveInputSplit> selectedSplits = new ArrayList<HiveInputFormat.HiveInputSplit>();
        private long position = 0L;

        private MockInputFileBuilder() {
        }

        @Override
        public DefaultSplitLengthStep path(String path) {
            this.path = path;
            return this;
        }

        @Override
        public SplitStep split() {
            this.nextSplit(this.defaultSplitSize);
            return this;
        }

        @Override
        public LastSplitStep split(long lastSplitSize) {
            this.nextSplit(lastSplitSize);
            return this;
        }

        @Override
        public SplitStep selectedSplit() {
            this.selectedSplits.add(this.nextSplit(this.defaultSplitSize));
            return this;
        }

        @Override
        public LastSplitStep selectedSplit(long lastSplitSize) {
            this.selectedSplits.add(this.nextSplit(lastSplitSize));
            return this;
        }

        @Override
        public SplitStep defaultSplitLength(long defaultSplitLength) {
            this.defaultSplitSize = defaultSplitLength;
            return this;
        }

        private HiveInputFormat.HiveInputSplit nextSplit(long splitSize) {
            HiveInputFormat.HiveInputSplit split = MockHiveInputSplits.createMockSplit(this.path, this.position, splitSize);
            this.position += splitSize;
            this.splits.add(split);
            return split;
        }

        @Override
        public MockInputFile build() {
            return new MockInputFile(this.path, this.splits, this.selectedSplits);
        }
    }

    public static interface LastSplitStep {
        public MockInputFile build();
    }

    public static interface SplitStep {
        public SplitStep split();

        public SplitStep selectedSplit();

        public LastSplitStep split(long var1);

        public LastSplitStep selectedSplit(long var1);

        public MockInputFile build();
    }

    public static interface DefaultSplitLengthStep
    extends SplitStep {
        public SplitStep defaultSplitLength(long var1);
    }

    public static interface PathStep {
        public DefaultSplitLengthStep path(String var1);
    }
}

