/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.DataTypePhysicalVariation;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.vector.VectorExtractRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomBatchSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.junit.Test;

public class TestVectorStringUnary {
    @Test
    public void testString() throws Exception {
        Random random = new Random(83221L);
        this.doTests(random, "string");
    }

    @Test
    public void testChar() throws Exception {
        Random random = new Random(12882L);
        this.doTests(random, "char(10)");
    }

    @Test
    public void testVarchar() throws Exception {
        Random random = new Random(12882L);
        this.doTests(random, "varchar(15)");
    }

    private void doTests(Random random, String typeName) throws Exception {
        if (typeName.equals("string")) {
            this.doTests(random, typeName, "ltrim");
            this.doTests(random, typeName, "rtrim");
            this.doTests(random, typeName, "trim");
            this.doTests(random, typeName, "initcap");
            this.doTests(random, typeName, "hex");
        }
        this.doTests(random, typeName, "lower");
        this.doTests(random, typeName, "upper");
        this.doTests(random, typeName, "char_length");
        this.doTests(random, typeName, "length");
        this.doTests(random, typeName, "octet_length");
    }

    private void doTests(Random random, String typeName, String functionName) throws Exception {
        int i;
        TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
        Object targetTypeInfo = functionName.equals("char_length") || functionName.equals("length") || functionName.equals("octet_length") ? TypeInfoFactory.intTypeInfo : typeInfo;
        ArrayList<VectorRandomRowSource.GenerationSpec> generationSpecList = new ArrayList<VectorRandomRowSource.GenerationSpec>();
        ArrayList<DataTypePhysicalVariation> explicitDataTypePhysicalVariationList = new ArrayList<DataTypePhysicalVariation>();
        ArrayList<String> columns = new ArrayList<String>();
        int columnNum = 0;
        VectorRandomRowSource.StringGenerationOption stringGenerationOption = new VectorRandomRowSource.StringGenerationOption(true, true);
        generationSpecList.add(VectorRandomRowSource.GenerationSpec.createStringFamily(typeInfo, stringGenerationOption));
        explicitDataTypePhysicalVariationList.add(DataTypePhysicalVariation.NONE);
        String columnName = "col" + columnNum++;
        ExprNodeColumnDesc col1Expr = new ExprNodeColumnDesc(typeInfo, columnName, "table", false);
        columns.add(columnName);
        VectorRandomRowSource rowSource = new VectorRandomRowSource();
        rowSource.initGenerationSpecSchema(random, generationSpecList, 0, true, explicitDataTypePhysicalVariationList);
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        children.add((ExprNodeDesc)col1Expr);
        String[] columnNames = columns.toArray(new String[0]);
        String[] outputScratchTypeNames = new String[]{targetTypeInfo.getTypeName()};
        DataTypePhysicalVariation[] outputDataTypePhysicalVariations = new DataTypePhysicalVariation[]{DataTypePhysicalVariation.NONE};
        VectorizedRowBatchCtx batchContext = new VectorizedRowBatchCtx(columnNames, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), null, 0, 0, null, outputScratchTypeNames, outputDataTypePhysicalVariations);
        Object[][] randomRows = rowSource.randomRows(100000);
        VectorRandomBatchSource batchSource = VectorRandomBatchSource.createInterestingBatches(random, rowSource, randomRows, null);
        FunctionInfo funcInfo = null;
        try {
            funcInfo = FunctionRegistry.getFunctionInfo((String)functionName);
        }
        catch (SemanticException e) {
            Assert.fail((String)("Failed to load " + functionName + " " + e));
        }
        GenericUDF genericUdf = funcInfo.getGenericUDF();
        int rowCount = randomRows.length;
        Object[][] resultObjectsArray = new Object[StringUnaryTestMode.count][];
        block6: for (i = 0; i < StringUnaryTestMode.count; ++i) {
            Object[] resultObjects = new Object[rowCount];
            resultObjectsArray[i] = resultObjects;
            StringUnaryTestMode stringUnaryTestMode = StringUnaryTestMode.values()[i];
            switch (stringUnaryTestMode) {
                case ROW_MODE: {
                    this.doRowIfTest(typeInfo, (TypeInfo)targetTypeInfo, columns, children, randomRows, (ObjectInspector)rowSource.rowStructObjectInspector(), genericUdf, resultObjects);
                    continue block6;
                }
                case ADAPTOR: 
                case VECTOR_EXPRESSION: {
                    this.doVectorIfTest(typeInfo, (TypeInfo)targetTypeInfo, columns, rowSource.typeInfos(), rowSource.dataTypePhysicalVariations(), children, stringUnaryTestMode, batchSource, batchContext, genericUdf, resultObjects);
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Unexpected STRING Unary test mode " + stringUnaryTestMode);
                }
            }
        }
        for (i = 0; i < rowCount; ++i) {
            Object expectedResult = resultObjectsArray[0][i];
            for (int v = 1; v < StringUnaryTestMode.count; ++v) {
                Object vectorResult = resultObjectsArray[v][i];
                if (expectedResult == null || vectorResult == null) {
                    if (expectedResult == null && vectorResult == null) continue;
                    Assert.fail((String)("Row " + i + " " + StringUnaryTestMode.values()[v] + " typeName " + typeName + " result is NULL " + (vectorResult == null) + " does not match row-mode expected result is NULL " + (expectedResult == null) + " functionName " + functionName + " genericUdf " + genericUdf.getClass().getSimpleName()));
                    continue;
                }
                if (expectedResult.equals(vectorResult)) continue;
                Assert.fail((String)("Row " + i + " " + StringUnaryTestMode.values()[v] + " typeName " + typeName + " result \"" + vectorResult.toString() + "\" (" + vectorResult.getClass().getSimpleName() + ") does not match row-mode expected result \"" + expectedResult.toString() + "\" (" + expectedResult.getClass().getSimpleName() + ") functionName " + functionName + " genericUdf " + genericUdf.getClass().getSimpleName()));
            }
        }
    }

    private void doRowIfTest(TypeInfo typeInfo, TypeInfo targetTypeInfo, List<String> columns, List<ExprNodeDesc> children, Object[][] randomRows, ObjectInspector rowInspector, GenericUDF genericUdf, Object[] resultObjects) throws Exception {
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc(typeInfo, genericUdf, children);
        HiveConf hiveConf = new HiveConf();
        hiveConf.set("fs.defaultFS", "file:///");
        ExprNodeEvaluator evaluator = ExprNodeEvaluatorFactory.get((ExprNodeDesc)exprDesc, (Configuration)hiveConf);
        evaluator.initialize(rowInspector);
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)targetTypeInfo);
        for (Object[] row : randomRows) {
            Object copyResult;
            Object result = evaluator.evaluate((Object)row);
            resultObjects[i] = copyResult = ObjectInspectorUtils.copyToStandardObject((Object)result, (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        }
    }

    private void extractResultObjects(VectorizedRowBatch batch, int rowIndex, VectorExtractRow resultVectorExtractRow, Object[] scrqtchRow, TypeInfo targetTypeInfo, Object[] resultObjects) {
        ObjectInspector objectInspector = TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)targetTypeInfo);
        boolean selectedInUse = batch.selectedInUse;
        int[] selected = batch.selected;
        for (int logicalIndex = 0; logicalIndex < batch.size; ++logicalIndex) {
            int batchIndex = selectedInUse ? selected[logicalIndex] : logicalIndex;
            try {
                resultVectorExtractRow.extractRow(batch, batchIndex, scrqtchRow);
            }
            catch (Exception e) {
                Assert.fail((String)e.toString());
            }
            Object copyResult = ObjectInspectorUtils.copyToStandardObject((Object)scrqtchRow[0], (ObjectInspector)objectInspector, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
            resultObjects[rowIndex++] = copyResult;
        }
    }

    private void doVectorIfTest(TypeInfo typeInfo, TypeInfo targetTypeInfo, List<String> columns, TypeInfo[] typeInfos, DataTypePhysicalVariation[] dataTypePhysicalVariations, List<ExprNodeDesc> children, StringUnaryTestMode stringUnaryTestMode, VectorRandomBatchSource batchSource, VectorizedRowBatchCtx batchContext, GenericUDF genericUdf, Object[] resultObjects) throws Exception {
        ExprNodeGenericFuncDesc exprDesc = new ExprNodeGenericFuncDesc(targetTypeInfo, genericUdf, children);
        HiveConf hiveConf = new HiveConf();
        hiveConf.set("fs.defaultFS", "file:///");
        if (stringUnaryTestMode == StringUnaryTestMode.ADAPTOR) {
            hiveConf.setBoolVar(HiveConf.ConfVars.HIVE_TEST_VECTOR_ADAPTOR_OVERRIDE, true);
        }
        VectorizationContext vectorizationContext = new VectorizationContext("name", columns, Arrays.asList(typeInfos), Arrays.asList(dataTypePhysicalVariations), hiveConf);
        VectorExpression vectorExpression = vectorizationContext.getVectorExpression((ExprNodeDesc)exprDesc);
        VectorizedRowBatch batch = batchContext.createVectorizedRowBatch();
        VectorExtractRow resultVectorExtractRow = new VectorExtractRow();
        resultVectorExtractRow.init(new TypeInfo[]{targetTypeInfo}, new int[]{columns.size()});
        Object[] scrqtchRow = new Object[1];
        System.out.println("*DEBUG* typeInfo " + typeInfo.toString() + " targetTypeInfo " + targetTypeInfo.toString() + " stringUnaryTestMode " + stringUnaryTestMode + " vectorExpression " + vectorExpression.getClass().getSimpleName());
        batchSource.resetBatchIteration();
        int rowIndex = 0;
        while (batchSource.fillNextBatch(batch)) {
            vectorExpression.evaluate(batch);
            this.extractResultObjects(batch, rowIndex, resultVectorExtractRow, scrqtchRow, targetTypeInfo, resultObjects);
            rowIndex += batch.size;
        }
    }

    public static enum StringUnaryTestMode {
        ROW_MODE,
        ADAPTOR,
        VECTOR_EXPRESSION;

        static final int count;

        static {
            count = StringUnaryTestMode.values().length;
        }
    }
}

