/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnStatsTask;
import org.apache.hadoop.hive.ql.exec.ColumnStatsUpdateTask;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.CopyTask;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.exec.DependencyCollectionTask;
import org.apache.hadoop.hive.ql.exec.ExplainSQRewriteTask;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FunctionTask;
import org.apache.hadoop.hive.ql.exec.MapRDbJsonFetchByIdTask;
import org.apache.hadoop.hive.ql.exec.MoveTask;
import org.apache.hadoop.hive.ql.exec.ReplCopyTask;
import org.apache.hadoop.hive.ql.exec.StatsNoJobTask;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.mr.MapredLocalTask;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.index.IndexMetadataChangeTask;
import org.apache.hadoop.hive.ql.index.IndexMetadataChangeWork;
import org.apache.hadoop.hive.ql.io.merge.MergeFileTask;
import org.apache.hadoop.hive.ql.io.merge.MergeFileWork;
import org.apache.hadoop.hive.ql.io.rcfile.stats.PartialScanTask;
import org.apache.hadoop.hive.ql.io.rcfile.stats.PartialScanWork;
import org.apache.hadoop.hive.ql.plan.ColumnStatsUpdateWork;
import org.apache.hadoop.hive.ql.plan.ColumnStatsWork;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.CopyWork;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.DependencyCollectionWork;
import org.apache.hadoop.hive.ql.plan.ExplainSQRewriteWork;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FunctionWork;
import org.apache.hadoop.hive.ql.plan.MapRDbJsonFetchByIdWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.ReplCopyWork;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.StatsNoJobWork;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TezWork;

public final class TaskFactory {
    public static ArrayList<TaskTuple<? extends Serializable>> taskvec = new ArrayList();
    private static ThreadLocal<Integer> tid;

    public static int getAndIncrementId() {
        int curValue = tid.get();
        tid.set(new Integer(curValue + 1));
        return curValue;
    }

    public static void resetId() {
        tid.set(0);
    }

    public static <T extends Serializable> Task<T> get(Class<T> workClass, HiveConf conf) {
        for (TaskTuple<? extends Serializable> t : taskvec) {
            if (t.workClass != workClass) continue;
            try {
                Task ret = t.taskClass.newInstance();
                ret.setId("Stage-" + Integer.toString(TaskFactory.getAndIncrementId()));
                return ret;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("No task for work class " + workClass.getName());
    }

    public static <T extends Serializable> Task<T> get(T work, HiveConf conf, Task<? extends Serializable> ... tasklist) {
        Task<?> ret = TaskFactory.get(work.getClass(), conf);
        ret.setWork(work);
        if (tasklist.length == 0) {
            return ret;
        }
        ArrayList<Task<? extends Serializable>> clist = new ArrayList<Task<? extends Serializable>>();
        for (Task<? extends Serializable> tsk : tasklist) {
            clist.add(tsk);
        }
        ret.setChildTasks(clist);
        return ret;
    }

    public static <T extends Serializable> Task<T> getAndMakeChild(T work, HiveConf conf, Task<? extends Serializable> ... tasklist) {
        Task<?> ret = TaskFactory.get(work.getClass(), conf);
        ret.setWork(work);
        if (tasklist.length == 0) {
            return ret;
        }
        TaskFactory.makeChild(ret, tasklist);
        return ret;
    }

    public static void makeChild(Task<?> ret, Task<? extends Serializable> ... tasklist) {
        for (Task<? extends Serializable> tsk : tasklist) {
            List<Task<? extends Serializable>> children = tsk.getChildTasks();
            if (children == null) {
                children = new ArrayList<Task<Serializable>>();
            }
            children.add(ret);
            tsk.setChildTasks(children);
        }
    }

    private TaskFactory() {
    }

    static {
        taskvec.add(new TaskTuple(MoveWork.class, MoveTask.class));
        taskvec.add(new TaskTuple(FetchWork.class, FetchTask.class));
        taskvec.add(new TaskTuple(MapRDbJsonFetchByIdWork.class, MapRDbJsonFetchByIdTask.class));
        taskvec.add(new TaskTuple(CopyWork.class, CopyTask.class));
        taskvec.add(new TaskTuple(ReplCopyWork.class, ReplCopyTask.class));
        taskvec.add(new TaskTuple(DDLWork.class, DDLTask.class));
        taskvec.add(new TaskTuple(FunctionWork.class, FunctionTask.class));
        taskvec.add(new TaskTuple(ExplainWork.class, ExplainTask.class));
        taskvec.add(new TaskTuple(ExplainSQRewriteWork.class, ExplainSQRewriteTask.class));
        taskvec.add(new TaskTuple(ConditionalWork.class, ConditionalTask.class));
        taskvec.add(new TaskTuple(MapredWork.class, MapRedTask.class));
        taskvec.add(new TaskTuple(MapredLocalWork.class, MapredLocalTask.class));
        taskvec.add(new TaskTuple(StatsWork.class, StatsTask.class));
        taskvec.add(new TaskTuple(StatsNoJobWork.class, StatsNoJobTask.class));
        taskvec.add(new TaskTuple(ColumnStatsWork.class, ColumnStatsTask.class));
        taskvec.add(new TaskTuple(ColumnStatsUpdateWork.class, ColumnStatsUpdateTask.class));
        taskvec.add(new TaskTuple(MergeFileWork.class, MergeFileTask.class));
        taskvec.add(new TaskTuple(DependencyCollectionWork.class, DependencyCollectionTask.class));
        taskvec.add(new TaskTuple(PartialScanWork.class, PartialScanTask.class));
        taskvec.add(new TaskTuple(IndexMetadataChangeWork.class, IndexMetadataChangeTask.class));
        taskvec.add(new TaskTuple(TezWork.class, TezTask.class));
        taskvec.add(new TaskTuple(SparkWork.class, SparkTask.class));
        tid = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };
    }

    public static final class TaskTuple<T extends Serializable> {
        public Class workClass;
        public Class<? extends Task> taskClass;

        public TaskTuple(Class workClass, Class<? extends Task> taskClass) {
            this.workClass = workClass;
            this.taskClass = taskClass;
        }
    }
}

