/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udaf;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.plan.ptf.BoundaryDef;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.ql.udf.generic.ISupportStreamingModeForWindowing;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.LongWritable;
import org.junit.Test;

public class TestStreamingSum {
    public static WindowFrameDef wdwFrame(int p, int f) {
        BoundaryDef start = p == 0 ? new BoundaryDef(WindowingSpec.Direction.CURRENT, 0) : new BoundaryDef(WindowingSpec.Direction.PRECEDING, p);
        BoundaryDef end = f == 0 ? new BoundaryDef(WindowingSpec.Direction.CURRENT, 0) : new BoundaryDef(WindowingSpec.Direction.FOLLOWING, f);
        return new WindowFrameDef(WindowingSpec.WindowType.ROWS, start, end);
    }

    public void sumDouble(Iterator<Double> inVals, int inSz, int numPreceding, int numFollowing, Iterator<Double> outVals) throws HiveException {
        GenericUDAFSum fnR = new GenericUDAFSum();
        TypeInfo[] inputTypes = new TypeInfo[]{TypeInfoFactory.doubleTypeInfo};
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableDoubleObjectInspector};
        DoubleWritable[] in = new DoubleWritable[]{new DoubleWritable()};
        TestStreamingSum._agg((GenericUDAFResolver)fnR, inputTypes, inVals, TypeHandler.DoubleHandler, in, inputOIs, inSz, numPreceding, numFollowing, outVals);
    }

    public void sumLong(Iterator<Long> inVals, int inSz, int numPreceding, int numFollowing, Iterator<Long> outVals) throws HiveException {
        GenericUDAFSum fnR = new GenericUDAFSum();
        TypeInfo[] inputTypes = new TypeInfo[]{TypeInfoFactory.longTypeInfo};
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableLongObjectInspector};
        LongWritable[] in = new LongWritable[]{new LongWritable()};
        TestStreamingSum._agg((GenericUDAFResolver)fnR, inputTypes, inVals, TypeHandler.LongHandler, in, inputOIs, inSz, numPreceding, numFollowing, outVals);
    }

    public void sumHiveDecimal(Iterator<HiveDecimal> inVals, int inSz, int numPreceding, int numFollowing, Iterator<HiveDecimal> outVals) throws HiveException {
        GenericUDAFSum fnR = new GenericUDAFSum();
        TypeInfo[] inputTypes = new TypeInfo[]{TypeInfoFactory.decimalTypeInfo};
        ObjectInspector[] inputOIs = new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableHiveDecimalObjectInspector};
        HiveDecimalWritable[] in = new HiveDecimalWritable[]{new HiveDecimalWritable()};
        TestStreamingSum._agg((GenericUDAFResolver)fnR, inputTypes, inVals, TypeHandler.HiveDecimalHandler, in, inputOIs, inSz, numPreceding, numFollowing, outVals);
    }

    public static <T, TW> void _agg(GenericUDAFResolver fnR, TypeInfo[] inputTypes, Iterator<T> inVals, TypeHandler<T, TW> typeHandler, TW[] in, ObjectInspector[] inputOIs, int inSz, int numPreceding, int numFollowing, Iterator<T> outVals) throws HiveException {
        Object out;
        GenericUDAFEvaluator fn = fnR.getEvaluator(inputTypes);
        fn.init(GenericUDAFEvaluator.Mode.COMPLETE, inputOIs);
        fn = fn.getWindowingEvaluator(TestStreamingSum.wdwFrame(numPreceding, numFollowing));
        GenericUDAFEvaluator.AggregationBuffer agg = fn.getNewAggregationBuffer();
        ISupportStreamingModeForWindowing oS = (ISupportStreamingModeForWindowing)fn;
        int outSz = 0;
        while (inVals.hasNext()) {
            typeHandler.set(inVals.next(), in[0]);
            fn.aggregate(agg, (Object[])in);
            out = oS.getNextResult(agg);
            if (out == null) continue;
            if (out == ISupportStreamingModeForWindowing.NULL_RESULT) {
                out = null;
            } else {
                try {
                    out = typeHandler.get(out);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            Assert.assertEquals((Object)out, outVals.next());
            ++outSz;
        }
        fn.terminate(agg);
        while (outSz < inSz) {
            out = oS.getNextResult(agg);
            if (out == ISupportStreamingModeForWindowing.NULL_RESULT) {
                out = null;
            } else {
                try {
                    out = typeHandler.get(out);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            Assert.assertEquals((Object)out, outVals.next());
            ++outSz;
        }
    }

    @Test
    public void testDouble_3_4() throws HiveException {
        List<Double> inVals = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0);
        List<Double> outVals = Arrays.asList(15.0, 21.0, 28.0, 36.0, 44.0, 52.0, 49.0, 45.0, 40.0, 34.0);
        this.sumDouble(inVals.iterator(), 10, 3, 4, outVals.iterator());
    }

    @Test
    public void testDouble_3_0() throws HiveException {
        List<Double> inVals = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0);
        List<Double> outVals = Arrays.asList(1.0, 3.0, 6.0, 10.0, 14.0, 18.0, 22.0, 26.0, 30.0, 34.0);
        this.sumDouble(inVals.iterator(), 10, 3, 0, outVals.iterator());
    }

    @Test
    public void testDouble_unb_0() throws HiveException {
        List<Double> inVals = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0);
        List<Double> outVals = Arrays.asList(1.0, 3.0, 6.0, 10.0, 15.0, 21.0, 28.0, 36.0, 45.0, 55.0);
        this.sumDouble(inVals.iterator(), 10, Integer.MAX_VALUE, 0, outVals.iterator());
    }

    @Test
    public void testDouble_0_5() throws HiveException {
        List<Double> inVals = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0);
        List<Double> outVals = Arrays.asList(21.0, 27.0, 33.0, 39.0, 45.0, 40.0, 34.0, 27.0, 19.0, 10.0);
        this.sumDouble(inVals.iterator(), 10, 0, 5, outVals.iterator());
    }

    @Test
    public void testDouble_unb_5() throws HiveException {
        List<Double> inVals = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0);
        List<Double> outVals = Arrays.asList(21.0, 28.0, 36.0, 45.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0);
        this.sumDouble(inVals.iterator(), 10, Integer.MAX_VALUE, 5, outVals.iterator());
    }

    @Test
    public void testDouble_7_2() throws HiveException {
        List<Double> inVals = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0);
        List<Double> outVals = Arrays.asList(6.0, 10.0, 15.0, 21.0, 28.0, 36.0, 45.0, 55.0, 54.0, 52.0);
        this.sumDouble(inVals.iterator(), 10, 7, 2, outVals.iterator());
    }

    @Test
    public void testDouble_15_15() throws HiveException {
        List<Double> inVals = Arrays.asList(1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0);
        List<Double> outVals = Arrays.asList(55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0, 55.0);
        this.sumDouble(inVals.iterator(), 10, 15, 15, outVals.iterator());
    }

    @Test
    public void testLong_3_4() throws HiveException {
        List<Long> inVals = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        List<Long> outVals = Arrays.asList(15L, 21L, 28L, 36L, 44L, 52L, 49L, 45L, 40L, 34L);
        this.sumLong(inVals.iterator(), 10, 3, 4, outVals.iterator());
    }

    @Test
    public void testLong_3_0() throws HiveException {
        List<Long> inVals = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        List<Long> outVals = Arrays.asList(1L, 3L, 6L, 10L, 14L, 18L, 22L, 26L, 30L, 34L);
        this.sumLong(inVals.iterator(), 10, 3, 0, outVals.iterator());
    }

    @Test
    public void testLong_unb_0() throws HiveException {
        List<Long> inVals = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        List<Long> outVals = Arrays.asList(1L, 3L, 6L, 10L, 15L, 21L, 28L, 36L, 45L, 55L);
        this.sumLong(inVals.iterator(), 10, Integer.MAX_VALUE, 0, outVals.iterator());
    }

    @Test
    public void testLong_0_5() throws HiveException {
        List<Long> inVals = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        List<Long> outVals = Arrays.asList(21L, 27L, 33L, 39L, 45L, 40L, 34L, 27L, 19L, 10L);
        this.sumLong(inVals.iterator(), 10, 0, 5, outVals.iterator());
    }

    @Test
    public void testLong_unb_5() throws HiveException {
        List<Long> inVals = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        List<Long> outVals = Arrays.asList(21L, 28L, 36L, 45L, 55L, 55L, 55L, 55L, 55L, 55L);
        this.sumLong(inVals.iterator(), 10, Integer.MAX_VALUE, 5, outVals.iterator());
    }

    @Test
    public void testLong_7_2() throws HiveException {
        List<Long> inVals = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        List<Long> outVals = Arrays.asList(6L, 10L, 15L, 21L, 28L, 36L, 45L, 55L, 54L, 52L);
        this.sumLong(inVals.iterator(), 10, 7, 2, outVals.iterator());
    }

    @Test
    public void testLong_15_15() throws HiveException {
        List<Long> inVals = Arrays.asList(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L);
        List<Long> outVals = Arrays.asList(55L, 55L, 55L, 55L, 55L, 55L, 55L, 55L, 55L, 55L);
        this.sumLong(inVals.iterator(), 10, 15, 15, outVals.iterator());
    }

    @Test
    public void testHiveDecimal_3_4() throws HiveException {
        List<HiveDecimal> inVals = Arrays.asList(HiveDecimal.create((long)1L), HiveDecimal.create((long)2L), HiveDecimal.create((long)3L), HiveDecimal.create((long)4L), HiveDecimal.create((long)5L), HiveDecimal.create((long)6L), HiveDecimal.create((long)7L), HiveDecimal.create((long)8L), HiveDecimal.create((long)9L), HiveDecimal.create((long)10L));
        List<HiveDecimal> outVals = Arrays.asList(HiveDecimal.create((long)15L), HiveDecimal.create((long)21L), HiveDecimal.create((long)28L), HiveDecimal.create((long)36L), HiveDecimal.create((long)44L), HiveDecimal.create((long)52L), HiveDecimal.create((long)49L), HiveDecimal.create((long)45L), HiveDecimal.create((long)40L), HiveDecimal.create((long)34L));
        this.sumHiveDecimal(inVals.iterator(), 10, 3, 4, outVals.iterator());
    }

    @Test
    public void testHiveDecimal_3_0() throws HiveException {
        List<HiveDecimal> inVals = Arrays.asList(HiveDecimal.create((long)1L), HiveDecimal.create((long)2L), HiveDecimal.create((long)3L), HiveDecimal.create((long)4L), HiveDecimal.create((long)5L), HiveDecimal.create((long)6L), HiveDecimal.create((long)7L), HiveDecimal.create((long)8L), HiveDecimal.create((long)9L), HiveDecimal.create((long)10L));
        List<HiveDecimal> outVals = Arrays.asList(HiveDecimal.create((long)1L), HiveDecimal.create((long)3L), HiveDecimal.create((long)6L), HiveDecimal.create((long)10L), HiveDecimal.create((long)14L), HiveDecimal.create((long)18L), HiveDecimal.create((long)22L), HiveDecimal.create((long)26L), HiveDecimal.create((long)30L), HiveDecimal.create((long)34L));
        this.sumHiveDecimal(inVals.iterator(), 10, 3, 0, outVals.iterator());
    }

    @Test
    public void testHiveDecimal_unb_0() throws HiveException {
        List<HiveDecimal> inVals = Arrays.asList(HiveDecimal.create((long)1L), HiveDecimal.create((long)2L), HiveDecimal.create((long)3L), HiveDecimal.create((long)4L), HiveDecimal.create((long)5L), HiveDecimal.create((long)6L), HiveDecimal.create((long)7L), HiveDecimal.create((long)8L), HiveDecimal.create((long)9L), HiveDecimal.create((long)10L));
        List<HiveDecimal> outVals = Arrays.asList(HiveDecimal.create((long)1L), HiveDecimal.create((long)3L), HiveDecimal.create((long)6L), HiveDecimal.create((long)10L), HiveDecimal.create((long)15L), HiveDecimal.create((long)21L), HiveDecimal.create((long)28L), HiveDecimal.create((long)36L), HiveDecimal.create((long)45L), HiveDecimal.create((long)55L));
        this.sumHiveDecimal(inVals.iterator(), 10, Integer.MAX_VALUE, 0, outVals.iterator());
    }

    @Test
    public void testHiveDecimal_0_5() throws HiveException {
        List<HiveDecimal> inVals = Arrays.asList(HiveDecimal.create((long)1L), HiveDecimal.create((long)2L), HiveDecimal.create((long)3L), HiveDecimal.create((long)4L), HiveDecimal.create((long)5L), HiveDecimal.create((long)6L), HiveDecimal.create((long)7L), HiveDecimal.create((long)8L), HiveDecimal.create((long)9L), HiveDecimal.create((long)10L));
        List<HiveDecimal> outVals = Arrays.asList(HiveDecimal.create((long)21L), HiveDecimal.create((long)27L), HiveDecimal.create((long)33L), HiveDecimal.create((long)39L), HiveDecimal.create((long)45L), HiveDecimal.create((long)40L), HiveDecimal.create((long)34L), HiveDecimal.create((long)27L), HiveDecimal.create((long)19L), HiveDecimal.create((long)10L));
        this.sumHiveDecimal(inVals.iterator(), 10, 0, 5, outVals.iterator());
    }

    @Test
    public void testHiveDecimal_unb_5() throws HiveException {
        List<HiveDecimal> inVals = Arrays.asList(HiveDecimal.create((long)1L), HiveDecimal.create((long)2L), HiveDecimal.create((long)3L), HiveDecimal.create((long)4L), HiveDecimal.create((long)5L), HiveDecimal.create((long)6L), HiveDecimal.create((long)7L), HiveDecimal.create((long)8L), HiveDecimal.create((long)9L), HiveDecimal.create((long)10L));
        List<HiveDecimal> outVals = Arrays.asList(HiveDecimal.create((long)21L), HiveDecimal.create((long)28L), HiveDecimal.create((long)36L), HiveDecimal.create((long)45L), HiveDecimal.create((long)55L), HiveDecimal.create((long)55L), HiveDecimal.create((long)55L), HiveDecimal.create((long)55L), HiveDecimal.create((long)55L), HiveDecimal.create((long)55L));
        this.sumHiveDecimal(inVals.iterator(), 10, Integer.MAX_VALUE, 5, outVals.iterator());
    }

    @Test
    public void testHiveDecimal_7_2() throws HiveException {
        List<HiveDecimal> inVals = Arrays.asList(HiveDecimal.create((long)1L), HiveDecimal.create((long)2L), HiveDecimal.create((long)3L), HiveDecimal.create((long)4L), HiveDecimal.create((long)5L), HiveDecimal.create((long)6L), HiveDecimal.create((long)7L), HiveDecimal.create((long)8L), HiveDecimal.create((long)9L), HiveDecimal.create((long)10L));
        List<HiveDecimal> outVals = Arrays.asList(HiveDecimal.create((long)6L), HiveDecimal.create((long)10L), HiveDecimal.create((long)15L), HiveDecimal.create((long)21L), HiveDecimal.create((long)28L), HiveDecimal.create((long)36L), HiveDecimal.create((long)45L), HiveDecimal.create((long)55L), HiveDecimal.create((long)54L), HiveDecimal.create((long)52L));
        this.sumHiveDecimal(inVals.iterator(), 10, 7, 2, outVals.iterator());
    }

    @Test
    public void testHiveDecimal_15_15() throws HiveException {
        List<HiveDecimal> inVals = Arrays.asList(HiveDecimal.create((long)1L), HiveDecimal.create((long)2L), HiveDecimal.create((long)3L), HiveDecimal.create((long)4L), HiveDecimal.create((long)5L), HiveDecimal.create((long)6L), HiveDecimal.create((long)7L), HiveDecimal.create((long)8L), HiveDecimal.create((long)9L), HiveDecimal.create((long)10L));
        List<HiveDecimal> outVals = Arrays.asList(HiveDecimal.create((long)55L), HiveDecimal.create((long)55L), HiveDecimal.create((long)55L), HiveDecimal.create((long)55L), HiveDecimal.create((long)55L), HiveDecimal.create((long)55L), HiveDecimal.create((long)55L), HiveDecimal.create((long)55L), HiveDecimal.create((long)55L), HiveDecimal.create((long)55L));
        this.sumHiveDecimal(inVals.iterator(), 10, 15, 15, outVals.iterator());
    }

    static interface TypeHandler<T, TW> {
        public static final TypeHandler<Double, DoubleWritable> DoubleHandler = new TypeHandler<Double, DoubleWritable>(){

            @Override
            public void set(Double d, DoubleWritable iw) {
                iw.set(d.doubleValue());
            }

            @Override
            public Double get(DoubleWritable iw) {
                return iw.get();
            }
        };
        public static final TypeHandler<Long, LongWritable> LongHandler = new TypeHandler<Long, LongWritable>(){

            @Override
            public void set(Long d, LongWritable iw) {
                iw.set(d.longValue());
            }

            @Override
            public Long get(LongWritable iw) {
                return iw.get();
            }
        };
        public static final TypeHandler<HiveDecimal, HiveDecimalWritable> HiveDecimalHandler = new TypeHandler<HiveDecimal, HiveDecimalWritable>(){

            @Override
            public void set(HiveDecimal d, HiveDecimalWritable iw) {
                iw.set(d);
            }

            @Override
            public HiveDecimal get(HiveDecimalWritable iw) {
                return iw.getHiveDecimal();
            }
        };

        public void set(T var1, TW var2);

        public T get(TW var1);
    }
}

