/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestParseDriverIntervals {
    private String query;
    private ParseDriver parseDriver = new ParseDriver();

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> getParameters() {
        ArrayList<Object[]> ret = new ArrayList<Object[]>();
        ret.add(new Object[]{"select 1 days"});
        ret.add(new Object[]{"select (1) days"});
        ret.add(new Object[]{"select (1) day"});
        ret.add(new Object[]{"select interval (1+1) days"});
        ret.add(new Object[]{"select interval 1 days"});
        ret.add(new Object[]{"select interval '1' days"});
        ret.add(new Object[]{"select interval (x) days"});
        ret.add(new Object[]{"select interval (x+1) days"});
        ret.add(new Object[]{"select interval (1+x) days"});
        ret.add(new Object[]{"select interval (1+1) days"});
        ret.add(new Object[]{"select interval (x+1) days"});
        return ret;
    }

    public TestParseDriverIntervals(String query) {
        this.query = query;
    }

    @Test
    public void parseInterval() throws Exception {
        ASTNode root = this.parseDriver.parse(this.query);
        Assert.assertNotNull((String)("failed: " + this.query), (Object)this.findFunctionNode(root));
        System.out.println(root.dump());
    }

    private ASTNode findFunctionNode(ASTNode n) {
        if (n.getType() == 767 && "internal_interval".equals(n.getChild(0).getText())) {
            return n;
        }
        ArrayList children = n.getChildren();
        if (children != null) {
            for (Node c : children) {
                ASTNode r = this.findFunctionNode((ASTNode)c);
                if (r == null) continue;
                return r;
            }
        }
        return null;
    }
}

