/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.io.IOException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.parquet.VectorizedColumnReaderTestBase;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedParquetRecordReader;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.io.api.Binary;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorizedListColumnReader
extends VectorizedColumnReaderTestBase {
    protected static void writeListData(ParquetWriter<Group> writer, boolean isDictionaryEncoding, int elementNum) throws IOException {
        SimpleGroupFactory f = new SimpleGroupFactory(schema);
        int listMaxSize = 4;
        int listElementIndex = 0;
        for (int i = 0; i < elementNum; ++i) {
            int j;
            boolean isNull = TestVectorizedListColumnReader.isNull(i);
            Group group = f.newGroup();
            int listSize = i % listMaxSize + 1;
            if (!isNull) {
                for (j = 0; j < listSize; ++j) {
                    group.append("list_int32_field", TestVectorizedListColumnReader.getIntValue(isDictionaryEncoding, listElementIndex));
                    group.append("list_int64_field", TestVectorizedListColumnReader.getLongValue(isDictionaryEncoding, listElementIndex));
                    group.append("list_double_field", TestVectorizedListColumnReader.getDoubleValue(isDictionaryEncoding, listElementIndex));
                    group.append("list_float_field", TestVectorizedListColumnReader.getFloatValue(isDictionaryEncoding, listElementIndex));
                    group.append("list_boolean_field", TestVectorizedListColumnReader.getBooleanValue(listElementIndex));
                    group.append("list_binary_field", TestVectorizedListColumnReader.getBinaryValue(isDictionaryEncoding, listElementIndex));
                    HiveDecimal hd = TestVectorizedListColumnReader.getDecimal(isDictionaryEncoding, listElementIndex).setScale(2);
                    HiveDecimalWritable hdw = new HiveDecimalWritable(hd);
                    group.append("list_decimal_field", Binary.fromConstantByteArray((byte[])hdw.getInternalStorage()));
                    ++listElementIndex;
                }
            }
            for (j = 0; j < listMaxSize; ++j) {
                group.append("list_int32_field_for_repeat_test", TestVectorizedListColumnReader.getIntValue(isDictionaryEncoding, j));
            }
            writer.write((Object)group);
        }
        writer.close();
    }

    protected static void writeRepeateListData(ParquetWriter<Group> writer, int elementNum, boolean isNull) throws IOException {
        SimpleGroupFactory f = new SimpleGroupFactory(schema);
        int listMaxSize = 4;
        for (int i = 0; i < elementNum; ++i) {
            Group group = f.newGroup();
            if (!isNull) {
                for (int j = 0; j < listMaxSize; ++j) {
                    group.append("list_int32_field_for_repeat_test", j);
                }
            }
            writer.write((Object)group);
        }
        writer.close();
    }

    @Test
    public void testListReadLessOneBatch() throws Exception {
        boolean isDictionaryEncoding = false;
        TestVectorizedListColumnReader.removeFile();
        TestVectorizedListColumnReader.writeListData(TestVectorizedListColumnReader.initWriterFromFile(), isDictionaryEncoding, 1023);
        this.testListReadAllType(isDictionaryEncoding, 1023);
        TestVectorizedListColumnReader.removeFile();
        isDictionaryEncoding = true;
        TestVectorizedListColumnReader.writeListData(TestVectorizedListColumnReader.initWriterFromFile(), isDictionaryEncoding, 1023);
        this.testListReadAllType(isDictionaryEncoding, 1023);
        TestVectorizedListColumnReader.removeFile();
    }

    @Test
    public void testListReadEqualOneBatch() throws Exception {
        boolean isDictionaryEncoding = false;
        TestVectorizedListColumnReader.removeFile();
        TestVectorizedListColumnReader.writeListData(TestVectorizedListColumnReader.initWriterFromFile(), isDictionaryEncoding, 1024);
        this.testListReadAllType(isDictionaryEncoding, 1024);
        TestVectorizedListColumnReader.removeFile();
        isDictionaryEncoding = true;
        TestVectorizedListColumnReader.writeListData(TestVectorizedListColumnReader.initWriterFromFile(), isDictionaryEncoding, 1024);
        this.testListReadAllType(isDictionaryEncoding, 1024);
        TestVectorizedListColumnReader.removeFile();
    }

    @Test
    public void testListReadMoreOneBatch() throws Exception {
        boolean isDictionaryEncoding = false;
        TestVectorizedListColumnReader.removeFile();
        TestVectorizedListColumnReader.writeListData(TestVectorizedListColumnReader.initWriterFromFile(), isDictionaryEncoding, 1025);
        this.testListReadAllType(isDictionaryEncoding, 1025);
        TestVectorizedListColumnReader.removeFile();
        isDictionaryEncoding = true;
        TestVectorizedListColumnReader.writeListData(TestVectorizedListColumnReader.initWriterFromFile(), isDictionaryEncoding, 1025);
        this.testListReadAllType(isDictionaryEncoding, 1025);
        TestVectorizedListColumnReader.removeFile();
    }

    @Test
    public void testRepeateListRead() throws Exception {
        TestVectorizedListColumnReader.removeFile();
        TestVectorizedListColumnReader.writeRepeateListData(TestVectorizedListColumnReader.initWriterFromFile(), 1023, false);
        this.testRepeateListRead(1023, false);
        TestVectorizedListColumnReader.removeFile();
        TestVectorizedListColumnReader.writeRepeateListData(TestVectorizedListColumnReader.initWriterFromFile(), 1023, true);
        this.testRepeateListRead(1023, true);
        TestVectorizedListColumnReader.removeFile();
        TestVectorizedListColumnReader.writeRepeateListData(TestVectorizedListColumnReader.initWriterFromFile(), 1024, false);
        this.testRepeateListRead(1024, false);
        TestVectorizedListColumnReader.removeFile();
        TestVectorizedListColumnReader.writeRepeateListData(TestVectorizedListColumnReader.initWriterFromFile(), 1024, true);
        this.testRepeateListRead(1024, true);
        TestVectorizedListColumnReader.removeFile();
        TestVectorizedListColumnReader.writeRepeateListData(TestVectorizedListColumnReader.initWriterFromFile(), 1025, false);
        this.testRepeateListRead(1025, false);
        TestVectorizedListColumnReader.removeFile();
        TestVectorizedListColumnReader.writeRepeateListData(TestVectorizedListColumnReader.initWriterFromFile(), 1025, true);
        this.testRepeateListRead(1025, true);
        TestVectorizedListColumnReader.removeFile();
    }

    private void testListReadAllType(boolean isDictionaryEncoding, int elementNum) throws Exception {
        this.testListRead(isDictionaryEncoding, "int", elementNum);
        this.testListRead(isDictionaryEncoding, "long", elementNum);
        this.testListRead(isDictionaryEncoding, "double", elementNum);
        this.testListRead(isDictionaryEncoding, "float", elementNum);
        this.testListRead(isDictionaryEncoding, "boolean", elementNum);
        this.testListRead(isDictionaryEncoding, "binary", elementNum);
        this.testListRead(isDictionaryEncoding, "decimal", elementNum);
    }

    private void setTypeConfiguration(String type, Configuration conf) {
        if ("int".equals(type)) {
            conf.set("columns", "list_int32_field");
            conf.set("columns.types", "array<int>");
        } else if ("long".equals(type)) {
            conf.set("columns", "list_int64_field");
            conf.set("columns.types", "array<bigint>");
        } else if ("double".equals(type)) {
            conf.set("columns", "list_double_field");
            conf.set("columns.types", "array<double>");
        } else if ("float".equals(type)) {
            conf.set("columns", "list_float_field");
            conf.set("columns.types", "array<float>");
        } else if ("boolean".equals(type)) {
            conf.set("columns", "list_boolean_field");
            conf.set("columns.types", "array<boolean>");
        } else if ("binary".equals(type)) {
            conf.set("columns", "list_binary_field");
            conf.set("columns.types", "array<string>");
        } else if ("decimal".equals(type)) {
            conf.set("columns", "list_decimal_field");
            conf.set("columns.types", "array<decimal(5,2)>");
        }
    }

    private String getSchema(String type) {
        if ("int".equals(type)) {
            return "message hive_schema {repeated int32 list_int32_field;}";
        }
        if ("long".equals(type)) {
            return "message hive_schema {repeated int64 list_int64_field;}";
        }
        if ("double".equals(type)) {
            return "message hive_schema {repeated double list_double_field;}";
        }
        if ("float".equals(type)) {
            return "message hive_schema {repeated float list_float_field;}";
        }
        if ("boolean".equals(type)) {
            return "message hive_schema {repeated boolean list_boolean_field;}";
        }
        if ("binary".equals(type)) {
            return "message hive_schema {repeated binary list_binary_field;}";
        }
        if ("decimal".equals(type)) {
            return "message hive_schema {repeated binary list_decimal_field (DECIMAL(5,2));}";
        }
        throw new RuntimeException("Unsupported type for TestVectorizedListColumnReader!");
    }

    private void assertValue(String type, ColumnVector childVector, boolean isDictionaryEncoding, int valueIndex, int position) {
        if ("int".equals(type)) {
            Assert.assertEquals((long)TestVectorizedListColumnReader.getIntValue(isDictionaryEncoding, valueIndex), (long)((LongColumnVector)childVector).vector[position]);
        } else if ("long".equals(type)) {
            Assert.assertEquals((long)TestVectorizedListColumnReader.getLongValue(isDictionaryEncoding, valueIndex), (long)((LongColumnVector)childVector).vector[position]);
        } else if ("double".equals(type)) {
            Assert.assertEquals((double)TestVectorizedListColumnReader.getDoubleValue(isDictionaryEncoding, valueIndex), (double)((DoubleColumnVector)childVector).vector[position], (double)0.0);
        } else if ("float".equals(type)) {
            Assert.assertEquals((double)TestVectorizedListColumnReader.getFloatValue(isDictionaryEncoding, valueIndex), (double)((DoubleColumnVector)childVector).vector[position], (double)0.0);
        } else if ("boolean".equals(type)) {
            Assert.assertEquals((long)(TestVectorizedListColumnReader.getBooleanValue(valueIndex) ? 1 : 0), (long)((LongColumnVector)childVector).vector[position]);
        } else if ("binary".equals(type)) {
            String actual = new String(ArrayUtils.subarray((byte[])((BytesColumnVector)childVector).vector[position], (int)((BytesColumnVector)childVector).start[position], (int)(((BytesColumnVector)childVector).start[position] + ((BytesColumnVector)childVector).length[position])));
            Assert.assertEquals((Object)TestVectorizedListColumnReader.getStr(isDictionaryEncoding, valueIndex), (Object)actual);
        } else if ("decimal".equals(type)) {
            Assert.assertEquals((Object)TestVectorizedListColumnReader.getDecimal(isDictionaryEncoding, valueIndex), (Object)((DecimalColumnVector)childVector).vector[position].getHiveDecimal());
        } else {
            throw new RuntimeException("Unsupported type for TestVectorizedListColumnReader!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testListRead(boolean isDictionaryEncoding, String type, int elementNum) throws Exception {
        Configuration conf = new Configuration();
        this.setTypeConfiguration(type, conf);
        conf.set("fs.default.name", "file:///");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        VectorizedParquetRecordReader reader = TestVectorizedListColumnReader.createTestParquetReader(this.getSchema(type), conf);
        VectorizedRowBatch previous = reader.createValue();
        int row = 0;
        int index = 0;
        try {
            block3: while (reader.next(NullWritable.get(), previous)) {
                ListColumnVector vector = (ListColumnVector)previous.cols[0];
                for (int i = 0; i < vector.offsets.length; ++i) {
                    if (row == elementNum) {
                        Assert.assertEquals((long)i, (long)(vector.offsets.length - 1));
                        continue block3;
                    }
                    long start = vector.offsets[i];
                    long length = vector.lengths[i];
                    boolean isNull = TestVectorizedListColumnReader.isNull(row);
                    if (isNull) {
                        Assert.assertEquals((Object)vector.isNull[i], (Object)true);
                    } else {
                        for (long j = 0L; j < length; ++j) {
                            this.assertValue(type, vector.child, isDictionaryEncoding, index, (int)(start + j));
                            ++index;
                        }
                    }
                    ++row;
                }
            }
            Assert.assertEquals((String)"It doesn't exit at expected position", (long)elementNum, (long)row);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRepeateListRead(int elementNum, boolean isNull) throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.default.name", "file:///");
        conf.set("columns", "list_int32_field_for_repeat_test");
        conf.set("columns.types", "array<int>");
        conf.setBoolean("hive.io.file.read.all.columns", false);
        conf.set("hive.io.file.readcolumn.ids", "0");
        VectorizedParquetRecordReader reader = TestVectorizedListColumnReader.createTestParquetReader("message hive_schema {repeated int32 list_int32_field_for_repeat_test;}", conf);
        VectorizedRowBatch previous = reader.createValue();
        int row = 0;
        try {
            block3: while (reader.next(NullWritable.get(), previous)) {
                ListColumnVector vector = (ListColumnVector)previous.cols[0];
                Assert.assertTrue((boolean)vector.isRepeating);
                Assert.assertEquals((Object)isNull, (Object)vector.isNull[0]);
                for (int i = 0; i < vector.offsets.length; ++i) {
                    if (row == elementNum) {
                        Assert.assertEquals((long)i, (long)(vector.offsets.length - 1));
                        continue block3;
                    }
                    ++row;
                }
            }
            Assert.assertEquals((String)"It doesn't exit at expected position", (long)elementNum, (long)row);
        }
        finally {
            reader.close();
        }
    }
}

