/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcNewInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcNewOutputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcSerde;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hive.common.util.HiveTestUtils;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class TestNewInputOutputFormat {
    Path workDir = new Path(System.getProperty("test.tmp.dir", "target" + File.separator + "test" + File.separator + "tmp"));
    Configuration conf;
    FileSystem localFs;
    @Rule
    public TestName testCaseName = new TestName();

    @Before
    public void setup() throws Exception {
        this.conf = new Configuration();
        this.conf.set("mapred.job.tracker", "local");
        this.conf.set("fs.default.name", "local");
        this.localFs = FileSystem.get((Configuration)this.conf);
    }

    @Test
    public void testNewInputFormat() throws Exception {
        String line;
        Job job = new Job(this.conf, "orc test");
        job.setInputFormatClass(OrcNewInputFormat.class);
        job.setJarByClass(TestNewInputOutputFormat.class);
        job.setMapperClass(OrcTestMapper1.class);
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(HiveTestUtils.getFileFromClasspath((String)"orc-file-11-format.orc")));
        Path outputPath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".txt");
        this.localFs.delete(outputPath, true);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        boolean result = job.waitForCompletion(true);
        Assert.assertTrue((boolean)result);
        Path outputFilePath = new Path(outputPath, "part-m-00000");
        Assert.assertTrue((boolean)this.localFs.exists(outputFilePath));
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.localFs.open(outputFilePath)));
        int count = 0;
        String lastLine = null;
        while ((line = reader.readLine()) != null) {
            ++count;
            lastLine = line;
        }
        reader.close();
        Assert.assertEquals((int)count, (int)7500);
        Assert.assertEquals((String)lastLine, (String)"{true, 100, 2048, 65536, 9223372036854775807, 2.0, -5.0, , bye, {[{1, bye}, {2, sigh}]}, [{100000000, cat}, {-100000, in}, {1234, hat}], {chani={5, chani}, mauddib={1, mauddib}}, 2000-03-12 15:00:01, 12345678.6547457}");
        this.localFs.delete(outputPath, true);
    }

    @Test
    public void testNewOutputFormat() throws Exception {
        int rownum = 1000;
        Path inputPath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".txt");
        Path outputPath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".orc");
        this.localFs.delete(outputPath, true);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)this.localFs.create(inputPath)));
        Random r = new Random(1000L);
        boolean firstRow = true;
        int firstIntValue = 0;
        String firstStringValue = null;
        for (int i = 0; i < rownum; ++i) {
            int intValue = r.nextInt();
            String stringValue = UUID.randomUUID().toString();
            if (firstRow) {
                firstRow = false;
                firstIntValue = intValue;
                firstStringValue = stringValue;
            }
            pw.println(intValue + "," + stringValue);
        }
        pw.close();
        Job job = new Job(this.conf, "orc test");
        job.setOutputFormatClass(OrcNewOutputFormat.class);
        job.setJarByClass(TestNewInputOutputFormat.class);
        job.setMapperClass(OrcTestMapper2.class);
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(Writable.class);
        FileInputFormat.addInputPath((Job)job, (Path)inputPath);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        boolean result = job.waitForCompletion(true);
        Assert.assertTrue((boolean)result);
        Path outputFilePath = new Path(outputPath, "part-m-00000");
        Assert.assertTrue((boolean)this.localFs.exists(outputFilePath));
        Reader reader = OrcFile.createReader((Path)outputFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.localFs));
        Assert.assertTrue((reader.getNumberOfRows() == (long)rownum ? 1 : 0) != 0);
        Assert.assertEquals((Object)reader.getCompression(), (Object)CompressionKind.ZLIB);
        StructObjectInspector soi = (StructObjectInspector)reader.getObjectInspector();
        StructTypeInfo ti = (StructTypeInfo)TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)soi);
        Assert.assertEquals((Object)((PrimitiveTypeInfo)ti.getAllStructFieldTypeInfos().get(0)).getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.INT);
        Assert.assertEquals((Object)((PrimitiveTypeInfo)ti.getAllStructFieldTypeInfos().get(1)).getPrimitiveCategory(), (Object)PrimitiveObjectInspector.PrimitiveCategory.STRING);
        RecordReader rows = reader.rows();
        Object row = rows.next(null);
        IntWritable intWritable = (IntWritable)soi.getStructFieldData(row, (StructField)soi.getAllStructFieldRefs().get(0));
        Text text = (Text)soi.getStructFieldData(row, (StructField)soi.getAllStructFieldRefs().get(1));
        Assert.assertEquals((int)intWritable.get(), (int)firstIntValue);
        Assert.assertEquals((String)text.toString(), (String)firstStringValue);
        this.localFs.delete(outputPath, true);
    }

    @Test
    public void testNewOutputFormatWithCompression() throws Exception {
        this.conf.set("hive.exec.orc.default.compress", "SNAPPY");
        Path inputPath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".txt");
        Path outputPath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".orc");
        this.localFs.delete(outputPath, true);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)this.localFs.create(inputPath)));
        pw.println("1,hello");
        pw.println("2,world");
        pw.close();
        Job job = new Job(this.conf, "orc test");
        job.setOutputFormatClass(OrcNewOutputFormat.class);
        job.setJarByClass(TestNewInputOutputFormat.class);
        job.setMapperClass(OrcTestMapper2.class);
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(OrcSerde.OrcSerdeRow.class);
        FileInputFormat.addInputPath((Job)job, (Path)inputPath);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        boolean result = job.waitForCompletion(true);
        Assert.assertTrue((boolean)result);
        Path outputFilePath = new Path(outputPath, "part-m-00000");
        Reader reader = OrcFile.createReader((Path)outputFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.localFs));
        Assert.assertEquals((Object)reader.getCompression(), (Object)CompressionKind.SNAPPY);
        this.localFs.delete(outputPath, true);
    }

    @Test
    public void testNewOutputFormatComplex() throws Exception {
        Path inputPath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".txt");
        Path outputPath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".orc");
        this.localFs.delete(outputPath, true);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)this.localFs.create(inputPath)));
        pw.println("I have eaten");
        pw.println("the plums");
        pw.println("that were in");
        pw.println("the icebox");
        pw.println("and which");
        pw.println("you were probably");
        pw.println("saving");
        pw.println("for breakfast");
        pw.println("Forgive me");
        pw.println("they were delicious");
        pw.println("so sweet");
        pw.println("and so cold");
        pw.close();
        Job job = new Job(this.conf, "orc test");
        job.setOutputFormatClass(OrcNewOutputFormat.class);
        job.setJarByClass(TestNewInputOutputFormat.class);
        job.setMapperClass(OrcTestMapper3.class);
        job.setReducerClass(OrcTestReducer3.class);
        job.setMapOutputKeyClass(IntWritable.class);
        job.setMapOutputValueClass(Text.class);
        job.setOutputKeyClass(NullWritable.class);
        job.setOutputValueClass(OrcSerde.OrcSerdeRow.class);
        FileInputFormat.addInputPath((Job)job, (Path)inputPath);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        boolean result = job.waitForCompletion(true);
        Assert.assertTrue((boolean)result);
        Path outputFilePath = new Path(outputPath, "part-r-00000");
        Reader reader = OrcFile.createReader((Path)outputFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)this.conf).filesystem(this.localFs));
        RecordReader rows = reader.rows();
        ObjectInspector orcOi = reader.getObjectInspector();
        ObjectInspector stoi = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)OrcTestReducer3.typeInfo);
        ObjectInspectorConverters.Converter converter = ObjectInspectorConverters.getConverter((ObjectInspector)orcOi, (ObjectInspector)stoi);
        Object row = rows.next(null);
        List converted = (List)converter.convert(row);
        Assert.assertEquals((Object)1, converted.get(0));
        Assert.assertEquals((Object)1, converted.get(1));
        List list = (List)converted.get(2);
        Assert.assertEquals((int)list.size(), (int)1);
        Assert.assertEquals((Object)"saving", ((List)list.get(0)).get(0));
        Assert.assertEquals((Object)6, ((List)list.get(0)).get(1));
        Map map = (Map)converted.get(3);
        Assert.assertEquals((int)map.size(), (int)1);
        Assert.assertEquals(map.get("saving"), (Object)new Integer(1));
        row = rows.next(null);
        converted = (List)converter.convert(row);
        Assert.assertEquals((Object)2, converted.get(0));
        Assert.assertEquals((Object)6, converted.get(1));
        list = (List)converted.get(2);
        Assert.assertEquals((int)list.size(), (int)6);
        Assert.assertEquals((Object)"breakfast", ((List)list.get(0)).get(0));
        Assert.assertEquals((Object)9, ((List)list.get(0)).get(1));
        map = (Map)converted.get(3);
        Assert.assertEquals((int)map.size(), (int)11);
        Assert.assertEquals(map.get("the"), (Object)new Integer(2));
        row = rows.next(null);
        converted = (List)converter.convert(row);
        Assert.assertEquals((Object)3, converted.get(0));
        Assert.assertEquals((Object)5, converted.get(1));
        list = (List)converted.get(2);
        Assert.assertEquals((int)list.size(), (int)5);
        Assert.assertEquals((Object)"cold", ((List)list.get(0)).get(0));
        Assert.assertEquals((Object)4, ((List)list.get(0)).get(1));
        map = (Map)converted.get(3);
        Assert.assertEquals((int)map.size(), (int)13);
        Assert.assertEquals(map.get("were"), (Object)new Integer(3));
        Assert.assertFalse((boolean)rows.hasNext());
        this.localFs.delete(outputPath, true);
    }

    @Test
    public void testNewInputFormatPruning() throws Exception {
        this.conf.set("hive.io.file.read.all.columns", "false");
        this.conf.set("hive.io.file.readcolumn.ids", "1,3");
        Job job = new Job(this.conf, "orc test");
        job.setInputFormatClass(OrcNewInputFormat.class);
        job.setJarByClass(TestNewInputOutputFormat.class);
        job.setMapperClass(OrcTestMapper1.class);
        job.setNumReduceTasks(0);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(IntWritable.class);
        FileInputFormat.addInputPath((Job)job, (Path)new Path(HiveTestUtils.getFileFromClasspath((String)"orc-file-11-format.orc")));
        Path outputPath = new Path(this.workDir, "TestOrcFile." + this.testCaseName.getMethodName() + ".txt");
        this.localFs.delete(outputPath, true);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        boolean result = job.waitForCompletion(true);
        Assert.assertTrue((boolean)result);
        Path outputFilePath = new Path(outputPath, "part-m-00000");
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)this.localFs.open(outputFilePath)));
        String line = reader.readLine();
        Assert.assertEquals((String)line, (String)"{null, 1, null, 65536, null, null, null, null, null, null, null, null, null, null}");
        this.localFs.delete(outputPath, true);
    }

    public static class OrcTestReducer3
    extends Reducer<IntWritable, Text, NullWritable, Writable> {
        static final TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)"struct<length:int,count:int,list:array<struct<lastword:string,lastwordlength:int>>,wordcounts:map<string,int>>");
        private final ObjectInspector oip = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)typeInfo);
        private final OrcSerde serde = new OrcSerde();
        private Writable row;

        public void reduce(IntWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            ArrayList<String> lastwords = new ArrayList<String>();
            HashMap<String, Integer> wordCounts = new HashMap<String, Integer>();
            int count = 0;
            for (Text val : values) {
                String[] items = val.toString().toLowerCase().split("\\s+");
                lastwords.add(items[items.length - 1]);
                for (String item : items) {
                    if (wordCounts.containsKey(item)) {
                        wordCounts.put(item, (Integer)wordCounts.get(item) + 1);
                        continue;
                    }
                    wordCounts.put(item, 1);
                }
                ++count;
            }
            ArrayList<Serializable> struct = new ArrayList<Serializable>(4);
            struct.add(0, Integer.valueOf(key.get()));
            struct.add(1, Integer.valueOf(count));
            ArrayList lastWordInfoList = new ArrayList();
            Collections.sort(lastwords);
            for (String word : lastwords) {
                ArrayList<Object> info = new ArrayList<Object>(2);
                info.add(0, word);
                info.add(1, word.length());
                lastWordInfoList.add(info);
            }
            struct.add(2, lastWordInfoList);
            struct.add(3, wordCounts);
            this.row = this.serde.serialize(struct, this.oip);
            context.write((Object)NullWritable.get(), (Object)this.row);
        }
    }

    public static class OrcTestMapper3
    extends Mapper<Object, Text, IntWritable, Text> {
        public void map(Object key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String[] items = value.toString().split("\\s+");
            context.write((Object)new IntWritable(items.length), (Object)value);
        }
    }

    public static class OrcTestMapper2
    extends Mapper<Object, Text, Object, Writable> {
        private final TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)"struct<a:int,b:string>");
        private final ObjectInspector oip = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)this.typeInfo);
        private final OrcSerde serde = new OrcSerde();
        private Writable row;

        public void map(Object key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String[] items = value.toString().split(",");
            ArrayList<Object> struct = new ArrayList<Object>(2);
            struct.add(0, Integer.parseInt(items[0]));
            struct.add(1, items[1]);
            this.row = this.serde.serialize(struct, this.oip);
            context.write(null, (Object)this.row);
        }
    }

    public static class OrcTestMapper1
    extends Mapper<Object, Writable, Text, Text> {
        public void map(Object key, Writable value, Mapper.Context context) throws IOException, InterruptedException {
            context.write(null, (Object)new Text(value.toString()));
        }
    }
}

