/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.vector.VectorRandomRowSource;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CheckFastRowHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CommonFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastMultiKeyHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastStringHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VerifyFastRow;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinarySerializeWrite;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Writable;
import org.junit.Test;

public class TestVectorMapJoinFastRowHashMap
extends CommonFastHashTable {
    private void addAndVerifyRows(VectorRandomRowSource valueSource, Object[][] rows, VectorMapJoinFastHashTable map, VectorMapJoinDesc.HashTableKeyType hashTableKeyType, CheckFastRowHashMap.VerifyFastRowHashMap verifyTable, String[] keyTypeNames, boolean doClipping, boolean useExactBytes) throws HiveException, IOException, SerDeException {
        int keyCount = keyTypeNames.length;
        PrimitiveTypeInfo[] keyPrimitiveTypeInfos = new PrimitiveTypeInfo[keyCount];
        PrimitiveObjectInspector.PrimitiveCategory[] keyPrimitiveCategories = new PrimitiveObjectInspector.PrimitiveCategory[keyCount];
        ArrayList<ObjectInspector> keyPrimitiveObjectInspectorList = new ArrayList<ObjectInspector>(keyCount);
        for (int i = 0; i < keyCount; ++i) {
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
            PrimitiveTypeInfo primitiveTypeInfo;
            keyPrimitiveTypeInfos[i] = primitiveTypeInfo = (PrimitiveTypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)keyTypeNames[i]);
            keyPrimitiveCategories[i] = primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
            keyPrimitiveObjectInspectorList.add((ObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)primitiveTypeInfo));
        }
        boolean[] keyColumnSortOrderIsDesc = new boolean[keyCount];
        Arrays.fill(keyColumnSortOrderIsDesc, false);
        byte[] keyColumnNullMarker = new byte[keyCount];
        Arrays.fill(keyColumnNullMarker, (byte)0);
        byte[] keyColumnNotNullMarker = new byte[keyCount];
        Arrays.fill(keyColumnNotNullMarker, (byte)1);
        BinarySortableSerializeWrite keySerializeWrite = new BinarySortableSerializeWrite(keyColumnSortOrderIsDesc, keyColumnNullMarker, keyColumnNotNullMarker);
        PrimitiveTypeInfo[] valuePrimitiveTypeInfos = valueSource.primitiveTypeInfos();
        int columnCount = valuePrimitiveTypeInfos.length;
        LazyBinarySerializeWrite valueSerializeWrite = new LazyBinarySerializeWrite(columnCount);
        for (Object[] valueRow : rows) {
            byte[] key;
            ByteStream.Output valueOutput = new ByteStream.Output();
            valueSerializeWrite.set(valueOutput);
            for (int index = 0; index < columnCount; ++index) {
                Writable writable = (Writable)valueRow[index];
                VerifyFastRow.serializeWrite((SerializeWrite)valueSerializeWrite, valuePrimitiveTypeInfos[index], writable);
            }
            byte[] value = Arrays.copyOf(valueOutput.getData(), valueOutput.getLength());
            if (random.nextBoolean() || verifyTable.getCount() == 0) {
                Object[] keyRow = VectorRandomRowSource.randomRow(keyCount, random, keyPrimitiveObjectInspectorList, keyPrimitiveCategories, keyPrimitiveTypeInfos);
                ByteStream.Output keyOutput = new ByteStream.Output();
                keySerializeWrite.set(keyOutput);
                for (int index = 0; index < keyCount; ++index) {
                    Writable writable = (Writable)keyRow[index];
                    VerifyFastRow.serializeWrite((SerializeWrite)keySerializeWrite, keyPrimitiveTypeInfos[index], writable);
                }
                key = Arrays.copyOf(keyOutput.getData(), keyOutput.getLength());
                verifyTable.add(key, keyRow, value, valueRow);
            } else {
                key = verifyTable.addRandomExisting(value, valueRow, random);
            }
            BytesWritable keyWritable = new BytesWritable(key);
            BytesWritable valueWritable = new BytesWritable(value);
            map.putRow(keyWritable, valueWritable);
        }
        verifyTable.verify(map, hashTableKeyType, valuePrimitiveTypeInfos, doClipping, useExactBytes, random);
    }

    @Test
    public void testBigIntRows() throws Exception {
        random = new Random(927337L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.LONG, verifyTable, new String[]{"bigint"}, false, false);
    }

    @Test
    public void testIntRows() throws Exception {
        random = new Random(927337L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.INT, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.INT, verifyTable, new String[]{"int"}, false, false);
    }

    @Test
    public void testStringRows() throws Exception {
        random = new Random(927337L);
        VectorMapJoinFastStringHashMap map = new VectorMapJoinFastStringHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.STRING, verifyTable, new String[]{"string"}, false, false);
    }

    @Test
    public void testMultiKeyRows1() throws Exception {
        random = new Random(833L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"int", "int"}, false, false);
    }

    @Test
    public void testMultiKeyRows2() throws Exception {
        random = new Random(833099L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"string", "string"}, false, false);
    }

    @Test
    public void testMultiKeyRows3() throws Exception {
        random = new Random(833099L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"bigint", "timestamp", "double"}, false, false);
    }

    @Test
    public void testBigIntRowsClipped() throws Exception {
        random = new Random(326232L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.LONG, verifyTable, new String[]{"bigint"}, true, false);
    }

    @Test
    public void testIntRowsClipped() throws Exception {
        random = new Random(326232L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.INT, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.INT, verifyTable, new String[]{"int"}, true, false);
    }

    @Test
    public void testStringRowsClipped() throws Exception {
        random = new Random(326232L);
        VectorMapJoinFastStringHashMap map = new VectorMapJoinFastStringHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.STRING, verifyTable, new String[]{"string"}, true, false);
    }

    @Test
    public void testMultiKeyRowsClipped1() throws Exception {
        random = new Random(2331L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"varchar(20)", "date", "interval_day_time"}, true, false);
    }

    @Test
    public void testMultiKeyRowsClipped2() throws Exception {
        random = new Random(7403L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"varchar(20)", "varchar(40)"}, true, false);
    }

    @Test
    public void testMultiKeyRowsClipped3() throws Exception {
        random = new Random(99L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"float", "tinyint"}, true, false);
    }

    @Test
    public void testBigIntRowsExact() throws Exception {
        random = new Random(27722L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.LONG, verifyTable, new String[]{"bigint"}, false, true);
    }

    @Test
    public void testIntRowsExact() throws Exception {
        random = new Random(8238383L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.INT, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.INT, verifyTable, new String[]{"int"}, false, true);
    }

    @Test
    public void testStringRowsExact() throws Exception {
        random = new Random(8235L);
        VectorMapJoinFastStringHashMap map = new VectorMapJoinFastStringHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.STRING, verifyTable, new String[]{"string"}, false, true);
    }

    @Test
    public void testMultiKeyRowsExact1() throws Exception {
        random = new Random(8235L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"string", "string", "string", "string"}, false, true);
    }

    @Test
    public void testMultiKeyRowsExact2() throws Exception {
        random = new Random(8235L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"smallint"}, false, true);
    }

    @Test
    public void testMultiKeyRowsExact3() throws Exception {
        random = new Random(8235L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"int", "binary"}, false, true);
    }

    @Test
    public void testBigIntRowsClippedExact() throws Exception {
        random = new Random(2122L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.LONG, verifyTable, new String[]{"bigint"}, true, true);
    }

    @Test
    public void testIntRowsClippedExact() throws Exception {
        random = new Random(7520L);
        VectorMapJoinFastLongHashMap map = new VectorMapJoinFastLongHashMap(false, false, VectorMapJoinDesc.HashTableKeyType.INT, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.INT, verifyTable, new String[]{"int"}, true, true);
    }

    @Test
    public void testStringRowsClippedExact() throws Exception {
        random = new Random(7539L);
        VectorMapJoinFastStringHashMap map = new VectorMapJoinFastStringHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.STRING, verifyTable, new String[]{"string"}, true, true);
    }

    @Test
    public void testMultiKeyRowsClippedExact1() throws Exception {
        random = new Random(13L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"interval_year_month", "decimal(12,8)"}, true, true);
    }

    @Test
    public void testMultiKeyRowsClippedExact2() throws Exception {
        random = new Random(12L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"bigint", "string", "int"}, true, true);
    }

    @Test
    public void testMultiKeyRowsClippedExact3() throws Exception {
        random = new Random(7L);
        VectorMapJoinFastMultiKeyHashMap map = new VectorMapJoinFastMultiKeyHashMap(false, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastRowHashMap.VerifyFastRowHashMap verifyTable = new CheckFastRowHashMap.VerifyFastRowHashMap();
        VectorRandomRowSource valueSource = new VectorRandomRowSource();
        valueSource.init(random);
        int rowCount = 10000;
        Object[][] rows = valueSource.randomRows(rowCount);
        this.addAndVerifyRows(valueSource, rows, (VectorMapJoinFastHashTable)map, VectorMapJoinDesc.HashTableKeyType.MULTI_KEY, verifyTable, new String[]{"bigint", "string", "varchar(5000)"}, true, true);
    }
}

