/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.thrift;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.thrift.HadoopThriftAuthBridge23;
import org.apache.hadoop.hive.thrift.ThriftTransportHelper;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.rpcauth.RpcAuthMethod;
import org.apache.thrift.transport.TSaslServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class HadoopThriftAuthBridge25Sasl
extends HadoopThriftAuthBridge23 {
    @Override
    public Server createServer(String keytabFile, String principalConf) throws TTransportException {
        if (keytabFile.isEmpty() || principalConf.isEmpty()) {
            return new Server();
        }
        return new Server(keytabFile, principalConf);
    }

    @Override
    public Client createClientWithConf(String authType) {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", authType);
        UserGroupInformation.setConfiguration((Configuration)conf);
        return new Client();
    }

    @Override
    public Client createClient() {
        return new Client();
    }

    public static class Client
    extends HadoopThriftAuthBridge.Client {
        @Override
        public TTransport createClientTransport(String principalConfig, String host, String methodStr, String tokenStrForm, TTransport underlyingTransport, Map<String, String> saslProps) throws IOException {
            switch (ThriftTransportHelper.format(methodStr)) {
                case "DIGEST": 
                case "TOKEN": {
                    return ThriftTransportHelper.createTokenTransport(underlyingTransport, tokenStrForm, saslProps);
                }
                case "KERBEROS": {
                    return ThriftTransportHelper.createKerberosTransport(principalConfig, host, underlyingTransport, saslProps);
                }
                case "MAPRSASL": 
                case "PAM": 
                case "LDAP": {
                    return ThriftTransportHelper.createMapRSaslTransport(underlyingTransport, saslProps);
                }
            }
            throw new IOException("Unsupported authentication method: " + methodStr);
        }
    }

    public static class Server
    extends HadoopThriftAuthBridge.Server {
        public Server() throws TTransportException {
        }

        protected Server(String keytabFile, String principalConf) throws TTransportException {
            super(keytabFile, principalConf);
        }

        @Override
        public TSaslServerTransport.Factory createSaslServerTransportFactory(Map<String, String> saslProps) {
            List rpcAuthMethods = this.realUgi.getRpcAuthMethodList();
            TSaslServerTransport.Factory transFactory = new TSaslServerTransport.Factory();
            for (RpcAuthMethod rpcAuthMethod : rpcAuthMethods) {
                if (rpcAuthMethod.getAuthenticationMethod().equals((Object)UserGroupInformation.AuthenticationMethod.KERBEROS)) {
                    String kerberosName = this.realUgi.getUserName();
                    String[] names = SaslRpcServer.splitKerberosName((String)kerberosName);
                    if (names.length != 3) continue;
                    transFactory.addServerDefinition(rpcAuthMethod.getMechanismName(), names[0], names[1], saslProps, rpcAuthMethod.createCallbackHandler());
                    continue;
                }
                transFactory.addServerDefinition(rpcAuthMethod.getMechanismName(), null, "default", saslProps, rpcAuthMethod.createCallbackHandler());
            }
            transFactory.addServerDefinition(SaslRpcServer.AuthMethod.TOKEN.getMechanismName(), null, "default", saslProps, new HadoopThriftAuthBridge.Server.SaslDigestCallbackHandler(this.secretManager));
            return transFactory;
        }
    }
}

