/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;

public class ExprNodeConstantDesc
extends ExprNodeDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final transient char[] hexArray = "0123456789ABCDEF".toCharArray();
    private Object value;
    private transient String foldedFromCol;
    private transient String foldedFromVal;

    public ExprNodeConstantDesc setFoldedFromVal(String foldedFromVal) {
        this.foldedFromVal = foldedFromVal;
        return this;
    }

    public String getFoldedFromVal() {
        return this.foldedFromVal;
    }

    public String getFoldedFromCol() {
        return this.foldedFromCol;
    }

    public void setFoldedFromCol(String foldedFromCol) {
        this.foldedFromCol = foldedFromCol;
    }

    public ExprNodeConstantDesc() {
    }

    public ExprNodeConstantDesc(TypeInfo typeInfo, Object value) {
        super(typeInfo);
        this.setValue(value);
    }

    public ExprNodeConstantDesc(Object value) {
        this(TypeInfoFactory.getPrimitiveTypeInfoFromJavaPrimitive(value.getClass()), value);
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            value = StringInternUtils.internIfNotNull((String)value);
        }
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public ConstantObjectInspector getWritableObjectInspector() {
        return ObjectInspectorUtils.getConstantObjectInspector(TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(this.typeInfo), this.value);
    }

    public String toString() {
        return "Const " + this.typeInfo.toString() + " " + this.value;
    }

    private static String getFormatted(TypeInfo typeInfo, Object value) {
        if (value == null) {
            return "null";
        }
        if (typeInfo.getTypeName().equals("string") || typeInfo instanceof BaseCharTypeInfo) {
            return "'" + value.toString() + "'";
        }
        if (typeInfo.getTypeName().equals("binary")) {
            byte[] bytes = (byte[])value;
            char[] hexChars = new char[bytes.length * 2];
            for (int j = 0; j < bytes.length; ++j) {
                int v = bytes[j] & 0xFF;
                hexChars[j * 2] = hexArray[v >>> 4];
                hexChars[j * 2 + 1] = hexArray[v & 0xF];
            }
            return new String(hexChars);
        }
        return value.toString();
    }

    @Override
    public String getExprString() {
        if (this.typeInfo.getCategory() == ObjectInspector.Category.PRIMITIVE) {
            return ExprNodeConstantDesc.getFormatted(this.typeInfo, this.value);
        }
        if (this.typeInfo.getCategory() == ObjectInspector.Category.STRUCT) {
            if (this.isNamedStruct()) {
                return this.getNamedStructExprString();
            }
            return this.getStructExprString();
        }
        return this.toString();
    }

    private boolean isNamedStruct() {
        ArrayList<String> columnNames = ((StructTypeInfo)this.typeInfo).getAllStructFieldNames();
        for (int i = 0; i < columnNames.size(); ++i) {
            if (((String)columnNames.get(i)).equals("col" + (i + 1))) continue;
            return true;
        }
        return false;
    }

    private String getNamedStructExprString() {
        StringBuilder sb = new StringBuilder();
        sb.append("const named_struct(");
        ArrayList<String> names = ((StructTypeInfo)this.typeInfo).getAllStructFieldNames();
        List items = (List)this.getWritableObjectInspector().getWritableConstantValue();
        ArrayList<TypeInfo> structTypes = ((StructTypeInfo)this.typeInfo).getAllStructFieldTypeInfos();
        for (int i = 0; i < structTypes.size(); ++i) {
            Object o = i < items.size() ? items.get(i) : null;
            String name = i < names.size() ? (String)names.get(i) : null;
            sb.append(ExprNodeConstantDesc.getFormatted(TypeInfoFactory.stringTypeInfo, name)).append(",").append(ExprNodeConstantDesc.getFormatted((TypeInfo)structTypes.get(i), o)).append(",");
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }

    private String getStructExprString() {
        StringBuilder sb = new StringBuilder();
        sb.append("const struct(");
        List items = (List)this.getWritableObjectInspector().getWritableConstantValue();
        ArrayList<TypeInfo> structTypes = ((StructTypeInfo)this.typeInfo).getAllStructFieldTypeInfos();
        for (int i = 0; i < structTypes.size(); ++i) {
            Object o = i < items.size() ? items.get(i) : null;
            sb.append(ExprNodeConstantDesc.getFormatted((TypeInfo)structTypes.get(i), o)).append(",");
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }

    @Override
    public ExprNodeDesc clone() {
        return new ExprNodeConstantDesc(this.typeInfo, this.value);
    }

    @Override
    public boolean isSame(Object o) {
        if (!(o instanceof ExprNodeConstantDesc)) {
            return false;
        }
        ExprNodeConstantDesc dest = (ExprNodeConstantDesc)o;
        if (!this.typeInfo.equals(dest.getTypeInfo())) {
            return false;
        }
        return !(this.value == null ? dest.getValue() != null : !this.value.equals(dest.getValue()));
    }

    @Override
    public int hashCode() {
        int superHashCode = super.hashCode();
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.appendSuper(superHashCode);
        builder.append(this.value);
        return builder.toHashCode();
    }
}

