/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.MapRDbJsonUtils;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.SimpleFetchOptimizer;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.MapRDbJsonFetchByIdWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRDbJsonFetchByIdOptimizer
extends Transform {
    private static final Logger LOG = LoggerFactory.getLogger((String)MapRDbJsonFetchByIdOptimizer.class.getName());
    private String mapRDbColumn = "";
    private String searchValue = "";
    private boolean optimized = false;
    private boolean isEmpty = false;

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        HashMap<String, TableScanOperator> topOps = pctx.getTopOps();
        QueryProperties qp = pctx.getQueryProperties();
        if (qp.isQuery() && !qp.isAnalyzeCommand() && topOps.size() == 1) {
            TableScanOperator topOp = (TableScanOperator)topOps.values().iterator().next();
            this.processTableScan(pctx, topOp);
        }
        return pctx;
    }

    void processTableScan(ParseContext pctx, TableScanOperator topOp) throws SemanticException {
        Table table = ((TableScanDesc)topOp.getConf()).getTableMetadata();
        if (MapRDbJsonUtils.isMapRDbJsonTable(table)) {
            this.mapRDbColumn = table.getMapRDbColumnId();
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%" + FilterOperator.getOperatorName() + "%"), this.getSimpleFilterProcessor());
            DefaultRuleDispatcher dispatcher = new DefaultRuleDispatcher(MapRDbJsonFetchByIdOptimizer.getDefaultFilterProcessor(), opRules, new SampleMapRDbJsonCtx());
            DefaultGraphWalker graphWalker = new DefaultGraphWalker(dispatcher);
            ArrayList<Node> topNodes = new ArrayList<Node>(pctx.getTopOps().values());
            graphWalker.startWalking(topNodes, null);
            if (this.optimized) {
                pctx.setFetchTask(this.createFetchTask(pctx, topOp, table));
            }
        }
    }

    private FetchTask createFetchTask(ParseContext pctx, TableScanOperator source, Table table) {
        String mapRDbTableName = table.getMapRDbTableName();
        MapRDbJsonFetchByIdWork fetchWork = new MapRDbJsonFetchByIdWork(table.getPath(), Utilities.getTableDesc(table), this.searchValue, mapRDbTableName, this.isEmpty);
        Operator<OperatorDesc> op = source.getChildOperators().get(0);
        fetchWork.setSink(SimpleFetchOptimizer.replaceFSwithLS(this.getFileSink(op), fetchWork.getSerializationNullFormat()));
        FetchTask fetchTask = (FetchTask)TaskFactory.get(fetchWork, pctx.getConf(), new Task[0]);
        fetchWork.setSource(source);
        return fetchTask;
    }

    private Operator<?> getFileSink(Operator<?> rootOperator) {
        for (Operator<OperatorDesc> operator : rootOperator.getChildOperators()) {
            if (operator instanceof FileSinkOperator) {
                return operator;
            }
            Operator<?> child = null;
            if (!operator.getChildOperators().isEmpty()) {
                child = this.getFileSink(operator);
            }
            if (child == null) continue;
            return child;
        }
        return null;
    }

    private NodeProcessor getSimpleFilterProcessor() {
        return new SimpleFilterProcessor();
    }

    private static NodeProcessor getDefaultFilterProcessor() {
        return new DefaultFilterProcessor();
    }

    public static class DefaultFilterProcessor
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    private class SimpleFilterProcessor
    implements NodeProcessor {
        private SimpleFilterProcessor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            if (nd instanceof FilterOperator) {
                FilterOperator fo = (FilterOperator)nd;
                FilterDesc fd = (FilterDesc)fo.getConf();
                ExprNodeDesc predicate = fd.getPredicate();
                if (this.isEquals(predicate) && this.isIdComparedToConstant(predicate)) {
                    MapRDbJsonFetchByIdOptimizer.this.searchValue = this.parseSearchValue(predicate);
                    MapRDbJsonFetchByIdOptimizer.this.optimized = true;
                    return null;
                }
                List<ExprNodeDesc> children = predicate.getChildren();
                if (this.isAnd(predicate) && this.hasIdComparisonAmongChildren(children)) {
                    MapRDbJsonFetchByIdOptimizer.this.searchValue = this.parseSearchValue(children);
                    MapRDbJsonFetchByIdOptimizer.this.optimized = true;
                    return null;
                }
                if (this.isConstantFalse(predicate)) {
                    MapRDbJsonFetchByIdOptimizer.this.searchValue = null;
                    MapRDbJsonFetchByIdOptimizer.this.isEmpty = true;
                    MapRDbJsonFetchByIdOptimizer.this.optimized = true;
                    return null;
                }
            }
            return null;
        }

        private boolean isEquals(ExprNodeDesc end) {
            ExprNodeGenericFuncDesc engfd;
            GenericUDF genericUDF;
            if (end instanceof ExprNodeGenericFuncDesc && (genericUDF = (engfd = (ExprNodeGenericFuncDesc)end).getGenericUDF()) instanceof GenericUDFOPEqual) {
                LOG.info("Operation equals");
                return true;
            }
            return false;
        }

        private boolean isConstantFalse(ExprNodeDesc end) {
            PrimitiveTypeInfo pti;
            ExprNodeConstantDesc encd;
            TypeInfo typeInfo;
            if (end instanceof ExprNodeConstantDesc && (typeInfo = (encd = (ExprNodeConstantDesc)end).getTypeInfo()) instanceof PrimitiveTypeInfo && PrimitiveObjectInspector.PrimitiveCategory.BOOLEAN == (pti = (PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
                return (Boolean)encd.getValue() == false;
            }
            return false;
        }

        private boolean hasIdComparisonAmongChildren(List<ExprNodeDesc> children) throws SemanticException {
            for (ExprNodeDesc child : children) {
                if (!this.isEquals(child) || !this.isIdComparedToConstant(child)) continue;
                return true;
            }
            return false;
        }

        private boolean isAnd(ExprNodeDesc end) {
            ExprNodeGenericFuncDesc engfd;
            GenericUDF genericUDF;
            if (end instanceof ExprNodeGenericFuncDesc && (genericUDF = (engfd = (ExprNodeGenericFuncDesc)end).getGenericUDF()) instanceof GenericUDFOPAnd) {
                LOG.info("Operation and");
                return true;
            }
            return false;
        }

        private boolean isIdComparedToConstant(ExprNodeDesc end) throws SemanticException {
            List<ExprNodeDesc> children = end.getChildren();
            if (children != null && children.size() == 2 && children.get(0) instanceof ExprNodeColumnDesc) {
                ExprNodeColumnDesc nodeColumnDesc = (ExprNodeColumnDesc)children.get(0);
                String column = nodeColumnDesc.getColumn();
                if (MapRDbJsonFetchByIdOptimizer.this.mapRDbColumn.equals(column)) {
                    LOG.info(String.format("Column %s", column));
                    if (children.get(1) instanceof ExprNodeConstantDesc) {
                        LOG.info("Value is constant literal");
                        return true;
                    }
                }
            }
            return false;
        }

        private String parseSearchValue(List<ExprNodeDesc> children) throws SemanticException {
            for (ExprNodeDesc child : children) {
                if (!this.isIdComparedToConstant(child)) continue;
                return this.parseSearchValue(child);
            }
            return "";
        }

        private String parseSearchValue(ExprNodeDesc end) {
            boolean isConstantDesc;
            boolean hasTwoChildren;
            List<ExprNodeDesc> children = end.getChildren();
            boolean bl = hasTwoChildren = children != null && children.size() == 2;
            if (hasTwoChildren && (isConstantDesc = children.get(1) instanceof ExprNodeConstantDesc)) {
                ExprNodeConstantDesc nodeConstantDesc = (ExprNodeConstantDesc)children.get(1);
                String value = (String)nodeConstantDesc.getValue();
                LOG.info(String.format("Value = %s", value));
                return value;
            }
            return "";
        }
    }

    private static class SampleMapRDbJsonCtx
    implements NodeProcessorCtx {
        private SampleMapRDbJsonCtx() {
        }
    }
}

