/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.CompressionKind;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.ql.io.orc.RecordReader;
import org.apache.hadoop.hive.ql.io.orc.RecordReaderImpl;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.orc.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReaderImpl
extends org.apache.orc.impl.ReaderImpl
implements Reader {
    private static final Logger LOG = LoggerFactory.getLogger(ReaderImpl.class);
    private final ObjectInspector inspector;

    @Override
    public ObjectInspector getObjectInspector() {
        return this.inspector;
    }

    @Override
    public CompressionKind getCompression() {
        for (CompressionKind value : CompressionKind.values()) {
            if (value.getUnderlying() != this.compressionKind) continue;
            return value;
        }
        throw new IllegalArgumentException("Unknown compression kind " + (Object)((Object)this.compressionKind));
    }

    public ReaderImpl(Path path, OrcFile.ReaderOptions options) throws IOException {
        super(path, options);
        this.inspector = OrcStruct.createObjectInspector(0, this.types);
    }

    @Override
    public ByteBuffer getSerializedFileFooter() {
        return this.tail.getSerializedTail();
    }

    @Override
    public RecordReader rows() throws IOException {
        return this.rowsOptions(new Reader.Options());
    }

    @Override
    public RecordReader rowsOptions(Reader.Options options) throws IOException {
        LOG.info("Reading ORC rows from " + this.path + " with " + options);
        return new RecordReaderImpl(this, options);
    }

    @Override
    public RecordReader rows(boolean[] include) throws IOException {
        return this.rowsOptions(new Reader.Options().include(include));
    }

    @Override
    public RecordReader rows(long offset, long length, boolean[] include) throws IOException {
        return this.rowsOptions(new Reader.Options().include(include).range(offset, length));
    }

    @Override
    public RecordReader rows(long offset, long length, boolean[] include, SearchArgument sarg, String[] columnNames) throws IOException {
        return this.rowsOptions(new Reader.Options().include(include).range(offset, length).searchArgument(sarg, columnNames));
    }

    @Override
    public String toString() {
        return "Hive " + super.toString();
    }
}

