/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.hadoop.hive.ql.exec.AmbiguousMethodException;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.NoMatchingMethodException;
import org.apache.hadoop.hive.ql.exec.Registry;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.WindowFunctionDescription;
import org.apache.hadoop.hive.ql.exec.WindowFunctionInfo;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.UDAFPercentile;
import org.apache.hadoop.hive.ql.udf.UDFAcos;
import org.apache.hadoop.hive.ql.udf.UDFAscii;
import org.apache.hadoop.hive.ql.udf.UDFAsin;
import org.apache.hadoop.hive.ql.udf.UDFAtan;
import org.apache.hadoop.hive.ql.udf.UDFBase64;
import org.apache.hadoop.hive.ql.udf.UDFBin;
import org.apache.hadoop.hive.ql.udf.UDFChr;
import org.apache.hadoop.hive.ql.udf.UDFConv;
import org.apache.hadoop.hive.ql.udf.UDFCos;
import org.apache.hadoop.hive.ql.udf.UDFCrc32;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorDay;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorHour;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorMinute;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorMonth;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorQuarter;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorSecond;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorWeek;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorYear;
import org.apache.hadoop.hive.ql.udf.UDFDayOfMonth;
import org.apache.hadoop.hive.ql.udf.UDFDayOfWeek;
import org.apache.hadoop.hive.ql.udf.UDFDegrees;
import org.apache.hadoop.hive.ql.udf.UDFE;
import org.apache.hadoop.hive.ql.udf.UDFExp;
import org.apache.hadoop.hive.ql.udf.UDFFindInSet;
import org.apache.hadoop.hive.ql.udf.UDFFromUnixTime;
import org.apache.hadoop.hive.ql.udf.UDFHex;
import org.apache.hadoop.hive.ql.udf.UDFHour;
import org.apache.hadoop.hive.ql.udf.UDFJson;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFLog10;
import org.apache.hadoop.hive.ql.udf.UDFLog2;
import org.apache.hadoop.hive.ql.udf.UDFMd5;
import org.apache.hadoop.hive.ql.udf.UDFMinute;
import org.apache.hadoop.hive.ql.udf.UDFMonth;
import org.apache.hadoop.hive.ql.udf.UDFOPBitAnd;
import org.apache.hadoop.hive.ql.udf.UDFOPBitNot;
import org.apache.hadoop.hive.ql.udf.UDFOPBitOr;
import org.apache.hadoop.hive.ql.udf.UDFOPBitShiftLeft;
import org.apache.hadoop.hive.ql.udf.UDFOPBitShiftRight;
import org.apache.hadoop.hive.ql.udf.UDFOPBitShiftRightUnsigned;
import org.apache.hadoop.hive.ql.udf.UDFOPBitXor;
import org.apache.hadoop.hive.ql.udf.UDFOPLongDivide;
import org.apache.hadoop.hive.ql.udf.UDFPI;
import org.apache.hadoop.hive.ql.udf.UDFParseUrl;
import org.apache.hadoop.hive.ql.udf.UDFRadians;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.UDFRegExpExtract;
import org.apache.hadoop.hive.ql.udf.UDFRegExpReplace;
import org.apache.hadoop.hive.ql.udf.UDFRepeat;
import org.apache.hadoop.hive.ql.udf.UDFReplace;
import org.apache.hadoop.hive.ql.udf.UDFReverse;
import org.apache.hadoop.hive.ql.udf.UDFSecond;
import org.apache.hadoop.hive.ql.udf.UDFSha1;
import org.apache.hadoop.hive.ql.udf.UDFSign;
import org.apache.hadoop.hive.ql.udf.UDFSin;
import org.apache.hadoop.hive.ql.udf.UDFSpace;
import org.apache.hadoop.hive.ql.udf.UDFSqrt;
import org.apache.hadoop.hive.ql.udf.UDFStringFromHBaseBytes;
import org.apache.hadoop.hive.ql.udf.UDFSubstr;
import org.apache.hadoop.hive.ql.udf.UDFTan;
import org.apache.hadoop.hive.ql.udf.UDFToBoolean;
import org.apache.hadoop.hive.ql.udf.UDFToByte;
import org.apache.hadoop.hive.ql.udf.UDFToDouble;
import org.apache.hadoop.hive.ql.udf.UDFToFloat;
import org.apache.hadoop.hive.ql.udf.UDFToInteger;
import org.apache.hadoop.hive.ql.udf.UDFToLong;
import org.apache.hadoop.hive.ql.udf.UDFToShort;
import org.apache.hadoop.hive.ql.udf.UDFToString;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.UDFUUID;
import org.apache.hadoop.hive.ql.udf.UDFUnbase64;
import org.apache.hadoop.hive.ql.udf.UDFUnhex;
import org.apache.hadoop.hive.ql.udf.UDFVersion;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFAverage;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBinarySetFunctions;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBloomFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCollectList;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCollectSet;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFComputeStats;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFContextNGrams;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCorrelation;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCovariance;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCovarianceSample;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCumeDist;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFDenseRank;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEWAHBitmap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFFirstValue;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFHistogramNumeric;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFLag;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFLastValue;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFLead;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMax;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMin;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFNTile;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFPercentRank;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFPercentileApprox;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFRank;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFRowNumber;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStdSample;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSumEmptyIsZero;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVariance;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVarianceSample;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFnGrams;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAddMonths;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAesDecrypt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAesEncrypt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFArray;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFArrayContains;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAssertTrue;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCardinalityViolation;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCbrt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCeil;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCharacterLength;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcat;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcatWS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCurrentDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCurrentTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCurrentUser;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateAdd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateDiff;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateFormat;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateSub;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDecode;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFEWAHBitmapAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFEWAHBitmapEmpty;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFEWAHBitmapOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFElt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFEncode;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFExtractUnion;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFactorial;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFField;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFloor;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFormatNumber;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFromUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFromUtcTimestampNew;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFGreatest;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFGrouping;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFHash;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInBloomFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInFile;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIndex;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInitCap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInstr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInternalInterval;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLag;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLastDay;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLead;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLeast;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLength;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLevenshtein;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLocate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLoggedInUser;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLpad;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMacro;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMapKeys;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMapValues;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMask;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMaskFirstN;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMaskHash;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMaskLastN;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMaskShowFirstN;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMaskShowLastN;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMonthsBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNamedStruct;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNextDay;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNullif;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNvl;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPDTIMinus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPDTIPlus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPDivide;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualNS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMinus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMultiply;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNumericMinus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNumericPlus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOctetLength;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPosMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPrintf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFQuarter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFReflect;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFReflect2;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRegExp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRpad;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSQCountCheck;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSentences;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSha2;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSize;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSortArray;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSortArrayByField;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSoundex;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSplit;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStringToMap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStruct;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSubstringIndex;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToIntervalDayTime;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToIntervalYearMonth;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestampNew;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTranslate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTrunc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUnion;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFExplode;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFGetSplits;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFInline;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFJSONTuple;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFParseUrlTuple;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFPosExplode;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFReplicateRows;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFStack;
import org.apache.hadoop.hive.ql.udf.generic.SimpleGenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.UDFCurrentDB;
import org.apache.hadoop.hive.ql.udf.ptf.MatchPath;
import org.apache.hadoop.hive.ql.udf.ptf.Noop;
import org.apache.hadoop.hive.ql.udf.ptf.NoopStreaming;
import org.apache.hadoop.hive.ql.udf.ptf.NoopWithMap;
import org.apache.hadoop.hive.ql.udf.ptf.NoopWithMapStreaming;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionResolver;
import org.apache.hadoop.hive.ql.udf.ptf.WindowingTableFunction;
import org.apache.hadoop.hive.ql.udf.xml.GenericUDFXPath;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathBoolean;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathDouble;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathFloat;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathInteger;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathLong;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathShort;
import org.apache.hadoop.hive.ql.udf.xml.UDFXPathString;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.HiveDecimalUtils;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.common.util.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FunctionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionRegistry.class);
    public static final String LEAD_FUNC_NAME = "lead";
    public static final String LAG_FUNC_NAME = "lag";
    public static final String LAST_VALUE_FUNC_NAME = "last_value";
    public static final String UNARY_PLUS_FUNC_NAME = "positive";
    public static final String UNARY_MINUS_FUNC_NAME = "negative";
    public static final String WINDOWING_TABLE_FUNCTION = "windowingtablefunction";
    private static final String NOOP_TABLE_FUNCTION = "noop";
    private static final String NOOP_MAP_TABLE_FUNCTION = "noopwithmap";
    private static final String NOOP_STREAMING_TABLE_FUNCTION = "noopstreaming";
    private static final String NOOP_STREAMING_MAP_TABLE_FUNCTION = "noopwithmapstreaming";
    private static final String MATCH_PATH_TABLE_FUNCTION = "matchpath";
    public static final Set<String> HIVE_OPERATORS = new HashSet<String>();
    private static final Registry system;

    public static String getNormalizedFunctionName(String fn) throws SemanticException {
        return FunctionUtils.isQualifiedFunctionName(fn = fn.toLowerCase()) || FunctionRegistry.getFunctionInfo(fn) != null ? fn : FunctionUtils.qualifyFunctionName(fn, SessionState.get().getCurrentDatabase().toLowerCase());
    }

    public static FunctionInfo getFunctionInfo(String functionName) throws SemanticException {
        try {
            Hive.get().ensureFunctionsRegistered();
        }
        catch (HiveException e) {
            LOG.warn("Function registration skipped due to error: ", (Throwable)e);
        }
        FunctionInfo info = FunctionRegistry.getTemporaryFunctionInfo(functionName);
        return info != null ? info : system.getFunctionInfo(functionName);
    }

    public static FunctionInfo getTemporaryFunctionInfo(String functionName) throws SemanticException {
        Registry registry = SessionState.getRegistry();
        return registry == null ? null : registry.getFunctionInfo(functionName);
    }

    public static WindowFunctionInfo getWindowFunctionInfo(String functionName) throws SemanticException {
        Registry registry = SessionState.getRegistry();
        WindowFunctionInfo info = registry == null ? null : registry.getWindowFunctionInfo(functionName);
        return info != null ? info : system.getWindowFunctionInfo(functionName);
    }

    public static Set<String> getFunctionNames() {
        TreeSet<String> names = new TreeSet<String>();
        names.addAll(system.getCurrentFunctionNames());
        if (SessionState.getRegistry() != null) {
            names.addAll(SessionState.getRegistry().getCurrentFunctionNames());
        }
        return names;
    }

    public static Set<String> getFunctionNames(String funcPatternStr) {
        TreeSet<String> funcNames = new TreeSet<String>();
        funcNames.addAll(system.getFunctionNames(funcPatternStr));
        if (SessionState.getRegistry() != null) {
            funcNames.addAll(SessionState.getRegistry().getFunctionNames(funcPatternStr));
        }
        return funcNames;
    }

    public static Set<String> getFunctionNamesByLikePattern(String funcPatternStr) {
        String[] subpatterns;
        TreeSet<String> funcNames = new TreeSet<String>();
        Set<String> allFuncs = FunctionRegistry.getFunctionNames();
        for (String subpattern : subpatterns = funcPatternStr.trim().split("\\|")) {
            subpattern = "(?i)" + subpattern.replaceAll("\\*", ".*");
            try {
                Pattern patternObj = Pattern.compile(subpattern);
                for (String funcName : allFuncs) {
                    if (!patternObj.matcher(funcName).matches()) continue;
                    funcNames.add(funcName);
                }
            }
            catch (PatternSyntaxException e) {
                // empty catch block
            }
        }
        return funcNames;
    }

    public static Set<String> getFunctionSynonyms(String funcName) throws SemanticException {
        FunctionInfo funcInfo = FunctionRegistry.getFunctionInfo(funcName);
        if (null == funcInfo) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> synonyms = new LinkedHashSet<String>();
        system.getFunctionSynonyms(funcName, funcInfo, synonyms);
        if (SessionState.getRegistry() != null) {
            SessionState.getRegistry().getFunctionSynonyms(funcName, funcInfo, synonyms);
        }
        return synonyms;
    }

    public static boolean isNumericType(PrimitiveTypeInfo typeInfo) {
        switch (typeInfo.getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DECIMAL: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case VARCHAR: 
            case CHAR: 
            case VOID: {
                return true;
            }
        }
        return false;
    }

    public static boolean isExactNumericType(PrimitiveTypeInfo typeInfo) {
        switch (typeInfo.getPrimitiveCategory()) {
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DECIMAL: {
                return true;
            }
        }
        return false;
    }

    static int getCommonLength(int aLen, int bLen) {
        int maxLength = aLen < 0 || bLen < 0 ? -1 : Math.max(aLen, bLen);
        return maxLength;
    }

    public static TypeInfo getTypeInfoForPrimitiveCategory(PrimitiveTypeInfo a, PrimitiveTypeInfo b, PrimitiveObjectInspector.PrimitiveCategory typeCategory) {
        switch (typeCategory) {
            case CHAR: {
                int maxLength = FunctionRegistry.getCommonLength(TypeInfoUtils.getCharacterLengthForType(a), TypeInfoUtils.getCharacterLengthForType(b));
                return TypeInfoFactory.getCharTypeInfo(maxLength);
            }
            case VARCHAR: {
                int maxLength = FunctionRegistry.getCommonLength(TypeInfoUtils.getCharacterLengthForType(a), TypeInfoUtils.getCharacterLengthForType(b));
                return TypeInfoFactory.getVarcharTypeInfo(maxLength);
            }
            case DECIMAL: {
                return HiveDecimalUtils.getDecimalTypeForPrimitiveCategories(a, b);
            }
        }
        return TypeInfoFactory.getPrimitiveTypeInfo(PrimitiveObjectInspectorUtils.getTypeEntryFromPrimitiveCategory((PrimitiveObjectInspector.PrimitiveCategory)typeCategory).typeName);
    }

    public static TypeInfo getCommonClassForUnionAll(TypeInfo a, TypeInfo b) {
        PrimitiveObjectInspector.PrimitiveCategory pcB;
        if (a.equals(b)) {
            return a;
        }
        if (a.getCategory() != ObjectInspector.Category.PRIMITIVE || b.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return null;
        }
        PrimitiveObjectInspector.PrimitiveCategory pcA = ((PrimitiveTypeInfo)a).getPrimitiveCategory();
        if (pcA == (pcB = ((PrimitiveTypeInfo)b).getPrimitiveCategory())) {
            return FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)a, (PrimitiveTypeInfo)b, pcA);
        }
        PrimitiveObjectInspectorUtils.PrimitiveGrouping pgA = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(pcA);
        PrimitiveObjectInspectorUtils.PrimitiveGrouping pgB = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(pcB);
        if (pgA == PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP) {
            return b;
        }
        if (pgB == PrimitiveObjectInspectorUtils.PrimitiveGrouping.VOID_GROUP) {
            return a;
        }
        if (pgA != pgB) {
            return null;
        }
        switch (pgA) {
            case STRING_GROUP: {
                return FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)a, (PrimitiveTypeInfo)b, PrimitiveObjectInspector.PrimitiveCategory.STRING);
            }
            case NUMERIC_GROUP: {
                return TypeInfoUtils.implicitConvertible(a, b) ? b : a;
            }
            case DATE_GROUP: {
                return TypeInfoFactory.timestampTypeInfo;
            }
        }
        return null;
    }

    public static synchronized TypeInfo getCommonClassForComparison(TypeInfo a, TypeInfo b) {
        PrimitiveObjectInspectorUtils.PrimitiveGrouping pgB;
        PrimitiveObjectInspector.PrimitiveCategory pcB;
        if (a.equals(b)) {
            return a;
        }
        if (a.getCategory() != ObjectInspector.Category.PRIMITIVE || b.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            if (a.getCategory() == ObjectInspector.Category.STRUCT && b.getCategory() == ObjectInspector.Category.STRUCT) {
                return FunctionRegistry.getCommonClassForStruct((StructTypeInfo)a, (StructTypeInfo)b, new BiFunction<TypeInfo, TypeInfo, TypeInfo>(){

                    @Override
                    public TypeInfo apply(TypeInfo type1, TypeInfo type2) {
                        return FunctionRegistry.getCommonClassForComparison(type1, type2);
                    }
                });
            }
            return null;
        }
        PrimitiveObjectInspector.PrimitiveCategory pcA = ((PrimitiveTypeInfo)a).getPrimitiveCategory();
        if (pcA == (pcB = ((PrimitiveTypeInfo)b).getPrimitiveCategory())) {
            return FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)a, (PrimitiveTypeInfo)b, pcA);
        }
        PrimitiveObjectInspectorUtils.PrimitiveGrouping pgA = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(pcA);
        if (pgA == (pgB = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(pcB)) && pgA == PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP) {
            return TypeInfoFactory.timestampTypeInfo;
        }
        if (pgA == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && pgB == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            return FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)a, (PrimitiveTypeInfo)b, PrimitiveObjectInspector.PrimitiveCategory.STRING);
        }
        if (pgA == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && pgB == PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP) {
            return b;
        }
        if (pgB == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && pgA == PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP) {
            return a;
        }
        if (!(pgA != PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP && pgB != PrimitiveObjectInspectorUtils.PrimitiveGrouping.NUMERIC_GROUP || pcA != PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP && pcB != PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP)) {
            return TypeInfoFactory.doubleTypeInfo;
        }
        for (PrimitiveObjectInspector.PrimitiveCategory t : TypeInfoUtils.numericTypeList) {
            if (!TypeInfoUtils.implicitConvertible(pcA, t) || !TypeInfoUtils.implicitConvertible(pcB, t)) continue;
            return FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)a, (PrimitiveTypeInfo)b, t);
        }
        return null;
    }

    public static PrimitiveObjectInspector.PrimitiveCategory getPrimitiveCommonCategory(TypeInfo a, TypeInfo b) {
        if (a.getCategory() != ObjectInspector.Category.PRIMITIVE || b.getCategory() != ObjectInspector.Category.PRIMITIVE) {
            return null;
        }
        PrimitiveObjectInspector.PrimitiveCategory pcA = ((PrimitiveTypeInfo)a).getPrimitiveCategory();
        PrimitiveObjectInspector.PrimitiveCategory pcB = ((PrimitiveTypeInfo)b).getPrimitiveCategory();
        PrimitiveObjectInspectorUtils.PrimitiveGrouping pgA = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(pcA);
        PrimitiveObjectInspectorUtils.PrimitiveGrouping pgB = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(pcB);
        if (pgA == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP && pgB == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            return PrimitiveObjectInspector.PrimitiveCategory.STRING;
        }
        if (pgA == PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP && pgB == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            return PrimitiveObjectInspector.PrimitiveCategory.STRING;
        }
        if (pgB == PrimitiveObjectInspectorUtils.PrimitiveGrouping.DATE_GROUP && pgA == PrimitiveObjectInspectorUtils.PrimitiveGrouping.STRING_GROUP) {
            return PrimitiveObjectInspector.PrimitiveCategory.STRING;
        }
        Integer ai = TypeInfoUtils.numericTypes.get((Object)pcA);
        Integer bi = TypeInfoUtils.numericTypes.get((Object)pcB);
        if (ai == null || bi == null) {
            return null;
        }
        return ai > bi ? pcA : pcB;
    }

    public static TypeInfo getCommonClass(TypeInfo a, TypeInfo b) {
        if (a.equals(b)) {
            return a;
        }
        PrimitiveObjectInspector.PrimitiveCategory commonCat = FunctionRegistry.getPrimitiveCommonCategory(a, b);
        if (commonCat != null) {
            return FunctionRegistry.getTypeInfoForPrimitiveCategory((PrimitiveTypeInfo)a, (PrimitiveTypeInfo)b, commonCat);
        }
        if (a.getCategory() == ObjectInspector.Category.STRUCT && b.getCategory() == ObjectInspector.Category.STRUCT) {
            return FunctionRegistry.getCommonClassForStruct((StructTypeInfo)a, (StructTypeInfo)b, new BiFunction<TypeInfo, TypeInfo, TypeInfo>(){

                @Override
                public TypeInfo apply(TypeInfo type1, TypeInfo type2) {
                    return FunctionRegistry.getCommonClass(type1, type2);
                }
            });
        }
        return null;
    }

    public static TypeInfo getCommonClassForStruct(StructTypeInfo a, StructTypeInfo b, BiFunction<TypeInfo, TypeInfo, TypeInfo> commonClassFunction) {
        if (a == b || a.equals(b)) {
            return a;
        }
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>();
        Iterator<String> namesIterator = a.getAllStructFieldNames().iterator();
        Iterator<String> otherNamesIterator = b.getAllStructFieldNames().iterator();
        while (namesIterator.hasNext() && otherNamesIterator.hasNext()) {
            String name = namesIterator.next();
            if (!name.equalsIgnoreCase(otherNamesIterator.next())) {
                return null;
            }
            names.add(name);
        }
        if (namesIterator.hasNext() || otherNamesIterator.hasNext()) {
            return null;
        }
        ArrayList<TypeInfo> fromTypes = a.getAllStructFieldTypeInfos();
        ArrayList<TypeInfo> toTypes = b.getAllStructFieldTypeInfos();
        for (int i = 0; i < fromTypes.size(); ++i) {
            TypeInfo commonType = commonClassFunction.apply(fromTypes.get(i), toTypes.get(i));
            if (commonType == null) {
                return null;
            }
            typeInfos.add(commonType);
        }
        return TypeInfoFactory.getStructTypeInfo(names, typeInfos);
    }

    public static GenericUDAFEvaluator getGenericUDAFEvaluator(String name, List<ObjectInspector> argumentOIs, boolean isDistinct, boolean isAllColumns) throws SemanticException {
        GenericUDAFResolver udafResolver = FunctionRegistry.getGenericUDAFResolver(name);
        if (udafResolver == null) {
            return null;
        }
        ObjectInspector[] args = new ObjectInspector[argumentOIs.size()];
        for (int ii = 0; ii < argumentOIs.size(); ++ii) {
            args[ii] = argumentOIs.get(ii);
        }
        SimpleGenericUDAFParameterInfo paramInfo = new SimpleGenericUDAFParameterInfo(args, false, isDistinct, isAllColumns);
        GenericUDAFEvaluator udafEvaluator = udafResolver instanceof GenericUDAFResolver2 ? ((GenericUDAFResolver2)udafResolver).getEvaluator(paramInfo) : udafResolver.getEvaluator(paramInfo.getParameters());
        return udafEvaluator;
    }

    public static GenericUDAFEvaluator getGenericWindowingEvaluator(String name, List<ObjectInspector> argumentOIs, boolean isDistinct, boolean isAllColumns) throws SemanticException {
        Registry registry = SessionState.getRegistry();
        GenericUDAFEvaluator evaluator = registry == null ? null : registry.getGenericWindowingEvaluator(name, argumentOIs, isDistinct, isAllColumns);
        return evaluator != null ? evaluator : system.getGenericWindowingEvaluator(name, argumentOIs, isDistinct, isAllColumns);
    }

    public static <T> Method getMethodInternal(Class<? extends T> udfClass, String methodName, boolean exact, List<TypeInfo> argumentClasses) throws UDFArgumentException {
        ArrayList<Method> mlist = new ArrayList<Method>();
        for (Method m : udfClass.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            mlist.add(m);
        }
        return FunctionRegistry.getMethodInternal(udfClass, mlist, exact, argumentClasses);
    }

    public static GenericUDAFResolver getGenericUDAFResolver(String functionName) throws SemanticException {
        FunctionInfo finfo;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Looking up GenericUDAF: " + functionName);
        }
        if ((finfo = FunctionRegistry.getFunctionInfo(functionName)) == null) {
            return null;
        }
        GenericUDAFResolver result = finfo.getGenericUDAFResolver();
        return result;
    }

    public static Object invoke(Method m, Object thisObject, Object ... arguments) throws HiveException {
        Object o;
        try {
            o = m.invoke(thisObject, arguments);
        }
        catch (Exception e) {
            StringBuilder argumentString = new StringBuilder();
            if (arguments == null) {
                argumentString.append("null");
            } else {
                argumentString.append("{");
                for (int i = 0; i < arguments.length; ++i) {
                    if (i > 0) {
                        argumentString.append(",");
                    }
                    argumentString.append(arguments[i]);
                }
                argumentString.append("}");
            }
            String detailedMsg = e instanceof InvocationTargetException ? e.getCause().getMessage() : e.getMessage();
            throw new HiveException("Unable to execute method " + m + " with arguments " + argumentString + ":" + detailedMsg, e);
        }
        return o;
    }

    public static int matchCost(TypeInfo argumentPassed, TypeInfo argumentAccepted, boolean exact) {
        if (argumentAccepted.equals(argumentPassed) || TypeInfoUtils.doPrimitiveCategoriesMatch(argumentPassed, argumentAccepted)) {
            return 0;
        }
        if (argumentPassed.equals(TypeInfoFactory.voidTypeInfo)) {
            return 0;
        }
        if (argumentPassed.getCategory().equals((Object)ObjectInspector.Category.LIST) && argumentAccepted.getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            TypeInfo argumentPassedElement = ((ListTypeInfo)argumentPassed).getListElementTypeInfo();
            TypeInfo argumentAcceptedElement = ((ListTypeInfo)argumentAccepted).getListElementTypeInfo();
            return FunctionRegistry.matchCost(argumentPassedElement, argumentAcceptedElement, exact);
        }
        if (argumentPassed.getCategory().equals((Object)ObjectInspector.Category.MAP) && argumentAccepted.getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            TypeInfo argumentPassedKey = ((MapTypeInfo)argumentPassed).getMapKeyTypeInfo();
            TypeInfo argumentAcceptedKey = ((MapTypeInfo)argumentAccepted).getMapKeyTypeInfo();
            TypeInfo argumentPassedValue = ((MapTypeInfo)argumentPassed).getMapValueTypeInfo();
            TypeInfo argumentAcceptedValue = ((MapTypeInfo)argumentAccepted).getMapValueTypeInfo();
            int cost1 = FunctionRegistry.matchCost(argumentPassedKey, argumentAcceptedKey, exact);
            int cost2 = FunctionRegistry.matchCost(argumentPassedValue, argumentAcceptedValue, exact);
            if (cost1 < 0 || cost2 < 0) {
                return -1;
            }
            return Math.max(cost1, cost2);
        }
        if (argumentAccepted.equals(TypeInfoFactory.unknownTypeInfo)) {
            return 1;
        }
        if (!exact && TypeInfoUtils.implicitConvertible(argumentPassed, argumentAccepted)) {
            return 1;
        }
        return -1;
    }

    static void filterMethodsByTypeAffinity(List<Method> udfMethods, List<TypeInfo> argumentsPassed) {
        if (udfMethods.size() > 1) {
            int currentScore = 0;
            int bestMatchScore = 0;
            Method bestMatch = null;
            for (Method m : udfMethods) {
                currentScore = 0;
                List<TypeInfo> argumentsAccepted = TypeInfoUtils.getParameterTypeInfos(m, argumentsPassed.size());
                Iterator<TypeInfo> argsPassedIter = argumentsPassed.iterator();
                for (TypeInfo acceptedType : argumentsAccepted) {
                    PrimitiveObjectInspectorUtils.PrimitiveGrouping passedPg;
                    PrimitiveObjectInspectorUtils.PrimitiveGrouping acceptedPg;
                    TypeInfo passedType = argsPassedIter.next();
                    if (acceptedType.getCategory() != ObjectInspector.Category.PRIMITIVE || passedType.getCategory() != ObjectInspector.Category.PRIMITIVE || (acceptedPg = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(((PrimitiveTypeInfo)acceptedType).getPrimitiveCategory())) != (passedPg = PrimitiveObjectInspectorUtils.getPrimitiveGrouping(((PrimitiveTypeInfo)passedType).getPrimitiveCategory()))) continue;
                    ++currentScore;
                }
                if (currentScore > bestMatchScore) {
                    bestMatchScore = currentScore;
                    bestMatch = m;
                    continue;
                }
                if (currentScore != bestMatchScore) continue;
                bestMatch = null;
            }
            if (bestMatch != null) {
                udfMethods.clear();
                udfMethods.add(bestMatch);
            }
        }
    }

    public static Method getMethodInternal(Class<?> udfClass, List<Method> mlist, boolean exact, List<TypeInfo> argumentsPassed) throws UDFArgumentException {
        ArrayList<Method> udfMethods = new ArrayList<Method>();
        int leastConversionCost = Integer.MAX_VALUE;
        for (Method m : mlist) {
            List<TypeInfo> argumentsAccepted = TypeInfoUtils.getParameterTypeInfos(m, argumentsPassed.size());
            if (argumentsAccepted == null) continue;
            boolean match = argumentsAccepted.size() == argumentsPassed.size();
            int conversionCost = 0;
            for (int i = 0; i < argumentsPassed.size() && match; ++i) {
                int cost = FunctionRegistry.matchCost(argumentsPassed.get(i), argumentsAccepted.get(i), exact);
                if (cost == -1) {
                    match = false;
                    continue;
                }
                conversionCost += cost;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Method " + (match ? "did" : "didn't") + " match: passed = " + argumentsPassed + " accepted = " + argumentsAccepted + " method = " + m);
            }
            if (!match) continue;
            if (conversionCost < leastConversionCost) {
                udfMethods.clear();
                udfMethods.add(m);
                leastConversionCost = conversionCost;
                if (leastConversionCost != 0) continue;
                break;
            }
            if (conversionCost != leastConversionCost) continue;
            udfMethods.add(m);
        }
        if (udfMethods.size() == 0) {
            throw new NoMatchingMethodException(udfClass, argumentsPassed, mlist);
        }
        if (udfMethods.size() > 1) {
            FunctionRegistry.filterMethodsByTypeAffinity(udfMethods, argumentsPassed);
        }
        if (udfMethods.size() > 1) {
            int lowestNumericType = Integer.MAX_VALUE;
            boolean multiple = true;
            Method candidate = null;
            List<TypeInfo> referenceArguments = null;
            for (Method m : udfMethods) {
                int maxNumericType = 0;
                List<TypeInfo> argumentsAccepted = TypeInfoUtils.getParameterTypeInfos(m, argumentsPassed.size());
                if (referenceArguments == null) {
                    referenceArguments = argumentsAccepted;
                }
                Iterator<TypeInfo> referenceIterator = referenceArguments.iterator();
                for (TypeInfo accepted : argumentsAccepted) {
                    TypeInfo reference = referenceIterator.next();
                    boolean acceptedIsPrimitive = false;
                    PrimitiveObjectInspector.PrimitiveCategory acceptedPrimCat = PrimitiveObjectInspector.PrimitiveCategory.UNKNOWN;
                    if (accepted.getCategory() == ObjectInspector.Category.PRIMITIVE) {
                        acceptedIsPrimitive = true;
                        acceptedPrimCat = ((PrimitiveTypeInfo)accepted).getPrimitiveCategory();
                    }
                    if (acceptedIsPrimitive && TypeInfoUtils.numericTypes.containsKey((Object)acceptedPrimCat)) {
                        int typeValue = TypeInfoUtils.numericTypes.get((Object)acceptedPrimCat);
                        maxNumericType = typeValue > maxNumericType ? typeValue : maxNumericType;
                        continue;
                    }
                    if (accepted.equals(reference)) continue;
                    throw new AmbiguousMethodException(udfClass, argumentsPassed, mlist);
                }
                if (lowestNumericType > maxNumericType) {
                    multiple = false;
                    lowestNumericType = maxNumericType;
                    candidate = m;
                    continue;
                }
                if (maxNumericType != lowestNumericType) continue;
                multiple = true;
            }
            if (!multiple) {
                return candidate;
            }
            throw new AmbiguousMethodException(udfClass, argumentsPassed, mlist);
        }
        return (Method)udfMethods.get(0);
    }

    public static GenericUDF getGenericUDFForIndex() {
        try {
            return FunctionRegistry.getFunctionInfo("index").getGenericUDF();
        }
        catch (SemanticException e) {
            throw new RuntimeException("hive operator -- never be thrown", e);
        }
    }

    public static GenericUDF getGenericUDFForAnd() {
        try {
            return FunctionRegistry.getFunctionInfo("and").getGenericUDF();
        }
        catch (SemanticException e) {
            throw new RuntimeException("hive operator -- never be thrown", e);
        }
    }

    public static GenericUDF cloneGenericUDF(GenericUDF genericUDF) {
        GenericUDF clonedUDF;
        GenericUDF bridge;
        if (null == genericUDF) {
            return null;
        }
        if (genericUDF instanceof GenericUDFBridge) {
            bridge = (GenericUDFBridge)genericUDF;
            clonedUDF = new GenericUDFBridge(((GenericUDFBridge)bridge).getUdfName(), ((GenericUDFBridge)bridge).isOperator(), ((GenericUDFBridge)bridge).getUdfClassName());
        } else if (genericUDF instanceof GenericUDFMacro) {
            bridge = (GenericUDFMacro)genericUDF;
            clonedUDF = new GenericUDFMacro(((GenericUDFMacro)bridge).getMacroName(), ((GenericUDFMacro)bridge).getBody().clone(), ((GenericUDFMacro)bridge).getColNames(), ((GenericUDFMacro)bridge).getColTypes());
        } else {
            clonedUDF = (GenericUDF)ReflectionUtils.newInstance(genericUDF.getClass(), null);
        }
        if (clonedUDF != null) {
            try {
                genericUDF.copyToNewInstance(clonedUDF);
            }
            catch (UDFArgumentException err) {
                throw new IllegalArgumentException(err);
            }
            if (genericUDF instanceof SettableUDF) {
                try {
                    TypeInfo typeInfo = ((SettableUDF)((Object)genericUDF)).getTypeInfo();
                    if (typeInfo != null) {
                        ((SettableUDF)((Object)clonedUDF)).setTypeInfo(typeInfo);
                    }
                }
                catch (UDFArgumentException err) {
                    LOG.error("Unable to add settable data to UDF " + genericUDF.getClass());
                    throw new IllegalArgumentException(err);
                }
            }
        }
        return clonedUDF;
    }

    public static GenericUDTF cloneGenericUDTF(GenericUDTF genericUDTF) {
        if (null == genericUDTF) {
            return null;
        }
        return (GenericUDTF)ReflectionUtils.newInstance(genericUDTF.getClass(), null);
    }

    private static Class<? extends GenericUDF> getGenericUDFClassFromExprDesc(ExprNodeDesc desc) {
        if (!(desc instanceof ExprNodeGenericFuncDesc)) {
            return null;
        }
        ExprNodeGenericFuncDesc genericFuncDesc = (ExprNodeGenericFuncDesc)desc;
        return genericFuncDesc.getGenericUDF().getClass();
    }

    public static boolean isDeterministic(GenericUDF genericUDF) {
        GenericUDFBridge bridge;
        UDFType bridgeUDFType;
        if (FunctionRegistry.isStateful(genericUDF)) {
            return false;
        }
        UDFType genericUDFType = AnnotationUtils.getAnnotation(genericUDF.getClass(), UDFType.class);
        if (genericUDFType != null && !genericUDFType.deterministic()) {
            return false;
        }
        if (genericUDF instanceof GenericUDFBridge && (bridgeUDFType = AnnotationUtils.getAnnotation((bridge = (GenericUDFBridge)genericUDF).getUdfClass(), UDFType.class)) != null && !bridgeUDFType.deterministic()) {
            return false;
        }
        if (genericUDF instanceof GenericUDFMacro) {
            GenericUDFMacro macro = (GenericUDFMacro)genericUDF;
            return macro.isDeterministic();
        }
        return true;
    }

    public static boolean isStateful(GenericUDF genericUDF) {
        GenericUDFBridge bridge;
        UDFType bridgeUDFType;
        UDFType genericUDFType = AnnotationUtils.getAnnotation(genericUDF.getClass(), UDFType.class);
        if (genericUDFType != null && genericUDFType.stateful()) {
            return true;
        }
        if (genericUDF instanceof GenericUDFBridge && (bridgeUDFType = AnnotationUtils.getAnnotation((bridge = (GenericUDFBridge)genericUDF).getUdfClass(), UDFType.class)) != null && bridgeUDFType.stateful()) {
            return true;
        }
        if (genericUDF instanceof GenericUDFMacro) {
            GenericUDFMacro macro = (GenericUDFMacro)genericUDF;
            return macro.isStateful();
        }
        return false;
    }

    public static boolean isOpAndOrNot(ExprNodeDesc desc) {
        Class<? extends GenericUDF> genericUdfClass = FunctionRegistry.getGenericUDFClassFromExprDesc(desc);
        return GenericUDFOPAnd.class == genericUdfClass || GenericUDFOPOr.class == genericUdfClass || GenericUDFOPNot.class == genericUdfClass;
    }

    public static boolean isOpAnd(ExprNodeDesc desc) {
        return GenericUDFOPAnd.class == FunctionRegistry.getGenericUDFClassFromExprDesc(desc);
    }

    public static boolean isOpOr(ExprNodeDesc desc) {
        return GenericUDFOPOr.class == FunctionRegistry.getGenericUDFClassFromExprDesc(desc);
    }

    public static boolean isIn(ExprNodeDesc desc) {
        return GenericUDFIn.class == FunctionRegistry.getGenericUDFClassFromExprDesc(desc);
    }

    public static boolean isOpNot(ExprNodeDesc desc) {
        return GenericUDFOPNot.class == FunctionRegistry.getGenericUDFClassFromExprDesc(desc);
    }

    public static boolean isEq(GenericUDF fn) {
        return fn instanceof GenericUDFOPEqual;
    }

    public static boolean isNeq(GenericUDF fn) {
        return fn instanceof GenericUDFOPNotEqual;
    }

    public static boolean isOpPositive(ExprNodeDesc desc) {
        return GenericUDFOPPositive.class == FunctionRegistry.getGenericUDFClassFromExprDesc(desc);
    }

    public static boolean isOpCast(ExprNodeDesc desc) {
        if (!(desc instanceof ExprNodeGenericFuncDesc)) {
            return false;
        }
        return FunctionRegistry.isOpCast(((ExprNodeGenericFuncDesc)desc).getGenericUDF());
    }

    public static boolean isOpCast(GenericUDF genericUDF) {
        Class<Object> udfClass = genericUDF instanceof GenericUDFBridge ? ((GenericUDFBridge)genericUDF).getUdfClass() : genericUDF.getClass();
        return udfClass == UDFToBoolean.class || udfClass == UDFToByte.class || udfClass == UDFToDouble.class || udfClass == UDFToFloat.class || udfClass == UDFToInteger.class || udfClass == UDFToLong.class || udfClass == UDFToShort.class || udfClass == UDFToString.class || udfClass == GenericUDFToVarchar.class || udfClass == GenericUDFToChar.class || udfClass == GenericUDFTimestamp.class || udfClass == GenericUDFToBinary.class || udfClass == GenericUDFToDate.class || udfClass == GenericUDFToDecimal.class;
    }

    public static boolean isOpPreserveInputName(ExprNodeDesc desc) {
        return FunctionRegistry.isOpCast(desc);
    }

    public static FunctionInfo registerTemporaryUDF(String functionName, Class<?> udfClass, FunctionInfo.FunctionResource ... resources) {
        return SessionState.getRegistryForWrite().registerFunction(functionName, udfClass, resources);
    }

    public static void unregisterTemporaryUDF(String functionName) throws HiveException {
        if (SessionState.getRegistry() != null) {
            SessionState.getRegistry().unregisterFunction(functionName);
        }
    }

    public static void registerTemporaryMacro(String macroName, ExprNodeDesc body, List<String> colNames, List<TypeInfo> colTypes) {
        SessionState.getRegistryForWrite().registerMacro(macroName, body, colNames, colTypes);
    }

    public static FunctionInfo registerPermanentFunction(String functionName, String className, boolean registerToSession, FunctionInfo.FunctionResource[] resources) {
        return system.registerPermanentFunction(functionName, className, registerToSession, resources);
    }

    public static boolean isPermanentFunction(ExprNodeGenericFuncDesc fnExpr) {
        GenericUDF udf = fnExpr.getGenericUDF();
        if (udf == null) {
            return false;
        }
        Class<Object> clazz = udf.getClass();
        if (udf instanceof GenericUDFBridge) {
            clazz = ((GenericUDFBridge)udf).getUdfClass();
        }
        if (clazz != null) {
            return SessionState.getRegistryForWrite().isPermanentFunc(clazz);
        }
        return false;
    }

    public static void unregisterPermanentFunction(String functionName) throws HiveException {
        system.unregisterFunction(functionName);
        FunctionRegistry.unregisterTemporaryUDF(functionName);
    }

    public static void unregisterPermanentFunctions(String dbName) throws HiveException {
        system.unregisterFunctions(dbName);
    }

    private FunctionRegistry() {
    }

    public static boolean impliesOrder(String functionName) throws SemanticException {
        UDFType type;
        FunctionInfo info = FunctionRegistry.getFunctionInfo(functionName);
        if (info != null && info.isGenericUDF() && (type = AnnotationUtils.getAnnotation(info.getGenericUDF().getClass(), UDFType.class)) != null) {
            return type.impliesOrder();
        }
        WindowFunctionInfo windowInfo = FunctionRegistry.getWindowFunctionInfo(functionName);
        if (windowInfo != null) {
            return windowInfo.isImpliesOrder();
        }
        return false;
    }

    public static boolean pivotResult(String functionName) throws SemanticException {
        WindowFunctionInfo windowInfo = FunctionRegistry.getWindowFunctionInfo(functionName);
        if (windowInfo != null) {
            return windowInfo.isPivotResult();
        }
        return false;
    }

    public static boolean isTableFunction(String functionName) throws SemanticException {
        FunctionInfo tFInfo = FunctionRegistry.getFunctionInfo(functionName);
        return tFInfo != null && !tFInfo.isInternalTableFunction() && tFInfo.isTableFunction();
    }

    public static TableFunctionResolver getTableFunctionResolver(String functionName) throws SemanticException {
        FunctionInfo tfInfo = FunctionRegistry.getFunctionInfo(functionName);
        if (tfInfo != null && tfInfo.isTableFunction()) {
            return (TableFunctionResolver)ReflectionUtils.newInstance(tfInfo.getFunctionClass(), null);
        }
        return null;
    }

    public static TableFunctionResolver getWindowingTableFunction() throws SemanticException {
        return FunctionRegistry.getTableFunctionResolver(WINDOWING_TABLE_FUNCTION);
    }

    public static boolean isNoopFunction(String fnName) {
        return (fnName = fnName.toLowerCase()).equals(NOOP_MAP_TABLE_FUNCTION) || fnName.equals(NOOP_STREAMING_MAP_TABLE_FUNCTION) || fnName.equals(NOOP_TABLE_FUNCTION) || fnName.equals(NOOP_STREAMING_TABLE_FUNCTION);
    }

    public static boolean isRankingFunction(String name) throws SemanticException {
        FunctionInfo info = FunctionRegistry.getFunctionInfo(name);
        if (info == null) {
            return false;
        }
        GenericUDAFResolver res = info.getGenericUDAFResolver();
        if (res == null) {
            return false;
        }
        WindowFunctionDescription desc = AnnotationUtils.getAnnotation(res.getClass(), WindowFunctionDescription.class);
        return desc != null && desc.rankingFunction();
    }

    public static boolean isBuiltInFuncExpr(ExprNodeGenericFuncDesc fnExpr) {
        GenericUDF udf = fnExpr.getGenericUDF();
        if (udf == null) {
            return false;
        }
        Class<Object> clazz = udf.getClass();
        if (udf instanceof GenericUDFBridge) {
            clazz = ((GenericUDFBridge)udf).getUdfClass();
        }
        if (clazz != null) {
            return system.isBuiltInFunc(clazz);
        }
        return false;
    }

    public static boolean isBuiltInFuncClass(Class<?> clazz) {
        return system.isBuiltInFunc(clazz);
    }

    public static void setupPermissionsForBuiltinUDFs(String whiteListStr, String blackListStr) {
        system.setupPermissionsForUDFs(whiteListStr, blackListStr);
    }

    static {
        HIVE_OPERATORS.addAll(Arrays.asList("+", "-", "*", "/", "%", "div", "&", "|", "^", "~", "and", "or", "not", "!", "=", "==", "<=>", "!=", "<>", "<", "<=", ">", ">=", "index"));
        system = new Registry(true);
        system.registerGenericUDF("concat", GenericUDFConcat.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("substr", UDFSubstr.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("substring", UDFSubstr.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("substring_index", GenericUDFSubstringIndex.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("space", UDFSpace.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("repeat", UDFRepeat.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("ascii", UDFAscii.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("lpad", GenericUDFLpad.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("rpad", GenericUDFRpad.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("levenshtein", GenericUDFLevenshtein.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("soundex", GenericUDFSoundex.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("size", GenericUDFSize.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("round", GenericUDFRound.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("bround", GenericUDFBRound.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("floor", GenericUDFFloor.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("sqrt", UDFSqrt.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("cbrt", GenericUDFCbrt.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("ceil", GenericUDFCeil.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("ceiling", GenericUDFCeil.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("rand", UDFRand.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("abs", GenericUDFAbs.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("sq_count_check", GenericUDFSQCountCheck.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("pmod", GenericUDFPosMod.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("ln", UDFLn.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("log2", UDFLog2.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("sin", UDFSin.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("asin", UDFAsin.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("cos", UDFCos.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("acos", UDFAcos.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("log10", UDFLog10.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("log", UDFLog.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("exp", UDFExp.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("power", GenericUDFPower.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("pow", GenericUDFPower.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("sign", UDFSign.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("pi", UDFPI.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("degrees", UDFDegrees.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("radians", UDFRadians.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("atan", UDFAtan.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("tan", UDFTan.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("e", UDFE.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("factorial", GenericUDFFactorial.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("crc32", UDFCrc32.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("conv", UDFConv.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("bin", UDFBin.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("chr", UDFChr.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("hex", UDFHex.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("unhex", UDFUnhex.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("base64", UDFBase64.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("unbase64", UDFUnbase64.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("sha2", GenericUDFSha2.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("md5", UDFMd5.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("sha1", UDFSha1.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("sha", UDFSha1.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("aes_encrypt", GenericUDFAesEncrypt.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("aes_decrypt", GenericUDFAesDecrypt.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("uuid", UDFUUID.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("hbasedecimal", UDFStringFromHBaseBytes.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("encode", GenericUDFEncode.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("decode", GenericUDFDecode.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("upper", GenericUDFUpper.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("lower", GenericUDFLower.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("ucase", GenericUDFUpper.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("lcase", GenericUDFLower.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("trim", GenericUDFTrim.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("ltrim", GenericUDFLTrim.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("rtrim", GenericUDFRTrim.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("length", GenericUDFLength.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("character_length", GenericUDFCharacterLength.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("char_length", GenericUDFCharacterLength.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("octet_length", GenericUDFOctetLength.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("reverse", UDFReverse.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("field", GenericUDFField.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("find_in_set", UDFFindInSet.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("initcap", GenericUDFInitCap.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("like", UDFLike.class, true, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("rlike", GenericUDFRegExp.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("regexp", GenericUDFRegExp.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("regexp_replace", UDFRegExpReplace.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("replace", UDFReplace.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("regexp_extract", UDFRegExpExtract.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("parse_url", UDFParseUrl.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("nvl", GenericUDFNvl.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("split", GenericUDFSplit.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("str_to_map", GenericUDFStringToMap.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("translate", GenericUDFTranslate.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF(UNARY_PLUS_FUNC_NAME, GenericUDFOPPositive.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF(UNARY_MINUS_FUNC_NAME, GenericUDFOPNegative.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("day", UDFDayOfMonth.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("dayofmonth", UDFDayOfMonth.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("dayofweek", UDFDayOfWeek.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("month", UDFMonth.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("quarter", GenericUDFQuarter.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("year", UDFYear.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("hour", UDFHour.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("minute", UDFMinute.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("second", UDFSecond.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("from_unixtime", UDFFromUnixTime.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("to_date", GenericUDFDate.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("weekofyear", UDFWeekOfYear.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("last_day", GenericUDFLastDay.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("next_day", GenericUDFNextDay.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("trunc", GenericUDFTrunc.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("date_format", GenericUDFDateFormat.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("floor_year", UDFDateFloorYear.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("floor_quarter", UDFDateFloorQuarter.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("floor_month", UDFDateFloorMonth.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("floor_day", UDFDateFloorDay.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("floor_week", UDFDateFloorWeek.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("floor_hour", UDFDateFloorHour.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("floor_minute", UDFDateFloorMinute.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("floor_second", UDFDateFloorSecond.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("date_add", GenericUDFDateAdd.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("date_sub", GenericUDFDateSub.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("datediff", GenericUDFDateDiff.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("add_months", GenericUDFAddMonths.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("months_between", GenericUDFMonthsBetween.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("get_json_object", UDFJson.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("xpath_string", UDFXPathString.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("xpath_boolean", UDFXPathBoolean.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("xpath_number", UDFXPathDouble.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("xpath_double", UDFXPathDouble.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("xpath_float", UDFXPathFloat.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("xpath_long", UDFXPathLong.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("xpath_int", UDFXPathInteger.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("xpath_short", UDFXPathShort.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("xpath", GenericUDFXPath.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("+", GenericUDFOPPlus.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("-", GenericUDFOPMinus.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("*", GenericUDFOPMultiply.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("/", GenericUDFOPDivide.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("%", GenericUDFOPMod.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("mod", GenericUDFOPMod.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("div", UDFOPLongDivide.class, true, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("&", UDFOPBitAnd.class, true, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("|", UDFOPBitOr.class, true, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("^", UDFOPBitXor.class, true, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("~", UDFOPBitNot.class, true, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("shiftleft", UDFOPBitShiftLeft.class, true, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("shiftright", UDFOPBitShiftRight.class, true, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("shiftrightunsigned", UDFOPBitShiftRightUnsigned.class, true, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("grouping", GenericUDFGrouping.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("current_database", UDFCurrentDB.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("current_date", GenericUDFCurrentDate.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("current_timestamp", GenericUDFCurrentTimestamp.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("current_user", GenericUDFCurrentUser.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("logged_in_user", GenericUDFLoggedInUser.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("isnull", GenericUDFOPNull.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("isnotnull", GenericUDFOPNotNull.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("if", GenericUDFIf.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("in", GenericUDFIn.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("and", GenericUDFOPAnd.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("or", GenericUDFOPOr.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("=", GenericUDFOPEqual.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("==", GenericUDFOPEqual.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("<=>", GenericUDFOPEqualNS.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("!=", GenericUDFOPNotEqual.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("<>", GenericUDFOPNotEqual.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("<", GenericUDFOPLessThan.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("<=", GenericUDFOPEqualOrLessThan.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF(">", GenericUDFOPGreaterThan.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF(">=", GenericUDFOPEqualOrGreaterThan.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("not", GenericUDFOPNot.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("!", GenericUDFOPNot.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("between", GenericUDFBetween.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("in_bloom_filter", GenericUDFInBloomFilter.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("ewah_bitmap_and", GenericUDFEWAHBitmapAnd.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("ewah_bitmap_or", GenericUDFEWAHBitmapOr.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("ewah_bitmap_empty", GenericUDFEWAHBitmapEmpty.class, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("version", UDFVersion.class, false, new FunctionInfo.FunctionResource[0]);
        system.registerUDF("boolean", UDFToBoolean.class, false, UDFToBoolean.class.getSimpleName(), new FunctionInfo.FunctionResource[0]);
        system.registerUDF("tinyint", UDFToByte.class, false, UDFToByte.class.getSimpleName(), new FunctionInfo.FunctionResource[0]);
        system.registerUDF("smallint", UDFToShort.class, false, UDFToShort.class.getSimpleName(), new FunctionInfo.FunctionResource[0]);
        system.registerUDF("int", UDFToInteger.class, false, UDFToInteger.class.getSimpleName(), new FunctionInfo.FunctionResource[0]);
        system.registerUDF("bigint", UDFToLong.class, false, UDFToLong.class.getSimpleName(), new FunctionInfo.FunctionResource[0]);
        system.registerUDF("float", UDFToFloat.class, false, UDFToFloat.class.getSimpleName(), new FunctionInfo.FunctionResource[0]);
        system.registerUDF("double", UDFToDouble.class, false, UDFToDouble.class.getSimpleName(), new FunctionInfo.FunctionResource[0]);
        system.registerUDF("string", UDFToString.class, false, UDFToString.class.getSimpleName(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("date", GenericUDFToDate.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("timestamp", GenericUDFTimestamp.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("interval_year_month", GenericUDFToIntervalYearMonth.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("interval_day_time", GenericUDFToIntervalDayTime.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("binary", GenericUDFToBinary.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("decimal", GenericUDFToDecimal.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("varchar", GenericUDFToVarchar.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("char", GenericUDFToChar.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("max", new GenericUDAFMax(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("min", new GenericUDAFMin(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("sum", new GenericUDAFSum(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("$SUM0", new GenericUDAFSumEmptyIsZero(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("count", new GenericUDAFCount(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("avg", new GenericUDAFAverage(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("std", new GenericUDAFStd(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("stddev", new GenericUDAFStd(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("stddev_pop", new GenericUDAFStd(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("stddev_samp", new GenericUDAFStdSample(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("variance", new GenericUDAFVariance(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("var_pop", new GenericUDAFVariance(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("var_samp", new GenericUDAFVarianceSample(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("covar_pop", new GenericUDAFCovariance(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("covar_samp", new GenericUDAFCovarianceSample(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("corr", new GenericUDAFCorrelation(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("regr_slope", new GenericUDAFBinarySetFunctions.RegrSlope(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("regr_intercept", new GenericUDAFBinarySetFunctions.RegrIntercept(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("regr_r2", new GenericUDAFBinarySetFunctions.RegrR2(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("regr_sxx", new GenericUDAFBinarySetFunctions.RegrSXX(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("regr_syy", new GenericUDAFBinarySetFunctions.RegrSYY(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("regr_sxy", new GenericUDAFBinarySetFunctions.RegrSXY(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("regr_avgx", new GenericUDAFBinarySetFunctions.RegrAvgX(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("regr_avgy", new GenericUDAFBinarySetFunctions.RegrAvgY(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("regr_count", new GenericUDAFBinarySetFunctions.RegrCount(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("histogram_numeric", new GenericUDAFHistogramNumeric(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("percentile_approx", new GenericUDAFPercentileApprox(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("collect_set", new GenericUDAFCollectSet(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("collect_list", new GenericUDAFCollectList(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("ngrams", new GenericUDAFnGrams(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("context_ngrams", new GenericUDAFContextNGrams(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("ewah_bitmap", new GenericUDAFEWAHBitmap(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("compute_stats", new GenericUDAFComputeStats(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("bloom_filter", new GenericUDAFBloomFilter(), new FunctionInfo.FunctionResource[0]);
        system.registerUDAF("percentile", UDAFPercentile.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("reflect", GenericUDFReflect.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("reflect2", GenericUDFReflect2.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("java_method", GenericUDFReflect.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("array", GenericUDFArray.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("assert_true", GenericUDFAssertTrue.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("map", GenericUDFMap.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("struct", GenericUDFStruct.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("named_struct", GenericUDFNamedStruct.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("create_union", GenericUDFUnion.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("extract_union", GenericUDFExtractUnion.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("case", GenericUDFCase.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("when", GenericUDFWhen.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("nullif", GenericUDFNullif.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("hash", GenericUDFHash.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("coalesce", GenericUDFCoalesce.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("index", GenericUDFIndex.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("in_file", GenericUDFInFile.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("instr", GenericUDFInstr.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("locate", GenericUDFLocate.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("elt", GenericUDFElt.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("concat_ws", GenericUDFConcatWS.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("sort_array", GenericUDFSortArray.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("sort_array_by", GenericUDFSortArrayByField.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("array_contains", GenericUDFArrayContains.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("sentences", GenericUDFSentences.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("map_keys", GenericUDFMapKeys.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("map_values", GenericUDFMapValues.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("format_number", GenericUDFFormatNumber.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("printf", GenericUDFPrintf.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("greatest", GenericUDFGreatest.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("least", GenericUDFLeast.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("cardinality_violation", GenericUDFCardinalityViolation.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("from_utc_timestamp", GenericUDFFromUtcTimestamp.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("to_utc_timestamp", GenericUDFToUtcTimestamp.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("from_utc_timestamp_new", GenericUDFFromUtcTimestampNew.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("to_utc_timestamp_new", GenericUDFToUtcTimestampNew.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("unix_timestamp", GenericUDFUnixTimeStamp.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("to_unix_timestamp", GenericUDFToUnixTimeStamp.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("internal_interval", GenericUDFInternalInterval.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDTF("explode", GenericUDTFExplode.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDTF("replicate_rows", GenericUDTFReplicateRows.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDTF("inline", GenericUDTFInline.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDTF("json_tuple", GenericUDTFJSONTuple.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDTF("parse_url_tuple", GenericUDTFParseUrlTuple.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDTF("posexplode", GenericUDTFPosExplode.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDTF("stack", GenericUDTFStack.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDTF("get_splits", GenericUDTFGetSplits.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF(LEAD_FUNC_NAME, GenericUDFLead.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF(LAG_FUNC_NAME, GenericUDFLag.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("row_number", new GenericUDAFRowNumber(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("rank", new GenericUDAFRank(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("dense_rank", new GenericUDAFDenseRank(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("percent_rank", new GenericUDAFPercentRank(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("cume_dist", new GenericUDAFCumeDist(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("ntile", new GenericUDAFNTile(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF("first_value", new GenericUDAFFirstValue(), new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDAF(LAST_VALUE_FUNC_NAME, new GenericUDAFLastValue(), new FunctionInfo.FunctionResource[0]);
        system.registerWindowFunction(LEAD_FUNC_NAME, new GenericUDAFLead());
        system.registerWindowFunction(LAG_FUNC_NAME, new GenericUDAFLag());
        system.registerTableFunction(NOOP_TABLE_FUNCTION, Noop.NoopResolver.class, new FunctionInfo.FunctionResource[0]);
        system.registerTableFunction(NOOP_MAP_TABLE_FUNCTION, NoopWithMap.NoopWithMapResolver.class, new FunctionInfo.FunctionResource[0]);
        system.registerTableFunction(NOOP_STREAMING_TABLE_FUNCTION, NoopStreaming.NoopStreamingResolver.class, new FunctionInfo.FunctionResource[0]);
        system.registerTableFunction(NOOP_STREAMING_MAP_TABLE_FUNCTION, NoopWithMapStreaming.NoopWithMapStreamingResolver.class, new FunctionInfo.FunctionResource[0]);
        system.registerTableFunction(WINDOWING_TABLE_FUNCTION, WindowingTableFunction.WindowingTableFunctionResolver.class, new FunctionInfo.FunctionResource[0]);
        system.registerTableFunction(MATCH_PATH_TABLE_FUNCTION, MatchPath.MatchPathResolver.class, new FunctionInfo.FunctionResource[0]);
        system.registerHiddenBuiltIn(GenericUDFOPDTIMinus.class);
        system.registerHiddenBuiltIn(GenericUDFOPDTIPlus.class);
        system.registerHiddenBuiltIn(GenericUDFOPNumericMinus.class);
        system.registerHiddenBuiltIn(GenericUDFOPNumericPlus.class);
        system.registerGenericUDF("mask", GenericUDFMask.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("mask_first_n", GenericUDFMaskFirstN.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("mask_last_n", GenericUDFMaskLastN.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("mask_show_first_n", GenericUDFMaskShowFirstN.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("mask_show_last_n", GenericUDFMaskShowLastN.class, new FunctionInfo.FunctionResource[0]);
        system.registerGenericUDF("mask_hash", GenericUDFMaskHash.class, new FunctionInfo.FunctionResource[0]);
    }

    private static interface BiFunction<T, U, R> {
        public R apply(T var1, U var2);
    }
}

