/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.PartitionFiles;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageFactory;
import org.apache.thrift.TException;

public class JSONAddPartitionMessage
extends AddPartitionMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String db;
    @JsonProperty
    String table;
    @JsonProperty
    String tableObjJson;
    @JsonProperty
    Long timestamp;
    @JsonProperty
    List<Map<String, String>> partitions;
    @JsonProperty
    List<String> partitionListJson;
    @JsonProperty
    List<PartitionFiles> partitionFiles;

    public JSONAddPartitionMessage() {
    }

    public JSONAddPartitionMessage(String server, String servicePrincipal, Table tableObj, Iterator<Partition> partitionsIterator, Iterator<PartitionFiles> partitionFileIter, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.db = tableObj.getDbName();
        this.table = tableObj.getTableName();
        this.timestamp = timestamp;
        this.partitions = new ArrayList<Map<String, String>>();
        this.partitionListJson = new ArrayList<String>();
        try {
            this.tableObjJson = JSONMessageFactory.createTableObjJson(tableObj);
            while (partitionsIterator.hasNext()) {
                Partition partitionObj = partitionsIterator.next();
                this.partitions.add(JSONMessageFactory.getPartitionKeyValues(tableObj, partitionObj));
                this.partitionListJson.add(JSONMessageFactory.createPartitionObjJson(partitionObj));
            }
        }
        catch (TException e) {
            throw new IllegalArgumentException("Could not serialize: ", e);
        }
        this.partitionFiles = Lists.newArrayList(partitionFileIter);
        this.checkValid();
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public Table getTableObj() throws Exception {
        return (Table)JSONMessageFactory.getTObj(this.tableObjJson, Table.class);
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public List<Map<String, String>> getPartitions() {
        return this.partitions;
    }

    @Override
    public Iterable<Partition> getPartitionObjs() throws Exception {
        return Iterables.transform(JSONMessageFactory.getTObjs(this.partitionListJson, Partition.class), new Function<Object, Partition>(){

            @Override
            @Nullable
            public Partition apply(@Nullable Object input) {
                return (Partition)input;
            }
        });
    }

    public String getTableObjJson() {
        return this.tableObjJson;
    }

    public List<String> getPartitionListJson() {
        return this.partitionListJson;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString((Object)this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }

    @Override
    public Iterable<PartitionFiles> getPartitionFilesIter() {
        return this.partitionFiles;
    }
}

