/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.sql.Date;
import java.sql.Timestamp;
import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTrunc;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableDateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableTimestampObjectInspector;
import org.apache.hadoop.io.Text;

public class TestGenericUDFTrunc
extends TestCase {
    public void testStringToDateWithMonthFormat() throws HiveException {
        GenericUDFTrunc udf = new GenericUDFTrunc();
        JavaStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        JavaStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] initArgs = new ObjectInspector[]{valueOI0, valueOI1};
        GenericUDF.DeferredJavaObject valueObjFmt = new GenericUDF.DeferredJavaObject((Object)new Text("MONTH"));
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-01"));
        GenericUDF.DeferredObject[] evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-14"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-31"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-02-02"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-02-28"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-03"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-28"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-29"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-01 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-14 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-31 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-02-02 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-02-28 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-03 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-28 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-29 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-02-01", (GenericUDF)udf, initArgs, evalArgs);
    }

    public void testStringToDateWithQuarterFormat() throws HiveException {
        GenericUDFTrunc udf = new GenericUDFTrunc();
        JavaStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        JavaStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] initArgs = new ObjectInspector[]{valueOI0, valueOI1};
        GenericUDF.DeferredJavaObject valueObjFmt = new GenericUDF.DeferredJavaObject((Object)new Text("QUARTER"));
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-01"));
        GenericUDF.DeferredObject[] evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-14"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-31"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-02-02"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-02-28"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-03"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-28"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-29"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-05-11"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-04-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-07-01"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-07-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-12-31"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-10-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-01 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-14 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-31 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-02-02 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-02-28 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-03 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-28 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-29 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-05-11 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-04-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-07-01 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-07-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-12-31 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-10-01", (GenericUDF)udf, initArgs, evalArgs);
    }

    public void testStringToDateWithYearFormat() throws HiveException {
        GenericUDFTrunc udf = new GenericUDFTrunc();
        JavaStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        JavaStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] initArgs = new ObjectInspector[]{valueOI0, valueOI1};
        GenericUDF.DeferredJavaObject valueObjFmt = new GenericUDF.DeferredJavaObject((Object)new Text("YEAR"));
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-01"));
        GenericUDF.DeferredObject[] evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-14"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-31"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-02-02"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-02-28"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-03"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-28"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-29"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-01 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-14 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-01-31 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-02-02 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2014-02-28 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-03 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-28 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new Text("2016-02-29 10:30:45"));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
    }

    public void testTimestampToDateWithMonthFormat() throws HiveException {
        GenericUDFTrunc udf = new GenericUDFTrunc();
        WritableTimestampObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        JavaStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] initArgs = new ObjectInspector[]{valueOI0, valueOI1};
        GenericUDF.DeferredJavaObject valueObjFmt = new GenericUDF.DeferredJavaObject((Object)new Text("MON"));
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-01 00:00:00")));
        GenericUDF.DeferredObject[] evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-14 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-31 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-02-02 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-02-28 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-03 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-28 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-29 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-01 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-14 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-31 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-02-02 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-02-28 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-03 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-28 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-29 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-02-01", (GenericUDF)udf, initArgs, evalArgs);
    }

    public void testTimestampToDateWithQuarterFormat() throws HiveException {
        GenericUDFTrunc udf = new GenericUDFTrunc();
        WritableTimestampObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        JavaStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] initArgs = new ObjectInspector[]{valueOI0, valueOI1};
        GenericUDF.DeferredJavaObject valueObjFmt = new GenericUDF.DeferredJavaObject((Object)new Text("Q"));
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-01 00:00:00")));
        GenericUDF.DeferredObject[] evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-14 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-31 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-02-02 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-02-28 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-03 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-28 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-29 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-05-11 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-04-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-07-01 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-07-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-12-31 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-10-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-01 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-14 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-31 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-02-02 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-02-28 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-03 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-28 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-29 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-05-11 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-04-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-07-01 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-07-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-12-31 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-10-01", (GenericUDF)udf, initArgs, evalArgs);
    }

    public void testTimestampToDateWithYearFormat() throws HiveException {
        GenericUDFTrunc udf = new GenericUDFTrunc();
        WritableTimestampObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        JavaStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] initArgs = new ObjectInspector[]{valueOI0, valueOI1};
        GenericUDF.DeferredJavaObject valueObjFmt = new GenericUDF.DeferredJavaObject((Object)new Text("YYYY"));
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-01 00:00:00")));
        GenericUDF.DeferredObject[] evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-14 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-31 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-02-02 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-02-28 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-03 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-28 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-29 00:00:00")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-01 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-14 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-01-31 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-02-02 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2014-02-28 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-03 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-28 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new TimestampWritable(Timestamp.valueOf("2016-02-29 10:30:45")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
    }

    public void testDateWritableToDateWithMonthFormat() throws HiveException {
        GenericUDFTrunc udf = new GenericUDFTrunc();
        WritableDateObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        JavaStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] initArgs = new ObjectInspector[]{valueOI0, valueOI1};
        GenericUDF.DeferredJavaObject valueObjFmt = new GenericUDF.DeferredJavaObject((Object)new Text("MM"));
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2014-01-01")));
        GenericUDF.DeferredObject[] evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2014-01-14")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2014-01-31")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2014-02-02")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2014-02-28")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2016-02-03")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2016-02-28")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-02-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2016-02-29")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-02-01", (GenericUDF)udf, initArgs, evalArgs);
    }

    public void testDateWritableToDateWithQuarterFormat() throws HiveException {
        GenericUDFTrunc udf = new GenericUDFTrunc();
        WritableDateObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        JavaStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] initArgs = new ObjectInspector[]{valueOI0, valueOI1};
        GenericUDF.DeferredJavaObject valueObjFmt = new GenericUDF.DeferredJavaObject((Object)new Text("Q"));
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2014-01-01")));
        GenericUDF.DeferredObject[] evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2014-01-14")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2014-01-31")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2014-02-02")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2014-02-28")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2016-02-03")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2016-02-28")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2016-02-29")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2016-05-11")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-04-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2016-07-01")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-07-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2016-12-31")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-10-01", (GenericUDF)udf, initArgs, evalArgs);
    }

    public void testDateWritableToDateWithYearFormat() throws HiveException {
        GenericUDFTrunc udf = new GenericUDFTrunc();
        WritableDateObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        JavaStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.javaStringObjectInspector;
        ObjectInspector[] initArgs = new ObjectInspector[]{valueOI0, valueOI1};
        GenericUDF.DeferredJavaObject valueObjFmt = new GenericUDF.DeferredJavaObject((Object)new Text("YY"));
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2014-01-01")));
        GenericUDF.DeferredObject[] evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2014-01-14")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2014-01-31")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2014-02-02")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2014-02-28")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2014-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2016-02-03")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2016-02-28")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
        valueObj0 = new GenericUDF.DeferredJavaObject((Object)new DateWritable(Date.valueOf("2016-02-29")));
        evalArgs = new GenericUDF.DeferredObject[]{valueObj0, valueObjFmt};
        this.runAndVerify("2016-01-01", (GenericUDF)udf, initArgs, evalArgs);
    }

    private void runAndVerify(String expResult, GenericUDF udf, ObjectInspector[] initArgs, GenericUDF.DeferredObject[] evalArgs) throws HiveException {
        udf.initialize(initArgs);
        Text output = (Text)udf.evaluate(evalArgs);
        TestGenericUDFTrunc.assertEquals((String)"frist_day() test ", (String)expResult, (String)output.toString());
    }
}

