/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFReplace;
import org.apache.hadoop.io.Text;

public class TestGenericUDFReplace
extends TestCase {
    public void testReplace() throws HiveException {
        UDFReplace udf = new UDFReplace();
        this.verify(udf, null, new Text(), new Text(), null);
        this.verify(udf, new Text(), null, new Text(), null);
        this.verify(udf, new Text(), new Text(), null, null);
        this.verify(udf, new Text(), new Text(), new Text(), "");
        this.verify(udf, new Text("ABCDEF"), new Text("X"), new Text("Z"), "ABCDEF");
        this.verify(udf, new Text("Hack and Hue"), new Text("H"), new Text("BL"), "BLack and BLue");
        this.verify(udf, new Text("ABABrdvABrk"), new Text("AB"), new Text("a"), "aardvark");
    }

    private void verify(UDFReplace udf, Text str, Text search, Text replacement, String expResult) throws HiveException {
        Text output = udf.evaluate(str, search, replacement);
        if (expResult == null) {
            TestGenericUDFReplace.assertNull((Object)output);
        } else {
            TestGenericUDFReplace.assertNotNull((Object)output);
            TestGenericUDFReplace.assertEquals((String)"replace() test ", (String)expResult, (String)output.toString());
        }
    }
}

