/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import junit.framework.TestCase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRegExp;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableStringObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.Text;

public class TestGenericUDFRegexp
extends TestCase {
    public void testConstant() throws HiveException {
        GenericUDFRegExp udf = new GenericUDFRegExp();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        Text regexText = new Text("^fo");
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)regexText);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyConst("fofo", regexText, true, (GenericUDF)udf);
        this.runAndVerifyConst("fofofo", regexText, true, (GenericUDF)udf);
        this.runAndVerifyConst("fobar", regexText, true, (GenericUDF)udf);
        this.runAndVerifyConst("barfobar", regexText, false, (GenericUDF)udf);
        this.runAndVerifyConst(null, regexText, null, (GenericUDF)udf);
    }

    public void testEmptyConstant() throws HiveException {
        GenericUDFRegExp udf = new GenericUDFRegExp();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        Text regexText = new Text("");
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, (Object)regexText);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyConst("foo", regexText, false, (GenericUDF)udf);
        this.runAndVerifyConst("bar", regexText, false, (GenericUDF)udf);
        this.runAndVerifyConst(null, regexText, null, (GenericUDF)udf);
    }

    public void testNullConstant() throws HiveException {
        GenericUDFRegExp udf = new GenericUDFRegExp();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        Text regexText = null;
        ConstantObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.stringTypeInfo, regexText);
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerifyConst("fofo", regexText, null, (GenericUDF)udf);
        this.runAndVerifyConst("fofofo", regexText, null, (GenericUDF)udf);
        this.runAndVerifyConst("fobar", regexText, null, (GenericUDF)udf);
        this.runAndVerifyConst(null, regexText, null, (GenericUDF)udf);
    }

    public void testNonConstant() throws HiveException {
        GenericUDFRegExp udf = new GenericUDFRegExp();
        WritableStringObjectInspector valueOI0 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        WritableStringObjectInspector valueOI1 = PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        ObjectInspector[] arguments = new ObjectInspector[]{valueOI0, valueOI1};
        udf.initialize(arguments);
        this.runAndVerify("fofo", "^fo", true, (GenericUDF)udf);
        this.runAndVerify("fo\no", "^fo\no$", true, (GenericUDF)udf);
        this.runAndVerify("Bn", "^Ba*n", true, (GenericUDF)udf);
        this.runAndVerify("afofo", "fo", true, (GenericUDF)udf);
        this.runAndVerify("afofo", "^fo", false, (GenericUDF)udf);
        this.runAndVerify("Baan", "^Ba?n", false, (GenericUDF)udf);
        this.runAndVerify("axe", "pi|apa", false, (GenericUDF)udf);
        this.runAndVerify("pip", "^(pi)*$", false, (GenericUDF)udf);
        this.runAndVerify("bar", "", false, (GenericUDF)udf);
        this.runAndVerify("foo", "", false, (GenericUDF)udf);
        this.runAndVerify(null, "^fo", null, (GenericUDF)udf);
        this.runAndVerify("fofo", null, null, (GenericUDF)udf);
    }

    private void runAndVerifyConst(String str, Text regexText, Boolean expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str != null ? new Text(str) : null));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)regexText);
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        BooleanWritable output = (BooleanWritable)udf.evaluate(args);
        if (expResult == null) {
            TestGenericUDFRegexp.assertNull((Object)output);
        } else {
            TestGenericUDFRegexp.assertNotNull((Object)output);
            TestGenericUDFRegexp.assertEquals((String)"regexp() const test ", (boolean)expResult, (boolean)output.get());
        }
    }

    private void runAndVerify(String str, String regex, Boolean expResult, GenericUDF udf) throws HiveException {
        GenericUDF.DeferredJavaObject valueObj0 = new GenericUDF.DeferredJavaObject((Object)(str != null ? new Text(str) : null));
        GenericUDF.DeferredJavaObject valueObj1 = new GenericUDF.DeferredJavaObject((Object)(regex != null ? new Text(regex) : null));
        GenericUDF.DeferredObject[] args = new GenericUDF.DeferredObject[]{valueObj0, valueObj1};
        BooleanWritable output = (BooleanWritable)udf.evaluate(args);
        if (expResult == null) {
            TestGenericUDFRegexp.assertNull((Object)output);
        } else {
            TestGenericUDFRegexp.assertNotNull((Object)output);
            TestGenericUDFRegexp.assertEquals((String)"regexp() test ", (boolean)expResult, (boolean)output.get());
        }
    }
}

