/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import com.google.common.collect.ImmutableList;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFExtractUnion;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableConstantIntObjectInspector;
import org.apache.hadoop.io.IntWritable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestGenericUDFExtractUnion {
    @Mock
    private GenericUDFExtractUnion.ObjectInspectorConverter objectInspectorConverter;
    @Mock
    private GenericUDFExtractUnion.ValueConverter valueConverter;
    @Mock
    private UnionObjectInspector unionOI;
    @Mock
    private WritableConstantIntObjectInspector tagOI;
    @Mock
    private ObjectInspector initialiseResult;
    @Mock
    private GenericUDF.DeferredObject deferredObject;
    private final Object value = new Object();
    private final Object converted = new Object();
    private GenericUDF underTest;

    @Before
    public void before() {
        this.underTest = new GenericUDFExtractUnion(this.objectInspectorConverter, this.valueConverter);
    }

    @Test
    public void evaluate_SingleArgumentOnly() throws HiveException {
        Mockito.when((Object)this.deferredObject.get()).thenReturn(this.value);
        Mockito.when((Object)this.valueConverter.convert(this.value, (ObjectInspector)this.unionOI)).thenReturn(this.converted);
        this.underTest.initialize(new ObjectInspector[]{this.unionOI});
        Object result = this.underTest.evaluate(new GenericUDF.DeferredObject[]{this.deferredObject});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.converted));
    }

    @Test
    public void evaluate_UnionAndTagArguments_MatchesTag() throws HiveException {
        Mockito.when((Object)this.unionOI.getObjectInspectors()).thenReturn((Object)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.writableStringObjectInspector, (Object)PrimitiveObjectInspectorFactory.writableLongObjectInspector));
        Mockito.when((Object)this.tagOI.getWritableConstantValue()).thenReturn((Object)new IntWritable(0));
        Mockito.when((Object)this.deferredObject.get()).thenReturn(this.value);
        Mockito.when((Object)this.unionOI.getTag(this.value)).thenReturn((Object)0);
        Mockito.when((Object)this.unionOI.getField(this.value)).thenReturn((Object)"foo");
        this.underTest.initialize(new ObjectInspector[]{this.unionOI, this.tagOI});
        Object result = this.underTest.evaluate(new GenericUDF.DeferredObject[]{this.deferredObject});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)"foo"));
    }

    @Test
    public void evaluate_UnionAndTagArguments_NotMatchesTag() throws HiveException {
        Mockito.when((Object)this.unionOI.getObjectInspectors()).thenReturn((Object)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.writableStringObjectInspector, (Object)PrimitiveObjectInspectorFactory.writableLongObjectInspector));
        Mockito.when((Object)this.tagOI.getWritableConstantValue()).thenReturn((Object)new IntWritable(0));
        Mockito.when((Object)this.deferredObject.get()).thenReturn(this.value);
        Mockito.when((Object)this.unionOI.getTag(this.value)).thenReturn((Object)1);
        this.underTest.initialize(new ObjectInspector[]{this.unionOI, this.tagOI});
        Object result = this.underTest.evaluate(new GenericUDF.DeferredObject[]{this.deferredObject});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void initialize_SingleArgumentOnly() throws UDFArgumentException {
        Mockito.when((Object)this.objectInspectorConverter.convert((ObjectInspector)this.unionOI)).thenReturn((Object)this.initialiseResult);
        ObjectInspector result = this.underTest.initialize(new ObjectInspector[]{this.unionOI});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)this.initialiseResult));
    }

    @Test
    public void initialize_UnionAndTagArguments() throws UDFArgumentException {
        Mockito.when((Object)this.unionOI.getObjectInspectors()).thenReturn((Object)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.writableStringObjectInspector, (Object)PrimitiveObjectInspectorFactory.writableLongObjectInspector));
        Mockito.when((Object)this.tagOI.getWritableConstantValue()).thenReturn((Object)new IntWritable(0));
        ObjectInspector result = this.underTest.initialize(new ObjectInspector[]{this.unionOI, this.tagOI});
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Object)PrimitiveObjectInspectorFactory.writableStringObjectInspector));
    }

    @Test(expected=UDFArgumentException.class)
    public void initialize_NegativeTagThrowsException() throws UDFArgumentException {
        Mockito.when((Object)this.tagOI.getWritableConstantValue()).thenReturn((Object)new IntWritable(-1));
        this.underTest.initialize(new ObjectInspector[]{this.unionOI, this.tagOI});
    }

    @Test(expected=UDFArgumentException.class)
    public void initialize_OutOfBoundsTagThrowsException() throws UDFArgumentException {
        Mockito.when((Object)this.unionOI.getObjectInspectors()).thenReturn((Object)ImmutableList.of((Object)PrimitiveObjectInspectorFactory.writableStringObjectInspector, (Object)PrimitiveObjectInspectorFactory.writableLongObjectInspector));
        Mockito.when((Object)this.tagOI.getWritableConstantValue()).thenReturn((Object)new IntWritable(2));
        this.underTest.initialize(new ObjectInspector[]{this.unionOI, this.tagOI});
    }

    @Test(expected=UDFArgumentException.class)
    public void initialize_TagNotAnIntThrowsException() throws UDFArgumentException {
        this.underTest.initialize(new ObjectInspector[]{this.unionOI, PrimitiveObjectInspectorFactory.writableIntObjectInspector});
    }

    @Test(expected=UDFArgumentException.class)
    public void initialize_UnionNotAUnionThrowsException() throws UDFArgumentException {
        this.underTest.initialize(new ObjectInspector[]{PrimitiveObjectInspectorFactory.writableIntObjectInspector, this.tagOI});
    }

    @Test(expected=UDFArgumentException.class)
    public void initialize_NoArgumentsThrowsException() throws UDFArgumentException {
        this.underTest.initialize(new ObjectInspector[0]);
    }

    @Test(expected=UDFArgumentException.class)
    public void initialize_TooManyArgumentsThrowsException() throws UDFArgumentException {
        this.underTest.initialize(new ObjectInspector[]{this.unionOI, this.tagOI, PrimitiveObjectInspectorFactory.writableIntObjectInspector});
    }
}

