/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd;

import com.google.common.base.Joiner;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.security.HadoopDefaultAuthenticator;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.DisallowTransformHook;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAccessController;
import org.junit.Assert;
import org.junit.Test;

public class TestSQLStdHiveAccessControllerHS2 {
    @Test
    public void testConfigProcessing() throws HiveAuthzPluginException, SecurityException, IllegalArgumentException, NoSuchFieldException, IllegalAccessException {
        HiveConf processedConf = this.newAuthEnabledConf();
        SQLStdHiveAccessController accessController = new SQLStdHiveAccessController(null, processedConf, (HiveAuthenticationProvider)new HadoopDefaultAuthenticator(), this.getHS2SessionCtx());
        accessController.applyAuthorizationConfigPolicy(processedConf);
        Assert.assertTrue((String)"Check for transform query disabling hook", (boolean)processedConf.getVar(HiveConf.ConfVars.PREEXECHOOKS).contains(DisallowTransformHook.class.getName()));
        List<String> settableParams = this.getSettableParams();
        this.verifyParamSettability(settableParams, processedConf);
    }

    private HiveConf newAuthEnabledConf() {
        HiveConf conf = new HiveConf();
        conf.set("fs.default.name", "file:///");
        conf.setBoolVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED, true);
        return conf;
    }

    private List<String> getSettableParams() throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field varNameField = HiveConf.class.getDeclaredField("sqlStdAuthSafeVarNames");
        varNameField.setAccessible(true);
        List<String> confVarList = Arrays.asList((String[])varNameField.get(null));
        List<String> confVarRegexList = Arrays.asList("hive.convert.join.bucket.mapjoin.tez", "hive.optimize.index.filter.compact.maxsize", "hive.tez.dummy", "tez.task.dummy", "hive.exec.dynamic.partition", "hive.exec.dynamic.partition.mode", "hive.exec.max.dynamic.partitions", "hive.exec.max.dynamic.partitions.pernode", "oozie.HadoopAccessorService.created", "tez.queue.name");
        ArrayList<String> varList = new ArrayList<String>();
        varList.addAll(confVarList);
        varList.addAll(confVarRegexList);
        return varList;
    }

    private HiveAuthzSessionContext getHS2SessionCtx() {
        HiveAuthzSessionContext.Builder ctxBuilder = new HiveAuthzSessionContext.Builder();
        ctxBuilder.setClientType(HiveAuthzSessionContext.CLIENT_TYPE.HIVESERVER2);
        return ctxBuilder.build();
    }

    private void verifyParamSettability(List<String> settableParams, HiveConf processedConf) {
        for (String param : settableParams) {
            try {
                processedConf.verifyAndSet(param, "dummy");
            }
            catch (IllegalArgumentException e) {
                Assert.fail((String)("Unable to set value for parameter in whitelist " + param + " " + e));
            }
        }
        this.assertConfModificationException(processedConf, "dummy.param");
        for (HiveConf.ConfVars metaVar : HiveConf.metaVars) {
            this.assertConfModificationException(processedConf, metaVar.varname);
        }
    }

    @Test
    public void testConfigProcessingCustomSetWhitelistAppend() throws HiveAuthzPluginException {
        List<String> paramRegexes = Arrays.asList("hive.ctest.param", "hive.abc..*");
        List<String> settableParams = Arrays.asList("hive.ctest.param", "hive.abc.def");
        this.verifySettability(paramRegexes, settableParams, HiveConf.ConfVars.HIVE_AUTHORIZATION_SQL_STD_AUTH_CONFIG_WHITELIST_APPEND);
    }

    @Test
    public void testConfigProcessingCustomSetWhitelist() throws HiveAuthzPluginException {
        List<String> paramRegexes = Arrays.asList("hive.ctest.param", "hive.abc..*");
        List<String> settableParams = Arrays.asList("hive.ctest.param", "hive.abc.def");
        this.verifySettability(paramRegexes, settableParams, HiveConf.ConfVars.HIVE_AUTHORIZATION_SQL_STD_AUTH_CONFIG_WHITELIST);
    }

    private void verifySettability(List<String> paramRegexes, List<String> settableParams, HiveConf.ConfVars whiteListParam) throws HiveAuthzPluginException {
        HiveConf processedConf = this.newAuthEnabledConf();
        processedConf.setVar(whiteListParam, Joiner.on((String)"|").join(paramRegexes));
        SQLStdHiveAccessController accessController = new SQLStdHiveAccessController(null, processedConf, (HiveAuthenticationProvider)new HadoopDefaultAuthenticator(), this.getHS2SessionCtx());
        accessController.applyAuthorizationConfigPolicy(processedConf);
        this.verifyParamSettability(settableParams, processedConf);
    }

    private void assertConfModificationException(HiveConf processedConf, String param) {
        boolean caughtEx = false;
        try {
            processedConf.verifyAndSet(param, "dummy");
        }
        catch (IllegalArgumentException e) {
            caughtEx = true;
        }
        Assert.assertTrue((String)("Exception should be thrown while modifying the param " + param), (boolean)caughtEx);
    }
}

