/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUpdateDeleteSemanticAnalyzer {
    private static final Logger LOG = LoggerFactory.getLogger((String)TestUpdateDeleteSemanticAnalyzer.class.getName());
    private QueryState queryState;
    private HiveConf conf;
    private Hive db;

    @Test
    public void testInsertSelect() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("insert into table T select a, b from U", "testInsertSelect");
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testDeleteAllNonPartitioned() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("delete from T", "testDeleteAllNonPartitioned");
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testDeleteWhereNoPartition() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("delete from T where a > 5", "testDeleteWhereNoPartition");
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testDeleteAllPartitioned() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("delete from U", "testDeleteAllPartitioned");
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testDeleteAllWherePartitioned() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("delete from U where a > 5", "testDeleteAllWherePartitioned");
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testDeleteOnePartition() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("delete from U where ds = 'today'", "testDeleteFromPartitionOnly");
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testDeleteOnePartitionWhere() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("delete from U where ds = 'today' and a > 5", "testDeletePartitionWhere");
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testUpdateAllNonPartitioned() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("update T set b = 5", "testUpdateAllNonPartitioned");
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testUpdateAllNonPartitionedWhere() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("update T set b = 5 where b > 5", "testUpdateAllNonPartitionedWhere");
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testUpdateAllPartitioned() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("update U set b = 5", "testUpdateAllPartitioned");
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testUpdateAllPartitionedWhere() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("update U set b = 5 where b > 5", "testUpdateAllPartitionedWhere");
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testUpdateOnePartition() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("update U set b = 5 where ds = 'today'", "testUpdateOnePartition");
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testUpdateOnePartitionWhere() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("update U set b = 5 where ds = 'today' and b > 5", "testUpdateOnePartitionWhere");
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testInsertValues() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("insert into table T values ('abc', 3), ('ghi', null)", "testInsertValues");
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Test
    public void testInsertValuesPartitioned() throws Exception {
        try {
            ReturnInfo rc = this.parseAndAnalyze("insert into table U partition (ds) values ('abc', 3, 'today'), ('ghi', 5, 'tomorrow')", "testInsertValuesPartitioned");
            LOG.info(this.explain((SemanticAnalyzer)rc.sem, rc.plan));
        }
        finally {
            this.cleanupTables();
        }
    }

    @Before
    public void setup() {
        this.queryState = new QueryState(null);
        this.conf = this.queryState.getConf();
        this.conf.set("fs.default.name", "file:///");
        this.conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        this.conf.setVar(HiveConf.ConfVars.DYNAMICPARTITIONINGMODE, "nonstrict");
        this.conf.setVar(HiveConf.ConfVars.HIVEMAPREDMODE, "nonstrict");
        this.conf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, "org.apache.hadoop.hive.ql.lockmgr.DbTxnManager");
    }

    public void cleanupTables() throws HiveException {
        if (this.db != null) {
            this.db.dropTable("T");
            this.db.dropTable("U");
        }
    }

    private ReturnInfo parseAndAnalyze(String query, String testName) throws IOException, ParseException, HiveException {
        SessionState.start((HiveConf)this.conf);
        Context ctx = new Context((Configuration)this.conf);
        ctx.setCmd(query);
        ctx.setHDFSCleanup(true);
        ASTNode tree = ParseUtils.parse((String)query, (Context)ctx, (HiveConf)this.conf);
        SessionState.get().initTxnMgr(this.conf);
        this.db = Hive.get((HiveConf)this.conf);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("transactional", "true");
        this.cleanupTables();
        this.db.createTable("T", Arrays.asList("a", "b"), null, OrcInputFormat.class, OrcOutputFormat.class, 2, Arrays.asList("a"), params);
        this.db.createTable("U", Arrays.asList("a", "b"), Arrays.asList("ds"), OrcInputFormat.class, OrcOutputFormat.class, 2, Arrays.asList("a"), params);
        Table u = this.db.getTable("U");
        HashMap<String, String> partVals = new HashMap<String, String>(2);
        partVals.put("ds", "yesterday");
        this.db.createPartition(u, partVals);
        partVals.clear();
        partVals.put("ds", "today");
        this.db.createPartition(u, partVals);
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get((QueryState)this.queryState, (ASTNode)tree);
        sem.analyze(tree, ctx);
        sem.validate();
        QueryPlan plan = new QueryPlan(query, sem, Long.valueOf(0L), testName, null, null);
        return new ReturnInfo(sem, plan);
    }

    private String explain(SemanticAnalyzer sem, QueryPlan plan) throws IOException {
        int bytesRead;
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        File f = File.createTempFile("TestSemanticAnalyzer", "explain");
        Path tmp = new Path(f.getPath());
        fs.create(tmp);
        fs.deleteOnExit(tmp);
        ExplainConfiguration config = new ExplainConfiguration();
        config.setExtended(true);
        ExplainWork work = new ExplainWork(tmp, sem.getParseContext(), sem.getRootTasks(), (Task)sem.getFetchTask(), null, (BaseSemanticAnalyzer)sem, config, null);
        ExplainTask task = new ExplainTask();
        task.setWork((Serializable)work);
        task.initialize(this.queryState, plan, null, null);
        task.execute(null);
        FSDataInputStream in = fs.open(tmp);
        StringBuilder builder = new StringBuilder();
        int bufSz = 4096;
        byte[] buf = new byte[4096];
        long pos = 0L;
        while ((bytesRead = in.read(pos, buf, 0, 4096)) > 0) {
            pos += (long)bytesRead;
            builder.append(new String(buf, 0, bytesRead));
        }
        in.close();
        return builder.toString().replaceAll("pfile:/.*\n", "pfile:MASKED-OUT\n").replaceAll("location file:/.*\n", "location file:MASKED-OUT\n").replaceAll("file:/.*\n", "file:MASKED-OUT\n").replaceAll("transient_lastDdlTime.*\n", "transient_lastDdlTime MASKED-OUT\n");
    }

    private class ReturnInfo {
        BaseSemanticAnalyzer sem;
        QueryPlan plan;

        ReturnInfo(BaseSemanticAnalyzer s, QueryPlan p) {
            this.sem = s;
            this.plan = p;
        }
    }
}

