/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.metadata.CheckResult;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreChecker;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.thrift.TException;

public class TestHiveMetaStoreChecker
extends TestCase {
    private Hive hive;
    private FileSystem fs;
    private HiveMetaStoreChecker checker = null;
    private final String dbName = "testhivemetastorechecker_db";
    private final String tableName = "testhivemetastorechecker_table";
    private final String partDateName = "partdate";
    private final String partCityName = "partcity";
    private List<FieldSchema> partCols;
    private List<Map<String, String>> parts;

    protected void setUp() throws Exception {
        super.setUp();
        this.hive = Hive.get();
        this.hive.getConf().setIntVar(HiveConf.ConfVars.METASTORE_FS_HANDLER_THREADS_COUNT, 15);
        this.hive.getConf().set(HiveConf.ConfVars.HIVE_MSCK_PATH_VALIDATION.varname, "throw");
        this.checker = new HiveMetaStoreChecker(this.hive);
        this.partCols = new ArrayList<FieldSchema>();
        this.partCols.add(new FieldSchema("partdate", "string", ""));
        this.partCols.add(new FieldSchema("partcity", "string", ""));
        this.parts = new ArrayList<Map<String, String>>();
        HashMap<String, String> part1 = new HashMap<String, String>();
        part1.put("partdate", "2008-01-01");
        part1.put("partcity", "london");
        this.parts.add(part1);
        HashMap<String, String> part2 = new HashMap<String, String>();
        part2.put("partdate", "2008-01-02");
        part2.put("partcity", "stockholm");
        this.parts.add(part2);
        this.dropDbTable();
    }

    private void dropDbTable() {
        try {
            this.hive.dropTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", true, true);
            this.hive.dropDatabase("testhivemetastorechecker_db", true, true, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
        }
        catch (HiveException hiveException) {
            // empty catch block
        }
    }

    protected void tearDown() throws Exception {
        this.dropDbTable();
        super.tearDown();
        Hive.closeCurrent();
    }

    public void testTableCheck() throws HiveException, MetaException, IOException, TException, AlreadyExistsException {
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", null, null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals((int)1, (int)result.getTablesNotInMs().size());
        TestHiveMetaStoreChecker.assertEquals((String)"testhivemetastorechecker_table", (String)((String)result.getTablesNotInMs().iterator().next()));
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        Database db = new Database();
        db.setName("testhivemetastorechecker_db");
        this.hive.createDatabase(db);
        Table table = new Table("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setDbName("testhivemetastorechecker_db");
        table.setInputFormatClass(TextInputFormat.class);
        table.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        this.hive.createTable(table);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", null, null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        this.fs = table.getPath().getFileSystem((Configuration)this.hive.getConf());
        this.fs.delete(table.getPath(), true);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals((int)1, (int)result.getTablesNotOnFs().size());
        TestHiveMetaStoreChecker.assertEquals((String)"testhivemetastorechecker_table", (String)((String)result.getTablesNotOnFs().iterator().next()));
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        this.fs.mkdirs(table.getPath());
        Path fakeTable = table.getPath().getParent().suffix("/faketable");
        this.fs.mkdirs(fakeTable);
        this.fs.deleteOnExit(fakeTable);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", null, null, result);
        TestHiveMetaStoreChecker.assertEquals((int)1, (int)result.getTablesNotInMs().size());
        TestHiveMetaStoreChecker.assertEquals((String)fakeTable.getName(), (String)((String)Lists.newArrayList((Iterable)result.getTablesNotInMs()).get(0)));
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        this.hive.dropTable("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setProperty("EXTERNAL", "TRUE");
        this.hive.createTable(table);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", null, null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
    }

    public void testPartitionsCheck() throws HiveException, MetaException, IOException, TException, AlreadyExistsException {
        Database db = new Database();
        db.setName("testhivemetastorechecker_db");
        this.hive.createDatabase(db);
        Table table = new Table("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setDbName("testhivemetastorechecker_db");
        table.setInputFormatClass(TextInputFormat.class);
        table.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        table.setPartCols(this.partCols);
        this.hive.createTable(table);
        table = this.hive.getTable("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        for (Map<String, String> partSpec : this.parts) {
            this.hive.createPartition(table, partSpec);
        }
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        List partitions = this.hive.getPartitions(table);
        TestHiveMetaStoreChecker.assertEquals((int)2, (int)partitions.size());
        this.fs = ((Partition)partitions.get(0)).getDataLocation().getFileSystem((Configuration)this.hive.getConf());
        Path fakePart = new Path(table.getDataLocation().toString(), "fakedate=2009-01-01/fakecity=sanjose");
        this.fs.mkdirs(fakePart);
        this.fs.deleteOnExit(fakePart);
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals((int)0, (int)result.getPartitionsNotOnFs().size());
        TestHiveMetaStoreChecker.assertEquals((int)0, (int)result.getPartitionsNotInMs().size());
        TestHiveMetaStoreChecker.assertEquals((int)2, (int)partitions.size());
        Partition partToRemove = (Partition)partitions.get(0);
        Path partToRemovePath = partToRemove.getDataLocation().getParent();
        this.fs = partToRemovePath.getFileSystem((Configuration)this.hive.getConf());
        this.fs.delete(partToRemovePath, true);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals((int)1, (int)result.getPartitionsNotOnFs().size());
        TestHiveMetaStoreChecker.assertEquals((String)partToRemove.getName(), (String)((CheckResult.PartitionResult)result.getPartitionsNotOnFs().iterator().next()).getPartitionName());
        TestHiveMetaStoreChecker.assertEquals((String)partToRemove.getTable().getTableName(), (String)((CheckResult.PartitionResult)result.getPartitionsNotOnFs().iterator().next()).getTableName());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        ArrayList<LinkedHashMap> partsCopy = new ArrayList<LinkedHashMap>();
        partsCopy.add(((Partition)partitions.get(1)).getSpec());
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", partsCopy, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        this.hive.dropTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", true, true);
        this.hive.createTable(table);
        result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", null, null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotInMs());
        System.err.println("Test completed - partition check");
    }

    public void testDataDeletion() throws HiveException, MetaException, IOException, TException, AlreadyExistsException, NoSuchObjectException {
        Database db = new Database();
        db.setName("testhivemetastorechecker_db");
        this.hive.createDatabase(db);
        Table table = new Table("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        table.setDbName("testhivemetastorechecker_db");
        table.setInputFormatClass(TextInputFormat.class);
        table.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        table.setPartCols(this.partCols);
        this.hive.createTable(table);
        table = this.hive.getTable("testhivemetastorechecker_db", "testhivemetastorechecker_table");
        Path fakeTable = table.getPath().getParent().suffix("/faketable");
        this.fs = fakeTable.getFileSystem((Configuration)this.hive.getConf());
        this.fs.mkdirs(fakeTable);
        this.fs.deleteOnExit(fakeTable);
        Path fakePart = new Path(table.getDataLocation().toString(), "fakepartition=fakevalue");
        this.fs.mkdirs(fakePart);
        this.fs.deleteOnExit(fakePart);
        this.hive.dropTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", true, true);
        TestHiveMetaStoreChecker.assertFalse((boolean)this.fs.exists(fakePart));
        this.hive.dropDatabase("testhivemetastorechecker_db");
        TestHiveMetaStoreChecker.assertFalse((boolean)this.fs.exists(fakeTable));
    }

    public void testPartitionsNotInMs() throws HiveException, AlreadyExistsException, IOException {
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals((int)10, (int)result.getPartitionsNotInMs().size());
    }

    public void testSingleThreadedCheckMetastore() throws HiveException, AlreadyExistsException, IOException {
        this.hive.getConf().setIntVar(HiveConf.ConfVars.METASTORE_FS_HANDLER_THREADS_COUNT, 0);
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals((int)10, (int)result.getPartitionsNotInMs().size());
    }

    public void testSingleThreadedDeeplyNestedTables() throws HiveException, AlreadyExistsException, IOException {
        this.hive.getConf().setIntVar(HiveConf.ConfVars.METASTORE_FS_HANDLER_THREADS_COUNT, 0);
        int poolSize = 2;
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", poolSize + 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals((int)10, (int)result.getPartitionsNotInMs().size());
    }

    public void testDeeplyNestedPartitionedTables() throws HiveException, AlreadyExistsException, IOException {
        this.hive.getConf().setIntVar(HiveConf.ConfVars.METASTORE_FS_HANDLER_THREADS_COUNT, 2);
        int poolSize = 2;
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", poolSize + 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        CheckResult result = new CheckResult();
        this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotInMs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getTablesNotOnFs());
        TestHiveMetaStoreChecker.assertEquals(Collections.emptySet(), (Object)result.getPartitionsNotOnFs());
        TestHiveMetaStoreChecker.assertEquals((int)10, (int)result.getPartitionsNotInMs().size());
    }

    public void testErrorForMissingPartitionColumn() throws AlreadyExistsException, IOException, HiveException {
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        StringBuilder sb = new StringBuilder(testTable.getDataLocation().toString());
        sb.append("/");
        sb.append("dummyPart=error");
        this.createDirectory(sb.toString());
        CheckResult result = new CheckResult();
        Exception exception = null;
        try {
            this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        }
        catch (Exception e) {
            exception = e;
        }
        TestHiveMetaStoreChecker.assertTrue((String)"Expected HiveException", (exception != null && exception instanceof HiveException ? 1 : 0) != 0);
        this.createFile(sb.toString(), "dummyFile");
        result = new CheckResult();
        exception = null;
        try {
            this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        }
        catch (Exception e) {
            exception = e;
        }
        TestHiveMetaStoreChecker.assertTrue((String)"Expected HiveException", (exception != null && exception instanceof HiveException ? 1 : 0) != 0);
    }

    public void testErrorForMissingPartitionsSingleThreaded() throws AlreadyExistsException, HiveException, IOException {
        this.hive.getConf().setIntVar(HiveConf.ConfVars.METASTORE_FS_HANDLER_THREADS_COUNT, 0);
        Table testTable = this.createPartitionedTestTable("testhivemetastorechecker_db", "testhivemetastorechecker_table", 2, 0);
        this.createPartitionsDirectoriesOnFS(testTable, 10);
        StringBuilder sb = new StringBuilder(testTable.getDataLocation().toString());
        sb.append("/");
        sb.append("dummyPart=error");
        this.createDirectory(sb.toString());
        CheckResult result = new CheckResult();
        Exception exception = null;
        try {
            this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        }
        catch (Exception e) {
            exception = e;
        }
        TestHiveMetaStoreChecker.assertTrue((String)"Expected HiveException", (exception != null && exception instanceof HiveException ? 1 : 0) != 0);
        this.createFile(sb.toString(), "dummyFile");
        result = new CheckResult();
        exception = null;
        try {
            this.checker.checkMetastore("testhivemetastorechecker_db", "testhivemetastorechecker_table", null, result);
        }
        catch (Exception e) {
            exception = e;
        }
        TestHiveMetaStoreChecker.assertTrue((String)"Expected HiveException", (exception != null && exception instanceof HiveException ? 1 : 0) != 0);
    }

    private Table createPartitionedTestTable(String dbName, String tableName, int numOfPartKeys, int valuesPerPartition) throws AlreadyExistsException, HiveException {
        Database db = new Database();
        db.setName(dbName);
        this.hive.createDatabase(db);
        Table table = new Table(dbName, tableName);
        table.setDbName(dbName);
        table.setInputFormatClass(TextInputFormat.class);
        table.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        ArrayList<FieldSchema> partKeys = new ArrayList<FieldSchema>();
        for (int i = 1; i <= numOfPartKeys; ++i) {
            String partName = "part" + String.valueOf(i);
            partKeys.add(new FieldSchema(partName, "string", ""));
        }
        table.setPartCols(partKeys);
        this.hive.createTable(table);
        table = this.hive.getTable(dbName, tableName);
        if (valuesPerPartition == 0) {
            return table;
        }
        ArrayList partitionSpecs = new ArrayList();
        for (int partKeyIndex = 0; partKeyIndex < numOfPartKeys; ++partKeyIndex) {
            String string = ((FieldSchema)partKeys.get(partKeyIndex)).getName();
            HashMap<String, String> partMap = new HashMap<String, String>();
            for (int val = 1; val <= valuesPerPartition; ++val) {
                partMap.put(string, String.valueOf(val));
            }
            partitionSpecs.add(partMap);
        }
        for (Map map : partitionSpecs) {
            this.hive.createPartition(table, map);
        }
        List partitions = this.hive.getPartitions(table);
        TestHiveMetaStoreChecker.assertEquals((int)(numOfPartKeys * valuesPerPartition), (int)partitions.size());
        return table;
    }

    private void createPartitionsDirectoriesOnFS(Table table, int numPartitions) throws IOException {
        String path = table.getDataLocation().toString();
        this.fs = table.getPath().getFileSystem((Configuration)this.hive.getConf());
        int numPartKeys = table.getPartitionKeys().size();
        for (int i = 0; i < numPartitions; ++i) {
            StringBuilder partPath = new StringBuilder(path);
            partPath.append("/");
            for (int j = 0; j < numPartKeys; ++j) {
                FieldSchema field = (FieldSchema)table.getPartitionKeys().get(j);
                partPath.append(field.getName());
                partPath.append('=');
                partPath.append("val_");
                partPath.append(i);
                if (j >= numPartKeys - 1) continue;
                partPath.append("/");
            }
            this.createDirectory(partPath.toString());
        }
    }

    private void createFile(String partPath, String filename) throws IOException {
        Path part = new Path(partPath);
        this.fs.mkdirs(part);
        this.fs.createNewFile(new Path(partPath + "/" + filename));
        this.fs.deleteOnExit(part);
    }

    private void createDirectory(String partPath) throws IOException {
        Path part = new Path(partPath);
        this.fs.mkdirs(part);
        this.fs.deleteOnExit(part);
    }
}

