/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="StringAppender", category="Core", elementType="appender", printObject=true)
public class StringAppender
extends AbstractOutputStreamAppender<StringOutputStreamManager> {
    private static final String APPENDER_NAME = "StringAppender";
    private static LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
    private static Configuration configuration = context.getConfiguration();
    private StringOutputStreamManager manager;

    protected StringAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, boolean immediateFlush, StringOutputStreamManager manager) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, (OutputStreamManager)manager);
        this.manager = manager;
    }

    @PluginFactory
    public static StringAppender createStringAppender(@PluginAttribute(value="name") String nullablePatternString) {
        PatternLayout layout = nullablePatternString == null ? PatternLayout.createDefaultLayout() : PatternLayout.createLayout((String)nullablePatternString, null, (Configuration)configuration, null, null, (boolean)true, (boolean)false, null, null);
        return new StringAppender(APPENDER_NAME, (Layout<? extends Serializable>)layout, null, false, true, new StringOutputStreamManager(new ByteArrayOutputStream(), "StringStream", (Layout<?>)layout));
    }

    @VisibleForTesting
    public void addToLogger(String loggerName, Level level) {
        LoggerConfig loggerConfig = configuration.getLoggerConfig(loggerName);
        loggerConfig.addAppender((Appender)this, level, null);
        context.updateLoggers();
    }

    @VisibleForTesting
    public void removeFromLogger(String loggerName) {
        LoggerConfig loggerConfig = configuration.getLoggerConfig(loggerName);
        loggerConfig.removeAppender(APPENDER_NAME);
        context.updateLoggers();
    }

    public String getOutput() {
        this.manager.flush();
        return new String(this.manager.getStream().toByteArray());
    }

    public void reset() {
        this.manager.reset();
    }

    protected static class StringOutputStreamManager
    extends OutputStreamManager {
        ByteArrayOutputStream stream;

        protected StringOutputStreamManager(ByteArrayOutputStream os, String streamName, Layout<?> layout) {
            super((OutputStream)os, streamName, layout, true);
            this.stream = os;
        }

        public ByteArrayOutputStream getStream() {
            return this.stream;
        }

        public void reset() {
            this.stream.reset();
        }
    }
}

