/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidCompactorTxnList;
import org.apache.hadoop.hive.common.ValidReadTxnList;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.orc.TestInputOutputFormat;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.junit.Assert;
import org.junit.Test;

public class TestAcidUtils {
    @Test
    public void testCreateFilename() throws Exception {
        Path p = new Path("/tmp");
        Configuration conf = new Configuration();
        AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).setOldStyle(true).bucket(1);
        Assert.assertEquals((Object)"/tmp/000001_0", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
        options.bucket(123);
        Assert.assertEquals((Object)"/tmp/000123_0", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
        options.bucket(23).minimumTransactionId(100L).maximumTransactionId(200L).writingBase(true).setOldStyle(false);
        Assert.assertEquals((Object)"/tmp/base_0000200/bucket_00023", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
        options.writingBase(false);
        Assert.assertEquals((Object)"/tmp/delta_0000100_0000200_0000/bucket_00023", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
        options.writingDeleteDelta(true);
        Assert.assertEquals((Object)"/tmp/delete_delta_0000100_0000200_0000/bucket_00023", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
        options.writingDeleteDelta(false);
        options.statementId(-1);
        Assert.assertEquals((Object)"/tmp/delta_0000100_0000200/bucket_00023", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
        options.writingDeleteDelta(true);
        Assert.assertEquals((Object)"/tmp/delete_delta_0000100_0000200/bucket_00023", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
        options.writingDeleteDelta(false);
        options.statementId(7);
        Assert.assertEquals((Object)"/tmp/delta_0000100_0000200_0007/bucket_00023", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
        options.writingDeleteDelta(true);
        Assert.assertEquals((Object)"/tmp/delete_delta_0000100_0000200_0007/bucket_00023", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
    }

    @Test
    public void testCreateFilenameLargeIds() throws Exception {
        Path p = new Path("/tmp");
        Configuration conf = new Configuration();
        AcidOutputFormat.Options options = new AcidOutputFormat.Options(conf).setOldStyle(true).bucket(123456789);
        Assert.assertEquals((Object)"/tmp/123456789_0", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
        options.bucket(23).minimumTransactionId(1234567880L).maximumTransactionId(1234567890L).writingBase(true).setOldStyle(false);
        Assert.assertEquals((Object)"/tmp/base_1234567890/bucket_00023", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
        options.writingBase(false);
        Assert.assertEquals((Object)"/tmp/delta_1234567880_1234567890_0000/bucket_00023", (Object)AcidUtils.createFilename((Path)p, (AcidOutputFormat.Options)options).toString());
    }

    @Test
    public void testParsing() throws Exception {
        Assert.assertEquals((long)123L, (long)AcidUtils.parseBase((Path)new Path("/tmp/base_000123")));
        Path dir = new Path("/tmp/tbl");
        Configuration conf = new Configuration();
        AcidOutputFormat.Options opts = AcidUtils.parseBaseOrDeltaBucketFilename((Path)new Path(dir, "base_567/bucket_123"), (Configuration)conf);
        Assert.assertEquals((Object)false, (Object)opts.getOldStyle());
        Assert.assertEquals((Object)true, (Object)opts.isWritingBase());
        Assert.assertEquals((long)567L, (long)opts.getMaximumTransactionId());
        Assert.assertEquals((long)0L, (long)opts.getMinimumTransactionId());
        Assert.assertEquals((long)123L, (long)opts.getBucket());
        opts = AcidUtils.parseBaseOrDeltaBucketFilename((Path)new Path(dir, "delta_000005_000006/bucket_00001"), (Configuration)conf);
        Assert.assertEquals((Object)false, (Object)opts.getOldStyle());
        Assert.assertEquals((Object)false, (Object)opts.isWritingBase());
        Assert.assertEquals((long)6L, (long)opts.getMaximumTransactionId());
        Assert.assertEquals((long)5L, (long)opts.getMinimumTransactionId());
        Assert.assertEquals((long)1L, (long)opts.getBucket());
        opts = AcidUtils.parseBaseOrDeltaBucketFilename((Path)new Path(dir, "delete_delta_000005_000006/bucket_00001"), (Configuration)conf);
        Assert.assertEquals((Object)false, (Object)opts.getOldStyle());
        Assert.assertEquals((Object)false, (Object)opts.isWritingBase());
        Assert.assertEquals((long)6L, (long)opts.getMaximumTransactionId());
        Assert.assertEquals((long)5L, (long)opts.getMinimumTransactionId());
        Assert.assertEquals((long)1L, (long)opts.getBucket());
        opts = AcidUtils.parseBaseOrDeltaBucketFilename((Path)new Path(dir, "000123_0"), (Configuration)conf);
        Assert.assertEquals((Object)true, (Object)opts.getOldStyle());
        Assert.assertEquals((Object)true, (Object)opts.isWritingBase());
        Assert.assertEquals((long)123L, (long)opts.getBucket());
        Assert.assertEquals((long)0L, (long)opts.getMinimumTransactionId());
        Assert.assertEquals((long)0L, (long)opts.getMaximumTransactionId());
    }

    @Test
    public void testOriginal() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/000000_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/000001_1", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/000002_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/random", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/_done", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/subdir/000000_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)new TestInputOutputFormat.MockPath(fs, "/tbl/part1"), (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:9223372036854775807:"));
        Assert.assertEquals(null, (Object)dir.getBaseDirectory());
        Assert.assertEquals((long)0L, (long)dir.getCurrentDirectories().size());
        Assert.assertEquals((long)0L, (long)dir.getObsolete().size());
        List result = dir.getOriginalFiles();
        Assert.assertEquals((long)5L, (long)result.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/000000_0", (Object)((HadoopShims.HdfsFileStatusWithId)result.get(0)).getFileStatus().getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/000001_1", (Object)((HadoopShims.HdfsFileStatusWithId)result.get(1)).getFileStatus().getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/000002_0", (Object)((HadoopShims.HdfsFileStatusWithId)result.get(2)).getFileStatus().getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/random", (Object)((HadoopShims.HdfsFileStatusWithId)result.get(3)).getFileStatus().getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/subdir/000000_0", (Object)((HadoopShims.HdfsFileStatusWithId)result.get(4)).getFileStatus().getPath().toString());
    }

    @Test
    public void testOriginalDeltas() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/000000_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/000001_1", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/000002_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/random", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/_done", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/subdir/000000_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_025_025/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_029_029/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_025_030/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_050_100/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_101_101/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1"), (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:9223372036854775807:"));
        Assert.assertEquals(null, (Object)dir.getBaseDirectory());
        List obsolete = dir.getObsolete();
        Assert.assertEquals((long)2L, (long)obsolete.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_025_025", (Object)((FileStatus)obsolete.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_029_029", (Object)((FileStatus)obsolete.get(1)).getPath().toString());
        List result = dir.getOriginalFiles();
        Assert.assertEquals((long)5L, (long)result.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/000000_0", (Object)((HadoopShims.HdfsFileStatusWithId)result.get(0)).getFileStatus().getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/000001_1", (Object)((HadoopShims.HdfsFileStatusWithId)result.get(1)).getFileStatus().getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/000002_0", (Object)((HadoopShims.HdfsFileStatusWithId)result.get(2)).getFileStatus().getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/random", (Object)((HadoopShims.HdfsFileStatusWithId)result.get(3)).getFileStatus().getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/subdir/000000_0", (Object)((HadoopShims.HdfsFileStatusWithId)result.get(4)).getFileStatus().getPath().toString());
        List deltas = dir.getCurrentDirectories();
        Assert.assertEquals((long)2L, (long)deltas.size());
        AcidUtils.ParsedDelta delt = (AcidUtils.ParsedDelta)deltas.get(0);
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_025_030", (Object)delt.getPath().toString());
        Assert.assertEquals((long)25L, (long)delt.getMinTransaction());
        Assert.assertEquals((long)30L, (long)delt.getMaxTransaction());
        delt = (AcidUtils.ParsedDelta)deltas.get(1);
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_050_100", (Object)delt.getPath().toString());
        Assert.assertEquals((long)50L, (long)delt.getMinTransaction());
        Assert.assertEquals((long)100L, (long)delt.getMaxTransaction());
    }

    @Test
    public void testBaseDeltas() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_49/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_025_025/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_029_029/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_025_030/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_050_105/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_90_120/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1"), (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:9223372036854775807:"));
        Assert.assertEquals((Object)"mock:/tbl/part1/base_49", (Object)dir.getBaseDirectory().toString());
        List obsolete = dir.getObsolete();
        Assert.assertEquals((long)5L, (long)obsolete.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_10", (Object)((FileStatus)obsolete.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_5", (Object)((FileStatus)obsolete.get(1)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_025_030", (Object)((FileStatus)obsolete.get(2)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_025_025", (Object)((FileStatus)obsolete.get(3)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_029_029", (Object)((FileStatus)obsolete.get(4)).getPath().toString());
        Assert.assertEquals((long)0L, (long)dir.getOriginalFiles().size());
        List deltas = dir.getCurrentDirectories();
        Assert.assertEquals((long)1L, (long)deltas.size());
        AcidUtils.ParsedDelta delt = (AcidUtils.ParsedDelta)deltas.get(0);
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_050_105", (Object)delt.getPath().toString());
        Assert.assertEquals((long)50L, (long)delt.getMinTransaction());
        Assert.assertEquals((long)105L, (long)delt.getMaxTransaction());
    }

    @Test
    public void testBestBase() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "mock:///");
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_25/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_98_100/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_100/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_120_130/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_200/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("150:9223372036854775807:"));
        Assert.assertEquals((Object)"mock:/tbl/part1/base_100", (Object)dir.getBaseDirectory().toString());
        Assert.assertEquals((long)1L, (long)dir.getCurrentDirectories().size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_120_130", (Object)((AcidUtils.ParsedDelta)dir.getCurrentDirectories().get(0)).getPath().toString());
        List obsoletes = dir.getObsolete();
        Assert.assertEquals((long)4L, (long)obsoletes.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_10", (Object)((FileStatus)obsoletes.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_25", (Object)((FileStatus)obsoletes.get(1)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_5", (Object)((FileStatus)obsoletes.get(2)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_98_100", (Object)((FileStatus)obsoletes.get(3)).getPath().toString());
        Assert.assertEquals((long)0L, (long)dir.getOriginalFiles().size());
        dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("10:9223372036854775807:"));
        Assert.assertEquals((Object)"mock:/tbl/part1/base_10", (Object)dir.getBaseDirectory().toString());
        Assert.assertEquals((long)0L, (long)dir.getCurrentDirectories().size());
        obsoletes = dir.getObsolete();
        Assert.assertEquals((long)1L, (long)obsoletes.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_5", (Object)((FileStatus)obsoletes.get(0)).getPath().toString());
        Assert.assertEquals((long)0L, (long)dir.getOriginalFiles().size());
        dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("150:121:99:121"));
        Assert.assertEquals((Object)"mock:/tbl/part1/base_100", (Object)dir.getBaseDirectory().toString());
        Assert.assertEquals((long)1L, (long)dir.getCurrentDirectories().size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_120_130", (Object)((AcidUtils.ParsedDelta)dir.getCurrentDirectories().get(0)).getPath().toString());
        obsoletes = dir.getObsolete();
        Assert.assertEquals((long)4L, (long)obsoletes.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_10", (Object)((FileStatus)obsoletes.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_25", (Object)((FileStatus)obsoletes.get(1)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_5", (Object)((FileStatus)obsoletes.get(2)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_98_100", (Object)((FileStatus)obsoletes.get(3)).getPath().toString());
        boolean gotException = false;
        try {
            dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("125:5:5"));
        }
        catch (IOException e) {
            gotException = true;
            Assert.assertEquals((Object)"Not enough history available for (125,5).  Oldest available base: mock:/tbl/part1/base_5", (Object)e.getMessage());
        }
        Assert.assertTrue((String)"Expected exception", (boolean)gotException);
        fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_1_10/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_12_25/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_25/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_100/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        part = new TestInputOutputFormat.MockPath(fs, "/tbl/part1");
        try {
            gotException = false;
            dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("150:7:7"));
        }
        catch (IOException e) {
            gotException = true;
            Assert.assertEquals((Object)"Not enough history available for (150,7).  Oldest available base: mock:/tbl/part1/base_25", (Object)e.getMessage());
        }
        Assert.assertTrue((String)"Expected exception", (boolean)gotException);
        fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_2_10/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_25/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_100/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        part = new TestInputOutputFormat.MockPath(fs, "/tbl/part1");
        try {
            gotException = false;
            dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("150:7:7"));
        }
        catch (IOException e) {
            gotException = true;
            Assert.assertEquals((Object)"Not enough history available for (150,7).  Oldest available base: mock:/tbl/part1/base_25", (Object)e.getMessage());
        }
        Assert.assertTrue((String)"Expected exception", (boolean)gotException);
        fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_-9223372036854775808/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_100/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        part = new TestInputOutputFormat.MockPath(fs, "/tbl/part1");
        dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("1:9223372036854775807:"));
        Assert.assertEquals((Object)"mock:/tbl/part1/base_-9223372036854775808", (Object)dir.getBaseDirectory().toString());
        Assert.assertEquals((long)1L, (long)dir.getCurrentDirectories().size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_1_1", (Object)((AcidUtils.ParsedDelta)dir.getCurrentDirectories().get(0)).getPath().toString());
        Assert.assertEquals((long)0L, (long)dir.getObsolete().size());
    }

    @Test
    public void testObsoleteOriginals() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/000000_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/000001_1", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("150:9223372036854775807:"));
        List obsolete = dir.getObsolete();
        Assert.assertEquals((long)3L, (long)obsolete.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_5", (Object)((FileStatus)obsolete.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_10", (Object)dir.getBaseDirectory().toString());
    }

    @Test
    public void testOverlapingDelta() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_0000063_63/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_000062_62/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_00061_61/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_0060_60/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_052_55/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_50/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:9223372036854775807:"));
        Assert.assertEquals((Object)"mock:/tbl/part1/base_50", (Object)dir.getBaseDirectory().toString());
        List obsolete = dir.getObsolete();
        Assert.assertEquals((long)2L, (long)obsolete.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_052_55", (Object)((FileStatus)obsolete.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_0060_60", (Object)((FileStatus)obsolete.get(1)).getPath().toString());
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((long)4L, (long)delts.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_40_60", (Object)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_00061_61", (Object)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_000062_62", (Object)((AcidUtils.ParsedDelta)delts.get(2)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_0000063_63", (Object)((AcidUtils.ParsedDelta)delts.get(3)).getPath().toString());
    }

    @Test
    public void testOverlapingDelta2() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_0000063_63_0/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_000062_62_0/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_000062_62_3/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_00061_61_0/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_0060_60_1/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_0060_60_4/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_0060_60_7/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_052_55/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_058_58/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_50/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:9223372036854775807:"));
        Assert.assertEquals((Object)"mock:/tbl/part1/base_50", (Object)dir.getBaseDirectory().toString());
        List obsolete = dir.getObsolete();
        Assert.assertEquals((long)5L, (long)obsolete.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_052_55", (Object)((FileStatus)obsolete.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_058_58", (Object)((FileStatus)obsolete.get(1)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_0060_60_1", (Object)((FileStatus)obsolete.get(2)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_0060_60_4", (Object)((FileStatus)obsolete.get(3)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_0060_60_7", (Object)((FileStatus)obsolete.get(4)).getPath().toString());
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((long)5L, (long)delts.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_40_60", (Object)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_00061_61_0", (Object)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_000062_62_0", (Object)((AcidUtils.ParsedDelta)delts.get(2)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_000062_62_3", (Object)((AcidUtils.ParsedDelta)delts.get(3)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_0000063_63_0", (Object)((AcidUtils.ParsedDelta)delts.get(4)).getPath().toString());
    }

    @Test
    public void deltasWithOpenTxnInRead() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:4:4"));
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((long)2L, (long)delts.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_1_1", (Object)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_2_5", (Object)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString());
    }

    @Test
    public void deltasWithOpenTxnInRead2() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_4_4_1/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_4_4_3/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_101_101_1/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:4:4"));
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((long)2L, (long)delts.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_1_1", (Object)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_2_5", (Object)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString());
    }

    @Test
    public void deltasWithOpenTxnsNotInCompact() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidCompactorTxnList("4:9223372036854775807"));
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((long)1L, (long)delts.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_1_1", (Object)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString());
    }

    @Test
    public void deltasWithOpenTxnsNotInCompact2() throws Exception {
        Configuration conf = new Configuration();
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_2_5/bucket_0_flush_length", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_6_10/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidCompactorTxnList("3:9223372036854775807"));
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((long)1L, (long)delts.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_1_1", (Object)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString());
    }

    @Test
    public void testBaseWithDeleteDeltas() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "mock:///");
        conf.setInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, AcidUtils.AcidOperationalProperties.getDefault().toInt());
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_10/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_49/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_025_025/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_029_029/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delete_delta_029_029/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_025_030/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delete_delta_025_030/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_050_105/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delete_delta_050_105/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delete_delta_110_110/bucket_0", 0, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1"), (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:9223372036854775807:"));
        Assert.assertEquals((Object)"mock:/tbl/part1/base_49", (Object)dir.getBaseDirectory().toString());
        List obsolete = dir.getObsolete();
        Assert.assertEquals((long)7L, (long)obsolete.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_10", (Object)((FileStatus)obsolete.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/base_5", (Object)((FileStatus)obsolete.get(1)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delete_delta_025_030", (Object)((FileStatus)obsolete.get(2)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_025_030", (Object)((FileStatus)obsolete.get(3)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_025_025", (Object)((FileStatus)obsolete.get(4)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delete_delta_029_029", (Object)((FileStatus)obsolete.get(5)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_029_029", (Object)((FileStatus)obsolete.get(6)).getPath().toString());
        Assert.assertEquals((long)0L, (long)dir.getOriginalFiles().size());
        List deltas = dir.getCurrentDirectories();
        Assert.assertEquals((long)2L, (long)deltas.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delete_delta_050_105", (Object)((AcidUtils.ParsedDelta)deltas.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_050_105", (Object)((AcidUtils.ParsedDelta)deltas.get(1)).getPath().toString());
    }

    @Test
    public void testOverlapingDeltaAndDeleteDelta() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "mock:///");
        conf.setInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, AcidUtils.AcidOperationalProperties.getDefault().toInt());
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_0000063_63/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_000062_62/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_00061_61/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delete_delta_00064_64/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delete_delta_40_60/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_0060_60/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_052_55/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delete_delta_052_55/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/base_50/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:9223372036854775807:"));
        Assert.assertEquals((Object)"mock:/tbl/part1/base_50", (Object)dir.getBaseDirectory().toString());
        List obsolete = dir.getObsolete();
        Assert.assertEquals((long)3L, (long)obsolete.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delete_delta_052_55", (Object)((FileStatus)obsolete.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_052_55", (Object)((FileStatus)obsolete.get(1)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_0060_60", (Object)((FileStatus)obsolete.get(2)).getPath().toString());
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((long)6L, (long)delts.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delete_delta_40_60", (Object)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_40_60", (Object)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_00061_61", (Object)((AcidUtils.ParsedDelta)delts.get(2)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_000062_62", (Object)((AcidUtils.ParsedDelta)delts.get(3)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_0000063_63", (Object)((AcidUtils.ParsedDelta)delts.get(4)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delete_delta_00064_64", (Object)((AcidUtils.ParsedDelta)delts.get(5)).getPath().toString());
    }

    @Test
    public void testMinorCompactedDeltaMakesInBetweenDelteDeltaObsolete() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "mock:///");
        conf.setInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, AcidUtils.AcidOperationalProperties.getDefault().toInt());
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_40_60/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delete_delta_50_50/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:9223372036854775807:"));
        List obsolete = dir.getObsolete();
        Assert.assertEquals((long)1L, (long)obsolete.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delete_delta_50_50", (Object)((FileStatus)obsolete.get(0)).getPath().toString());
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((long)1L, (long)delts.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_40_60", (Object)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString());
    }

    @Test
    public void deltasAndDeleteDeltasWithOpenTxnsNotInCompact() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "mock:///");
        conf.setInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, AcidUtils.AcidOperationalProperties.getDefault().toInt());
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delete_delta_2_2/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delete_delta_2_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_2_5/bucket_0_flush_length", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delete_delta_7_7/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_6_10/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidCompactorTxnList("4:9223372036854775807:"));
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((long)2L, (long)delts.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_1_1", (Object)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delete_delta_2_2", (Object)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString());
    }

    @Test
    public void deleteDeltasWithOpenTxnInRead() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "mock:///");
        conf.setInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, AcidUtils.AcidOperationalProperties.getDefault().toInt());
        TestInputOutputFormat.MockFileSystem fs = new TestInputOutputFormat.MockFileSystem(conf, new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_1_1/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_2_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delete_delta_2_5/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delete_delta_3_3/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_4_4_1/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_4_4_3/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]), new TestInputOutputFormat.MockFile("mock:/tbl/part1/delta_101_101_1/bucket_0", 500, new byte[0], new TestInputOutputFormat.MockBlock[0]));
        TestInputOutputFormat.MockPath part = new TestInputOutputFormat.MockPath(fs, "mock:/tbl/part1");
        AcidUtils.Directory dir = AcidUtils.getAcidState((Path)part, (Configuration)conf, (ValidTxnList)new ValidReadTxnList("100:4:4"));
        List delts = dir.getCurrentDirectories();
        Assert.assertEquals((long)3L, (long)delts.size());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_1_1", (Object)((AcidUtils.ParsedDelta)delts.get(0)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delete_delta_2_5", (Object)((AcidUtils.ParsedDelta)delts.get(1)).getPath().toString());
        Assert.assertEquals((Object)"mock:/tbl/part1/delta_2_5", (Object)((AcidUtils.ParsedDelta)delts.get(2)).getPath().toString());
    }

    @Test
    public void testDeleteDeltaSubdirPathGeneration() throws Exception {
        String deleteDeltaSubdirPath = AcidUtils.deleteDeltaSubdir((long)1L, (long)10L);
        Assert.assertEquals((Object)"delete_delta_0000001_0000010", (Object)deleteDeltaSubdirPath);
        deleteDeltaSubdirPath = AcidUtils.deleteDeltaSubdir((long)1L, (long)10L, (int)5);
        Assert.assertEquals((Object)"delete_delta_0000001_0000010_0005", (Object)deleteDeltaSubdirPath);
    }

    @Test
    public void testDeleteEventDeltaDirPathFilter() throws Exception {
        Path positivePath = new Path("delete_delta_000001_000010");
        Path negativePath = new Path("delta_000001_000010");
        Assert.assertEquals((Object)true, (Object)AcidUtils.deleteEventDeltaDirFilter.accept(positivePath));
        Assert.assertEquals((Object)false, (Object)AcidUtils.deleteEventDeltaDirFilter.accept(negativePath));
    }

    @Test
    public void testAcidOperationalProperties() throws Exception {
        AcidUtils.AcidOperationalProperties testObj = AcidUtils.AcidOperationalProperties.getLegacy();
        this.assertsForAcidOperationalProperties(testObj, "legacy");
        testObj = AcidUtils.AcidOperationalProperties.getDefault();
        this.assertsForAcidOperationalProperties(testObj, "default");
        testObj = AcidUtils.AcidOperationalProperties.parseInt((int)0);
        this.assertsForAcidOperationalProperties(testObj, "legacy");
        testObj = AcidUtils.AcidOperationalProperties.parseInt((int)1);
        this.assertsForAcidOperationalProperties(testObj, "split_update");
        testObj = AcidUtils.AcidOperationalProperties.parseString((String)"legacy");
        this.assertsForAcidOperationalProperties(testObj, "legacy");
        testObj = AcidUtils.AcidOperationalProperties.parseString((String)"default");
        this.assertsForAcidOperationalProperties(testObj, "default");
    }

    private void assertsForAcidOperationalProperties(AcidUtils.AcidOperationalProperties testObj, String type) throws Exception {
        switch (type) {
            case "split_update": 
            case "default": {
                Assert.assertEquals((Object)true, (Object)testObj.isSplitUpdate());
                Assert.assertEquals((Object)false, (Object)testObj.isHashBasedMerge());
                Assert.assertEquals((long)1L, (long)testObj.toInt());
                Assert.assertEquals((Object)"|split_update", (Object)testObj.toString());
                break;
            }
            case "legacy": {
                Assert.assertEquals((Object)false, (Object)testObj.isSplitUpdate());
                Assert.assertEquals((Object)false, (Object)testObj.isHashBasedMerge());
                Assert.assertEquals((long)0L, (long)testObj.toInt());
                Assert.assertEquals((Object)"", (Object)testObj.toString());
                break;
            }
        }
    }

    @Test
    public void testAcidOperationalPropertiesSettersAndGetters() throws Exception {
        AcidUtils.AcidOperationalProperties oprProps = AcidUtils.AcidOperationalProperties.getDefault();
        Configuration testConf = new Configuration();
        testConf.set("fs.default.name", "file:///");
        AcidUtils.setAcidOperationalProperties((Configuration)testConf, (AcidUtils.AcidOperationalProperties)oprProps);
        Assert.assertEquals((long)1L, (long)testConf.getInt(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname, 0));
        Assert.assertEquals((Object)oprProps.toString(), (Object)AcidUtils.getAcidOperationalProperties((Configuration)testConf).toString());
        HashMap<String, String> parameters = new HashMap<String, String>();
        AcidUtils.setAcidOperationalProperties(parameters, (AcidUtils.AcidOperationalProperties)oprProps);
        Assert.assertEquals((Object)oprProps.toString(), parameters.get(HiveConf.ConfVars.HIVE_TXN_OPERATIONAL_PROPERTIES.varname));
        Assert.assertEquals((long)0L, (long)AcidUtils.getAcidOperationalProperties(parameters).toInt());
        parameters.put("transactional_properties", oprProps.toString());
        Assert.assertEquals((long)1L, (long)AcidUtils.getAcidOperationalProperties(parameters).toInt());
    }
}

