/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class VerifyFastRow {
    public static void verifyDeserializeRead(DeserializeRead deserializeRead, PrimitiveTypeInfo primitiveTypeInfo, Writable writable) throws IOException {
        boolean isNull;
        boolean bl = isNull = !deserializeRead.readNextField();
        if (isNull) {
            if (writable != null) {
                TestCase.fail((String)(deserializeRead.getClass().getName() + " field reports null but object is not null (class " + writable.getClass().getName() + ", " + writable.toString() + ")"));
            }
            return;
        }
        if (writable == null) {
            TestCase.fail((String)"Field report not null but object is null");
        }
        switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case BOOLEAN: {
                boolean expected;
                boolean value = deserializeRead.currentBoolean;
                if (!(writable instanceof BooleanWritable)) {
                    TestCase.fail((String)"Boolean expected writable not Boolean");
                }
                if (value == (expected = ((BooleanWritable)writable).get())) break;
                TestCase.fail((String)("Boolean field mismatch (expected " + expected + " found " + value + ")"));
                break;
            }
            case BYTE: {
                byte expected;
                byte value = deserializeRead.currentByte;
                if (!(writable instanceof ByteWritable)) {
                    TestCase.fail((String)"Byte expected writable not Byte");
                }
                if (value == (expected = ((ByteWritable)writable).get())) break;
                TestCase.fail((String)("Byte field mismatch (expected " + expected + " found " + value + ")"));
                break;
            }
            case SHORT: {
                short expected;
                short value = deserializeRead.currentShort;
                if (!(writable instanceof ShortWritable)) {
                    TestCase.fail((String)"Short expected writable not Short");
                }
                if (value == (expected = ((ShortWritable)writable).get())) break;
                TestCase.fail((String)("Short field mismatch (expected " + expected + " found " + value + ")"));
                break;
            }
            case INT: {
                int expected;
                int value = deserializeRead.currentInt;
                if (!(writable instanceof IntWritable)) {
                    TestCase.fail((String)"Integer expected writable not Integer");
                }
                if (value == (expected = ((IntWritable)writable).get())) break;
                TestCase.fail((String)("Int field mismatch (expected " + expected + " found " + value + ")"));
                break;
            }
            case LONG: {
                Long expected;
                long value = deserializeRead.currentLong;
                if (!(writable instanceof LongWritable)) {
                    TestCase.fail((String)"Long expected writable not Long");
                }
                if (value == (expected = Long.valueOf(((LongWritable)writable).get()))) break;
                TestCase.fail((String)("Long field mismatch (expected " + expected + " found " + value + ")"));
                break;
            }
            case FLOAT: {
                float expected;
                float value = deserializeRead.currentFloat;
                if (!(writable instanceof FloatWritable)) {
                    TestCase.fail((String)"Float expected writable not Float");
                }
                if (value == (expected = ((FloatWritable)writable).get())) break;
                TestCase.fail((String)("Float field mismatch (expected " + expected + " found " + value + ")"));
                break;
            }
            case DOUBLE: {
                double expected;
                double value = deserializeRead.currentDouble;
                if (!(writable instanceof DoubleWritable)) {
                    TestCase.fail((String)"Double expected writable not Double");
                }
                if (value == (expected = ((DoubleWritable)writable).get())) break;
                TestCase.fail((String)("Double field mismatch (expected " + expected + " found " + value + ")"));
                break;
            }
            case STRING: {
                byte[] stringBytes = Arrays.copyOfRange(deserializeRead.currentBytes, deserializeRead.currentBytesStart, deserializeRead.currentBytesStart + deserializeRead.currentBytesLength);
                Text text = new Text(stringBytes);
                String string = text.toString();
                String expected = ((Text)writable).toString();
                if (string.equals(expected)) break;
                TestCase.fail((String)("String field mismatch (expected '" + expected + "' found '" + string + "')"));
                break;
            }
            case CHAR: {
                byte[] stringBytes = Arrays.copyOfRange(deserializeRead.currentBytes, deserializeRead.currentBytesStart, deserializeRead.currentBytesStart + deserializeRead.currentBytesLength);
                Text text = new Text(stringBytes);
                String string = text.toString();
                HiveChar hiveChar = new HiveChar(string, ((CharTypeInfo)primitiveTypeInfo).getLength());
                HiveChar expected = ((HiveCharWritable)writable).getHiveChar();
                if (hiveChar.equals((Object)expected)) break;
                TestCase.fail((String)("Char field mismatch (expected '" + expected + "' found '" + hiveChar + "')"));
                break;
            }
            case VARCHAR: {
                byte[] stringBytes = Arrays.copyOfRange(deserializeRead.currentBytes, deserializeRead.currentBytesStart, deserializeRead.currentBytesStart + deserializeRead.currentBytesLength);
                Text text = new Text(stringBytes);
                String string = text.toString();
                HiveVarchar hiveVarchar = new HiveVarchar(string, ((VarcharTypeInfo)primitiveTypeInfo).getLength());
                HiveVarchar expected = ((HiveVarcharWritable)writable).getHiveVarchar();
                if (hiveVarchar.equals((Object)expected)) break;
                TestCase.fail((String)("Varchar field mismatch (expected '" + expected + "' found '" + hiveVarchar + "')"));
                break;
            }
            case DECIMAL: {
                HiveDecimal expected;
                HiveDecimal value = deserializeRead.currentHiveDecimalWritable.getHiveDecimal();
                if (value == null) {
                    TestCase.fail((String)"Decimal field evaluated to NULL");
                }
                if (value.equals((Object)(expected = ((HiveDecimalWritable)writable).getHiveDecimal()))) break;
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)primitiveTypeInfo;
                int precision = decimalTypeInfo.getPrecision();
                int scale = decimalTypeInfo.getScale();
                TestCase.fail((String)("Decimal field mismatch (expected " + expected.toString() + " found " + value.toString() + ") precision " + precision + ", scale " + scale));
                break;
            }
            case DATE: {
                Date value = deserializeRead.currentDateWritable.get();
                Date expected = ((DateWritable)writable).get();
                if (value.equals(expected)) break;
                TestCase.fail((String)("Date field mismatch (expected " + expected.toString() + " found " + value.toString() + ")"));
                break;
            }
            case TIMESTAMP: {
                Timestamp value = deserializeRead.currentTimestampWritable.getTimestamp();
                Timestamp expected = ((TimestampWritable)writable).getTimestamp();
                if (value.equals(expected)) break;
                TestCase.fail((String)("Timestamp field mismatch (expected " + expected.toString() + " found " + value.toString() + ")"));
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                HiveIntervalYearMonth value = deserializeRead.currentHiveIntervalYearMonthWritable.getHiveIntervalYearMonth();
                HiveIntervalYearMonth expected = ((HiveIntervalYearMonthWritable)writable).getHiveIntervalYearMonth();
                if (value.equals((Object)expected)) break;
                TestCase.fail((String)("HiveIntervalYearMonth field mismatch (expected " + expected.toString() + " found " + value.toString() + ")"));
                break;
            }
            case INTERVAL_DAY_TIME: {
                HiveIntervalDayTime value = deserializeRead.currentHiveIntervalDayTimeWritable.getHiveIntervalDayTime();
                HiveIntervalDayTime expected = ((HiveIntervalDayTimeWritable)writable).getHiveIntervalDayTime();
                if (value.equals((Object)expected)) break;
                TestCase.fail((String)("HiveIntervalDayTime field mismatch (expected " + expected.toString() + " found " + value.toString() + ")"));
                break;
            }
            case BINARY: {
                byte[] byteArray = Arrays.copyOfRange(deserializeRead.currentBytes, deserializeRead.currentBytesStart, deserializeRead.currentBytesStart + deserializeRead.currentBytesLength);
                BytesWritable bytesWritable = (BytesWritable)writable;
                byte[] expected = Arrays.copyOfRange(bytesWritable.getBytes(), 0, bytesWritable.getLength());
                if (byteArray.length != expected.length) {
                    TestCase.fail((String)("Byte Array field mismatch (expected " + Arrays.toString(expected) + " found " + Arrays.toString(byteArray) + ")"));
                }
                for (int b = 0; b < byteArray.length; ++b) {
                    if (byteArray[b] == expected[b]) continue;
                    TestCase.fail((String)("Byte Array field mismatch (expected " + Arrays.toString(expected) + " found " + Arrays.toString(byteArray) + ")"));
                }
                break;
            }
            default: {
                throw new Error("Unknown primitive category " + primitiveTypeInfo.getPrimitiveCategory());
            }
        }
    }

    public static void serializeWrite(SerializeWrite serializeWrite, PrimitiveTypeInfo primitiveTypeInfo, Writable writable) throws IOException {
        if (writable == null) {
            serializeWrite.writeNull();
            return;
        }
        switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case BOOLEAN: {
                boolean value = ((BooleanWritable)writable).get();
                serializeWrite.writeBoolean(value);
                break;
            }
            case BYTE: {
                byte value = ((ByteWritable)writable).get();
                serializeWrite.writeByte(value);
                break;
            }
            case SHORT: {
                short value = ((ShortWritable)writable).get();
                serializeWrite.writeShort(value);
                break;
            }
            case INT: {
                int value = ((IntWritable)writable).get();
                serializeWrite.writeInt(value);
                break;
            }
            case LONG: {
                long value = ((LongWritable)writable).get();
                serializeWrite.writeLong(value);
                break;
            }
            case FLOAT: {
                float value = ((FloatWritable)writable).get();
                serializeWrite.writeFloat(value);
                break;
            }
            case DOUBLE: {
                double value = ((DoubleWritable)writable).get();
                serializeWrite.writeDouble(value);
                break;
            }
            case STRING: {
                Text value = (Text)writable;
                byte[] stringBytes = value.getBytes();
                int stringLength = stringBytes.length;
                serializeWrite.writeString(stringBytes, 0, stringLength);
                break;
            }
            case CHAR: {
                HiveChar value = ((HiveCharWritable)writable).getHiveChar();
                serializeWrite.writeHiveChar(value);
                break;
            }
            case VARCHAR: {
                HiveVarchar value = ((HiveVarcharWritable)writable).getHiveVarchar();
                serializeWrite.writeHiveVarchar(value);
                break;
            }
            case DECIMAL: {
                HiveDecimal value = ((HiveDecimalWritable)writable).getHiveDecimal();
                DecimalTypeInfo decTypeInfo = (DecimalTypeInfo)primitiveTypeInfo;
                serializeWrite.writeHiveDecimal(value, decTypeInfo.scale());
                break;
            }
            case DATE: {
                Date value = ((DateWritable)writable).get();
                serializeWrite.writeDate(value);
                break;
            }
            case TIMESTAMP: {
                Timestamp value = ((TimestampWritable)writable).getTimestamp();
                serializeWrite.writeTimestamp(value);
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                HiveIntervalYearMonth value = ((HiveIntervalYearMonthWritable)writable).getHiveIntervalYearMonth();
                serializeWrite.writeHiveIntervalYearMonth(value);
                break;
            }
            case INTERVAL_DAY_TIME: {
                HiveIntervalDayTime value = ((HiveIntervalDayTimeWritable)writable).getHiveIntervalDayTime();
                serializeWrite.writeHiveIntervalDayTime(value);
                break;
            }
            case BINARY: {
                BytesWritable byteWritable = (BytesWritable)writable;
                byte[] binaryBytes = byteWritable.getBytes();
                int length = byteWritable.getLength();
                serializeWrite.writeBinary(binaryBytes, 0, length);
                break;
            }
            default: {
                throw new Error("Unknown primitive category " + primitiveTypeInfo.getPrimitiveCategory().name());
            }
        }
    }
}

