/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CheckFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.CommonFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashSetResult;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorMapJoinFastLongHashSet
extends CommonFastHashTable {
    @Test
    public void testOneKey() throws Exception {
        random = new Random(4186L);
        VectorMapJoinFastLongHashSet map = new VectorMapJoinFastLongHashSet(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastLongHashSet verifyTable = new CheckFastHashTable.VerifyFastLongHashSet();
        long key = random.nextLong();
        map.testPutRow(key);
        verifyTable.add(key);
        verifyTable.verify(map);
        map.testPutRow(key);
        verifyTable.add(key);
        verifyTable.verify(map);
        map.testPutRow(key);
        verifyTable.add(key);
        verifyTable.verify(map);
    }

    @Test
    public void testMultipleKeysSingleValue() throws Exception {
        random = new Random(1412L);
        VectorMapJoinFastLongHashSet map = new VectorMapJoinFastLongHashSet(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastLongHashSet verifyTable = new CheckFastHashTable.VerifyFastLongHashSet();
        int keyCount = 100 + random.nextInt(1000);
        for (int i = 0; i < keyCount; ++i) {
            long key;
            while (verifyTable.contains(key = random.nextLong())) {
            }
            map.testPutRow(key);
            verifyTable.add(key);
        }
        verifyTable.verify(map);
    }

    @Test
    public void testGetNonExistent() throws Exception {
        random = new Random(100L);
        VectorMapJoinFastLongHashSet map = new VectorMapJoinFastLongHashSet(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 0.75f, 128, -1L);
        CheckFastHashTable.VerifyFastLongHashSet verifyTable = new CheckFastHashTable.VerifyFastLongHashSet();
        long key1 = random.nextLong();
        map.testPutRow(key1);
        verifyTable.add(key1);
        verifyTable.verify(map);
        long key2 = ++key1;
        VectorMapJoinHashSetResult hashSetResult = map.createHashSetResult();
        JoinUtil.JoinResult joinResult = map.contains(key2, hashSetResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
        map.testPutRow(key2);
        verifyTable.add(key2);
        verifyTable.verify(map);
        long key3 = ++key2;
        hashSetResult = map.createHashSetResult();
        joinResult = map.contains(key3, hashSetResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
    }

    @Test
    public void testFullMap() throws Exception {
        long anotherKey;
        random = new Random(2520L);
        VectorMapJoinFastLongHashSet map = new VectorMapJoinFastLongHashSet(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 8, 1.0f, 128, -1L);
        CheckFastHashTable.VerifyFastLongHashSet verifyTable = new CheckFastHashTable.VerifyFastLongHashSet();
        for (int i = 0; i < 8; ++i) {
            long key;
            while (verifyTable.contains(key = random.nextLong())) {
            }
            map.testPutRow(key);
            verifyTable.add(key);
        }
        verifyTable.verify(map);
        while (verifyTable.contains(anotherKey = random.nextLong())) {
        }
        VectorMapJoinHashSetResult hashSetResult = map.createHashSetResult();
        JoinUtil.JoinResult joinResult = map.contains(anotherKey, hashSetResult);
        Assert.assertTrue((joinResult == JoinUtil.JoinResult.NOMATCH ? 1 : 0) != 0);
    }

    @Test
    public void testExpand() throws Exception {
        random = new Random(348L);
        VectorMapJoinFastLongHashSet map = new VectorMapJoinFastLongHashSet(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 1, 1.0E-7f, 128, -1L);
        CheckFastHashTable.VerifyFastLongHashSet verifyTable = new CheckFastHashTable.VerifyFastLongHashSet();
        for (int i = 0; i < 18; ++i) {
            long key;
            while (verifyTable.contains(key = random.nextLong())) {
            }
            map.testPutRow(key);
            verifyTable.add(key);
        }
        verifyTable.verify(map);
    }

    public void addAndVerifyMultipleKeyMultipleValue(int keyCount, VectorMapJoinFastLongHashSet map, CheckFastHashTable.VerifyFastLongHashSet verifyTable) throws HiveException, IOException {
        for (int i = 0; i < keyCount; ++i) {
            byte[] value = new byte[TestVectorMapJoinFastLongHashSet.generateLargeCount() - 1];
            random.nextBytes(value);
            if (random.nextBoolean() || verifyTable.getCount() == 0) {
                long key;
                while (verifyTable.contains(key = random.nextLong())) {
                }
                map.testPutRow(key);
                verifyTable.add(key);
                verifyTable.verify(map);
            } else {
                long randomExistingKey = verifyTable.addRandomExisting(value, random);
                map.testPutRow(randomExistingKey);
            }
            verifyTable.verify(map);
        }
    }

    @Test
    public void testMultipleKeysMultipleValue() throws Exception {
        random = new Random(7778L);
        VectorMapJoinFastLongHashSet map = new VectorMapJoinFastLongHashSet(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 0x800000, 0.75f, 0x100000, -1L);
        CheckFastHashTable.VerifyFastLongHashSet verifyTable = new CheckFastHashTable.VerifyFastLongHashSet();
        int keyCount = 1000;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }

    @Test
    public void testLargeAndExpand() throws Exception {
        random = new Random(56L);
        VectorMapJoinFastLongHashSet map = new VectorMapJoinFastLongHashSet(false, false, VectorMapJoinDesc.HashTableKeyType.LONG, 512, 0.75f, 8192, -1L);
        CheckFastHashTable.VerifyFastLongHashSet verifyTable = new CheckFastHashTable.VerifyFastLongHashSet();
        int keyCount = 1000;
        this.addAndVerifyMultipleKeyMultipleValue(keyCount, map, verifyTable);
    }
}

