/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ColAndCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ColOrCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DoubleColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterExprAndExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.FilterExprOrExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IsNotNull;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IsNull;
import org.apache.hadoop.hive.ql.exec.vector.expressions.LongColumnInList;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NotCol;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsFalse;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsNotNull;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsNull;
import org.apache.hadoop.hive.ql.exec.vector.expressions.SelectColumnIsTrue;
import org.apache.hadoop.hive.ql.exec.vector.expressions.TestVectorMathFunctions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.junit.Assert;
import org.junit.Test;

public class TestVectorLogicalExpressions {
    private static final int BOOLEAN_COLUMN_TEST_SIZE = 9;

    @Test
    public void testLongColOrLongCol() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        ColOrCol expr = new ColOrCol(0, 1, 2);
        LongColumnVector outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertEquals((long)1L, (long)outCol.vector[1]);
        Assert.assertEquals((long)1L, (long)outCol.vector[2]);
        Assert.assertEquals((long)1L, (long)outCol.vector[3]);
        Assert.assertFalse((boolean)outCol.isNull[3]);
        Assert.assertTrue((boolean)outCol.isNull[4]);
        Assert.assertEquals((long)1L, (long)outCol.vector[5]);
        Assert.assertTrue((boolean)outCol.isNull[6]);
        Assert.assertEquals((long)1L, (long)outCol.vector[7]);
        Assert.assertTrue((boolean)outCol.isNull[8]);
        Assert.assertEquals((long)batch.size, (long)9L);
        Assert.assertFalse((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].noNulls = true;
        batch.cols[1].noNulls = true;
        batch.cols[2].noNulls = false;
        outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertEquals((long)1L, (long)outCol.vector[1]);
        Assert.assertEquals((long)1L, (long)outCol.vector[2]);
        Assert.assertEquals((long)1L, (long)outCol.vector[3]);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].noNulls = true;
        batch.cols[0].isRepeating = true;
        batch.cols[1].noNulls = true;
        batch.cols[1].isRepeating = false;
        batch.cols[2].noNulls = false;
        batch.cols[2].isRepeating = true;
        outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertEquals((long)1L, (long)outCol.vector[1]);
        Assert.assertEquals((long)0L, (long)outCol.vector[2]);
        Assert.assertEquals((long)1L, (long)outCol.vector[3]);
    }

    @Test
    public void testLongColAndLongCol() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        ColAndCol expr = new ColAndCol(0, 1, 2);
        LongColumnVector outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertEquals((long)0L, (long)outCol.vector[1]);
        Assert.assertEquals((long)0L, (long)outCol.vector[2]);
        Assert.assertEquals((long)1L, (long)outCol.vector[3]);
        Assert.assertEquals((long)0L, (long)outCol.vector[4]);
        Assert.assertFalse((boolean)outCol.isNull[4]);
        Assert.assertTrue((boolean)outCol.isNull[5]);
        Assert.assertEquals((long)0L, (long)outCol.vector[6]);
        Assert.assertFalse((boolean)outCol.isNull[6]);
        Assert.assertTrue((boolean)outCol.isNull[7]);
        Assert.assertTrue((boolean)outCol.isNull[8]);
        Assert.assertEquals((long)batch.size, (long)9L);
        Assert.assertFalse((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].noNulls = true;
        batch.cols[1].noNulls = true;
        batch.cols[2].noNulls = false;
        outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertEquals((long)0L, (long)outCol.vector[1]);
        Assert.assertEquals((long)0L, (long)outCol.vector[2]);
        Assert.assertEquals((long)1L, (long)outCol.vector[3]);
        batch = this.getBatchThreeBooleanCols();
        ((LongColumnVector)batch.cols[0]).vector[0] = 1L;
        batch.cols[0].noNulls = true;
        batch.cols[0].isRepeating = true;
        batch.cols[1].noNulls = true;
        batch.cols[1].isRepeating = false;
        batch.cols[2].noNulls = false;
        batch.cols[2].isRepeating = true;
        outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertEquals((long)1L, (long)outCol.vector[1]);
        Assert.assertEquals((long)0L, (long)outCol.vector[2]);
        Assert.assertEquals((long)1L, (long)outCol.vector[3]);
    }

    private VectorizedRowBatch getBatchThreeBooleanCols() {
        VectorizedRowBatch batch = new VectorizedRowBatch(3, 1024);
        LongColumnVector v0 = new LongColumnVector(1024);
        LongColumnVector v1 = new LongColumnVector(1024);
        LongColumnVector v2 = new LongColumnVector(1024);
        batch.cols[0] = v0;
        batch.cols[1] = v1;
        batch.cols[2] = v2;
        int i = 0;
        v0.vector[i] = 0L;
        v0.isNull[i] = false;
        v1.vector[i] = 0L;
        v1.isNull[i] = false;
        i = 1;
        v0.vector[i] = 0L;
        v0.isNull[i] = false;
        v1.vector[i] = 1L;
        v1.isNull[i] = false;
        i = 2;
        v0.vector[i] = 1L;
        v0.isNull[i] = false;
        v1.vector[i] = 0L;
        v1.isNull[i] = false;
        i = 3;
        v0.vector[i] = 1L;
        v0.isNull[i] = false;
        v1.vector[i] = 1L;
        v1.isNull[i] = false;
        i = 4;
        v0.vector[i] = 0L;
        v0.isNull[i] = true;
        v1.vector[i] = 0L;
        v1.isNull[i] = false;
        i = 5;
        v0.vector[i] = 0L;
        v0.isNull[i] = true;
        v1.vector[i] = 1L;
        v1.isNull[i] = false;
        i = 6;
        v0.vector[i] = 0L;
        v0.isNull[i] = false;
        v1.vector[i] = 0L;
        v1.isNull[i] = true;
        i = 7;
        v0.vector[i] = 1L;
        v0.isNull[i] = false;
        v1.vector[i] = 1L;
        v1.isNull[i] = true;
        i = 8;
        v0.vector[i] = 1L;
        v0.isNull[i] = true;
        v1.vector[i] = 1L;
        v1.isNull[i] = true;
        v0.noNulls = false;
        v1.noNulls = false;
        v0.isRepeating = false;
        v1.isRepeating = false;
        v2.isRepeating = true;
        v2.noNulls = true;
        batch.size = 9;
        return batch;
    }

    @Test
    public void testBooleanNot() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        NotCol expr = new NotCol(0, 2);
        LongColumnVector outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertEquals((long)1L, (long)outCol.vector[0]);
        Assert.assertFalse((boolean)outCol.isNull[0]);
        Assert.assertEquals((long)0L, (long)outCol.vector[2]);
        Assert.assertFalse((boolean)outCol.isNull[0]);
        Assert.assertTrue((boolean)outCol.isNull[4]);
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertFalse((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)1L, (long)outCol.vector[0]);
        Assert.assertEquals((long)0L, (long)outCol.vector[2]);
        batch = this.getBatchThreeBooleanCols();
        outCol = (LongColumnVector)batch.cols[2];
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.isNull[0]);
        batch = this.getBatchThreeBooleanCols();
        outCol = (LongColumnVector)batch.cols[2];
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)1L, (long)outCol.vector[0]);
    }

    @Test
    public void testIsNullExpr() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        IsNull expr = new IsNull(0, 2);
        LongColumnVector outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertEquals((long)1L, (long)outCol.vector[4]);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        batch = this.getBatchThreeBooleanCols();
        outCol = (LongColumnVector)batch.cols[2];
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertEquals((long)1L, (long)outCol.vector[0]);
        Assert.assertTrue((boolean)outCol.noNulls);
        batch = this.getBatchThreeBooleanCols();
        outCol = (LongColumnVector)batch.cols[2];
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
    }

    @Test
    public void testIsNotNullExpr() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        IsNotNull expr = new IsNotNull(0, 2);
        LongColumnVector outCol = (LongColumnVector)batch.cols[2];
        expr.evaluate(batch);
        Assert.assertEquals((long)1L, (long)outCol.vector[0]);
        Assert.assertEquals((long)0L, (long)outCol.vector[4]);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertFalse((boolean)outCol.isRepeating);
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)1L, (long)outCol.vector[0]);
        batch = this.getBatchThreeBooleanCols();
        outCol = (LongColumnVector)batch.cols[2];
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertEquals((long)0L, (long)outCol.vector[0]);
        Assert.assertTrue((boolean)outCol.noNulls);
        batch = this.getBatchThreeBooleanCols();
        outCol = (LongColumnVector)batch.cols[2];
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertTrue((boolean)outCol.isRepeating);
        Assert.assertTrue((boolean)outCol.noNulls);
        Assert.assertEquals((long)1L, (long)outCol.vector[0]);
    }

    @Test
    public void testBooleanFiltersOnColumns() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        SelectColumnIsTrue expr = new SelectColumnIsTrue(0);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((long)2L, (long)batch.selected[0]);
        Assert.assertEquals((long)3L, (long)batch.selected[1]);
        Assert.assertEquals((long)7L, (long)batch.selected[2]);
        batch = this.getBatchThreeBooleanCols();
        SelectColumnIsFalse expr1 = new SelectColumnIsFalse(1);
        expr1.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((long)0L, (long)batch.selected[0]);
        Assert.assertEquals((long)2L, (long)batch.selected[1]);
        Assert.assertEquals((long)4L, (long)batch.selected[2]);
    }

    @Test
    public void testSelectColumnIsNull() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        SelectColumnIsNull expr = new SelectColumnIsNull(0);
        expr.evaluate(batch);
        Assert.assertEquals((long)3L, (long)batch.size);
        Assert.assertEquals((long)4L, (long)batch.selected[0]);
        Assert.assertEquals((long)5L, (long)batch.selected[1]);
        Assert.assertEquals((long)8L, (long)batch.selected[2]);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)batch.size);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        int initialSize = batch.size;
        expr.evaluate(batch);
        Assert.assertEquals((long)initialSize, (long)batch.size);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)batch.size);
    }

    @Test
    public void testSelectColumnIsNotNull() {
        VectorizedRowBatch batch = this.getBatchThreeBooleanCols();
        SelectColumnIsNotNull expr = new SelectColumnIsNotNull(0);
        expr.evaluate(batch);
        Assert.assertEquals((long)6L, (long)batch.size);
        Assert.assertEquals((long)0L, (long)batch.selected[0]);
        Assert.assertEquals((long)1L, (long)batch.selected[1]);
        Assert.assertEquals((long)2L, (long)batch.selected[2]);
        Assert.assertEquals((long)3L, (long)batch.selected[3]);
        Assert.assertEquals((long)6L, (long)batch.selected[4]);
        Assert.assertEquals((long)7L, (long)batch.selected[5]);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].noNulls = true;
        int initialSize = batch.size;
        expr.evaluate(batch);
        Assert.assertEquals((long)initialSize, (long)batch.size);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].isRepeating = true;
        batch.cols[0].isNull[0] = true;
        expr.evaluate(batch);
        Assert.assertEquals((long)0L, (long)batch.size);
        batch = this.getBatchThreeBooleanCols();
        batch.cols[0].isRepeating = true;
        batch.cols[0].noNulls = true;
        initialSize = batch.size;
        expr.evaluate(batch);
        Assert.assertEquals((long)initialSize, (long)batch.size);
    }

    @Test
    public void testFilterExprOrExpr() {
        VectorizedRowBatch batch1 = this.getBatchThreeBooleanCols();
        VectorizedRowBatch batch2 = this.getBatchThreeBooleanCols();
        SelectColumnIsTrue expr1 = new SelectColumnIsTrue(0);
        SelectColumnIsFalse expr2 = new SelectColumnIsFalse(1);
        FilterExprOrExpr orExpr = new FilterExprOrExpr();
        orExpr.setChildExpressions(new VectorExpression[]{expr1, expr2});
        orExpr.evaluate(batch1);
        orExpr.evaluate(batch2);
        Assert.assertEquals((long)batch1.size, (long)batch2.size);
        int j = 0;
        while (j < batch1.size) {
            Assert.assertEquals((long)batch1.selected[j], (long)batch2.selected[j]);
            int i = j++;
            Assert.assertEquals((long)((LongColumnVector)batch1.cols[0]).vector[i], (long)((LongColumnVector)batch2.cols[0]).vector[i]);
        }
        Assert.assertEquals((long)5L, (long)batch1.size);
        Assert.assertEquals((long)0L, (long)batch1.selected[0]);
        Assert.assertEquals((long)2L, (long)batch1.selected[1]);
        Assert.assertEquals((long)3L, (long)batch1.selected[2]);
        Assert.assertEquals((long)4L, (long)batch1.selected[3]);
        Assert.assertEquals((long)7L, (long)batch1.selected[4]);
        orExpr.evaluate(batch1);
        Assert.assertEquals((long)5L, (long)batch1.size);
        Assert.assertEquals((long)0L, (long)batch1.selected[0]);
        Assert.assertEquals((long)2L, (long)batch1.selected[1]);
        Assert.assertEquals((long)3L, (long)batch1.selected[2]);
        Assert.assertEquals((long)4L, (long)batch1.selected[3]);
        Assert.assertEquals((long)7L, (long)batch1.selected[4]);
    }

    @Test
    public void testFilterExprMultiOrExpr() {
        VectorizedRowBatch batch1a = this.getBatchThreeBooleanCols();
        SelectColumnAll expr1a = new SelectColumnAll(0);
        SelectColumnNotExpected expr2a = new SelectColumnNotExpected(1);
        SelectColumnNotExpected expr3a = new SelectColumnNotExpected(1);
        FilterExprOrExpr orExpr = new FilterExprOrExpr();
        orExpr.setChildExpressions(new VectorExpression[]{expr1a, expr2a, expr3a});
        orExpr.evaluate(batch1a);
        Assert.assertEquals((long)9L, (long)batch1a.size);
        for (int i = 0; i < 9; ++i) {
            Assert.assertEquals((long)i, (long)batch1a.selected[i]);
        }
        VectorizedRowBatch batch1b = this.getBatchThreeBooleanCols();
        SelectColumnIsNotNull expr1b = new SelectColumnIsNotNull(0);
        SelectColumnIsNull expr2b = new SelectColumnIsNull(0);
        SelectColumnNotExpected expr3b = new SelectColumnNotExpected(0);
        FilterExprOrExpr orExpr2 = new FilterExprOrExpr();
        orExpr2.setChildExpressions(new VectorExpression[]{expr1b, expr2b, expr3b});
        orExpr2.evaluate(batch1b);
        Assert.assertEquals((long)9L, (long)batch1b.size);
        for (int i = 0; i < 9; ++i) {
            Assert.assertEquals((long)i, (long)batch1b.selected[i]);
        }
        VectorizedRowBatch batch1c = this.getBatchThreeBooleanCols();
        SelectColumnIsNotNull expr1c = new SelectColumnIsNotNull(0);
        SelectColumnNothing expr2c = new SelectColumnNothing(0);
        SelectColumnIsNull expr3c = new SelectColumnIsNull(0);
        SelectColumnNotExpected expr4c = new SelectColumnNotExpected(0);
        FilterExprOrExpr orExpr3 = new FilterExprOrExpr();
        orExpr3.setChildExpressions(new VectorExpression[]{expr1c, expr2c, expr3c, expr4c});
        orExpr3.evaluate(batch1c);
        Assert.assertEquals((long)9L, (long)batch1c.size);
        for (int i = 0; i < 9; ++i) {
            Assert.assertEquals((long)i, (long)batch1c.selected[i]);
        }
        VectorizedRowBatch batch1d = this.getBatchThreeBooleanCols();
        SelectColumnIsTrue expr1d = new SelectColumnIsTrue(0);
        SelectColumnNothing expr2d = new SelectColumnNothing(0);
        SelectColumnNothing expr3d = new SelectColumnNothing(0);
        FilterExprOrExpr orExpr4 = new FilterExprOrExpr();
        orExpr4.setChildExpressions(new VectorExpression[]{expr1d, expr3d, expr3d});
        orExpr4.evaluate(batch1d);
        int[] expected4 = new int[]{2, 3, 7};
        Assert.assertEquals((long)expected4.length, (long)batch1d.size);
        for (int i = 0; i < expected4.length; ++i) {
            Assert.assertEquals((long)expected4[i], (long)batch1d.selected[i]);
        }
        VectorizedRowBatch batch1e = this.getBatchThreeBooleanCols();
        SelectColumnNothing expr1e = new SelectColumnNothing(0);
        SelectColumnNothing expr2e = new SelectColumnNothing(0);
        SelectColumnNothing expr3e = new SelectColumnNothing(0);
        FilterExprOrExpr orExpr5 = new FilterExprOrExpr();
        orExpr5.setChildExpressions(new VectorExpression[]{expr1e, expr2e, expr3e});
        orExpr5.evaluate(batch1e);
        Assert.assertEquals((long)0L, (long)batch1e.size);
        VectorizedRowBatch batch1f = this.getBatchThreeBooleanCols();
        SelectColumnOne expr1f = new SelectColumnOne(0, 4);
        SelectColumnNothing expr2f = new SelectColumnNothing(0);
        SelectColumnNothing expr3f = new SelectColumnNothing(0);
        FilterExprOrExpr orExpr6 = new FilterExprOrExpr();
        orExpr6.setChildExpressions(new VectorExpression[]{expr1f, expr2f, expr3f});
        orExpr6.evaluate(batch1f);
        Assert.assertEquals((long)1L, (long)batch1f.size);
        Assert.assertEquals((long)4L, (long)batch1f.selected[0]);
        VectorizedRowBatch batch1g = this.getBatchThreeBooleanCols();
        SelectColumnNothing expr1g = new SelectColumnNothing(0);
        SelectColumnOne expr2g = new SelectColumnOne(0, 2);
        SelectColumnNothing expr3g = new SelectColumnNothing(0);
        FilterExprOrExpr orExpr7 = new FilterExprOrExpr();
        orExpr7.setChildExpressions(new VectorExpression[]{expr1g, expr2g, expr3g});
        orExpr7.evaluate(batch1g);
        Assert.assertEquals((long)1L, (long)batch1g.size);
        Assert.assertEquals((long)2L, (long)batch1g.selected[0]);
    }

    @Test
    public void testFilterExprOrExprWithBatchReuse() {
        VectorizedRowBatch batch1 = this.getBatchThreeBooleanCols();
        SelectColumnIsTrue expr1 = new SelectColumnIsTrue(0);
        SelectColumnIsFalse expr2 = new SelectColumnIsFalse(1);
        FilterExprOrExpr orExpr = new FilterExprOrExpr();
        orExpr.setChildExpressions(new VectorExpression[]{expr1, expr2});
        orExpr.evaluate(batch1);
        for (int i = 0; i < 1024; ++i) {
            batch1.selected[i] = 0;
        }
        batch1.size = 9;
        batch1.selectedInUse = false;
        ColumnVector tmp = batch1.cols[0];
        batch1.cols[0] = batch1.cols[1];
        batch1.cols[1] = tmp;
        orExpr.evaluate(batch1);
        Assert.assertEquals((long)5L, (long)batch1.size);
        Assert.assertEquals((long)0L, (long)batch1.selected[0]);
        Assert.assertEquals((long)1L, (long)batch1.selected[1]);
        Assert.assertEquals((long)3L, (long)batch1.selected[2]);
        Assert.assertEquals((long)5L, (long)batch1.selected[3]);
        Assert.assertEquals((long)6L, (long)batch1.selected[4]);
    }

    @Test
    public void testFilterExprOrExprWithSelectInUse() {
        VectorizedRowBatch batch1 = this.getBatchThreeBooleanCols();
        SelectColumnIsTrue expr1 = new SelectColumnIsTrue(0);
        SelectColumnIsFalse expr2 = new SelectColumnIsFalse(1);
        FilterExprOrExpr orExpr = new FilterExprOrExpr();
        orExpr.setChildExpressions(new VectorExpression[]{expr1, expr2});
        orExpr.evaluate(batch1);
        ColumnVector tmp = batch1.cols[0];
        batch1.cols[0] = batch1.cols[1];
        batch1.cols[1] = tmp;
        batch1.cols[1].isNull[7] = false;
        ((LongColumnVector)batch1.cols[1]).vector[7] = 0L;
        orExpr.evaluate(batch1);
        Assert.assertEquals((long)3L, (long)batch1.size);
        Assert.assertEquals((long)0L, (long)batch1.selected[0]);
        Assert.assertEquals((long)3L, (long)batch1.selected[1]);
        Assert.assertEquals((long)7L, (long)batch1.selected[2]);
    }

    @Test
    public void testFilterExprAndExpr() {
        VectorizedRowBatch batch1 = this.getBatchThreeBooleanCols();
        SelectColumnIsTrue expr1 = new SelectColumnIsTrue(0);
        SelectColumnIsFalse expr2 = new SelectColumnIsFalse(1);
        FilterExprAndExpr andExpr = new FilterExprAndExpr();
        andExpr.setChildExpressions(new VectorExpression[]{expr1, expr2});
        andExpr.evaluate(batch1);
        Assert.assertEquals((long)1L, (long)batch1.size);
        Assert.assertEquals((long)2L, (long)batch1.selected[0]);
    }

    @Test
    public void testLongInExpr() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchLongInLongOut();
        LongColumnVector outV = (LongColumnVector)b.cols[1];
        long[] inVals = new long[]{0L, -2L};
        LongColumnInList expr = new LongColumnInList(0, 1);
        expr.setInListValues(inVals);
        expr.evaluate(b);
        Assert.assertEquals((long)1L, (long)outV.vector[0]);
        Assert.assertEquals((long)0L, (long)outV.vector[1]);
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        expr.evaluate(b);
        Assert.assertEquals((Object)true, (Object)(!outV.noNulls && outV.isNull[0] ? 1 : 0));
        Assert.assertEquals((long)0L, (long)outV.vector[1]);
        b = TestVectorMathFunctions.getVectorizedRowBatchLongInLongOut();
        outV = (LongColumnVector)b.cols[1];
        b.cols[0].isRepeating = true;
        expr.evaluate(b);
        Assert.assertEquals((Object)true, (Object)outV.isRepeating);
        Assert.assertEquals((long)1L, (long)outV.vector[0]);
    }

    @Test
    public void testDoubleInExpr() {
        VectorizedRowBatch b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInLongOut();
        LongColumnVector outV = (LongColumnVector)b.cols[1];
        double[] inVals = new double[]{-1.5, 30.0};
        b.size = 2;
        DoubleColumnInList expr = new DoubleColumnInList(0, 1);
        expr.setInListValues(inVals);
        expr.evaluate(b);
        Assert.assertEquals((long)1L, (long)outV.vector[0]);
        Assert.assertEquals((long)0L, (long)outV.vector[1]);
        b.cols[0].noNulls = false;
        b.cols[0].isNull[0] = true;
        expr.evaluate(b);
        Assert.assertEquals((Object)true, (Object)(!outV.noNulls && outV.isNull[0] ? 1 : 0));
        Assert.assertEquals((long)0L, (long)outV.vector[1]);
        b = TestVectorMathFunctions.getVectorizedRowBatchDoubleInLongOut();
        outV = (LongColumnVector)b.cols[1];
        b.cols[0].isRepeating = true;
        expr.evaluate(b);
        Assert.assertEquals((Object)true, (Object)outV.isRepeating);
        Assert.assertEquals((long)1L, (long)outV.vector[0]);
    }

    public class SelectColumnOne
    extends VectorExpression {
        private static final long serialVersionUID = 1L;
        private int colNum1;
        private int batchIndex;

        public SelectColumnOne(int colNum1, int batchIndex) {
            this();
            this.colNum1 = colNum1;
            this.batchIndex = batchIndex;
        }

        public SelectColumnOne() {
        }

        public void evaluate(VectorizedRowBatch batch) {
            if (this.childExpressions != null) {
                super.evaluateChildren(batch);
            }
            batch.selected[0] = this.batchIndex;
            batch.size = 1;
        }

        public int getOutputColumn() {
            return 0;
        }

        public VectorExpressionDescriptor.Descriptor getDescriptor() {
            return null;
        }
    }

    public class SelectColumnNothing
    extends VectorExpression {
        private static final long serialVersionUID = 1L;
        private int colNum1;

        public SelectColumnNothing(int colNum1) {
            this();
            this.colNum1 = colNum1;
        }

        public SelectColumnNothing() {
        }

        public void evaluate(VectorizedRowBatch batch) {
            if (this.childExpressions != null) {
                super.evaluateChildren(batch);
            }
            batch.size = 0;
        }

        public int getOutputColumn() {
            return 0;
        }

        public VectorExpressionDescriptor.Descriptor getDescriptor() {
            return null;
        }
    }

    public class SelectColumnNotExpected
    extends VectorExpression {
        private static final long serialVersionUID = 1L;
        private int colNum1;

        public SelectColumnNotExpected(int colNum1) {
            this();
            this.colNum1 = colNum1;
        }

        public SelectColumnNotExpected() {
        }

        public void evaluate(VectorizedRowBatch batch) {
            if (this.childExpressions != null) {
                super.evaluateChildren(batch);
            }
            Assert.assertFalse((boolean)true);
        }

        public int getOutputColumn() {
            return 0;
        }

        public VectorExpressionDescriptor.Descriptor getDescriptor() {
            return null;
        }
    }

    public class SelectColumnAll
    extends VectorExpression {
        private static final long serialVersionUID = 1L;
        private int colNum1;

        public SelectColumnAll(int colNum1) {
            this();
            this.colNum1 = colNum1;
        }

        public SelectColumnAll() {
        }

        public void evaluate(VectorizedRowBatch batch) {
            if (this.childExpressions != null) {
                super.evaluateChildren(batch);
            }
        }

        public int getOutputColumn() {
            return 0;
        }

        public VectorExpressionDescriptor.Descriptor getDescriptor() {
            return null;
        }
    }
}

