/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Random;
import junit.framework.Assert;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.exec.vector.util.VectorizedRowGroupGenUtil;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.junit.Test;

public class TestVectorExpressionWriters {
    private final int vectorSize = 5;

    private VectorExpressionWriter getWriter(TypeInfo colTypeInfo) throws HiveException {
        ExprNodeColumnDesc columnDesc = new ExprNodeColumnDesc();
        columnDesc.setTypeInfo(colTypeInfo);
        VectorExpressionWriter vew = VectorExpressionWriterFactory.genVectorExpressionWritable((ExprNodeDesc)columnDesc);
        return vew;
    }

    private Writable getWritableValue(TypeInfo ti, double value) {
        if (ti.equals((Object)TypeInfoFactory.floatTypeInfo)) {
            return new FloatWritable((float)value);
        }
        if (ti.equals((Object)TypeInfoFactory.doubleTypeInfo)) {
            return new DoubleWritable(value);
        }
        return null;
    }

    private Writable getWritableValue(TypeInfo ti, Timestamp value) {
        return new TimestampWritable(value);
    }

    private Writable getWritableValue(TypeInfo ti, HiveDecimal value) {
        return new HiveDecimalWritable(value);
    }

    private Writable getWritableValue(TypeInfo ti, byte[] value) {
        if (ti.equals((Object)TypeInfoFactory.stringTypeInfo)) {
            return new Text(value);
        }
        if (ti.equals((Object)TypeInfoFactory.varcharTypeInfo)) {
            return new HiveVarcharWritable(new HiveVarchar(new Text(value).toString(), -1));
        }
        if (ti.equals((Object)TypeInfoFactory.binaryTypeInfo)) {
            return new BytesWritable(value);
        }
        return null;
    }

    private Writable getWritableValue(TypeInfo ti, long value) {
        if (ti.equals((Object)TypeInfoFactory.byteTypeInfo)) {
            return new ByteWritable((byte)value);
        }
        if (ti.equals((Object)TypeInfoFactory.shortTypeInfo)) {
            return new ShortWritable((short)value);
        }
        if (ti.equals((Object)TypeInfoFactory.intTypeInfo)) {
            return new IntWritable((int)value);
        }
        if (ti.equals((Object)TypeInfoFactory.longTypeInfo)) {
            return new LongWritable(value);
        }
        if (ti.equals((Object)TypeInfoFactory.booleanTypeInfo)) {
            return new BooleanWritable(value != 0L);
        }
        if (ti.equals((Object)TypeInfoFactory.timestampTypeInfo)) {
            Timestamp ts = new Timestamp(value);
            TimestampWritable tw = new TimestampWritable(ts);
            return tw;
        }
        return null;
    }

    private void testWriterDouble(TypeInfo type) throws HiveException {
        DoubleColumnVector dcv = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, this.vectorSize, new Random(10L));
        dcv.isNull[2] = true;
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            Writable w = (Writable)vew.writeValue((ColumnVector)dcv, i);
            if (w != null) {
                Writable expected = this.getWritableValue(type, dcv.vector[i]);
                Assert.assertEquals((Object)expected, (Object)w);
                continue;
            }
            Assert.assertTrue((boolean)dcv.isNull[i]);
        }
    }

    private void testSetterDouble(TypeInfo type) throws HiveException {
        DoubleColumnVector dcv = VectorizedRowGroupGenUtil.generateDoubleColumnVector(true, false, this.vectorSize, new Random(10L));
        dcv.isNull[2] = true;
        Object[] values = new Object[this.vectorSize];
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            values[i] = null;
            values[i] = vew.setValue(values[i], (ColumnVector)dcv, i);
            if (values[i] != null) {
                Writable expected = this.getWritableValue(type, dcv.vector[i]);
                Assert.assertEquals((Object)expected, (Object)values[i]);
                continue;
            }
            Assert.assertTrue((boolean)dcv.isNull[i]);
        }
    }

    private void testWriterDecimal(DecimalTypeInfo type) throws HiveException {
        DecimalColumnVector dcv = VectorizedRowGroupGenUtil.generateDecimalColumnVector(type, true, false, this.vectorSize, new Random(10L));
        dcv.isNull[2] = true;
        VectorExpressionWriter vew = this.getWriter((TypeInfo)type);
        for (int i = 0; i < 5; ++i) {
            Writable w = (Writable)vew.writeValue((ColumnVector)dcv, i);
            if (w != null) {
                Writable expected = this.getWritableValue((TypeInfo)type, dcv.vector[i].getHiveDecimal());
                Assert.assertEquals((Object)expected, (Object)w);
                continue;
            }
            Assert.assertTrue((boolean)dcv.isNull[i]);
        }
    }

    private void testSetterDecimal(DecimalTypeInfo type) throws HiveException {
        DecimalColumnVector dcv = VectorizedRowGroupGenUtil.generateDecimalColumnVector(type, true, false, this.vectorSize, new Random(10L));
        dcv.isNull[2] = true;
        Object[] values = new Object[this.vectorSize];
        VectorExpressionWriter vew = this.getWriter((TypeInfo)type);
        for (int i = 0; i < 5; ++i) {
            values[i] = null;
            values[i] = vew.setValue(values[i], (ColumnVector)dcv, i);
            if (values[i] != null) {
                Writable expected = this.getWritableValue((TypeInfo)type, dcv.vector[i].getHiveDecimal());
                Assert.assertEquals((Object)expected, (Object)values[i]);
                continue;
            }
            Assert.assertTrue((boolean)dcv.isNull[i]);
        }
    }

    private void testWriterLong(TypeInfo type) throws HiveException {
        LongColumnVector lcv = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 5, new Random(10L));
        lcv.isNull[3] = true;
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            Writable w = (Writable)vew.writeValue((ColumnVector)lcv, i);
            if (w != null) {
                Writable expected = this.getWritableValue(type, lcv.vector[i]);
                Assert.assertEquals((Object)expected, (Object)w);
                continue;
            }
            Assert.assertTrue((boolean)lcv.isNull[i]);
        }
    }

    private void testSetterLong(TypeInfo type) throws HiveException {
        LongColumnVector lcv = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 5, new Random(10L));
        lcv.isNull[3] = true;
        Object[] values = new Object[this.vectorSize];
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            values[i] = null;
            values[i] = vew.setValue(values[i], (ColumnVector)lcv, i);
            if (values[i] != null) {
                Writable expected = this.getWritableValue(type, lcv.vector[i]);
                Assert.assertEquals((Object)expected, (Object)values[i]);
                continue;
            }
            Assert.assertTrue((boolean)lcv.isNull[i]);
        }
    }

    private void testWriterTimestamp(TypeInfo type) throws HiveException {
        Timestamp[] timestampValues = new Timestamp[5];
        TimestampColumnVector tcv = VectorizedRowGroupGenUtil.generateTimestampColumnVector(true, false, 5, new Random(10L), timestampValues);
        tcv.isNull[3] = true;
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            Writable w = (Writable)vew.writeValue((ColumnVector)tcv, i);
            if (w != null) {
                Writable expected = this.getWritableValue(type, timestampValues[i]);
                TimestampWritable t1 = (TimestampWritable)expected;
                TimestampWritable t2 = (TimestampWritable)w;
                Assert.assertTrue((boolean)t1.equals((Object)t2));
                continue;
            }
            Assert.assertTrue((boolean)tcv.isNull[i]);
        }
    }

    private void testSetterTimestamp(TypeInfo type) throws HiveException {
        Timestamp[] timestampValues = new Timestamp[5];
        TimestampColumnVector tcv = VectorizedRowGroupGenUtil.generateTimestampColumnVector(true, false, 5, new Random(10L), timestampValues);
        tcv.isNull[3] = true;
        Object[] values = new Object[this.vectorSize];
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            values[i] = null;
            values[i] = vew.setValue(values[i], (ColumnVector)tcv, i);
            if (values[i] != null) {
                Writable expected = this.getWritableValue(type, timestampValues[i]);
                TimestampWritable t1 = (TimestampWritable)expected;
                TimestampWritable t2 = (TimestampWritable)values[i];
                Assert.assertTrue((boolean)t1.equals((Object)t2));
                continue;
            }
            Assert.assertTrue((boolean)tcv.isNull[i]);
        }
    }

    private StructObjectInspector genStructOI() {
        ArrayList<String> fieldNames1 = new ArrayList<String>();
        fieldNames1.add("theInt");
        fieldNames1.add("theBool");
        ArrayList<Object> fieldObjectInspectors1 = new ArrayList<Object>();
        fieldObjectInspectors1.add(PrimitiveObjectInspectorFactory.writableIntObjectInspector);
        fieldObjectInspectors1.add(PrimitiveObjectInspectorFactory.writableBooleanObjectInspector);
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames1, fieldObjectInspectors1);
    }

    private void testStructLong(TypeInfo type) throws HiveException {
        LongColumnVector icv = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 5, new Random(10L));
        icv.isNull[3] = true;
        LongColumnVector bcv = VectorizedRowGroupGenUtil.generateLongColumnVector(true, false, 5, new Random(10L));
        bcv.isNull[2] = true;
        ArrayList[] values = new ArrayList[this.vectorSize];
        StructObjectInspector soi = this.genStructOI();
        VectorExpressionWriter[] vew = VectorExpressionWriterFactory.getExpressionWriters((StructObjectInspector)soi);
        for (int i = 0; i < 5; ++i) {
            values[i] = new ArrayList(2);
            values[i].add(null);
            values[i].add(null);
            vew[0].setValue((Object)values[i], (ColumnVector)icv, i);
            vew[1].setValue((Object)values[i], (ColumnVector)bcv, i);
            Object theInt = values[i].get(0);
            if (theInt == null) {
                Assert.assertTrue((boolean)icv.isNull[i]);
            } else {
                IntWritable w = (IntWritable)theInt;
                Assert.assertEquals((int)((int)icv.vector[i]), (int)w.get());
            }
            Object theBool = values[i].get(1);
            if (theBool == null) {
                Assert.assertTrue((boolean)bcv.isNull[i]);
                continue;
            }
            BooleanWritable w = (BooleanWritable)theBool;
            Assert.assertEquals((bcv.vector[i] != 0L ? 1 : 0) != 0, (boolean)w.get());
        }
    }

    private void testWriterText(TypeInfo type) throws HiveException {
        Text t1 = new Text("alpha");
        Text t2 = new Text("beta");
        BytesColumnVector bcv = new BytesColumnVector(5);
        bcv.noNulls = false;
        bcv.initBuffer();
        bcv.setVal(0, t1.getBytes(), 0, t1.getLength());
        bcv.isNull[1] = true;
        bcv.setVal(2, t2.getBytes(), 0, t2.getLength());
        bcv.isNull[3] = true;
        bcv.setVal(4, t1.getBytes(), 0, t1.getLength());
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            Writable w = (Writable)vew.writeValue((ColumnVector)bcv, i);
            if (w != null) {
                byte[] val = new byte[bcv.length[i]];
                System.arraycopy(bcv.vector[i], bcv.start[i], val, 0, bcv.length[i]);
                Writable expected = this.getWritableValue(type, val);
                Assert.assertEquals((Object)expected, (Object)w);
                continue;
            }
            Assert.assertTrue((boolean)bcv.isNull[i]);
        }
    }

    private void testSetterText(TypeInfo type) throws HiveException {
        Text t1 = new Text("alpha");
        Text t2 = new Text("beta");
        BytesColumnVector bcv = new BytesColumnVector(5);
        bcv.noNulls = false;
        bcv.initBuffer();
        bcv.setVal(0, t1.getBytes(), 0, t1.getLength());
        bcv.isNull[1] = true;
        bcv.setVal(2, t2.getBytes(), 0, t2.getLength());
        bcv.isNull[3] = true;
        bcv.setVal(4, t1.getBytes(), 0, t1.getLength());
        Object[] values = new Object[this.vectorSize];
        VectorExpressionWriter vew = this.getWriter(type);
        for (int i = 0; i < 5; ++i) {
            values[i] = null;
            Writable w = (Writable)vew.setValue(values[i], (ColumnVector)bcv, i);
            if (w != null) {
                byte[] val = new byte[bcv.length[i]];
                System.arraycopy(bcv.vector[i], bcv.start[i], val, 0, bcv.length[i]);
                Writable expected = this.getWritableValue(type, val);
                Assert.assertEquals((Object)expected, (Object)w);
                continue;
            }
            Assert.assertTrue((boolean)bcv.isNull[i]);
        }
    }

    @Test
    public void testVectorExpressionWriterDouble() throws HiveException {
        this.testWriterDouble((TypeInfo)TypeInfoFactory.doubleTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterDouble() throws HiveException {
        this.testSetterDouble((TypeInfo)TypeInfoFactory.doubleTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterFloat() throws HiveException {
        this.testWriterDouble((TypeInfo)TypeInfoFactory.floatTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterFloat() throws HiveException {
        this.testSetterDouble((TypeInfo)TypeInfoFactory.floatTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterLong() throws HiveException {
        this.testWriterLong((TypeInfo)TypeInfoFactory.longTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterDecimal() throws HiveException {
        DecimalTypeInfo typeInfo = TypeInfoFactory.getDecimalTypeInfo((int)38, (int)18);
        this.testWriterDecimal(typeInfo);
    }

    @Test
    public void testVectorExpressionSetterDecimal() throws HiveException {
        DecimalTypeInfo typeInfo = TypeInfoFactory.getDecimalTypeInfo((int)38, (int)18);
        this.testSetterDecimal(typeInfo);
    }

    @Test
    public void testVectorExpressionSetterLong() throws HiveException {
        this.testSetterLong((TypeInfo)TypeInfoFactory.longTypeInfo);
    }

    @Test
    public void testVectorExpressionStructLong() throws HiveException {
        this.testStructLong((TypeInfo)TypeInfoFactory.longTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterInt() throws HiveException {
        this.testWriterLong((TypeInfo)TypeInfoFactory.intTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterInt() throws HiveException {
        this.testSetterLong((TypeInfo)TypeInfoFactory.intTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterShort() throws HiveException {
        this.testWriterLong((TypeInfo)TypeInfoFactory.shortTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterShort() throws HiveException {
        this.testSetterLong((TypeInfo)TypeInfoFactory.shortTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterBoolean() throws HiveException {
        this.testWriterLong((TypeInfo)TypeInfoFactory.booleanTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterBoolean() throws HiveException {
        this.testSetterLong((TypeInfo)TypeInfoFactory.booleanTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterTimestamp() throws HiveException {
        this.testWriterTimestamp((TypeInfo)TypeInfoFactory.timestampTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterTimestamp() throws HiveException {
        this.testSetterTimestamp((TypeInfo)TypeInfoFactory.timestampTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterByte() throws HiveException {
        this.testWriterLong((TypeInfo)TypeInfoFactory.byteTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterByte() throws HiveException {
        this.testSetterLong((TypeInfo)TypeInfoFactory.byteTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterString() throws HiveException {
        this.testWriterText((TypeInfo)TypeInfoFactory.stringTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterString() throws HiveException {
        this.testSetterText((TypeInfo)TypeInfoFactory.stringTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterVarchar() throws HiveException {
        this.testWriterText((TypeInfo)TypeInfoFactory.varcharTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterVarchar() throws HiveException {
        this.testSetterText((TypeInfo)TypeInfoFactory.varcharTypeInfo);
    }

    @Test
    public void testVectorExpressionWriterBinary() throws HiveException {
        this.testWriterText((TypeInfo)TypeInfoFactory.binaryTypeInfo);
    }

    @Test
    public void testVectorExpressionSetterBinary() throws HiveException {
        this.testSetterText((TypeInfo)TypeInfoFactory.binaryTypeInfo);
    }
}

