/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import junit.framework.Assert;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinEagerRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKeyObject;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinPersistableTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainerSerDe;
import org.apache.hadoop.hive.ql.exec.persistence.Utilities;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.io.Text;
import org.junit.Before;
import org.junit.Test;

public class TestMapJoinTableContainer {
    private static final Object[] KEY = new Object[]{new Text("key")};
    private static final Object[] VALUE = new Object[]{new Text("value")};
    private ByteArrayOutputStream baos;
    private ObjectOutputStream out;
    private ObjectInputStream in;
    private MapJoinPersistableTableContainer container;
    private MapJoinTableContainerSerDe containerSerde;
    private MapJoinKeyObject key;
    private MapJoinRowContainer rowContainer;

    @Before
    public void setup() throws Exception {
        this.key = new MapJoinKeyObject(KEY);
        this.rowContainer = new MapJoinEagerRowContainer();
        this.rowContainer.addRow(VALUE);
        this.baos = new ByteArrayOutputStream();
        this.out = new ObjectOutputStream(this.baos);
        LazyBinarySerDe keySerde = new LazyBinarySerDe();
        Properties keyProps = new Properties();
        keyProps.put("columns", "v1");
        keyProps.put("columns.types", "string");
        SerDeUtils.initializeSerDe((Deserializer)keySerde, null, (Properties)keyProps, null);
        LazyBinarySerDe valueSerde = new LazyBinarySerDe();
        Properties valueProps = new Properties();
        valueProps.put("columns", "v1");
        valueProps.put("columns.types", "string");
        SerDeUtils.initializeSerDe((Deserializer)valueSerde, null, (Properties)keyProps, null);
        this.containerSerde = new MapJoinTableContainerSerDe(new MapJoinObjectSerDeContext((AbstractSerDe)keySerde, false), new MapJoinObjectSerDeContext((AbstractSerDe)valueSerde, false));
        this.container = new HashMapWrapper();
    }

    @Test
    public void testSerialization() throws Exception {
        this.container.put((MapJoinKey)this.key, this.rowContainer);
        this.containerSerde.persist(this.out, this.container);
        this.out.close();
        this.in = new ObjectInputStream(new ByteArrayInputStream(this.baos.toByteArray()));
        this.container = this.containerSerde.load(this.in);
        Utilities.testEquality(this.rowContainer, this.container.get((MapJoinKey)this.key));
    }

    @Test
    public void testDummyContainer() throws Exception {
        MapJoinTableContainerSerDe.persistDummyTable((ObjectOutputStream)this.out);
        this.out.close();
        this.in = new ObjectInputStream(new ByteArrayInputStream(this.baos.toByteArray()));
        this.container = this.containerSerde.load(this.in);
        Assert.assertEquals((int)0, (int)this.container.size());
        Assert.assertTrue((boolean)this.container.entrySet().isEmpty());
    }
}

