/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.InputEstimatorTestClass;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.ContentSummaryInputFormat;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InputEstimator;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFromUtcTimestamp;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtilities {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    public static final Logger LOG = LoggerFactory.getLogger(TestUtilities.class);
    private static final int NUM_BUCKETS = 3;

    @Test
    public void testGetFileExtension() {
        JobConf jc = new JobConf();
        jc.set("fs.default.name", "file:///");
        Assert.assertEquals((String)"No extension for uncompressed unknown format", (Object)"", (Object)Utilities.getFileExtension((JobConf)jc, (boolean)false, null));
        Assert.assertEquals((String)"No extension for compressed unknown format", (Object)"", (Object)Utilities.getFileExtension((JobConf)jc, (boolean)true, null));
        Assert.assertEquals((String)"No extension for uncompressed text format", (Object)"", (Object)Utilities.getFileExtension((JobConf)jc, (boolean)false, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
        Assert.assertEquals((String)"Deflate for uncompressed text format", (Object)".deflate", (Object)Utilities.getFileExtension((JobConf)jc, (boolean)true, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
        Assert.assertEquals((String)"No extension for uncompressed default format", (Object)"", (Object)Utilities.getFileExtension((JobConf)jc, (boolean)false));
        Assert.assertEquals((String)"Deflate for uncompressed default format", (Object)".deflate", (Object)Utilities.getFileExtension((JobConf)jc, (boolean)true));
        String extension = ".myext";
        jc.set("hive.output.file.extension", extension);
        Assert.assertEquals((String)"Custom extension for uncompressed unknown format", (Object)extension, (Object)Utilities.getFileExtension((JobConf)jc, (boolean)false, null));
        Assert.assertEquals((String)"Custom extension for compressed unknown format", (Object)extension, (Object)Utilities.getFileExtension((JobConf)jc, (boolean)true, null));
        Assert.assertEquals((String)"Custom extension for uncompressed text format", (Object)extension, (Object)Utilities.getFileExtension((JobConf)jc, (boolean)false, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
        Assert.assertEquals((String)"Custom extension for uncompressed text format", (Object)extension, (Object)Utilities.getFileExtension((JobConf)jc, (boolean)true, (HiveOutputFormat)new HiveIgnoreKeyTextOutputFormat()));
    }

    @Test
    public void testSerializeTimestamp() {
        Timestamp ts = new Timestamp(1374554702000L);
        ts.setNanos(123456);
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((Object)ts);
        ArrayList<ExprNodeConstantDesc> children = new ArrayList<ExprNodeConstantDesc>(1);
        children.add(constant);
        ExprNodeGenericFuncDesc desc = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.timestampTypeInfo, (GenericUDF)new GenericUDFFromUtcTimestamp(), children);
        Assert.assertEquals((Object)desc.getExprString(), (Object)SerializationUtilities.deserializeExpression((String)SerializationUtilities.serializeExpression((ExprNodeGenericFuncDesc)desc)).getExprString());
    }

    @Test
    public void testgetDbTableName() throws HiveException {
        HiveConf conf = new HiveConf(this.getClass());
        conf.set("fs.default.name", "file:///");
        SessionState.start((HiveConf)conf);
        String curDefaultdb = SessionState.get().getCurrentDatabase();
        String tablename = "tab1";
        String[] dbtab = Utilities.getDbTableName((String)tablename);
        Assert.assertEquals((String)"db name", (Object)curDefaultdb, (Object)dbtab[0]);
        Assert.assertEquals((String)"table name", (Object)tablename, (Object)dbtab[1]);
        tablename = "dab1.tab1";
        dbtab = Utilities.getDbTableName((String)tablename);
        Assert.assertEquals((String)"db name", (Object)"dab1", (Object)dbtab[0]);
        Assert.assertEquals((String)"table name", (Object)"tab1", (Object)dbtab[1]);
        tablename = "dab1.tab1.x1";
        try {
            dbtab = Utilities.getDbTableName((String)tablename);
            Assert.fail((String)"exception was expected for invalid table name");
        }
        catch (HiveException ex) {
            Assert.assertEquals((Object)("Invalid table name " + tablename), (Object)ex.getMessage());
        }
    }

    @Test
    public void testReplaceTaskId() {
        String taskID = "000000";
        int bucketNum = 1;
        String newTaskID = Utilities.replaceTaskId((String)taskID, (int)bucketNum);
        Assert.assertEquals((Object)"000001", (Object)newTaskID);
        taskID = "(ds%3D1)000001";
        newTaskID = Utilities.replaceTaskId((String)taskID, (int)5);
        Assert.assertEquals((Object)"(ds%3D1)000005", (Object)newTaskID);
    }

    @Test
    public void testRemoveTempOrDuplicateFilesOnTezNoDp() throws Exception {
        List<Path> paths = this.runRemoveTempOrDuplicateFilesTestCase("tez", false);
        Assert.assertEquals((long)0L, (long)paths.size());
    }

    @Test
    public void testRemoveTempOrDuplicateFilesOnTezWithDp() throws Exception {
        List<Path> paths = this.runRemoveTempOrDuplicateFilesTestCase("tez", true);
        Assert.assertEquals((long)0L, (long)paths.size());
    }

    @Test
    public void testRemoveTempOrDuplicateFilesOnMrNoDp() throws Exception {
        List<Path> paths = this.runRemoveTempOrDuplicateFilesTestCase("mr", false);
        Assert.assertEquals((long)3L, (long)paths.size());
    }

    @Test
    public void testRemoveTempOrDuplicateFilesOnMrWithDp() throws Exception {
        List<Path> paths = this.runRemoveTempOrDuplicateFilesTestCase("mr", true);
        Assert.assertEquals((long)3L, (long)paths.size());
    }

    private List<Path> runRemoveTempOrDuplicateFilesTestCase(String executionEngine, boolean dPEnabled) throws Exception {
        HiveConf hconf = new HiveConf(this.getClass());
        hconf.set("fs.defaultFS", "hdfs://should-not-be-used/");
        hconf.set(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE.varname, executionEngine);
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)hconf);
        DynamicPartitionCtx dpCtx = this.getDynamicPartitionCtx(dPEnabled);
        Path tempDirPath = this.setupTempDirWithSingleOutputFile((Configuration)hconf);
        FileSinkDesc conf = this.getFileSinkDesc(tempDirPath);
        List paths = Utilities.removeTempOrDuplicateFiles((FileSystem)localFs, (Path)tempDirPath, (DynamicPartitionCtx)dpCtx, (FileSinkDesc)conf, (Configuration)hconf);
        String expectedScheme = tempDirPath.toUri().getScheme();
        String expectedAuthority = tempDirPath.toUri().getAuthority();
        this.assertPathsMatchSchemeAndAuthority(expectedScheme, expectedAuthority, paths);
        return paths;
    }

    private void assertPathsMatchSchemeAndAuthority(String expectedScheme, String expectedAuthority, List<Path> paths) {
        for (Path path : paths) {
            Assert.assertEquals((Object)path.toUri().getScheme().toLowerCase(), (Object)expectedScheme.toLowerCase());
            Assert.assertEquals((Object)path.toUri().getAuthority(), (Object)expectedAuthority);
        }
    }

    private DynamicPartitionCtx getDynamicPartitionCtx(boolean dPEnabled) {
        DynamicPartitionCtx dpCtx = null;
        if (dPEnabled) {
            dpCtx = (DynamicPartitionCtx)Mockito.mock(DynamicPartitionCtx.class);
            Mockito.when((Object)dpCtx.getNumDPCols()).thenReturn((Object)0);
            Mockito.when((Object)dpCtx.getNumBuckets()).thenReturn((Object)3);
        }
        return dpCtx;
    }

    private FileSinkDesc getFileSinkDesc(Path tempDirPath) {
        Table table = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)table.getNumBuckets()).thenReturn((Object)3);
        FileSinkDesc conf = new FileSinkDesc(tempDirPath, null, false);
        conf.setTable(table);
        return conf;
    }

    private Path setupTempDirWithSingleOutputFile(Configuration hconf) throws IOException {
        Path tempDirPath = new Path("file://" + this.temporaryFolder.newFolder().getAbsolutePath());
        Path taskOutputPath = new Path(tempDirPath, Utilities.getTaskId((Configuration)hconf));
        FileSystem.getLocal((Configuration)hconf).create(taskOutputPath).close();
        return tempDirPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetInputPathsWithEmptyTables() throws Exception {
        String alias1Name = "alias1";
        String alias2Name = "alias2";
        MapWork mapWork1 = new MapWork();
        MapWork mapWork2 = new MapWork();
        JobConf jobConf = new JobConf();
        jobConf.set("fs.default.name", "file:///");
        Path nonExistentPath1 = new Path(UUID.randomUUID().toString());
        Path nonExistentPath2 = new Path(UUID.randomUUID().toString());
        PartitionDesc mockPartitionDesc = (PartitionDesc)Mockito.mock(PartitionDesc.class);
        TableDesc mockTableDesc = (TableDesc)Mockito.mock(TableDesc.class);
        Mockito.when((Object)mockTableDesc.isNonNative()).thenReturn((Object)false);
        Mockito.when((Object)mockTableDesc.getProperties()).thenReturn((Object)new Properties());
        Mockito.when((Object)mockPartitionDesc.getProperties()).thenReturn((Object)new Properties());
        Mockito.when((Object)mockPartitionDesc.getTableDesc()).thenReturn((Object)mockTableDesc);
        ((PartitionDesc)Mockito.doReturn(HiveSequenceFileOutputFormat.class).when((Object)mockPartitionDesc)).getOutputFileFormatClass();
        mapWork1.setPathToAliases(new LinkedHashMap(ImmutableMap.of((Object)nonExistentPath1, (Object)Lists.newArrayList((Object[])new String[]{alias1Name}))));
        mapWork1.setAliasToWork(new LinkedHashMap(ImmutableMap.of((Object)alias1Name, (Object)((Operator)Mockito.mock(Operator.class)))));
        mapWork1.setPathToPartitionInfo(new LinkedHashMap(ImmutableMap.of((Object)nonExistentPath1, (Object)mockPartitionDesc)));
        mapWork2.setPathToAliases(new LinkedHashMap(ImmutableMap.of((Object)nonExistentPath2, (Object)Lists.newArrayList((Object[])new String[]{alias2Name}))));
        mapWork2.setAliasToWork(new LinkedHashMap(ImmutableMap.of((Object)alias2Name, (Object)((Operator)Mockito.mock(Operator.class)))));
        mapWork2.setPathToPartitionInfo(new LinkedHashMap(ImmutableMap.of((Object)nonExistentPath2, (Object)mockPartitionDesc)));
        ArrayList inputPaths = new ArrayList();
        try {
            Path scratchDir = new Path(HiveConf.getVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.LOCALSCRATCHDIR));
            inputPaths.addAll(Utilities.getInputPaths((JobConf)jobConf, (MapWork)mapWork1, (Path)scratchDir, (Context)((Context)Mockito.mock(Context.class)), (boolean)false));
            inputPaths.addAll(Utilities.getInputPaths((JobConf)jobConf, (MapWork)mapWork2, (Path)scratchDir, (Context)((Context)Mockito.mock(Context.class)), (boolean)false));
            Assert.assertEquals((long)inputPaths.size(), (long)2L);
        }
        finally {
            for (Path path : inputPaths) {
                File file = new File(path.toString());
                if (!file.exists()) continue;
                file.delete();
            }
        }
    }

    @Test
    public void testGetMaxExecutorsForInputListing() {
        Configuration conf = new Configuration();
        conf.set("fs.default.name", "file:///");
        boolean ZERO_EXECUTORS = false;
        boolean ONE_EXECUTOR = true;
        int TWO_EXECUTORS = 2;
        boolean ZERO_THREADS = false;
        boolean ONE_THREAD = true;
        int TWO_THREADS = 2;
        boolean ZERO_LOCATIONS = false;
        boolean ONE_LOCATION = true;
        int TWO_LOCATIONS = 2;
        int THREE_LOCATIONS = 3;
        conf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 1);
        Assert.assertEquals((long)0L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)0));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)1));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)2));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)3));
        conf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 2);
        Assert.assertEquals((long)0L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)0));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)1));
        Assert.assertEquals((long)2L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)2));
        Assert.assertEquals((long)2L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)3));
        conf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 0);
        conf.setInt("mapred.dfsclient.parallelism.max", 0);
        Assert.assertEquals((long)0L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)0));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)1));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)2));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)3));
        conf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 0);
        conf.setInt("mapred.dfsclient.parallelism.max", 1);
        Assert.assertEquals((long)0L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)0));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)1));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)2));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)3));
        conf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 0);
        conf.setInt("mapred.dfsclient.parallelism.max", 2);
        Assert.assertEquals((long)0L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)0));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)1));
        Assert.assertEquals((long)2L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)2));
        Assert.assertEquals((long)2L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)3));
        conf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 2);
        conf.setInt("mapred.dfsclient.parallelism.max", 1);
        Assert.assertEquals((long)0L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)0));
        Assert.assertEquals((long)1L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)1));
        Assert.assertEquals((long)2L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)2));
        Assert.assertEquals((long)2L, (long)Utilities.getMaxExecutorsForInputListing((Configuration)conf, (int)3));
    }

    @Test
    public void testGetInputPathsWithASingleThread() throws Exception {
        int NUM_PARTITIONS = 5;
        JobConf jobConf = new JobConf();
        jobConf.set("fs.default.name", "file:///");
        jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 1);
        this.runTestGetInputPaths(jobConf, 5);
    }

    @Test
    public void testGetInputPathsWithMultipleThreads() throws Exception {
        int NUM_PARTITIONS = 5;
        JobConf jobConf = new JobConf();
        jobConf.set("fs.default.name", "file:///");
        jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 2);
        this.runTestGetInputPaths(jobConf, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestGetInputPaths(JobConf jobConf, int numOfPartitions) throws Exception {
        MapWork mapWork = new MapWork();
        Path scratchDir = new Path(HiveConf.getVar((Configuration)jobConf, (HiveConf.ConfVars)HiveConf.ConfVars.LOCALSCRATCHDIR));
        LinkedHashMap<Path, ArrayList> pathToAliasTable = new LinkedHashMap<Path, ArrayList>();
        String testTableName = "testTable";
        Path testTablePath = new Path(testTableName);
        Path[] testPartitionsPaths = new Path[numOfPartitions];
        for (int i = 0; i < numOfPartitions; ++i) {
            String testPartitionName = "p=1";
            testPartitionsPaths[i] = new Path(testTablePath, "p=" + i);
            pathToAliasTable.put(testPartitionsPaths[i], Lists.newArrayList((Object[])new String[]{testPartitionName}));
            mapWork.getAliasToWork().put(testPartitionName, (Operator)Mockito.mock(Operator.class));
        }
        mapWork.setPathToAliases(pathToAliasTable);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)jobConf);
        try {
            fs.mkdirs(testTablePath);
            for (int i = 0; i < numOfPartitions; ++i) {
                fs.mkdirs(testPartitionsPaths[i]);
                fs.create(new Path(testPartitionsPaths[i], "test1.txt")).close();
            }
            List inputPaths = Utilities.getInputPaths((JobConf)jobConf, (MapWork)mapWork, (Path)scratchDir, (Context)((Context)Mockito.mock(Context.class)), (boolean)false);
            Assert.assertEquals((long)inputPaths.size(), (long)numOfPartitions);
            for (int i = 0; i < numOfPartitions; ++i) {
                Assert.assertEquals(inputPaths.get(i), (Object)testPartitionsPaths[i]);
            }
        }
        finally {
            if (fs.exists(testTablePath)) {
                fs.delete(testTablePath, true);
            }
        }
    }

    @Test
    public void testGetInputSummaryWithASingleThread() throws IOException {
        int NUM_PARTITIONS = 5;
        int BYTES_PER_FILE = 5;
        JobConf jobConf = new JobConf();
        jobConf.set("fs.default.name", "file:///");
        Properties properties = new Properties();
        jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 0);
        ContentSummary summary = this.runTestGetInputSummary(jobConf, properties, 5, 5, HiveInputFormat.class);
        Assert.assertEquals((long)25L, (long)summary.getLength());
        Assert.assertEquals((long)5L, (long)summary.getFileCount());
        Assert.assertEquals((long)5L, (long)summary.getDirectoryCount());
    }

    @Test
    public void testGetInputSummaryWithMultipleThreads() throws IOException {
        int NUM_PARTITIONS = 5;
        int BYTES_PER_FILE = 5;
        JobConf jobConf = new JobConf();
        jobConf.set("fs.default.name", "file:///");
        Properties properties = new Properties();
        jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 2);
        ContentSummary summary = this.runTestGetInputSummary(jobConf, properties, 5, 5, HiveInputFormat.class);
        Assert.assertEquals((long)25L, (long)summary.getLength());
        Assert.assertEquals((long)5L, (long)summary.getFileCount());
        Assert.assertEquals((long)5L, (long)summary.getDirectoryCount());
        jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 0);
        jobConf.setInt("mapred.dfsclient.parallelism.max", 2);
        summary = this.runTestGetInputSummary(jobConf, properties, 5, 5, HiveInputFormat.class);
        Assert.assertEquals((long)25L, (long)summary.getLength());
        Assert.assertEquals((long)5L, (long)summary.getFileCount());
        Assert.assertEquals((long)5L, (long)summary.getDirectoryCount());
    }

    @Test
    public void testGetInputSummaryWithInputEstimator() throws IOException, HiveException {
        int NUM_PARTITIONS = 5;
        int BYTES_PER_FILE = 10;
        int NUM_OF_ROWS = 5;
        JobConf jobConf = new JobConf();
        jobConf.set("fs.default.name", "file:///");
        Properties properties = new Properties();
        jobConf.setInt("mapred.dfsclient.parallelism.max", 2);
        properties.setProperty("storage_handler", InputEstimatorTestClass.class.getName());
        InputEstimatorTestClass.setEstimation(new InputEstimator.Estimation(5, 10L));
        ContentSummary summary = this.runTestGetInputSummary(jobConf, properties, 5, 20, HiveInputFormat.class);
        Assert.assertEquals((long)50L, (long)summary.getLength());
        Assert.assertEquals((long)-5L, (long)summary.getFileCount());
        Assert.assertEquals((long)-5L, (long)summary.getDirectoryCount());
        jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 0);
        jobConf.setInt(HiveConf.ConfVars.HIVE_EXEC_INPUT_LISTING_MAX_THREADS.varname, 2);
        properties.setProperty("storage_handler", InputEstimatorTestClass.class.getName());
        InputEstimatorTestClass.setEstimation(new InputEstimator.Estimation(5, 10L));
        summary = this.runTestGetInputSummary(jobConf, properties, 5, 20, HiveInputFormat.class);
        Assert.assertEquals((long)50L, (long)summary.getLength());
        Assert.assertEquals((long)-5L, (long)summary.getFileCount());
        Assert.assertEquals((long)-5L, (long)summary.getDirectoryCount());
    }

    @Test
    public void testGetInputSummaryWithContentSummaryInputFormat() throws IOException {
        int NUM_PARTITIONS = 5;
        int BYTES_PER_FILE = 10;
        JobConf jobConf = new JobConf();
        jobConf.set("fs.default.name", "file:///");
        Properties properties = new Properties();
        jobConf.setInt("mapred.dfsclient.parallelism.max", 2);
        ContentSummaryInputFormatTestClass.setContentSummary(new ContentSummary.Builder().length(10L).fileCount(2L).directoryCount(1L).build());
        ContentSummary summary = this.runTestGetInputSummary(jobConf, properties, 5, 20, ContentSummaryInputFormatTestClass.class);
        Assert.assertEquals((long)50L, (long)summary.getLength());
        Assert.assertEquals((long)10L, (long)summary.getFileCount());
        Assert.assertEquals((long)5L, (long)summary.getDirectoryCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentSummary runTestGetInputSummary(JobConf jobConf, Properties properties, int numOfPartitions, int bytesPerFile, Class<? extends InputFormat> inputFormatClass) throws IOException {
        HiveConf conf = new HiveConf(this.getClass());
        conf.set("fs.default.name", "file:///");
        SessionState.start((HiveConf)conf);
        MapWork mapWork = new MapWork();
        Context context = new Context((Configuration)jobConf);
        LinkedHashMap<Path, PartitionDesc> pathToPartitionInfo = new LinkedHashMap<Path, PartitionDesc>();
        LinkedHashMap<Path, ArrayList> pathToAliasTable = new LinkedHashMap<Path, ArrayList>();
        TableScanOperator scanOp = new TableScanOperator();
        PartitionDesc partitionDesc = new PartitionDesc(new TableDesc(inputFormatClass, null, properties), null);
        String testTableName = "testTable";
        Path testTablePath = new Path(testTableName);
        Path[] testPartitionsPaths = new Path[numOfPartitions];
        for (int i = 0; i < numOfPartitions; ++i) {
            String testPartitionName = "p=1";
            testPartitionsPaths[i] = new Path(testTablePath, "p=" + i);
            pathToPartitionInfo.put(testPartitionsPaths[i], partitionDesc);
            pathToAliasTable.put(testPartitionsPaths[i], Lists.newArrayList((Object[])new String[]{testPartitionName}));
            mapWork.getAliasToWork().put(testPartitionName, scanOp);
        }
        mapWork.setPathToAliases(pathToAliasTable);
        mapWork.setPathToPartitionInfo(pathToPartitionInfo);
        LocalFileSystem fs = FileSystem.getLocal((Configuration)jobConf);
        try {
            fs.mkdirs(testTablePath);
            byte[] data = new byte[bytesPerFile];
            for (int i = 0; i < numOfPartitions; ++i) {
                fs.mkdirs(testPartitionsPaths[i]);
                FSDataOutputStream out = fs.create(new Path(testPartitionsPaths[i], "test1.txt"));
                out.write(data);
                out.close();
            }
            ContentSummary contentSummary = Utilities.getInputSummary((Context)context, (MapWork)mapWork, null);
            return contentSummary;
        }
        finally {
            if (fs.exists(testTablePath)) {
                fs.delete(testTablePath, true);
            }
        }
    }

    static class ContentSummaryInputFormatTestClass
    extends FileInputFormat
    implements ContentSummaryInputFormat {
        private static ContentSummary summary = new ContentSummary.Builder().build();

        ContentSummaryInputFormatTestClass() {
        }

        public static void setContentSummary(ContentSummary contentSummary) {
            summary = contentSummary;
        }

        public RecordReader getRecordReader(InputSplit inputSplit, JobConf jobConf, Reporter reporter) throws IOException {
            return null;
        }

        public ContentSummary getContentSummary(Path p, JobConf job) throws IOException {
            return summary;
        }
    }
}

