/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;

@Explain(displayName="MapR DB JSON Fetch By Id Operator", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED}, vectorization=Explain.Vectorization.SUMMARY_PATH)
public class MapRDbJsonFetchByIdWork
extends FetchWork {
    private static final long serialVersionUID = 1L;
    private final String searchValue;
    private final String mapRDbTableName;
    private final boolean isEmpty;

    public MapRDbJsonFetchByIdWork(Path tblDir, TableDesc tblDesc, String searchValue, String mapRDbTableName, boolean isEmpty) {
        this(tblDir, tblDesc, -1, searchValue, mapRDbTableName, isEmpty);
    }

    private MapRDbJsonFetchByIdWork(Path tblDir, TableDesc tblDesc, int limit, String searchValue, String mapRDbTableName, boolean isEmpty) {
        super(tblDir, tblDesc, limit);
        this.searchValue = searchValue;
        this.mapRDbTableName = mapRDbTableName;
        this.isEmpty = isEmpty;
    }

    public String getSearchValue() {
        return this.searchValue;
    }

    public String getMapRDbTableName() {
        return this.mapRDbTableName;
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    @Override
    public int getLeastNumRows() {
        return 1;
    }
}

