/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.reducesink;

import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorSerializeRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.VectorReduceSinkInfo;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableSerializeWrite;
import org.apache.hadoop.hive.serde2.lazybinary.fast.LazyBinarySerializeWrite;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.OutputCollector;

public abstract class VectorReduceSinkCommonOperator
extends TerminalOperator<ReduceSinkDesc>
implements VectorizationContextRegion {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = VectorReduceSinkCommonOperator.class.getName();
    private static final Log LOG = LogFactory.getLog((String)CLASS_NAME);
    protected VectorReduceSinkDesc vectorDesc;
    protected VectorReduceSinkInfo vectorReduceSinkInfo;
    protected VectorizationContext vContext;
    protected int[] reduceSinkKeyColumnMap;
    protected TypeInfo[] reduceSinkKeyTypeInfos;
    protected VectorExpression[] reduceSinkKeyExpressions;
    protected int[] reduceSinkValueColumnMap;
    protected TypeInfo[] reduceSinkValueTypeInfos;
    protected VectorExpression[] reduceSinkValueExpressions;
    protected transient boolean reduceSkipTag;
    protected transient byte reduceTagByte;
    protected transient BinarySortableSerializeWrite keyBinarySortableSerializeWrite;
    protected transient LazyBinarySerializeWrite valueLazyBinarySerializeWrite;
    protected transient VectorSerializeRow<LazyBinarySerializeWrite> valueVectorSerializeRow;
    protected transient ByteStream.Output valueOutput;
    protected transient HiveKey keyWritable;
    protected transient BytesWritable valueBytesWritable;
    private transient OutputCollector out;
    private transient long numRows = 0L;
    private transient long cntr = 1L;
    private transient long logEveryNRows = 0L;
    private final transient LongWritable recordCounter = new LongWritable();
    protected transient String taskName;
    protected transient long batchCounter;

    protected VectorReduceSinkCommonOperator() {
    }

    public VectorReduceSinkCommonOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorReduceSinkCommonOperator(CompilationOpContext ctx, VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        this(ctx);
        LOG.info((Object)"VectorReduceSinkCommonOperator constructor");
        ReduceSinkDesc desc = (ReduceSinkDesc)conf;
        this.conf = desc;
        this.vectorDesc = (VectorReduceSinkDesc)desc.getVectorDesc();
        this.vectorReduceSinkInfo = this.vectorDesc.getVectorReduceSinkInfo();
        this.vContext = vContext;
        this.reduceSinkKeyColumnMap = this.vectorReduceSinkInfo.getReduceSinkKeyColumnMap();
        this.reduceSinkKeyTypeInfos = this.vectorReduceSinkInfo.getReduceSinkKeyTypeInfos();
        this.reduceSinkKeyExpressions = this.vectorReduceSinkInfo.getReduceSinkKeyExpressions();
        this.reduceSinkValueColumnMap = this.vectorReduceSinkInfo.getReduceSinkValueColumnMap();
        this.reduceSinkValueTypeInfos = this.vectorReduceSinkInfo.getReduceSinkValueTypeInfos();
        this.reduceSinkValueExpressions = this.vectorReduceSinkInfo.getReduceSinkValueExpressions();
    }

    private boolean[] getColumnSortOrder(Properties properties, int columnCount) {
        String columnSortOrder = properties.getProperty("serialization.sort.order");
        boolean[] columnSortOrderIsDesc = new boolean[columnCount];
        if (columnSortOrder == null) {
            Arrays.fill(columnSortOrderIsDesc, false);
        } else {
            for (int i = 0; i < columnSortOrderIsDesc.length; ++i) {
                columnSortOrderIsDesc[i] = columnSortOrder.charAt(i) == '-';
            }
        }
        return columnSortOrderIsDesc;
    }

    private byte[] getColumnNullMarker(Properties properties, int columnCount, boolean[] columnSortOrder) {
        String columnNullOrder = properties.getProperty("serialization.sort.order.null");
        byte[] columnNullMarker = new byte[columnCount];
        for (int i = 0; i < columnNullMarker.length; ++i) {
            if (columnSortOrder[i]) {
                if (columnNullOrder != null && columnNullOrder.charAt(i) == 'a') {
                    columnNullMarker[i] = 1;
                    continue;
                }
                columnNullMarker[i] = 0;
                continue;
            }
            columnNullMarker[i] = columnNullOrder != null && columnNullOrder.charAt(i) == 'z' ? (byte)1 : 0;
        }
        return columnNullMarker;
    }

    private byte[] getColumnNotNullMarker(Properties properties, int columnCount, boolean[] columnSortOrder) {
        String columnNullOrder = properties.getProperty("serialization.sort.order.null");
        byte[] columnNotNullMarker = new byte[columnCount];
        for (int i = 0; i < columnNotNullMarker.length; ++i) {
            if (columnSortOrder[i]) {
                if (columnNullOrder != null && columnNullOrder.charAt(i) == 'a') {
                    columnNotNullMarker[i] = 0;
                    continue;
                }
                columnNotNullMarker[i] = 1;
                continue;
            }
            columnNotNullMarker[i] = columnNullOrder != null && columnNullOrder.charAt(i) == 'z' ? (byte)0 : 1;
        }
        return columnNotNullMarker;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        String context;
        super.initializeOp(hconf);
        if (this.isLogDebugEnabled) {
            LOG.debug((Object)("useUniformHash " + this.vectorReduceSinkInfo.getUseUniformHash()));
            LOG.debug((Object)("reduceSinkKeyColumnMap " + (this.vectorReduceSinkInfo.getReduceSinkKeyColumnMap() == null ? "NULL" : Arrays.toString(this.vectorReduceSinkInfo.getReduceSinkKeyColumnMap()))));
            LOG.debug((Object)("reduceSinkKeyTypeInfos " + (this.vectorReduceSinkInfo.getReduceSinkKeyTypeInfos() == null ? "NULL" : Arrays.toString(this.vectorReduceSinkInfo.getReduceSinkKeyTypeInfos()))));
            LOG.debug((Object)("reduceSinkKeyColumnVectorTypes " + (this.vectorReduceSinkInfo.getReduceSinkKeyColumnVectorTypes() == null ? "NULL" : Arrays.toString((Object[])this.vectorReduceSinkInfo.getReduceSinkKeyColumnVectorTypes()))));
            LOG.debug((Object)("reduceSinkKeyExpressions " + (this.vectorReduceSinkInfo.getReduceSinkKeyExpressions() == null ? "NULL" : Arrays.toString(this.vectorReduceSinkInfo.getReduceSinkKeyExpressions()))));
            LOG.debug((Object)("reduceSinkValueColumnMap " + (this.vectorReduceSinkInfo.getReduceSinkValueColumnMap() == null ? "NULL" : Arrays.toString(this.vectorReduceSinkInfo.getReduceSinkValueColumnMap()))));
            LOG.debug((Object)("reduceSinkValueTypeInfos " + (this.vectorReduceSinkInfo.getReduceSinkValueTypeInfos() == null ? "NULL" : Arrays.toString(this.vectorReduceSinkInfo.getReduceSinkValueTypeInfos()))));
            LOG.debug((Object)("reduceSinkValueColumnVectorTypes " + (this.vectorReduceSinkInfo.getReduceSinkValueColumnVectorTypes() == null ? "NULL" : Arrays.toString((Object[])this.vectorReduceSinkInfo.getReduceSinkValueColumnVectorTypes()))));
            LOG.debug((Object)("reduceSinkValueExpressions " + (this.vectorReduceSinkInfo.getReduceSinkValueExpressions() == null ? "NULL" : Arrays.toString(this.vectorReduceSinkInfo.getReduceSinkValueExpressions()))));
            LOG.debug((Object)("reduceSinkBucketColumnMap " + (this.vectorReduceSinkInfo.getReduceSinkBucketColumnMap() == null ? "NULL" : Arrays.toString(this.vectorReduceSinkInfo.getReduceSinkBucketColumnMap()))));
            LOG.debug((Object)("reduceSinkBucketTypeInfos " + (this.vectorReduceSinkInfo.getReduceSinkBucketTypeInfos() == null ? "NULL" : Arrays.toString(this.vectorReduceSinkInfo.getReduceSinkBucketTypeInfos()))));
            LOG.debug((Object)("reduceSinkBucketColumnVectorTypes " + (this.vectorReduceSinkInfo.getReduceSinkBucketColumnVectorTypes() == null ? "NULL" : Arrays.toString((Object[])this.vectorReduceSinkInfo.getReduceSinkBucketColumnVectorTypes()))));
            LOG.debug((Object)("reduceSinkBucketExpressions " + (this.vectorReduceSinkInfo.getReduceSinkBucketExpressions() == null ? "NULL" : Arrays.toString(this.vectorReduceSinkInfo.getReduceSinkBucketExpressions()))));
            LOG.debug((Object)("reduceSinkPartitionColumnMap " + (this.vectorReduceSinkInfo.getReduceSinkPartitionColumnMap() == null ? "NULL" : Arrays.toString(this.vectorReduceSinkInfo.getReduceSinkPartitionColumnMap()))));
            LOG.debug((Object)("reduceSinkPartitionTypeInfos " + (this.vectorReduceSinkInfo.getReduceSinkPartitionTypeInfos() == null ? "NULL" : Arrays.toString(this.vectorReduceSinkInfo.getReduceSinkPartitionTypeInfos()))));
            LOG.debug((Object)("reduceSinkPartitionColumnVectorTypes " + (this.vectorReduceSinkInfo.getReduceSinkPartitionColumnVectorTypes() == null ? "NULL" : Arrays.toString((Object[])this.vectorReduceSinkInfo.getReduceSinkPartitionColumnVectorTypes()))));
            LOG.debug((Object)("reduceSinkPartitionExpressions " + (this.vectorReduceSinkInfo.getReduceSinkPartitionExpressions() == null ? "NULL" : Arrays.toString(this.vectorReduceSinkInfo.getReduceSinkPartitionExpressions()))));
        }
        if (LOG.isDebugEnabled()) {
            BaseWork work = Utilities.getMapWork(hconf);
            if (work == null) {
                work = Utilities.getReduceWork(hconf);
            }
            this.taskName = work.getName();
        }
        if ((context = hconf.get("__hive.context.name", "")) != null && !context.isEmpty()) {
            context = "_" + context.replace(" ", "_");
        }
        this.statsMap.put((Object)((Object)ReduceSinkOperator.Counter.RECORDS_OUT_INTERMEDIATE) + context, this.recordCounter);
        this.reduceSkipTag = ((ReduceSinkDesc)this.conf).getSkipTag();
        this.reduceTagByte = (byte)((ReduceSinkDesc)this.conf).getTag();
        if (this.isLogInfoEnabled) {
            LOG.info((Object)("Using tag = " + this.reduceTagByte));
        }
        TableDesc keyTableDesc = ((ReduceSinkDesc)this.conf).getKeySerializeInfo();
        boolean[] columnSortOrder = this.getColumnSortOrder(keyTableDesc.getProperties(), this.reduceSinkKeyColumnMap.length);
        byte[] columnNullMarker = this.getColumnNullMarker(keyTableDesc.getProperties(), this.reduceSinkKeyColumnMap.length, columnSortOrder);
        byte[] columnNotNullMarker = this.getColumnNotNullMarker(keyTableDesc.getProperties(), this.reduceSinkKeyColumnMap.length, columnSortOrder);
        this.keyBinarySortableSerializeWrite = new BinarySortableSerializeWrite(columnSortOrder, columnNullMarker, columnNotNullMarker);
        this.valueLazyBinarySerializeWrite = new LazyBinarySerializeWrite(this.reduceSinkValueColumnMap.length);
        this.valueVectorSerializeRow = new VectorSerializeRow<LazyBinarySerializeWrite>(this.valueLazyBinarySerializeWrite);
        this.valueVectorSerializeRow.init(this.reduceSinkValueTypeInfos, this.reduceSinkValueColumnMap);
        this.valueOutput = new ByteStream.Output();
        this.valueVectorSerializeRow.setOutput(this.valueOutput);
        this.keyWritable = new HiveKey();
        this.valueBytesWritable = new BytesWritable();
        this.batchCounter = 0L;
    }

    protected void collect(BytesWritable keyWritable, Writable valueWritable) throws IOException {
        if (null != this.out) {
            ++this.numRows;
            if (this.isLogInfoEnabled && this.numRows == this.cntr) {
                long l = this.cntr = this.logEveryNRows == 0L ? this.cntr * 10L : this.numRows + this.logEveryNRows;
                if (this.cntr < 0L || this.numRows < 0L) {
                    this.cntr = 0L;
                    this.numRows = 1L;
                }
                LOG.info((Object)(this.toString() + ": records written - " + this.numRows));
            }
            this.out.collect((Object)keyWritable, (Object)valueWritable);
        }
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        super.closeOp(abort);
        this.out = null;
        if (this.isLogInfoEnabled) {
            LOG.info((Object)(this.toString() + ": records written - " + this.numRows));
        }
        this.recordCounter.set(this.numRows);
    }

    @Override
    public String getName() {
        return VectorReduceSinkCommonOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "RS";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.REDUCESINK;
    }

    @Override
    public VectorizationContext getOuputVectorizationContext() {
        return this.vContext;
    }

    @Override
    public boolean getIsReduceSink() {
        return true;
    }

    @Override
    public String getReduceOutputName() {
        return ((ReduceSinkDesc)this.conf).getOutputName();
    }

    @Override
    public void setOutputCollector(OutputCollector _out) {
        this.out = _out;
    }
}

