/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.alias.CredentialProvider;
import org.apache.hadoop.security.alias.CredentialProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HiveEncryptTool {
    private static final Logger LOG = LoggerFactory.getLogger((String)HiveEncryptTool.class.getName());
    private final Options cmdLineOptions = new Options();

    private HiveEncryptTool() {
    }

    private void init() {
        System.out.println("Initializing HiveEncryptTool");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"Print help information");
        this.cmdLineOptions.addOption(OptionBuilder.create((String)"help"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"keystorename");
        OptionBuilder.withDescription((String)"Create KeyStore to store properties from hive-site.xml using valid path in MapRFS");
        this.cmdLineOptions.addOption(OptionBuilder.create((String)"keyStorePath"));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withDescription((String)"Key, value of property that should be written to keystore");
        this.cmdLineOptions.addOption(OptionBuilder.create((String)"property"));
    }

    private static void printAndExit(Options cmdLineOptions) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("encryptconf", cmdLineOptions);
        System.exit(1);
    }

    private static void encryptPassword(String propertyName, String propertyValue, String pathToKeyStore) throws IOException {
        Configuration configuration = new Configuration();
        String keyStorePath = "jceks://maprfs/" + pathToKeyStore;
        configuration.set("hadoop.security.credential.clear-text-fallback", "true");
        configuration.set("hadoop.security.credential.provider.path", keyStorePath);
        LOG.debug("Creating alias " + propertyName + " under " + pathToKeyStore);
        CredentialProvider provider = (CredentialProvider)CredentialProviderFactory.getProviders((Configuration)configuration).get(0);
        provider.createCredentialEntry(propertyName, propertyValue.toCharArray());
        provider.flush();
    }

    public static void main(String[] args) {
        HiveEncryptTool hiveEncryptTool = new HiveEncryptTool();
        hiveEncryptTool.init();
        GnuParser cmdParser = new GnuParser();
        CommandLine line = null;
        try {
            line = cmdParser.parse(hiveEncryptTool.cmdLineOptions, args);
        }
        catch (ParseException e) {
            System.err.println("HiveEncryptTool:Parsing failed.  Reason: " + e.getLocalizedMessage());
            HiveEncryptTool.printAndExit(hiveEncryptTool.cmdLineOptions);
        }
        if (line == null) {
            HiveEncryptTool.printAndExit(hiveEncryptTool.cmdLineOptions);
        } else if (line.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("encryptconf", hiveEncryptTool.cmdLineOptions);
        } else if (line.hasOption("keyStorePath") && line.hasOption("property")) {
            String[] hiveVars = line.getOptionValues("property");
            if (hiveVars.length != 2) {
                System.err.println("HiveEncryptTool:property takes in 2 required arguments separated by = ;was passed " + hiveVars.length + " arguments");
                HiveEncryptTool.printAndExit(hiveEncryptTool.cmdLineOptions);
            }
            String propertyName = hiveVars[0];
            String propertyValue = hiveVars[1];
            String pathToKeyStore = line.getOptionValue("keyStorePath");
            try {
                System.out.println("Creating keystore... ");
                HiveEncryptTool.encryptPassword(propertyName, propertyValue, pathToKeyStore);
            }
            catch (IOException e) {
                System.err.println("HiveEncryptTool:Error while creating credential keystore. Reason: " + e.getLocalizedMessage());
                HiveEncryptTool.printAndExit(hiveEncryptTool.cmdLineOptions);
            }
            System.out.println("KeyStore successfully created");
        } else {
            System.err.print("HiveEncryptTool:Parsing failed.  Reason: Invalid arguments: ");
            for (String s : line.getArgs()) {
                System.err.println(s + " ");
            }
            System.err.println();
        }
    }
}

