/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.junit.Assert;
import org.junit.Test;

public final class TestTezWorkConcurrency {
    @Test
    public void ensureDagIdIsUnique() throws Exception {
        int threadCount = 5;
        final CountDownLatch threadReadyToStartSignal = new CountDownLatch(5);
        final CountDownLatch startThreadSignal = new CountDownLatch(1);
        int numberOfTezWorkToCreatePerThread = 100;
        ArrayList tasks = Lists.newArrayList();
        for (int i = 0; i < 5; ++i) {
            tasks.add(new FutureTask<Set<String>>(new Callable<Set<String>>(){

                @Override
                public Set<String> call() throws Exception {
                    threadReadyToStartSignal.countDown();
                    startThreadSignal.await();
                    return TestTezWorkConcurrency.generateTezWorkDagIds(100);
                }
            }));
        }
        ExecutorService executor = Executors.newFixedThreadPool(5);
        for (FutureTask task : tasks) {
            executor.execute(task);
        }
        threadReadyToStartSignal.await();
        startThreadSignal.countDown();
        Set<String> allTezWorkDagIds = TestTezWorkConcurrency.getAllTezWorkDagIds(tasks);
        Assert.assertEquals((long)500L, (long)allTezWorkDagIds.size());
    }

    private static Set<String> generateTezWorkDagIds(int numberOfNames) {
        HashSet tezWorkIds = Sets.newHashSet();
        for (int i = 0; i < numberOfNames; ++i) {
            TezWork work = new TezWork("query-id");
            tezWorkIds.add(work.getDagId());
        }
        return tezWorkIds;
    }

    private static Set<String> getAllTezWorkDagIds(List<FutureTask<Set<String>>> tasks) throws ExecutionException, InterruptedException {
        HashSet allTezWorkDagIds = Sets.newHashSet();
        for (FutureTask<Set<String>> task : tasks) {
            allTezWorkDagIds.addAll((Collection)task.get());
        }
        return allTezWorkDagIds;
    }
}

