/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.tez.SampleTezSessionState;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTezSessionPool {
    private static final Logger LOG = LoggerFactory.getLogger(TestTezSessionPoolManager.class);
    HiveConf conf;
    Random random;
    private TezSessionPoolManager poolManager;

    @Before
    public void setUp() {
        this.conf = new HiveConf();
        this.conf.set("fs.default.name", "file:///");
    }

    @Test
    public void testGetNonDefaultSession() {
        this.poolManager = new TestTezSessionPoolManager();
        try {
            TezSessionState sessionState = this.poolManager.getSession(null, this.conf, true, false);
            TezSessionState sessionState1 = this.poolManager.getSession(sessionState, this.conf, true, false);
            if (sessionState1 != sessionState) {
                Assert.fail();
            }
            this.conf.set("tez.queue.name", "nondefault");
            TezSessionState sessionState2 = this.poolManager.getSession(sessionState, this.conf, true, false);
            if (sessionState2 == sessionState) {
                Assert.fail();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testSessionPoolGetInOrder() {
        try {
            this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
            this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_DEFAULT_QUEUES, "a,b,c");
            this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSIONS_PER_DEFAULT_QUEUE, 2);
            this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSION_MAX_INIT_THREADS, 1);
            this.poolManager = new TestTezSessionPoolManager();
            this.poolManager.setupPool(this.conf);
            this.poolManager.startPool();
            TezSessionState sessionState = this.poolManager.getSession(null, this.conf, true, false);
            Assert.assertEquals((Object)"a", (Object)sessionState.getQueueName());
            this.poolManager.returnSession(sessionState, false);
            sessionState = this.poolManager.getSession(null, this.conf, true, false);
            Assert.assertEquals((Object)"b", (Object)sessionState.getQueueName());
            this.poolManager.returnSession(sessionState, false);
            sessionState = this.poolManager.getSession(null, this.conf, true, false);
            Assert.assertEquals((Object)"c", (Object)sessionState.getQueueName());
            this.poolManager.returnSession(sessionState, false);
            sessionState = this.poolManager.getSession(null, this.conf, true, false);
            if (sessionState.getQueueName().compareTo("a") != 0) {
                Assert.fail();
            }
            this.poolManager.returnSession(sessionState, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testSessionPoolThreads() {
        try {
            int i;
            this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
            this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_DEFAULT_QUEUES, "0,1,2");
            this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSIONS_PER_DEFAULT_QUEUE, 4);
            this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSION_MAX_INIT_THREADS, 16);
            this.poolManager = new TestTezSessionPoolManager();
            this.poolManager.setupPool(this.conf);
            this.poolManager.startPool();
            TezSessionState[] sessions = new TezSessionState[12];
            int[] queueCounts = new int[3];
            for (i = 0; i < sessions.length; ++i) {
                sessions[i] = this.poolManager.getSession(null, this.conf, true, false);
                int n = Integer.parseInt(sessions[i].getQueueName());
                queueCounts[n] = queueCounts[n] + 1;
            }
            for (i = 0; i < queueCounts.length; ++i) {
                Assert.assertEquals((long)4L, (long)queueCounts[i]);
            }
            for (i = 0; i < sessions.length; ++i) {
                this.poolManager.returnSession(sessions[i], false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testSessionReopen() {
        try {
            this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
            this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_DEFAULT_QUEUES, "default,tezq1");
            this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSIONS_PER_DEFAULT_QUEUE, 1);
            this.poolManager = new TestTezSessionPoolManager();
            TezSessionState session = (TezSessionState)Mockito.mock(TezSessionState.class);
            Mockito.when((Object)session.getQueueName()).thenReturn((Object)"default");
            Mockito.when((Object)session.isDefault()).thenReturn((Object)false);
            Mockito.when((Object)session.getConf()).thenReturn((Object)this.conf);
            this.poolManager.reopenSession(session, this.conf, null, false);
            ((TezSessionState)Mockito.verify((Object)session)).close(false);
            String[] files = null;
            ((TezSessionState)Mockito.verify((Object)session)).open(this.conf, files);
            Assert.assertEquals((Object)"default", (Object)session.getQueueName());
            this.conf.set("tez.queue.name", "tezq1");
            this.poolManager.reopenSession(session, this.conf, null, false);
            Assert.assertEquals((Object)"tezq1", (Object)this.poolManager.getSession(null, this.conf, false, false).getQueueName());
            this.conf.unset("tez.queue.name");
            this.poolManager.reopenSession(session, this.conf, null, false);
            Assert.assertEquals((Object)"default", (Object)this.poolManager.getSession(null, this.conf, false, false).getQueueName());
            this.conf.unset("tez.queue.name");
            Mockito.when((Object)session.getQueueName()).thenReturn((Object)"tezq1");
            this.poolManager.reopenSession(session, this.conf, null, false);
            Assert.assertEquals((Object)"tezq1", (Object)this.poolManager.getSession(null, this.conf, false, false).getQueueName());
            this.conf.set("tez.queue.name", "default");
            this.poolManager.reopenSession(session, this.conf, null, false);
            Assert.assertEquals((Object)"default", (Object)this.poolManager.getSession(null, this.conf, false, false).getQueueName());
            this.conf.unset("tez.queue.name");
            this.poolManager.reopenSession(session, this.conf, null, false);
            Assert.assertEquals((Object)"tezq1", (Object)this.poolManager.getSession(null, this.conf, false, false).getQueueName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testSessionReopenWithPreservingQueueName() {
        try {
            this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
            this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_DEFAULT_QUEUES, "q1,q2");
            this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSIONS_PER_DEFAULT_QUEUE, 1);
            this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_UNSET_TEZ_QUEUE_NAME, false);
            this.poolManager = new TestTezSessionPoolManager();
            TezSessionState session = (TezSessionState)Mockito.mock(TezSessionState.class);
            Mockito.when((Object)session.getQueueName()).thenReturn((Object)"q1");
            Mockito.when((Object)session.isDefault()).thenReturn((Object)false);
            Mockito.when((Object)session.getConf()).thenReturn((Object)this.conf);
            this.poolManager.reopenSession(session, this.conf, null, false);
            ((TezSessionState)Mockito.verify((Object)session)).close(false);
            String[] files = null;
            ((TezSessionState)Mockito.verify((Object)session)).open(this.conf, files);
            Assert.assertEquals((Object)"q1", (Object)session.getQueueName());
            this.conf.set("tez.queue.name", "q2");
            this.poolManager.reopenSession(session, this.conf, null, false);
            Assert.assertEquals((Object)"q2", (Object)this.poolManager.getSession(null, this.conf, false, false).getQueueName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testLlapSessionQueuing() {
        try {
            this.random = new Random(1000L);
            this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_LLAP_CONCURRENT_QUERIES, 2);
            this.poolManager = new TestTezSessionPoolManager();
            this.poolManager.setupPool(this.conf);
            this.poolManager.startPool();
        }
        catch (Exception e) {
            LOG.error("Initialization error", (Throwable)e);
            Assert.fail();
        }
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        for (int i = 0; i < 15; ++i) {
            Thread t = new Thread(new SessionThread(true));
            threadList.add(t);
            t.start();
        }
        for (Thread t : threadList) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
    }

    @Test
    public void testReturn() {
        this.conf.set("tez.queue.name", "");
        this.random = new Random(1000L);
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS, false);
        this.conf.setVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_DEFAULT_QUEUES, "a,b,c");
        this.conf.setIntVar(HiveConf.ConfVars.HIVE_SERVER2_TEZ_SESSIONS_PER_DEFAULT_QUEUE, 2);
        try {
            this.poolManager = new TestTezSessionPoolManager();
            this.poolManager.setupPool(this.conf);
            this.poolManager.startPool();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        for (int i = 0; i < 15; ++i) {
            Thread t = new Thread(new SessionThread(false));
            threadList.add(t);
            t.start();
        }
        for (Thread t : threadList) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Assert.fail();
            }
        }
    }

    @Test
    public void testCloseAndOpenDefault() throws Exception {
        this.poolManager = new TestTezSessionPoolManager();
        TezSessionState session = (TezSessionState)Mockito.mock(TezSessionState.class);
        Mockito.when((Object)session.isDefault()).thenReturn((Object)false);
        this.poolManager.reopenSession(session, this.conf, null, false);
        ((TezSessionState)Mockito.verify((Object)session)).close(false);
        String[] files = null;
        ((TezSessionState)Mockito.verify((Object)session)).open(this.conf, files);
    }

    @Test
    public void testSessionDestroy() throws Exception {
        this.poolManager = new TestTezSessionPoolManager();
        TezSessionState session = (TezSessionState)Mockito.mock(TezSessionState.class);
        Mockito.when((Object)session.isDefault()).thenReturn((Object)false);
        this.poolManager.destroySession(session);
    }

    @Test
    public void testCloseAndOpenWithResources() throws Exception {
        this.poolManager = new TestTezSessionPoolManager();
        TezSessionState session = (TezSessionState)Mockito.mock(TezSessionState.class);
        Mockito.when((Object)session.isDefault()).thenReturn((Object)false);
        String[] extraResources = new String[]{"file:///tmp/foo.jar"};
        this.poolManager.reopenSession(session, this.conf, extraResources, false);
        ((TezSessionState)Mockito.verify((Object)session)).close(false);
        ((TezSessionState)Mockito.verify((Object)session)).open(this.conf, extraResources);
    }

    @Test
    public void testTezTasksSequenceExecutionInSession() {
        this.poolManager = new TestTezSessionPoolManager();
        try {
            TezSessionState sessionState = this.poolManager.getSession(null, this.conf, true, false, null);
            this.conf.set("tez.queue.name", "tezTaskQueueName");
            TezSessionState sessionState1 = this.poolManager.getSession(sessionState, this.conf, false, false, "tezTaskQueueName");
            if (sessionState1 == sessionState) {
                Assert.fail();
            }
            sessionState1.open(this.conf);
            this.conf.unset("tez.queue.name");
            TezSessionState sessionState2 = this.poolManager.getSession(sessionState1, this.conf, false, false, "tezTaskQueueName");
            if (sessionState2 != sessionState1) {
                Assert.fail();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    public class SessionThread
    implements Runnable {
        private boolean llap = false;

        public SessionThread(boolean llap) {
            this.llap = llap;
        }

        @Override
        public void run() {
            try {
                HiveConf tmpConf = new HiveConf(TestTezSessionPool.this.conf);
                if (TestTezSessionPool.this.random.nextDouble() > 0.5) {
                    tmpConf.set("tez.queue.name", "default");
                } else {
                    tmpConf.set("tez.queue.name", "");
                }
                TezSessionState session = TestTezSessionPool.this.poolManager.getSession(null, tmpConf, true, this.llap);
                Thread.sleep(TestTezSessionPool.this.random.nextInt(9) % 10 * 1000);
                TestTezSessionPool.this.poolManager.returnSession(session, this.llap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class TestTezSessionPoolManager
    extends TezSessionPoolManager {
        public TezSessionPoolManager.TezSessionPoolSession createSession(String sessionId) {
            return new SampleTezSessionState(sessionId, this);
        }
    }
}

