/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class CastStringToIntervalYearMonth
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int inputColumn;
    private int outputColumn;

    public CastStringToIntervalYearMonth() {
    }

    public CastStringToIntervalYearMonth(int inputColumn, int outputColumn) {
        this.inputColumn = inputColumn;
        this.outputColumn = outputColumn;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        BytesColumnVector inV = (BytesColumnVector)batch.cols[this.inputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumn];
        boolean[] inputIsNull = inV.isNull;
        boolean[] outputIsNull = outV.isNull;
        if (n == 0) {
            return;
        }
        outV.isRepeating = false;
        if (inV.isRepeating) {
            if (inV.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.evaluate(outV, inV, 0);
            } else {
                outputIsNull[0] = true;
                outV.noNulls = false;
            }
            outV.isRepeating = true;
            return;
        }
        if (inV.noNulls) {
            if (batch.selectedInUse) {
                if (!outV.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.evaluate(outV, inV, i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.evaluate(outV, inV, i);
                    }
                }
            } else {
                if (!outV.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outV.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.evaluate(outV, inV, i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inV.isNull[i]) {
                    outputIsNull[i] = false;
                    this.evaluate(outV, inV, i);
                    continue;
                }
                outputIsNull[i] = true;
                outV.noNulls = false;
            }
        } else {
            System.arraycopy(inV.isNull, 0, outV.isNull, 0, n);
            for (int i = 0; i != n; ++i) {
                if (!inV.isNull[i]) {
                    outputIsNull[i] = false;
                    this.evaluate(outV, inV, i);
                    continue;
                }
                outputIsNull[i] = true;
                outV.noNulls = false;
            }
        }
    }

    private void evaluate(LongColumnVector outV, BytesColumnVector inV, int i) {
        try {
            HiveIntervalYearMonth interval = HiveIntervalYearMonth.valueOf(new String(inV.vector[i], inV.start[i], inV.length[i], "UTF-8"));
            outV.vector[i] = interval.getTotalMonths();
        }
        catch (Exception e) {
            outV.vector[i] = 1L;
            outV.isNull[i] = true;
            outV.noNulls = false;
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public int getInputColumn() {
        return this.inputColumn;
    }

    public void setInputColumn(int inputColumn) {
        this.inputColumn = inputColumn;
    }

    @Override
    public String getOutputType() {
        return "interval_year_month";
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.inputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

