/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.exec.TestMsckCreatePartitionsInBatches;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.metadata.CheckResult;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.RetryUtilities;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestMsckDropPartitionsInBatches {
    private static HiveConf hiveConf;
    private static DDLTask ddlTask;
    private final String tableName = "test_msck_batch";
    private static Hive db;
    private List<String> repairOutput;
    private Table table;
    private final int noException = 1;
    private final int oneException = 2;
    private final int allException = 3;

    @BeforeClass
    public static void setupClass() throws HiveException {
        hiveConf = new HiveConf(TestMsckCreatePartitionsInBatches.class);
        hiveConf.set("fs.default.name", "file:///");
        hiveConf.setIntVar(HiveConf.ConfVars.HIVE_MSCK_REPAIR_BATCH_SIZE, 5);
        hiveConf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        SessionState.start((HiveConf)hiveConf);
        db = Hive.get((HiveConf)hiveConf);
        ddlTask = new DDLTask();
    }

    @Before
    public void before() throws Exception {
        this.createPartitionedTable("default", "test_msck_batch");
        this.table = db.getTable("test_msck_batch");
        this.repairOutput = new ArrayList<String>();
    }

    @After
    public void after() throws Exception {
        this.cleanUpTableQuietly("default", "test_msck_batch");
    }

    private Table createPartitionedTable(String dbName, String tableName) throws Exception {
        try {
            db.dropTable(dbName, tableName);
            db.createTable(tableName, Arrays.asList("key", "value"), Arrays.asList("city"), TextInputFormat.class, HiveIgnoreKeyTextOutputFormat.class);
            return db.getTable(dbName, tableName);
        }
        catch (Exception exception) {
            Assert.fail((String)("Unable to drop and create table " + StatsUtils.getFullyQualifiedTableName((String)dbName, (String)tableName) + " because " + StringUtils.stringifyException((Throwable)exception)));
            throw exception;
        }
    }

    private void cleanUpTableQuietly(String dbName, String tableName) {
        try {
            db.dropTable(dbName, tableName, true, true, true);
        }
        catch (Exception exception) {
            Assert.fail((String)("Unexpected exception: " + StringUtils.stringifyException((Throwable)exception)));
        }
    }

    private Set<CheckResult.PartitionResult> dropPartsNotInFs(int numOfParts) {
        HashSet<CheckResult.PartitionResult> partsNotInFs = new HashSet<CheckResult.PartitionResult>();
        for (int i = 0; i < numOfParts; ++i) {
            CheckResult.PartitionResult result = new CheckResult.PartitionResult();
            result.setPartitionName("city=dummyCity_" + String.valueOf(i));
            partsNotInFs.add(result);
        }
        return partsNotInFs;
    }

    private int findMSB(int n) {
        int msbIndex = 0;
        Assert.assertTrue((String)"Only positive values expected", (n > 0 ? 1 : 0) != 0);
        while (n > 1) {
            n >>= 1;
            ++msbIndex;
        }
        return msbIndex;
    }

    private void runDropPartitions(int partCount, int batchSize, int maxRetries, int exceptionStatus) throws Exception {
        int[] expectedBatchSizes;
        Hive spyDb = (Hive)Mockito.spy((Object)db);
        Set<CheckResult.PartitionResult> partsNotInFs = this.dropPartsNotInFs(partCount);
        int expectedCallCount = maxRetries;
        int lastBatchSize = batchSize;
        int actualBatchSize = batchSize;
        if (exceptionStatus == 2) {
            actualBatchSize = batchSize / 2;
        }
        if (exceptionStatus != 3) {
            expectedCallCount = partCount / actualBatchSize;
            if (expectedCallCount * actualBatchSize < partCount) {
                lastBatchSize = partCount - expectedCallCount * actualBatchSize;
                ++expectedCallCount;
            }
            if (exceptionStatus == 2) {
                ++expectedCallCount;
                ((Hive)Mockito.doThrow(HiveException.class).doCallRealMethod().doCallRealMethod().when((Object)spyDb)).dropPartitions((Table)Mockito.eq((Object)this.table), (List)Mockito.any(List.class), Mockito.eq((boolean)false), Mockito.eq((boolean)true));
            }
            expectedBatchSizes = new int[expectedCallCount];
            expectedBatchSizes[0] = Integer.min(partCount, batchSize);
            for (int i = 1; i < expectedCallCount - 1; ++i) {
                expectedBatchSizes[i] = Integer.min(partCount, actualBatchSize);
            }
            expectedBatchSizes[expectedCallCount - 1] = lastBatchSize;
            ddlTask.dropPartitionsInBatches(spyDb, this.repairOutput, partsNotInFs, this.table, batchSize, 2, maxRetries);
        } else {
            if (maxRetries == 0) {
                expectedCallCount = this.findMSB(batchSize) + 1;
            }
            expectedBatchSizes = new int[expectedCallCount];
            for (int i = 0; i < expectedCallCount; ++i) {
                actualBatchSize = batchSize / (int)Math.pow(2.0, i);
                expectedBatchSizes[i] = Integer.min(partCount, actualBatchSize);
            }
            ((Hive)Mockito.doThrow(HiveException.class).when((Object)spyDb)).dropPartitions((Table)Mockito.eq((Object)this.table), (List)Mockito.any(List.class), Mockito.eq((boolean)false), Mockito.eq((boolean)true));
            Exception ex = null;
            try {
                ddlTask.dropPartitionsInBatches(spyDb, this.repairOutput, partsNotInFs, this.table, batchSize, 2, maxRetries);
            }
            catch (Exception retryEx) {
                ex = retryEx;
            }
            Assert.assertFalse((String)"Exception was expected but was not thrown", (ex == null ? 1 : 0) != 0);
            Assert.assertTrue((String)"Unexpected class of exception thrown", (boolean)(ex instanceof RetryUtilities.RetryException));
        }
        ArgumentCaptor argument = ArgumentCaptor.forClass(List.class);
        ((Hive)Mockito.verify((Object)spyDb, (VerificationMode)Mockito.times((int)expectedCallCount))).dropPartitions((Table)Mockito.eq((Object)this.table), (List)argument.capture(), Mockito.eq((boolean)false), Mockito.eq((boolean)true));
        List droppedParts = argument.getAllValues();
        for (int i = 0; i < expectedCallCount; ++i) {
            Assert.assertEquals((String)String.format("Unexpected batch size in attempt %d.  Expected: %d.  Found: %d", i + 1, expectedBatchSizes[i], ((List)droppedParts.get(i)).size()), (long)expectedBatchSizes[i], (long)((List)droppedParts.get(i)).size());
        }
    }

    private void runDropPartitions(int partCount, int batchSize) throws Exception {
        this.runDropPartitions(partCount, batchSize, 0, 1);
    }

    @Test
    public void testNumberOfDropPartitionsCalls() throws Exception {
        this.runDropPartitions(10, 5);
    }

    @Test
    public void testUnevenNumberOfCreatePartitionCalls() throws Exception {
        this.runDropPartitions(14, 5);
    }

    @Test
    public void testEqualNumberOfPartitions() throws Exception {
        this.runDropPartitions(13, 13);
    }

    @Test
    public void testSmallNumberOfPartitions() throws Exception {
        this.runDropPartitions(10, 20);
    }

    @Test
    public void testBatchingWhenException() throws Exception {
        this.runDropPartitions(23, 30, 0, 2);
    }

    @Test
    public void testRetriesExhaustedBatchSize() throws Exception {
        this.runDropPartitions(17, 30, 0, 3);
    }

    @Test
    public void testMaxRetriesReached() throws Exception {
        this.runDropPartitions(17, 30, 2, 3);
    }

    @Test
    public void testOneMaxRetries() throws Exception {
        this.runDropPartitions(17, 30, 1, 3);
    }
}

