/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class FilterDecimalColGreaterEqualDecimalColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;

    public FilterDecimalColGreaterEqualDecimalColumn(int colNum1, int colNum2) {
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public FilterDecimalColGreaterEqualDecimalColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DecimalColumnVector inputColVector1 = (DecimalColumnVector)batch.cols[this.colNum1];
        DecimalColumnVector inputColVector2 = (DecimalColumnVector)batch.cols[this.colNum2];
        int[] sel = batch.selected;
        boolean[] nullPos1 = inputColVector1.isNull;
        boolean[] nullPos2 = inputColVector2.isNull;
        int n = batch.size;
        HiveDecimalWritable[] vector1 = inputColVector1.vector;
        HiveDecimalWritable[] vector2 = inputColVector2.vector;
        if (n == 0) {
            return;
        }
        if (inputColVector1.noNulls && inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (vector1[0].compareTo(vector2[0]) < 0) {
                    batch.size = 0;
                }
            } else if (inputColVector1.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (vector1[0].compareTo(vector2[i]) < 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (vector1[0].compareTo(vector2[i]) < 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (vector1[i].compareTo(vector2[0]) < 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (vector1[i].compareTo(vector2[0]) < 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (vector1[i].compareTo(vector2[i]) < 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (vector1[i].compareTo(vector2[i]) < 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector1.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (nullPos2[0] || vector1[0].compareTo(vector2[0]) < 0) {
                    batch.size = 0;
                }
            } else if (inputColVector1.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (nullPos2[i] || vector1[0].compareTo(vector2[i]) < 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (nullPos2[i] || vector1[0].compareTo(vector2[i]) < 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (nullPos2[0]) {
                    batch.size = 0;
                    return;
                }
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (vector1[i].compareTo(vector2[0]) < 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (vector1[i].compareTo(vector2[0]) < 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos2[i] || vector1[i].compareTo(vector2[i]) < 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos2[i] || vector1[i].compareTo(vector2[i]) < 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector2.noNulls) {
            if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
                if (nullPos1[0] || vector1[0].compareTo(vector2[0]) < 0) {
                    batch.size = 0;
                    return;
                }
            } else if (inputColVector1.isRepeating) {
                if (nullPos1[0]) {
                    batch.size = 0;
                    return;
                }
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (vector1[0].compareTo(vector2[i]) < 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (vector1[0].compareTo(vector2[i]) < 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (inputColVector2.isRepeating) {
                if (batch.selectedInUse) {
                    int newSize = 0;
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        if (nullPos1[i] || vector1[i].compareTo(vector2[0]) < 0) continue;
                        sel[newSize++] = i;
                    }
                    batch.size = newSize;
                } else {
                    int newSize = 0;
                    for (int i = 0; i != n; ++i) {
                        if (nullPos1[i] || vector1[i].compareTo(vector2[0]) < 0) continue;
                        sel[newSize++] = i;
                    }
                    if (newSize < batch.size) {
                        batch.size = newSize;
                        batch.selectedInUse = true;
                    }
                }
            } else if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos1[i] || vector1[i].compareTo(vector2[i]) < 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos1[i] || vector1[i].compareTo(vector2[i]) < 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            if (nullPos1[0] || nullPos2[0] || vector1[0].compareTo(vector2[0]) < 0) {
                batch.size = 0;
            }
        } else if (inputColVector1.isRepeating) {
            if (nullPos1[0]) {
                batch.size = 0;
                return;
            }
            if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos2[i] || vector1[0].compareTo(vector2[i]) < 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos2[i] || vector1[0].compareTo(vector2[i]) < 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (nullPos2[0]) {
                batch.size = 0;
                return;
            }
            if (batch.selectedInUse) {
                int newSize = 0;
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (nullPos1[i] || vector1[i].compareTo(vector2[0]) < 0) continue;
                    sel[newSize++] = i;
                }
                batch.size = newSize;
            } else {
                int newSize = 0;
                for (int i = 0; i != n; ++i) {
                    if (nullPos1[i] || vector1[i].compareTo(vector2[0]) < 0) continue;
                    sel[newSize++] = i;
                }
                if (newSize < batch.size) {
                    batch.size = newSize;
                    batch.selectedInUse = true;
                }
            }
        } else if (batch.selectedInUse) {
            int newSize = 0;
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (nullPos1[i] || nullPos2[i] || vector1[i].compareTo(vector2[i]) < 0) continue;
                sel[newSize++] = i;
            }
            batch.size = newSize;
        } else {
            int newSize = 0;
            for (int i = 0; i != n; ++i) {
                if (nullPos1[i] || nullPos2[i] || vector1[i].compareTo(vector2[i]) < 0) continue;
                sel[newSize++] = i;
            }
            if (newSize < batch.size) {
                batch.size = newSize;
                batch.selectedInUse = true;
            }
        }
    }

    @Override
    public String getOutputType() {
        return "boolean";
    }

    @Override
    public int getOutputColumn() {
        return -1;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum1 + ", col " + this.colNum2;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("decimal"), VectorExpressionDescriptor.ArgumentType.getType("decimal")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

