/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.lockmgr.DummyTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManagerCtx;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.lockmgr.TxnManagerFactory;
import org.apache.hadoop.hive.ql.lockmgr.zookeeper.ZooKeeperHiveLock;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TestDummyTxnManager {
    private final HiveConf conf = new HiveConf();
    private HiveTxnManager txnMgr;
    private Context ctx;
    private int nextInput = 1;
    @Mock
    HiveLockManager mockLockManager;
    @Mock
    QueryPlan mockQueryPlan;

    @Before
    public void setUp() throws Exception {
        this.conf.set("fs.default.name", "file:///");
        this.conf.setBoolVar(HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY, true);
        this.conf.setVar(HiveConf.ConfVars.HIVE_TXN_MANAGER, DummyTxnManager.class.getName());
        this.conf.setVar(HiveConf.ConfVars.HIVE_AUTHORIZATION_MANAGER, "org.apache.hadoop.hive.ql.security.authorization.plugin.sqlstd.SQLStdHiveAuthorizerFactory");
        SessionState.start((HiveConf)this.conf);
        this.ctx = new Context((Configuration)this.conf);
        this.txnMgr = TxnManagerFactory.getTxnManagerFactory().getTxnManager(this.conf);
        Assert.assertTrue((boolean)(this.txnMgr instanceof DummyTxnManager));
        Field field = DummyTxnManager.class.getDeclaredField("lockMgr");
        field.setAccessible(true);
        field.set(this.txnMgr, this.mockLockManager);
    }

    @After
    public void tearDown() throws Exception {
        if (this.txnMgr != null) {
            this.txnMgr.closeTxnManager();
        }
    }

    @Test
    public void testSingleReadTable() throws Exception {
        SessionState.get().setCurrentDatabase("db1");
        ArrayList<ZooKeeperHiveLock> expectedLocks = new ArrayList<ZooKeeperHiveLock>();
        expectedLocks.add(new ZooKeeperHiveLock("default", new HiveLockObject(), HiveLockMode.SHARED));
        expectedLocks.add(new ZooKeeperHiveLock("default.table1", new HiveLockObject(), HiveLockMode.SHARED));
        Driver.LockedDriverState lDrvState = new Driver.LockedDriverState();
        Driver.LockedDriverState lDrvInp = new Driver.LockedDriverState();
        lDrvInp.driverState = Driver.DriverState.INTERRUPT;
        LockException lEx = new LockException(ErrorMsg.LOCK_ACQUIRE_CANCELLED.getMsg());
        Mockito.when((Object)this.mockLockManager.lock(Mockito.anyListOf(HiveLockObj.class), Mockito.eq((boolean)false), (Driver.LockedDriverState)Mockito.eq((Object)lDrvState))).thenReturn(expectedLocks);
        Mockito.when((Object)this.mockLockManager.lock(Mockito.anyListOf(HiveLockObj.class), Mockito.eq((boolean)false), (Driver.LockedDriverState)Mockito.eq((Object)lDrvInp))).thenThrow(new Throwable[]{lEx});
        ((HiveLockManager)Mockito.doNothing().when((Object)this.mockLockManager)).setContext((HiveLockManagerCtx)Mockito.any(HiveLockManagerCtx.class));
        ((HiveLockManager)Mockito.doNothing().when((Object)this.mockLockManager)).close();
        ArgumentCaptor lockObjsCaptor = ArgumentCaptor.forClass(List.class);
        Mockito.when((Object)this.mockQueryPlan.getInputs()).thenReturn(this.createReadEntities());
        Mockito.when((Object)this.mockQueryPlan.getOutputs()).thenReturn(new HashSet());
        this.txnMgr.acquireLocks(this.mockQueryPlan, this.ctx, "fred", lDrvState);
        Assert.assertEquals((Object)"db1", (Object)SessionState.get().getCurrentDatabase());
        List resultLocks = this.ctx.getHiveLocks();
        Assert.assertEquals((long)expectedLocks.size(), (long)resultLocks.size());
        Assert.assertEquals((Object)((HiveLock)expectedLocks.get(0)).getHiveLockMode(), (Object)((HiveLock)resultLocks.get(0)).getHiveLockMode());
        Assert.assertEquals((Object)((HiveLock)expectedLocks.get(0)).getHiveLockObject().getName(), (Object)((HiveLock)resultLocks.get(0)).getHiveLockObject().getName());
        Assert.assertEquals((Object)((HiveLock)expectedLocks.get(1)).getHiveLockMode(), (Object)((HiveLock)resultLocks.get(1)).getHiveLockMode());
        Assert.assertEquals((Object)((HiveLock)expectedLocks.get(0)).getHiveLockObject().getName(), (Object)((HiveLock)resultLocks.get(0)).getHiveLockObject().getName());
        ((HiveLockManager)Mockito.verify((Object)this.mockLockManager)).lock((List)lockObjsCaptor.capture(), Mockito.eq((boolean)false), (Driver.LockedDriverState)Mockito.eq((Object)lDrvState));
        List lockObjs = (List)lockObjsCaptor.getValue();
        Assert.assertEquals((long)2L, (long)lockObjs.size());
        Assert.assertEquals((Object)"default", (Object)((HiveLockObj)lockObjs.get(0)).getName());
        Assert.assertEquals((Object)HiveLockMode.SHARED, (Object)((HiveLockObj)lockObjs.get((int)0)).mode);
        Assert.assertEquals((Object)"default/table1", (Object)((HiveLockObj)lockObjs.get(1)).getName());
        Assert.assertEquals((Object)HiveLockMode.SHARED, (Object)((HiveLockObj)lockObjs.get((int)1)).mode);
        try {
            this.txnMgr.acquireLocks(this.mockQueryPlan, this.ctx, "fred", lDrvInp);
            Assert.fail();
        }
        catch (LockException le) {
            Assert.assertEquals((Object)le.getMessage(), (Object)ErrorMsg.LOCK_ACQUIRE_CANCELLED.getMsg());
        }
    }

    @Test
    public void testDedupLockObjects() {
        ArrayList<HiveLockObj> lockObjs = new ArrayList<HiveLockObj>();
        String path1 = "path1";
        String path2 = "path2";
        HiveLockObject.HiveLockObjectData lockData1 = new HiveLockObject.HiveLockObjectData("query1", "1", "IMPLICIT", "drop table table1", this.conf);
        HiveLockObject.HiveLockObjectData lockData2 = new HiveLockObject.HiveLockObjectData("query1", "1", "IMPLICIT", "drop table table1", this.conf);
        lockObjs.add(new HiveLockObj(new HiveLockObject(path1, lockData1), HiveLockMode.SHARED));
        String name1 = ((HiveLockObj)lockObjs.get(lockObjs.size() - 1)).getName();
        lockObjs.add(new HiveLockObj(new HiveLockObject(path1, lockData1), HiveLockMode.EXCLUSIVE));
        lockObjs.add(new HiveLockObj(new HiveLockObject(path2, lockData2), HiveLockMode.SHARED));
        String name2 = ((HiveLockObj)lockObjs.get(lockObjs.size() - 1)).getName();
        lockObjs.add(new HiveLockObj(new HiveLockObject(path2, lockData2), HiveLockMode.SHARED));
        lockObjs.add(new HiveLockObj(new HiveLockObject(path2, lockData2), HiveLockMode.SHARED));
        DummyTxnManager.dedupLockObjects(lockObjs);
        Assert.assertEquals((String)"Locks should be deduped", (long)2L, (long)lockObjs.size());
        Comparator<HiveLockObj> cmp = new Comparator<HiveLockObj>(){

            @Override
            public int compare(HiveLockObj lock1, HiveLockObj lock2) {
                return lock1.getName().compareTo(lock2.getName());
            }
        };
        Collections.sort(lockObjs, cmp);
        HiveLockObj lockObj = (HiveLockObj)lockObjs.get(0);
        Assert.assertEquals((Object)name1, (Object)lockObj.getName());
        Assert.assertEquals((Object)HiveLockMode.EXCLUSIVE, (Object)lockObj.getMode());
        lockObj = (HiveLockObj)lockObjs.get(1);
        Assert.assertEquals((Object)name2, (Object)lockObj.getName());
        Assert.assertEquals((Object)HiveLockMode.SHARED, (Object)lockObj.getMode());
    }

    private HashSet<ReadEntity> createReadEntities() {
        HashSet<ReadEntity> readEntities = new HashSet<ReadEntity>();
        ReadEntity re = new ReadEntity(this.newTable(false));
        readEntities.add(re);
        return readEntities;
    }

    private Table newTable(boolean isPartitioned) {
        Table t = new Table("default", "table" + Integer.toString(this.nextInput++));
        if (isPartitioned) {
            FieldSchema fs = new FieldSchema();
            fs.setName("version");
            fs.setType("String");
            ArrayList<FieldSchema> partCols = new ArrayList<FieldSchema>(1);
            partCols.add(fs);
            t.setPartCols(partCols);
        }
        return t;
    }
}

