/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.server.coordinator.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.io.druid.java.util.common.DateTimes;
import org.apache.hive.druid.io.druid.java.util.common.guava.Comparators;
import org.apache.hive.druid.io.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.io.druid.metadata.MetadataRuleManager;
import org.apache.hive.druid.io.druid.server.coordinator.CoordinatorStats;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCluster;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinator;
import org.apache.hive.druid.io.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.hive.druid.io.druid.server.coordinator.ReplicationThrottler;
import org.apache.hive.druid.io.druid.server.coordinator.helper.DruidCoordinatorHelper;
import org.apache.hive.druid.io.druid.server.coordinator.rules.Rule;
import org.apache.hive.druid.io.druid.timeline.DataSegment;
import org.apache.hive.druid.io.druid.timeline.TimelineObjectHolder;
import org.apache.hive.druid.io.druid.timeline.VersionedIntervalTimeline;
import org.joda.time.DateTime;

public class DruidCoordinatorRuleRunner
implements DruidCoordinatorHelper {
    private static final EmittingLogger log = new EmittingLogger(DruidCoordinatorRuleRunner.class);
    private static int MAX_MISSING_RULES = 10;
    private final ReplicationThrottler replicatorThrottler;
    private final DruidCoordinator coordinator;

    public DruidCoordinatorRuleRunner(DruidCoordinator coordinator) {
        this(new ReplicationThrottler(coordinator.getDynamicConfigs().getReplicationThrottleLimit(), coordinator.getDynamicConfigs().getReplicantLifetime()), coordinator);
    }

    public DruidCoordinatorRuleRunner(ReplicationThrottler replicatorThrottler, DruidCoordinator coordinator) {
        this.replicatorThrottler = replicatorThrottler;
        this.coordinator = coordinator;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        this.replicatorThrottler.updateParams(this.coordinator.getDynamicConfigs().getReplicationThrottleLimit(), this.coordinator.getDynamicConfigs().getReplicantLifetime());
        CoordinatorStats stats = new CoordinatorStats();
        DruidCluster cluster = params.getDruidCluster();
        if (cluster.isEmpty()) {
            log.warn("Uh... I have no servers. Not assigning anything...", new Object[0]);
            return params;
        }
        HashMap<String, Iterator<String>> timelines = new HashMap<String, Iterator<String>>();
        for (DataSegment dataSegment : params.getAvailableSegments()) {
            Object timeline = (VersionedIntervalTimeline)timelines.get(dataSegment.getDataSource());
            if (timeline == null) {
                timeline = new VersionedIntervalTimeline(Comparators.comparable());
                timelines.put(dataSegment.getDataSource(), (Iterator<String>)timeline);
            }
            ((VersionedIntervalTimeline)timeline).add(dataSegment.getInterval(), dataSegment.getVersion(), dataSegment.getShardSpec().createChunk(dataSegment));
        }
        HashSet<DataSegment> overshadowed = new HashSet<DataSegment>();
        for (Object timeline : timelines.values()) {
            for (TimelineObjectHolder holder : ((VersionedIntervalTimeline)timeline).findOvershadowed()) {
                for (DataSegment dataSegment : holder.getObject().payloads()) {
                    overshadowed.add(dataSegment);
                }
            }
        }
        HashSet<DataSegment> hashSet = new HashSet<DataSegment>();
        for (DataSegment dataSegment : params.getAvailableSegments()) {
            if (overshadowed.contains(dataSegment)) continue;
            hashSet.add(dataSegment);
        }
        for (String tier : cluster.getTierNames()) {
            this.replicatorThrottler.updateReplicationState(tier);
        }
        DruidCoordinatorRuntimeParams paramsWithReplicationManager = params.buildFromExistingWithoutAvailableSegments().withReplicationManager(this.replicatorThrottler).withAvailableSegments(hashSet).build();
        DateTime now = DateTimes.nowUtc();
        MetadataRuleManager databaseRuleManager = paramsWithReplicationManager.getDatabaseRuleManager();
        ArrayList<String> segmentsWithMissingRules = Lists.newArrayListWithCapacity(MAX_MISSING_RULES);
        int missingRules = 0;
        for (DataSegment segment : paramsWithReplicationManager.getAvailableSegments()) {
            List<Rule> rules = databaseRuleManager.getRulesWithDefault(segment.getDataSource());
            boolean foundMatchingRule = false;
            for (Rule rule : rules) {
                if (!rule.appliesTo(segment, now)) continue;
                stats.accumulate(rule.run(this.coordinator, paramsWithReplicationManager, segment));
                foundMatchingRule = true;
                break;
            }
            if (foundMatchingRule) continue;
            if (segmentsWithMissingRules.size() < MAX_MISSING_RULES) {
                segmentsWithMissingRules.add(segment.getIdentifier());
            }
            ++missingRules;
        }
        if (!segmentsWithMissingRules.isEmpty()) {
            log.makeAlert("Unable to find matching rules!", new Object[0]).addData("segmentsWithMissingRulesCount", missingRules).addData("segmentsWithMissingRules", segmentsWithMissingRules).emit();
        }
        return paramsWithReplicationManager.buildFromExistingWithoutAvailableSegments().withCoordinatorStats(stats).withAvailableSegments(params.getAvailableSegments()).build();
    }
}

