/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.realtime.appenderator;

import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.segment.realtime.appenderator.SegmentIdentifier;
import org.apache.hive.druid.io.druid.timeline.DataSegment;

public class SegmentWithState {
    private final SegmentIdentifier segmentIdentifier;
    private SegmentState state;
    @Nullable
    private DataSegment dataSegment;

    static SegmentWithState newSegment(SegmentIdentifier segmentIdentifier) {
        return new SegmentWithState(segmentIdentifier, SegmentState.APPENDING, null);
    }

    static SegmentWithState newSegment(SegmentIdentifier segmentIdentifier, SegmentState state) {
        return new SegmentWithState(segmentIdentifier, state, null);
    }

    @JsonCreator
    public SegmentWithState(@JsonProperty(value="segmentIdentifier") SegmentIdentifier segmentIdentifier, @JsonProperty(value="state") SegmentState state, @JsonProperty(value="dataSegment") @Nullable DataSegment dataSegment) {
        this.segmentIdentifier = segmentIdentifier;
        this.state = state;
        this.dataSegment = dataSegment;
    }

    public void setState(SegmentState state) {
        this.state = state;
    }

    public void finishAppending() {
        SegmentWithState.checkStateTransition(this.state, SegmentState.APPENDING, SegmentState.APPEND_FINISHED);
        this.state = SegmentState.APPEND_FINISHED;
    }

    public void pushAndDrop(DataSegment dataSegment) {
        SegmentWithState.checkStateTransition(this.state, SegmentState.APPENDING, SegmentState.PUSHED_AND_DROPPED);
        this.state = SegmentState.PUSHED_AND_DROPPED;
        this.dataSegment = dataSegment;
    }

    @JsonProperty
    public SegmentIdentifier getSegmentIdentifier() {
        return this.segmentIdentifier;
    }

    @JsonProperty
    public SegmentState getState() {
        return this.state;
    }

    @JsonProperty
    @Nullable
    public DataSegment getDataSegment() {
        return this.dataSegment;
    }

    private static void checkStateTransition(SegmentState actualFrom, SegmentState expectedFrom, SegmentState to) {
        Preconditions.checkState(actualFrom == expectedFrom, "Wrong state transition from [%s] to [%s]", new Object[]{actualFrom, to});
    }

    public static enum SegmentState {
        APPENDING,
        APPEND_FINISHED,
        PUSHED_AND_DROPPED;


        @JsonCreator
        public static SegmentState fromString(@JsonProperty String name) {
            if (name.equalsIgnoreCase("ACTIVE")) {
                return APPENDING;
            }
            if (name.equalsIgnoreCase("INACTIVE")) {
                return APPEND_FINISHED;
            }
            return SegmentState.valueOf(name);
        }
    }
}

