/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.segment.loading;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JacksonInject;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hive.druid.com.fasterxml.jackson.annotation.JsonTypeName;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.segment.loading.LoadSpec;
import org.apache.hive.druid.io.druid.segment.loading.LocalDataSegmentPuller;
import org.apache.hive.druid.io.druid.segment.loading.SegmentLoadingException;

@JsonTypeName(value="local")
public class LocalLoadSpec
implements LoadSpec {
    private final Path path;
    private final LocalDataSegmentPuller puller;

    @JsonCreator
    public LocalLoadSpec(@JacksonInject LocalDataSegmentPuller puller, @JsonProperty(value="path", required=true) String path) {
        Preconditions.checkNotNull(path);
        this.path = Paths.get(path, new String[0]);
        Preconditions.checkArgument(Files.exists(Paths.get(path, new String[0]), new LinkOption[0]), "[%s] does not exist", new Object[]{path});
        this.puller = puller;
    }

    @JsonProperty
    public String getPath() {
        return this.path.toString();
    }

    @Override
    public LoadSpec.LoadSpecResult loadSegment(File outDir) throws SegmentLoadingException {
        return new LoadSpec.LoadSpecResult(this.puller.getSegmentFiles(this.path.toFile(), outDir).size());
    }
}

