/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.org.apache.calcite.plan.Convention;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRule;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.hive.druid.org.apache.calcite.plan.RelOptUtil;
import org.apache.hive.druid.org.apache.calcite.rel.RelNode;
import org.apache.hive.druid.org.apache.calcite.rel.core.RelFactories;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.tools.RelBuilderFactory;

public class CoerceInputsRule
extends RelOptRule {
    private final Class consumerRelClass;
    private final boolean coerceNames;

    @Deprecated
    public CoerceInputsRule(Class<? extends RelNode> consumerRelClass, boolean coerceNames) {
        this(consumerRelClass, coerceNames, RelFactories.LOGICAL_BUILDER);
    }

    public CoerceInputsRule(Class<? extends RelNode> consumerRelClass, boolean coerceNames, RelBuilderFactory relBuilderFactory) {
        super(CoerceInputsRule.operand(consumerRelClass, CoerceInputsRule.any()), relBuilderFactory, "CoerceInputsRule:" + consumerRelClass.getName());
        this.consumerRelClass = consumerRelClass;
        this.coerceNames = coerceNames;
    }

    @Override
    public Convention getOutConvention() {
        return Convention.NONE;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Object consumerRel = call.rel(0);
        if (consumerRel.getClass() != this.consumerRelClass) {
            return;
        }
        List<RelNode> inputs = consumerRel.getInputs();
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>(inputs);
        boolean coerce = false;
        for (int i = 0; i < inputs.size(); ++i) {
            RelDataType expectedType = consumerRel.getExpectedInputRowType(i);
            RelNode input = inputs.get(i);
            RelNode newInput = RelOptUtil.createCastRel(input, expectedType, this.coerceNames);
            if (newInput != input) {
                newInputs.set(i, newInput);
                coerce = true;
            }
            assert (RelOptUtil.areRowTypesEqual(((RelNode)newInputs.get(i)).getRowType(), expectedType, this.coerceNames));
        }
        if (!coerce) {
            return;
        }
        RelNode newConsumerRel = consumerRel.copy(consumerRel.getTraitSet(), newInputs);
        call.transformTo(newConsumerRel);
    }
}

