/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.calcite.adapter.druid;

import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.BoundType;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.collect.Range;
import org.apache.hive.druid.com.google.common.collect.TreeRangeSet;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.DruidTable;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.Granularities;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.Granularity;
import org.apache.hive.druid.org.apache.calcite.adapter.druid.TimeExtractionFunction;
import org.apache.hive.druid.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.hive.druid.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.hive.druid.org.apache.calcite.rel.type.RelDataType;
import org.apache.hive.druid.org.apache.calcite.rex.RexCall;
import org.apache.hive.druid.org.apache.calcite.rex.RexInputRef;
import org.apache.hive.druid.org.apache.calcite.rex.RexLiteral;
import org.apache.hive.druid.org.apache.calcite.rex.RexNode;
import org.apache.hive.druid.org.apache.calcite.sql.SqlKind;
import org.apache.hive.druid.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.hive.druid.org.apache.calcite.util.DateString;
import org.apache.hive.druid.org.apache.calcite.util.TimestampString;
import org.apache.hive.druid.org.apache.calcite.util.TimestampWithTimeZoneString;
import org.apache.hive.druid.org.apache.calcite.util.Util;
import org.apache.hive.druid.org.apache.calcite.util.trace.CalciteTrace;
import org.joda.time.Chronology;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.chrono.ISOChronology;
import org.slf4j.Logger;

public class DruidDateTimeUtils {
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();

    private DruidDateTimeUtils() {
    }

    @Nullable
    public static List<Interval> createInterval(RexNode e, String timeZone) {
        List<Range<TimestampString>> ranges = DruidDateTimeUtils.extractRanges(e, TimeZone.getTimeZone(timeZone), false);
        if (ranges == null) {
            return null;
        }
        TreeRangeSet<TimestampString> condensedRanges = TreeRangeSet.create();
        for (Range<TimestampString> r : ranges) {
            condensedRanges.add(r);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Inferred ranges on interval : " + condensedRanges);
        }
        return DruidDateTimeUtils.toInterval(ImmutableList.copyOf(condensedRanges.asRanges()));
    }

    protected static List<Interval> toInterval(List<Range<TimestampString>> ranges) {
        List<Interval> intervals = Lists.transform(ranges, new Function<Range<TimestampString>, Interval>(){

            @Override
            public Interval apply(Range<TimestampString> range) {
                long end;
                if (!range.hasLowerBound() && !range.hasUpperBound()) {
                    return DruidTable.DEFAULT_INTERVAL;
                }
                long start = range.hasLowerBound() ? range.lowerEndpoint().getMillisSinceEpoch() : DruidTable.DEFAULT_INTERVAL.getStartMillis();
                long l = end = range.hasUpperBound() ? range.upperEndpoint().getMillisSinceEpoch() : DruidTable.DEFAULT_INTERVAL.getEndMillis();
                if (range.hasLowerBound() && range.lowerBoundType() == BoundType.OPEN) {
                    ++start;
                }
                if (range.hasUpperBound() && range.upperBoundType() == BoundType.CLOSED) {
                    ++end;
                }
                return new Interval(start, end, (Chronology)ISOChronology.getInstanceUTC());
            }
        });
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Converted time ranges " + ranges + " to interval " + intervals);
        }
        return intervals;
    }

    @Nullable
    protected static List<Range<TimestampString>> extractRanges(RexNode node, TimeZone timeZone, boolean withNot) {
        switch (node.getKind()) {
            case EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case BETWEEN: 
            case IN: {
                return DruidDateTimeUtils.leafToRanges((RexCall)node, timeZone, withNot);
            }
            case NOT: {
                return DruidDateTimeUtils.extractRanges(((RexCall)node).getOperands().get(0), timeZone, !withNot);
            }
            case OR: {
                RexCall call = (RexCall)node;
                ArrayList<Range<TimestampString>> intervals = Lists.newArrayList();
                for (RexNode child : call.getOperands()) {
                    List<Range<TimestampString>> extracted = DruidDateTimeUtils.extractRanges(child, timeZone, withNot);
                    if (extracted == null) continue;
                    intervals.addAll(extracted);
                }
                return intervals;
            }
            case AND: {
                RexCall call = (RexCall)node;
                ArrayList<Range<TimestampString>> ranges = new ArrayList<Range<TimestampString>>();
                for (RexNode child : call.getOperands()) {
                    List<Range<TimestampString>> extractedRanges = DruidDateTimeUtils.extractRanges(child, timeZone, false);
                    if (extractedRanges == null || extractedRanges.isEmpty()) {
                        return null;
                    }
                    if (ranges.isEmpty()) {
                        ranges.addAll(extractedRanges);
                        continue;
                    }
                    ArrayList<Range<TimestampString>> overlapped = new ArrayList<Range<TimestampString>>();
                    for (Range range : ranges) {
                        for (Range<TimestampString> interval : extractedRanges) {
                            if (!range.isConnected(interval)) continue;
                            overlapped.add(range.intersection(interval));
                        }
                    }
                    ranges = overlapped;
                }
                return ranges;
            }
        }
        return null;
    }

    @Nullable
    protected static List<Range<TimestampString>> leafToRanges(RexCall call, TimeZone timeZone, boolean withNot) {
        switch (call.getKind()) {
            case EQUALS: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: {
                TimestampString value;
                if (call.getOperands().get(0) instanceof RexInputRef && DruidDateTimeUtils.literalValue(call.getOperands().get(1), timeZone) != null) {
                    value = DruidDateTimeUtils.literalValue(call.getOperands().get(1), timeZone);
                } else if (call.getOperands().get(1) instanceof RexInputRef && DruidDateTimeUtils.literalValue(call.getOperands().get(0), timeZone) != null) {
                    value = DruidDateTimeUtils.literalValue(call.getOperands().get(0), timeZone);
                } else {
                    return null;
                }
                switch (call.getKind()) {
                    case LESS_THAN: {
                        return ImmutableList.of(withNot ? Range.atLeast(value) : Range.lessThan(value));
                    }
                    case LESS_THAN_OR_EQUAL: {
                        return ImmutableList.of(withNot ? Range.greaterThan(value) : Range.atMost(value));
                    }
                    case GREATER_THAN: {
                        return ImmutableList.of(withNot ? Range.atMost(value) : Range.greaterThan(value));
                    }
                    case GREATER_THAN_OR_EQUAL: {
                        return ImmutableList.of(withNot ? Range.lessThan(value) : Range.atLeast(value));
                    }
                }
                if (!withNot) {
                    return ImmutableList.of(Range.closed(value, value));
                }
                return ImmutableList.of(Range.lessThan(value), Range.greaterThan(value));
            }
            case BETWEEN: {
                boolean inverted;
                if (DruidDateTimeUtils.literalValue(call.getOperands().get(2), timeZone) == null || DruidDateTimeUtils.literalValue(call.getOperands().get(3), timeZone) == null) {
                    return null;
                }
                TimestampString value1 = DruidDateTimeUtils.literalValue(call.getOperands().get(2), timeZone);
                TimestampString value2 = DruidDateTimeUtils.literalValue(call.getOperands().get(3), timeZone);
                boolean bl = inverted = value1.compareTo(value2) > 0;
                if (!withNot) {
                    return ImmutableList.of(inverted ? Range.closed(value2, value1) : Range.closed(value1, value2));
                }
                return ImmutableList.of(Range.lessThan(inverted ? value2 : value1), Range.greaterThan(inverted ? value1 : value2));
            }
            case IN: {
                ImmutableList.Builder ranges = ImmutableList.builder();
                for (RexNode operand : Util.skip(call.operands)) {
                    TimestampString element = DruidDateTimeUtils.literalValue(operand, timeZone);
                    if (element == null) {
                        return null;
                    }
                    if (withNot) {
                        ranges.add(Range.lessThan(element));
                        ranges.add(Range.greaterThan(element));
                        continue;
                    }
                    ranges.add(Range.closed(element, element));
                }
                return ranges.build();
            }
        }
        return null;
    }

    @Nullable
    protected static TimestampString literalValue(RexNode node, TimeZone timeZone) {
        switch (node.getKind()) {
            case LITERAL: {
                switch (((RexLiteral)node).getTypeName()) {
                    case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                        return ((RexLiteral)node).getValueAs(TimestampString.class);
                    }
                    case TIMESTAMP: {
                        TimestampString t = ((RexLiteral)node).getValueAs(TimestampString.class);
                        return new TimestampWithTimeZoneString(t.toString() + " " + timeZone.getID()).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimestampString();
                    }
                    case DATE: {
                        DateString d = ((RexLiteral)node).getValueAs(DateString.class);
                        return new TimestampWithTimeZoneString(TimestampString.fromMillisSinceEpoch(d.getMillisSinceEpoch()).toString() + " " + timeZone.getID()).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimestampString();
                    }
                }
                break;
            }
            case CAST: {
                assert (node instanceof RexCall);
                RexCall call = (RexCall)node;
                RexNode operand = call.getOperands().get(0);
                RelDataType callType = call.getType();
                RelDataType operandType = operand.getType();
                if (operand.getKind() != SqlKind.LITERAL || callType.getSqlTypeName() != operandType.getSqlTypeName() || callType.getSqlTypeName() != SqlTypeName.DATE && callType.getSqlTypeName() != SqlTypeName.TIMESTAMP && callType.getSqlTypeName() != SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE || !callType.isNullable() || operandType.isNullable()) break;
                return DruidDateTimeUtils.literalValue(operand, timeZone);
            }
        }
        return null;
    }

    public static Granularity extractGranularity(RexNode node, String timeZone) {
        int flagIndex;
        if (TimeExtractionFunction.isValidTimeExtract(node)) {
            flagIndex = 0;
        } else if (TimeExtractionFunction.isValidTimeFloor(node)) {
            flagIndex = 1;
        } else {
            return null;
        }
        RexCall call = (RexCall)node;
        RexLiteral flag = (RexLiteral)call.operands.get(flagIndex);
        TimeUnitRange timeUnit = (TimeUnitRange)flag.getValue();
        return Granularities.createGranularity(timeUnit, timeZone);
    }

    @Nullable
    public static String toISOPeriodFormat(Granularity.Type type) {
        switch (type) {
            case SECOND: {
                return Period.seconds((int)1).toString();
            }
            case MINUTE: {
                return Period.minutes((int)1).toString();
            }
            case HOUR: {
                return Period.hours((int)1).toString();
            }
            case DAY: {
                return Period.days((int)1).toString();
            }
            case WEEK: {
                return Period.weeks((int)1).toString();
            }
            case MONTH: {
                return Period.months((int)1).toString();
            }
            case QUARTER: {
                return Period.months((int)3).toString();
            }
            case YEAR: {
                return Period.years((int)1).toString();
            }
        }
        return null;
    }

    @Nullable
    public static Granularity.Type toDruidGranularity(TimeUnitRange timeUnit) {
        if (timeUnit == null) {
            return null;
        }
        switch (timeUnit) {
            case YEAR: {
                return Granularity.Type.YEAR;
            }
            case QUARTER: {
                return Granularity.Type.QUARTER;
            }
            case MONTH: {
                return Granularity.Type.MONTH;
            }
            case WEEK: {
                return Granularity.Type.WEEK;
            }
            case DAY: {
                return Granularity.Type.DAY;
            }
            case HOUR: {
                return Granularity.Type.HOUR;
            }
            case MINUTE: {
                return Granularity.Type.MINUTE;
            }
            case SECOND: {
                return Granularity.Type.SECOND;
            }
        }
        return null;
    }
}

