/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.netty.resolver.dns;

import java.util.ArrayList;
import org.apache.hive.druid.io.netty.bootstrap.ChannelFactory;
import org.apache.hive.druid.io.netty.channel.EventLoop;
import org.apache.hive.druid.io.netty.channel.ReflectiveChannelFactory;
import org.apache.hive.druid.io.netty.channel.socket.DatagramChannel;
import org.apache.hive.druid.io.netty.channel.socket.InternetProtocolFamily2;
import org.apache.hive.druid.io.netty.resolver.HostsFileEntriesResolver;
import org.apache.hive.druid.io.netty.resolver.dns.DefaultDnsCache;
import org.apache.hive.druid.io.netty.resolver.dns.DnsCache;
import org.apache.hive.druid.io.netty.resolver.dns.DnsNameResolver;
import org.apache.hive.druid.io.netty.resolver.dns.DnsServerAddresses;
import org.apache.hive.druid.io.netty.util.internal.ObjectUtil;

public final class DnsNameResolverBuilder {
    private final EventLoop eventLoop;
    private ChannelFactory<? extends DatagramChannel> channelFactory;
    private DnsServerAddresses nameServerAddresses = DnsServerAddresses.defaultAddresses();
    private DnsCache resolveCache;
    private DnsCache authoritativeDnsServerCache;
    private Integer minTtl;
    private Integer maxTtl;
    private Integer negativeTtl;
    private long queryTimeoutMillis = 5000L;
    private InternetProtocolFamily2[] resolvedAddressTypes = DnsNameResolver.DEFAULT_RESOLVE_ADDRESS_TYPES;
    private boolean recursionDesired = true;
    private int maxQueriesPerResolve = 16;
    private boolean traceEnabled;
    private int maxPayloadSize = 4096;
    private boolean optResourceEnabled = true;
    private HostsFileEntriesResolver hostsFileEntriesResolver = HostsFileEntriesResolver.DEFAULT;
    private String[] searchDomains = DnsNameResolver.DEFAULT_SEACH_DOMAINS;
    private int ndots = 1;
    private boolean decodeIdn = true;

    public DnsNameResolverBuilder(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    public DnsNameResolverBuilder channelFactory(ChannelFactory<? extends DatagramChannel> channelFactory) {
        this.channelFactory = channelFactory;
        return this;
    }

    public DnsNameResolverBuilder channelType(Class<? extends DatagramChannel> channelType) {
        return this.channelFactory(new ReflectiveChannelFactory<DatagramChannel>(channelType));
    }

    public DnsNameResolverBuilder nameServerAddresses(DnsServerAddresses nameServerAddresses) {
        this.nameServerAddresses = nameServerAddresses;
        return this;
    }

    public DnsNameResolverBuilder resolveCache(DnsCache resolveCache) {
        this.resolveCache = resolveCache;
        return this;
    }

    public DnsNameResolverBuilder authoritativeDnsServerCache(DnsCache authoritativeDnsServerCache) {
        this.authoritativeDnsServerCache = authoritativeDnsServerCache;
        return this;
    }

    public DnsNameResolverBuilder ttl(int minTtl, int maxTtl) {
        this.maxTtl = maxTtl;
        this.minTtl = minTtl;
        return this;
    }

    public DnsNameResolverBuilder negativeTtl(int negativeTtl) {
        this.negativeTtl = negativeTtl;
        return this;
    }

    public DnsNameResolverBuilder queryTimeoutMillis(long queryTimeoutMillis) {
        this.queryTimeoutMillis = queryTimeoutMillis;
        return this;
    }

    public DnsNameResolverBuilder resolvedAddressTypes(InternetProtocolFamily2 ... resolvedAddressTypes) {
        ObjectUtil.checkNotNull(resolvedAddressTypes, "resolvedAddressTypes");
        ArrayList<InternetProtocolFamily2> list = new ArrayList<InternetProtocolFamily2>(InternetProtocolFamily2.values().length);
        for (InternetProtocolFamily2 f : resolvedAddressTypes) {
            if (f == null) break;
            if (list.contains((Object)f)) continue;
            list.add(f);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("no protocol family specified");
        }
        this.resolvedAddressTypes = list.toArray(new InternetProtocolFamily2[list.size()]);
        return this;
    }

    public DnsNameResolverBuilder resolvedAddressTypes(Iterable<InternetProtocolFamily2> resolvedAddressTypes) {
        ObjectUtil.checkNotNull(resolvedAddressTypes, "resolveAddressTypes");
        ArrayList<InternetProtocolFamily2> list = new ArrayList<InternetProtocolFamily2>(InternetProtocolFamily2.values().length);
        for (InternetProtocolFamily2 f : resolvedAddressTypes) {
            if (f == null) break;
            if (list.contains((Object)f)) continue;
            list.add(f);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("no protocol family specified");
        }
        this.resolvedAddressTypes = list.toArray(new InternetProtocolFamily2[list.size()]);
        return this;
    }

    public DnsNameResolverBuilder recursionDesired(boolean recursionDesired) {
        this.recursionDesired = recursionDesired;
        return this;
    }

    public DnsNameResolverBuilder maxQueriesPerResolve(int maxQueriesPerResolve) {
        this.maxQueriesPerResolve = maxQueriesPerResolve;
        return this;
    }

    public DnsNameResolverBuilder traceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        return this;
    }

    public DnsNameResolverBuilder maxPayloadSize(int maxPayloadSize) {
        this.maxPayloadSize = maxPayloadSize;
        return this;
    }

    public DnsNameResolverBuilder optResourceEnabled(boolean optResourceEnabled) {
        this.optResourceEnabled = optResourceEnabled;
        return this;
    }

    public DnsNameResolverBuilder hostsFileEntriesResolver(HostsFileEntriesResolver hostsFileEntriesResolver) {
        this.hostsFileEntriesResolver = hostsFileEntriesResolver;
        return this;
    }

    public DnsNameResolverBuilder searchDomains(Iterable<String> searchDomains) {
        ObjectUtil.checkNotNull(searchDomains, "searchDomains");
        ArrayList<String> list = new ArrayList<String>(4);
        for (String f : searchDomains) {
            if (f == null) break;
            if (list.contains(f)) continue;
            list.add(f);
        }
        this.searchDomains = list.toArray(new String[list.size()]);
        return this;
    }

    public DnsNameResolverBuilder ndots(int ndots) {
        this.ndots = ndots;
        return this;
    }

    private DnsCache newCache() {
        return new DefaultDnsCache(ObjectUtil.intValue(this.minTtl, 0), ObjectUtil.intValue(this.maxTtl, Integer.MAX_VALUE), ObjectUtil.intValue(this.negativeTtl, 0));
    }

    public DnsNameResolverBuilder decodeIdn(boolean decodeIdn) {
        this.decodeIdn = decodeIdn;
        return this;
    }

    public DnsNameResolver build() {
        if (this.resolveCache != null && (this.minTtl != null || this.maxTtl != null || this.negativeTtl != null)) {
            throw new IllegalStateException("resolveCache and TTLs are mutually exclusive");
        }
        if (this.authoritativeDnsServerCache != null && (this.minTtl != null || this.maxTtl != null || this.negativeTtl != null)) {
            throw new IllegalStateException("authoritativeDnsServerCache and TTLs are mutually exclusive");
        }
        DnsCache resolveCache = this.resolveCache != null ? this.resolveCache : this.newCache();
        DnsCache authoritativeDnsServerCache = this.authoritativeDnsServerCache != null ? this.authoritativeDnsServerCache : this.newCache();
        return new DnsNameResolver(this.eventLoop, this.channelFactory, this.nameServerAddresses, resolveCache, authoritativeDnsServerCache, this.queryTimeoutMillis, this.resolvedAddressTypes, this.recursionDesired, this.maxQueriesPerResolve, this.traceEnabled, this.maxPayloadSize, this.optResourceEnabled, this.hostsFileEntriesResolver, this.searchDomains, this.ndots, this.decodeIdn);
    }
}

