/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.io.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.io.druid.java.util.common.IAE;
import org.apache.hive.druid.io.druid.math.expr.Expr;
import org.apache.hive.druid.io.druid.math.expr.ExprEval;
import org.apache.hive.druid.io.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.io.druid.query.expression.ExprUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class TimestampFormatExprMacro
implements ExprMacroTable.ExprMacro {
    @Override
    public String name() {
        return "timestamp_format";
    }

    @Override
    public Expr apply(List<Expr> args) {
        String formatString;
        if (args.size() < 1 || args.size() > 3) {
            throw new IAE("Function[%s] must have 1 to 3 arguments", this.name());
        }
        final Expr arg = args.get(0);
        if (args.size() > 1) {
            Preconditions.checkArgument(args.get(1).isLiteral(), "Function[%s] format arg must be a literal", new Object[]{this.name()});
            formatString = (String)args.get(1).getLiteralValue();
        } else {
            formatString = null;
        }
        DateTimeZone timeZone = args.size() > 2 ? ExprUtils.toTimeZone(args.get(2)) : DateTimeZone.UTC;
        final DateTimeFormatter formatter = formatString == null ? ISODateTimeFormat.dateTime() : DateTimeFormat.forPattern(formatString).withZone(timeZone);
        class TimestampFormatExpr
        implements Expr {
            TimestampFormatExpr() {
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                return ExprEval.of(formatter.print(arg.eval(bindings).asLong()));
            }

            @Override
            public void visit(Expr.Visitor visitor) {
                arg.visit(visitor);
                visitor.visit(this);
            }
        }
        return new TimestampFormatExpr();
    }
}

